/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.concur.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openmicroscopy.shoola.util.concur.tasks.Invocation;
import org.openmicroscopy.shoola.util.concur.tasks.InvocationAdapter;
import org.openmicroscopy.shoola.util.concur.tasks.MultiStepTask;
import org.openmicroscopy.shoola.util.concur.tasks.TaskAdapter;

public class CompositeTask
implements MultiStepTask {
    public static final int ADDING = 0;
    public static final int ITERATING = 1;
    public static final int DONE = 2;
    private int state = 0;
    private List children = new ArrayList();
    private int curIndex;
    private MultiStepTask curChild;

    private int next() {
        int m = this.children.size();
        this.curChild = null;
        for (int k = this.curIndex; k < m; ++k) {
            this.curChild = (MultiStepTask)this.children.get(k);
            if (this.curChild.isDone()) continue;
            m = k;
            break;
        }
        this.curIndex = m;
        return m;
    }

    public Object doStep() throws Exception {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        return this.curChild.doStep();
    }

    public boolean isDone() {
        if (this.state == 2) {
            return true;
        }
        int m = this.next();
        if (m == this.children.size()) {
            this.state = 2;
        } else if (this.state == 0) {
            this.state = 1;
        }
        return this.state == 2;
    }

    public void add(MultiStepTask mst) {
        if (this.state == 2) {
            throw new IllegalStateException();
        }
        if (mst == null) {
            throw new NullPointerException("No task.");
        }
        this.children.add(mst);
    }

    public void add(Runnable task) {
        this.add(new TaskAdapter(task));
    }

    public void add(Invocation call) {
        this.add(new InvocationAdapter(call));
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public MultiStepTask getCurChild() {
        if (this.isDone()) {
            return null;
        }
        return this.curChild;
    }

    public int getState() {
        return this.state;
    }
}

