/*
 * Decompiled with CFR 0.152.
 */
package endrov.starter;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceClassLoader
extends URLClassLoader {
    private List<String> binfiles;

    public ResourceClassLoader(URL[] urls, Collection<String> binfiles, ClassLoader parent) {
        super(urls, parent);
        this.binfiles = new LinkedList<String>(binfiles);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cl = super.findClass(name);
        return cl;
    }

    @Override
    protected synchronized Class<?> loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        return super.loadClass(arg0, arg1);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    @Override
    protected String findLibrary(String libname) {
        String OS = System.getProperty("os.name").toLowerCase();
        libname = OS.equals("mac os x") ? "lib" + libname + ".jnilib" : (OS.startsWith("windows") ? String.valueOf(libname) + ".dll" : "lib" + libname + ".so");
        for (String s : this.binfiles) {
            File f = new File(s, libname);
            if (!f.exists()) continue;
            return f.getAbsolutePath();
        }
        String dellib = super.findLibrary(libname);
        return dellib;
    }

    public static Collection<String> getBinDirs(ClassLoader cl) {
        try {
            if (cl instanceof ResourceClassLoader) {
                return new LinkedList<String>(((ResourceClassLoader)cl).binfiles);
            }
            System.out.println(cl);
            return ResourceClassLoader.getBinDirs(cl.getParent());
        }
        catch (Exception e) {
            return new LinkedList<String>();
        }
    }

    @Override
    public URL findResource(String name) {
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return super.findResources(name);
    }
}

