/*
 * Decompiled with CFR 0.152.
 */
package endrov.starter;

import endrov.core.EvBuild;
import endrov.starter.EvSystemUtil;
import endrov.starter.ResourceClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewStart {
    private String javaexe = "java";
    private LinkedList<String> platformExt = new LinkedList();
    public LinkedList<String> jarfiles = new LinkedList();
    public LinkedList<String> binfiles = new LinkedList();

    public static void main(String[] args) {
        new NewStart().run(args);
    }

    public void collectSystemInfo(String path) {
        this.collectSystemInfo(new File(path));
    }

    public void collectSystemInfo(File path) {
        String s;
        StringTokenizer stok;
        this.platformExt.clear();
        if (EvSystemUtil.arch.equals("ppc")) {
            this.platformExt.add("ppc");
        } else if (EvSystemUtil.arch.equals("x86_64") || EvSystemUtil.arch.equals("amd64")) {
            this.platformExt.add("amd64");
        } else if (EvSystemUtil.arch.equals("sparc")) {
            this.platformExt.add("sparc");
        } else {
            this.platformExt.add("x86");
        }
        if (EvSystemUtil.OS.equals("mac os x")) {
            this.platformExt.add("mac");
        } else if (EvSystemUtil.OS.startsWith("windows")) {
            this.platformExt.add("windows");
        } else if (EvSystemUtil.OS.startsWith("linux")) {
            this.platformExt.add("linux");
        } else if (EvSystemUtil.OS.startsWith("sunos")) {
            this.platformExt.add("solaris");
        } else {
            JOptionPane.showMessageDialog(null, "Your OS + CPU combination is not supported at this moment. We would be happy if you got in\ntouch so we can support for your platform. If you want to do it yourself it is easy: Get\nlibraries for your platform (JAI and JOGL), edit endrov/starter/StartGUI.java and recompile.");
            System.exit(1);
        }
        String libpath = System.getProperty("java.library.path");
        if (libpath != null) {
            stok = new StringTokenizer(libpath, File.pathSeparator);
            while (stok.hasMoreTokens()) {
                File root;
                s = stok.nextToken();
                if (s.equals(".") || !(root = new File(s)).exists()) continue;
                File[] fileArray = root.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
                        this.jarfiles.add(f.getAbsolutePath());
                    }
                    ++n2;
                }
            }
        }
        this.jarfiles.add(path.getAbsolutePath());
        NewStart.collectJars(this.jarfiles, this.binfiles, new File(path, "libs"), this.platformExt);
        if (libpath != null) {
            stok = new StringTokenizer(libpath, File.pathSeparator);
            while (stok.hasMoreTokens()) {
                s = stok.nextToken();
                if (s.equals(".")) continue;
                this.binfiles.add(s);
            }
        }
    }

    public String getJarString() {
        String jarstring = "";
        for (String s : this.jarfiles) {
            if (!jarstring.equals("")) {
                jarstring = String.valueOf(jarstring) + File.pathSeparatorChar;
            }
            jarstring = String.valueOf(jarstring) + s;
        }
        return jarstring;
    }

    public String getBinString() {
        String binstring = "";
        for (String s : this.binfiles) {
            if (!binstring.equals("")) {
                binstring = String.valueOf(binstring) + File.pathSeparatorChar;
            }
            binstring = String.valueOf(binstring) + s;
        }
        return binstring;
    }

    private static void addJar(LinkedList<String> v, String toadd) {
        v.addFirst(toadd);
    }

    private static void collectJars(LinkedList<String> v, LinkedList<String> binfiles, File p, Collection<String> platformExt) {
        if (p.exists()) {
            File[] fileArray = p.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File sub = fileArray[n2];
                if (sub.isFile() && (sub.getName().endsWith(".jar") || sub.getName().endsWith(".zip"))) {
                    NewStart.addJar(v, sub.getAbsolutePath());
                } else if (sub.isFile() && sub.getName().endsWith(".paths")) {
                    try {
                        String line;
                        BufferedReader input = new BufferedReader(new FileReader(sub));
                        while ((line = input.readLine()) != null) {
                            if (line.startsWith("j:")) {
                                NewStart.addJar(v, line.substring(2));
                                continue;
                            }
                            if (!line.startsWith("b:")) continue;
                            binfiles.add(line.substring(2));
                        }
                        input.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (sub.isDirectory() && sub.getName().endsWith("_inc") && !sub.getName().startsWith(".") && !sub.getName().equals("unused")) {
                    NewStart.collectJars(v, binfiles, sub, platformExt);
                } else {
                    for (String oneExt : platformExt) {
                        if (!sub.isDirectory() || !sub.getName().equals("bin_" + oneExt)) continue;
                        NewStart.collectJars(v, binfiles, sub, platformExt);
                        String toadd = sub.getAbsolutePath();
                        binfiles.add(toadd);
                    }
                }
                ++n2;
            }
        }
    }

    public void run(String[] argsa) {
        boolean hasSpecifiedLibdir = false;
        boolean printCommand = false;
        boolean useClassLoader = false;
        boolean printClassPath = false;
        File javaenvFile = EvSystemUtil.getJavaenvReadFileName();
        File basedir = new File(".");
        String mainClass = "";
        LinkedList<String> args = new LinkedList<String>();
        int argi = 0;
        while (argi < argsa.length) {
            String curarg = argsa[argi];
            if (curarg.equals("--printcommand")) {
                printCommand = true;
            } else if (args.contains("--version")) {
                System.out.println("Endrov " + EvBuild.version);
                System.exit(0);
            } else if (curarg.equals("--cp2")) {
                this.jarfiles.add(argsa[argi + 1]);
                ++argi;
            } else if (curarg.equals("--libpath2")) {
                this.binfiles.add(argsa[argi + 1]);
                ++argi;
            } else if (curarg.equals("--basedir")) {
                basedir = new File(argsa[argi + 1]);
                ++argi;
            } else if (curarg.equals("--main")) {
                mainClass = argsa[argi + 1];
                ++argi;
            } else if (curarg.equals("--javaenv")) {
                javaenvFile = new File(argsa[argi + 1]);
                ++argi;
            } else if (curarg.equals("--archinfo")) {
                System.out.println("This system runs OS:" + EvSystemUtil.OS + " with java:" + EvSystemUtil.javaver + " on arch:" + EvSystemUtil.arch);
                System.exit(0);
            } else if (curarg.equals("--classload")) {
                useClassLoader = true;
            } else if (curarg.equals("--printcp")) {
                printClassPath = true;
            } else if (curarg.equals("--help")) {
                System.out.println("--printcommand, version, cp2, libpath2, basedir, main, javaenv, archinfo, classload, printcp, help");
                System.exit(0);
            } else {
                args.add(curarg);
            }
            ++argi;
        }
        this.collectSystemInfo(basedir);
        if (printClassPath) {
            String out = ".";
            for (String s : this.jarfiles) {
                out = String.valueOf(out) + ":" + s;
            }
            System.out.print(out);
            System.exit(0);
        }
        if (EvSystemUtil.javaVerMajor > 1 || EvSystemUtil.javaVerMajor == 1 && EvSystemUtil.javaVerMinor >= 5) {
            if (useClassLoader) {
                this.runWithClassLoader(mainClass, args.toArray(new String[0]));
            } else {
                this.runBootstrap(mainClass, hasSpecifiedLibdir, printCommand, javaenvFile, basedir, args.toArray(new String[0]));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Your version of Java is too old. It must be at least 1.5");
        }
    }

    private void runBootstrap(String mainClass, boolean hasSpecifiedLibdir, boolean printCommand, File javaenvFile, File basedir, String[] argsa) {
        try {
            String line;
            Object tok;
            LinkedList<String> cmdarg = new LinkedList<String>();
            cmdarg.add(this.javaexe);
            cmdarg.add("-cp");
            cmdarg.add(basedir.toString());
            if (javaenvFile.exists()) {
                System.out.println("Using environment from " + javaenvFile);
                BufferedReader envReader = new BufferedReader(new FileReader(javaenvFile));
                String line2 = envReader.readLine();
                if (line2 != null) {
                    StringTokenizer envTokenizer = new StringTokenizer(line2, " ");
                    while (envTokenizer.hasMoreTokens()) {
                        tok = envTokenizer.nextToken();
                        cmdarg.add((String)tok);
                        System.out.println("Java environment flag: " + (String)tok);
                    }
                }
                envReader.close();
            }
            System.out.println("Using environment: " + javaenvFile);
            cmdarg.add("endrov.starter.StartGUI");
            cmdarg.add("--main");
            cmdarg.add(mainClass);
            cmdarg.add("--classload");
            tok = argsa;
            int envTokenizer = argsa.length;
            int line2 = 0;
            while (line2 < envTokenizer) {
                String s = tok[line2];
                cmdarg.add(s);
                ++line2;
            }
            ProcessBuilder pb = new ProcessBuilder("");
            pb.command(cmdarg);
            if (printCommand) {
                String totalCmd = "";
                for (String s : pb.command()) {
                    totalCmd = String.valueOf(totalCmd) + s + " ";
                }
                System.out.println(totalCmd);
            }
            final Process p = pb.start();
            new Thread(){

                public synchronized void run() {
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            if (line.startsWith("Could not create the Java Virtual Machine")) {
                                JOptionPane.showMessageDialog(null, "Trouble creating virtual machine. Try to reduce the ammount of memory allocated");
                            }
                            System.err.println(line);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("Process exited");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Was unable to exec command. Full error:\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void runWithClassLoader(String mainClass, String[] argsa) {
        try {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (String s : this.jarfiles) {
                urls.add(new File(s).toURI().toURL());
            }
            System.out.println("Bin files: " + this.binfiles);
            ResourceClassLoader cload = new ResourceClassLoader(urls.toArray(new URL[0]), this.binfiles, null);
            Class<?> cl = cload.loadClass(mainClass);
            Method mMethod = cl.getMethod("main", String[].class);
            mMethod.invoke(null, new Object[]{argsa});
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Failing to load \"" + mainClass + "\"");
        }
    }
}

