/*
 * Decompiled with CFR 0.152.
 */
package endrov.starter;

import endrov.core.EndrovCore;
import endrov.core.dbus.EndrovDBUS;
import endrov.core.log.EvLog;
import endrov.core.log.EvLogFile;
import endrov.core.log.EvLogStdout;
import endrov.data.EvContainer;
import endrov.data.EvData;
import endrov.data.EvPath;
import endrov.data.gui.EvDataGUI;
import endrov.flow.FlowExec;
import endrov.gui.RepeatingKeyEventsFixer;
import endrov.gui.window.BasicWindowExtensionExitLast;
import endrov.gui.window.EvBasicWindow;
import endrov.gui.window.EvRegistrationDialog;
import endrov.gui.window.EvSplashScreen;
import endrov.starter.EvSystemUtil;
import endrov.windowConsole.ConsoleLogger;
import endrov.windowViewer2D.Viewer2DWindow;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class MW {
    public static void main(final String[] args) {
        int argi = 0;
        while (argi < args.length) {
            if (args[argi].equals("--runflow")) {
                try {
                    String fname = args[argi + 1];
                    String flowname = args[argi + 2];
                    EvData data = EvData.loadFile((File)new File(fname));
                    EvPath path = EvPath.parse((EvContainer)data, (String)flowname);
                    FlowExec flowExec = new FlowExec(data, path);
                    flowExec.evaluateAll();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                System.exit(0);
            }
            ++argi;
        }
        if (args.length != 0 && EndrovDBUS.openFile(Arrays.asList(args))) {
            System.exit(0);
        }
        new RepeatingKeyEventsFixer().install();
        EvLog.addListener((EvLog)new EvLogStdout());
        EvLog.addListener((EvLog)new EvLogFile(EvSystemUtil.getLogFileName()));
        if (EvSystemUtil.isMac()) {
            try {
                Class<?> c = Class.forName("endrov.bindingMac.OSXAdapter");
                Method m = c.getDeclaredMethod("registerMacOSXApplication", new Class[0]);
                m.invoke(null, new Object[0]);
                System.out.println("invoked");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        EvSplashScreen ss = null;
        if (EvSplashScreen.isSplashEnabled()) {
            ss = new EvSplashScreen();
        }
        try {
            if (EndrovDBUS.startServer()) {
                System.out.println("Started DBUS server");
            } else {
                System.out.println("Could not start DBUS server, skipping");
            }
            EndrovCore.loadPlugins();
            BasicWindowExtensionExitLast.integrate();
            EndrovCore.loadPersonalConfig();
            EndrovCore.setHasStartedUp();
            if (EvBasicWindow.getWindowList().size() == 0) {
                EvLog.printLog((String)"Opening up first window");
                new Viewer2DWindow();
            }
            if (ss != null) {
                ss.disableLog();
                ss.dispose();
            }
            if (!EvRegistrationDialog.hasRegistered()) {
                EvRegistrationDialog.runDialog();
                EvRegistrationDialog.connectAndRegister((boolean)true);
            } else {
                EvRegistrationDialog.connectAndRegister((boolean)false);
            }
            ConsoleLogger.install();
            new Thread(new Runnable(){

                public void run() {
                    EndrovCore.waitUntilStartedUp();
                    String[] stringArray = args;
                    int n = args.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        File f = new File(s);
                        System.out.println("To be loaded from command line: " + f);
                        EvData d = EvData.loadFile((File)f);
                        if (d == null) {
                            JOptionPane.showMessageDialog(null, "Failed to open " + f);
                        } else {
                            EvDataGUI.registerOpenedData((EvData)d);
                            EvBasicWindow.updateLoadedFile((EvData)d);
                        }
                        ++n2;
                    }
                }
            }).start();
        }
        catch (Exception e) {
            EvLog.printError((String)"EVGUI", (Throwable)e);
        }
        System.gc();
    }

    public static void openFileOnLoad(final File f) {
        new Thread(new Runnable(){

            public void run() {
                EndrovCore.waitUntilStartedUp();
                EvData d = EvData.loadFile((File)f);
                if (d == null) {
                    JOptionPane.showMessageDialog(null, "Failed to open " + f);
                } else {
                    EvDataGUI.registerOpenedData((EvData)d);
                    EvBasicWindow.updateLoadedFile((EvData)d);
                }
            }
        }).start();
    }
}

