/*
 * Decompiled with CFR 0.152.
 */
package endrov.starter;

import endrov.core.EndrovCore;
import endrov.core.log.EvLog;
import endrov.core.log.EvLogStdout;
import endrov.data.EvData;
import endrov.data.gui.EvDataGUI;
import endrov.gui.window.BasicWindowExtensionExitLast;
import endrov.gui.window.EvBasicWindow;
import endrov.gui.window.EvSplashScreen;
import endrov.starter.EvSystemUtil;
import endrov.windowLineage.LineageWindow;
import endrov.windowViewer3D.Viewer3DWindow;
import java.io.File;
import java.lang.reflect.Method;

public class CEviewer {
    public static void main(String[] args) {
        EvLog.addListener((EvLog)new EvLogStdout());
        if (EvSystemUtil.isMac()) {
            try {
                Class<?> c = Class.forName("endrov.macBinding.OSXAdapter");
                Method m = c.getDeclaredMethod("registerMacOSXApplication", new Class[0]);
                m.invoke(null, new Object[0]);
                System.out.println("invoked");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        EvSplashScreen ss = null;
        if (EvSplashScreen.isSplashEnabled()) {
            ss = new EvSplashScreen();
        }
        String javalib = System.getProperty("java.library.path");
        File javalibfile = new File(javalib);
        EvLog.printLog((String)("Loading native libraries from " + javalibfile.getAbsolutePath()));
        try {
            EndrovCore.loadPlugins();
            BasicWindowExtensionExitLast.integrate();
            EndrovCore.loadPersonalConfig();
            EndrovCore.setHasStartedUp();
            if (EvBasicWindow.getWindowList().size() == 0) {
                new LineageWindow();
                new Viewer3DWindow();
            }
            EvDataGUI.registerOpenedData((EvData)EvData.loadFile((File)new File("angler.ost")));
            EvDataGUI.registerOpenedData((EvData)EvData.loadFile((File)new File("ce2008.ost")));
            if (ss != null) {
                ss.disableLog();
                ss.dispose();
            }
        }
        catch (Exception e) {
            EvLog.printError((String)"EVGUI", (Throwable)e);
        }
        System.gc();
    }
}

