/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt.util;

import com.sun.javafx.newt.impl.Debug;
import com.sun.javafx.newt.impl.NativeLibLoader;
import com.sun.javafx.newt.macosx.MacDisplay;
import com.sun.nativewindow.impl.NWReflection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import javax.media.nativewindow.NativeWindowFactory;

public class MainThread {
    private static AccessControlContext localACC = AccessController.getContext();
    public static final boolean USE_MAIN_THREAD = "MacOSX".equals(NativeWindowFactory.getNativeWindowType((boolean)false)) || Debug.getBooleanProperty("newt.MainThread.force", true, localACC);
    protected static final boolean DEBUG = Debug.debug("MainThread");
    private static boolean isExit = false;
    private static volatile boolean isRunning = false;
    private static Object taskWorkerLock = new Object();
    private static boolean shouldStop;
    private static ArrayList tasks;
    private static ArrayList tasksBlock;
    private static Thread mainThread;
    private static MainAction mainAction;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void main(String[] stringArray) {
        if (DEBUG) {
            System.err.println("MainThread.main(): " + Thread.currentThread().getName() + " USE_MAIN_THREAD " + USE_MAIN_THREAD);
        }
        if (stringArray.length == 0) {
            return;
        }
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        if (stringArray.length > 1) {
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        }
        NativeLibLoader.loadNEWT();
        shouldStop = false;
        tasks = new ArrayList();
        tasksBlock = new ArrayList();
        mainThread = Thread.currentThread();
        mainAction = new MainAction(string, stringArray2);
        if ("MacOSX".equals(NativeWindowFactory.getNativeWindowType((boolean)false))) {
            MacDisplay.initSingleton();
        }
        if (USE_MAIN_THREAD) {
            mainAction.start();
            MainThread.run();
        } else {
            mainAction.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invoke(boolean bl, Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (!MainThread.isRunning() || mainThread == Thread.currentThread()) {
            runnable.run();
            return;
        }
        Object object = taskWorkerLock;
        synchronized (object) {
            tasks.add(runnable);
            if (bl) {
                tasksBlock.add(runnable);
            }
            taskWorkerLock.notifyAll();
            if (bl) {
                while (tasksBlock.size() > 0) {
                    try {
                        taskWorkerLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit() {
        if (DEBUG) {
            System.err.println("MainThread.exit(): " + Thread.currentThread().getName() + " start");
        }
        Object object = taskWorkerLock;
        synchronized (object) {
            if (isRunning) {
                shouldStop = true;
            }
            taskWorkerLock.notifyAll();
        }
        if (DEBUG) {
            System.err.println("MainThread.exit(): " + Thread.currentThread().getName() + " end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning() {
        Object object = taskWorkerLock;
        synchronized (object) {
            return isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitUntilRunning() {
        Object object = taskWorkerLock;
        synchronized (object) {
            if (isExit) {
                return;
            }
            while (!isRunning) {
                try {
                    taskWorkerLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run() {
        if (DEBUG) {
            System.err.println("MainThread.run(): " + Thread.currentThread().getName());
        }
        Object object = taskWorkerLock;
        synchronized (object) {
            isRunning = true;
            taskWorkerLock.notifyAll();
        }
        while (!shouldStop) {
            try {
                Object object2;
                object = null;
                Iterator iterator = taskWorkerLock;
                synchronized (iterator) {
                    while (!shouldStop && tasks.size() == 0) {
                        try {
                            taskWorkerLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    object2 = tasks.iterator();
                    while (tasksBlock.size() > 0 && object2.hasNext()) {
                        Runnable runnable = (Runnable)object2.next();
                        runnable.run();
                        object2.remove();
                        tasksBlock.remove(runnable);
                    }
                    if (tasks.size() > 0) {
                        object = tasks;
                        tasks = new ArrayList();
                    }
                    taskWorkerLock.notifyAll();
                }
                if (null == object) continue;
                iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    object2 = (Runnable)iterator.next();
                    object2.run();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (DEBUG) {
            System.err.println("MainThread.run(): " + Thread.currentThread().getName() + " fin");
        }
        object = taskWorkerLock;
        synchronized (object) {
            isRunning = false;
            isExit = true;
            taskWorkerLock.notifyAll();
        }
    }

    static class MainAction
    extends Thread {
        private String mainClassName;
        private String[] mainClassArgs;
        private Class mainClass;
        private Method mainClassMain;

        public MainAction(String string, String[] stringArray) {
            this.mainClassName = string;
            this.mainClassArgs = stringArray;
        }

        public void run() {
            if (USE_MAIN_THREAD) {
                MainThread.waitUntilRunning();
            }
            try {
                Class clazz = NWReflection.getClass((String)this.mainClassName, (boolean)true);
                if (null == clazz) {
                    throw new RuntimeException(new ClassNotFoundException("MainThread couldn't find main class " + this.mainClassName));
                }
                try {
                    this.mainClassMain = clazz.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = MainThread.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    this.mainClassMain.setAccessible(true);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                if (DEBUG) {
                    System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " invoke " + this.mainClassName);
                }
                this.mainClassMain.invoke(null, new Object[]{this.mainClassArgs});
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (DEBUG) {
                System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " user app fin");
            }
            if (USE_MAIN_THREAD) {
                MainThread.exit();
                if (DEBUG) {
                    System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " MainThread fin - exit");
                }
                System.exit(0);
            }
        }
    }
}

