/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt.awt;

import com.sun.javafx.newt.Display;
import com.sun.javafx.newt.Window;
import com.sun.javafx.newt.awt.AWTWindow;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.LinkedList;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.awt.AWTGraphicsDevice;

public class AWTDisplay
extends Display {
    private LinkedList events = new LinkedList();

    protected void createNative() {
        this.aDevice = (AWTGraphicsDevice)AWTGraphicsDevice.createDevice(null);
    }

    protected void setAWTGraphicsDevice(AWTGraphicsDevice aWTGraphicsDevice) {
        this.aDevice = aWTGraphicsDevice;
    }

    protected void closeNative() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchMessages() {
        AWTEventWrapper aWTEventWrapper;
        do {
            Object object = this;
            synchronized (object) {
                aWTEventWrapper = !this.events.isEmpty() ? (AWTEventWrapper)this.events.removeFirst() : null;
            }
            if (aWTEventWrapper == null) continue;
            switch (aWTEventWrapper.getType()) {
                case 100: 
                case 101: 
                case 102: {
                    aWTEventWrapper.getWindow().sendWindowEvent(aWTEventWrapper.getType());
                    break;
                }
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: {
                    object = (MouseEvent)aWTEventWrapper.getEvent();
                    int n = 0;
                    if (object instanceof MouseWheelEvent) {
                        n = ((MouseWheelEvent)object).getWheelRotation();
                    }
                    aWTEventWrapper.getWindow().sendMouseEvent(aWTEventWrapper.getType(), AWTDisplay.convertModifiers((InputEvent)object), ((MouseEvent)object).getX(), ((MouseEvent)object).getY(), AWTDisplay.convertButton((MouseEvent)object), n);
                    break;
                }
                case 300: 
                case 301: 
                case 302: {
                    object = (KeyEvent)aWTEventWrapper.getEvent();
                    aWTEventWrapper.getWindow().sendKeyEvent(aWTEventWrapper.getType(), AWTDisplay.convertModifiers((InputEvent)object), ((KeyEvent)object).getKeyCode(), ((KeyEvent)object).getKeyChar());
                    break;
                }
                default: {
                    throw new NativeWindowException("Unknown event type " + aWTEventWrapper.getType());
                }
            }
            if (!Window.DEBUG_MOUSE_EVENT) continue;
            System.out.println("dispatchMessages: " + aWTEventWrapper.getWindow() + " in event:" + aWTEventWrapper.getEvent());
        } while (aWTEventWrapper != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueEvent(AWTWindow aWTWindow, int n, InputEvent inputEvent) {
        AWTEventWrapper aWTEventWrapper = new AWTEventWrapper(aWTWindow, n, inputEvent);
        AWTDisplay aWTDisplay = this;
        synchronized (aWTDisplay) {
            this.events.add(aWTEventWrapper);
        }
    }

    private static int convertModifiers(InputEvent inputEvent) {
        int n = 0;
        int n2 = inputEvent.getModifiers();
        if ((n2 & 1) != 0) {
            n |= 1;
        }
        if ((n2 & 2) != 0) {
            n |= 2;
        }
        if ((n2 & 4) != 0) {
            n |= 4;
        }
        if ((n2 & 8) != 0) {
            n |= 8;
        }
        if ((n2 & 0x20) != 0) {
            n |= 0x20;
        }
        return n;
    }

    private static int convertButton(MouseEvent mouseEvent) {
        switch (mouseEvent.getButton()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    static class AWTEventWrapper {
        AWTWindow window;
        int type;
        InputEvent e;

        AWTEventWrapper(AWTWindow aWTWindow, int n, InputEvent inputEvent) {
            this.window = aWTWindow;
            this.type = n;
            this.e = inputEvent;
        }

        public AWTWindow getWindow() {
            return this.window;
        }

        public int getType() {
            return this.type;
        }

        public InputEvent getEvent() {
            return this.e;
        }
    }
}

