/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt;

import com.sun.javafx.newt.Event;
import com.sun.javafx.newt.Window;

public abstract class InputEvent
extends Event {
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 64;
    public static final int BUTTON2_MASK = 128;
    public static final int BUTTON3_MASK = 256;
    private boolean consumed = false;
    private int modifiers;

    protected InputEvent(boolean bl, int n, Window window, long l, int n2) {
        super(bl, n, window, l);
        this.modifiers = n2;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isAltDown() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isButton1Down() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isButton2Down() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isButton3Down() {
        return (this.modifiers & 0x100) != 0;
    }

    public String toString() {
        return "InputEvent[modifiers:" + this.modifiers + "]";
    }
}

