/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.DBusMap;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MarshallingException;
import org.freedesktop.dbus.exceptions.UnknownTypeCodeException;

public class Message {
    public static final byte PROTOCOL = 1;
    private static byte[][] padding = new byte[][]{null, new byte[1], new byte[2], new byte[3], new byte[4], new byte[5], new byte[6], new byte[7]};
    private static final int BUFFERINCREMENT = 20;
    private boolean big;
    protected byte[][] wiredata = new byte[20][];
    protected long bytecounter;
    protected Map<Byte, Object> headers = new HashMap<Byte, Object>();
    protected static long globalserial = 0L;
    protected long serial;
    protected byte type;
    protected byte flags;
    protected byte protover;
    private Object[] args;
    private byte[] body;
    private long bodylen = 0L;
    private int preallocated = 0;
    private int paofs = 0;
    private byte[] pabuf;
    private int bufferuse = 0;

    public static String getHeaderFieldName(byte by) {
        switch (by) {
            case 1: {
                return "Path";
            }
            case 2: {
                return "Interface";
            }
            case 3: {
                return "Member";
            }
            case 4: {
                return "Error Name";
            }
            case 5: {
                return "Reply Serial";
            }
            case 6: {
                return "Destination";
            }
            case 7: {
                return "Sender";
            }
            case 8: {
                return "Signature";
            }
        }
        return "Invalid";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message(byte by, byte by2, byte by3) throws DBusException {
        this.big = 66 == by;
        this.bytecounter = 0L;
        Class<Message> clazz = Message.class;
        synchronized (Message.class) {
            this.serial = ++globalserial;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.type = by2;
            this.flags = by3;
            this.preallocate(4);
            this.append("yyyy", by, by2, by3, (byte)1);
            return;
        }
    }

    protected Message() {
        this.bytecounter = 0L;
    }

    void populate(byte[] byArray, byte[] byArray2, byte[] byArray3) throws DBusException {
        this.big = byArray[0] == 66;
        this.type = byArray[1];
        this.flags = byArray[2];
        this.protover = byArray[3];
        this.wiredata[0] = byArray;
        this.wiredata[1] = byArray2;
        this.wiredata[2] = byArray3;
        this.body = byArray3;
        this.bufferuse = 3;
        this.bodylen = ((Number)this.extract("u", byArray, 4)[0]).longValue();
        this.serial = ((Number)this.extract("u", byArray, 8)[0]).longValue();
        this.bytecounter = byArray.length + byArray2.length + byArray3.length;
        Object[] objectArray = this.extract("a(yv)", byArray2, 0);
        for (Object e : (Vector)objectArray[0]) {
            this.headers.put((Byte)((Object[])e)[0], ((Variant)((Object[])e)[1]).getValue());
        }
    }

    private void preallocate(int n) {
        this.preallocated = 0;
        this.pabuf = new byte[n];
        this.appendBytes(this.pabuf);
        this.preallocated = n;
        this.paofs = 0;
    }

    private void ensureBuffers(int n) {
        int n2 = n - this.wiredata.length + this.bufferuse;
        if (n2 > 0) {
            if (n2 < 20) {
                n2 = 20;
            }
            byte[][] byArrayArray = new byte[this.wiredata.length + n2][];
            System.arraycopy(this.wiredata, 0, byArrayArray, 0, this.wiredata.length);
            this.wiredata = byArrayArray;
        }
    }

    protected void appendBytes(byte[] byArray) {
        if (null == byArray) {
            return;
        }
        if (this.preallocated > 0) {
            if (this.paofs + byArray.length > this.pabuf.length) {
                throw new ArrayIndexOutOfBoundsException(MessageFormat.format(Gettext._("Array index out of bounds, paofs={0}, pabuf.length={1}, buf.length={2}."), this.paofs, this.pabuf.length, byArray.length));
            }
            System.arraycopy(byArray, 0, this.pabuf, this.paofs, byArray.length);
            this.paofs += byArray.length;
            this.preallocated -= byArray.length;
        } else {
            if (this.bufferuse == this.wiredata.length) {
                byte[][] byArrayArray = new byte[this.wiredata.length + 20][];
                System.arraycopy(this.wiredata, 0, byArrayArray, 0, this.wiredata.length);
                this.wiredata = byArrayArray;
            }
            this.wiredata[this.bufferuse++] = byArray;
            this.bytecounter += (long)byArray.length;
        }
    }

    protected void appendByte(byte by) {
        if (this.preallocated > 0) {
            this.pabuf[this.paofs++] = by;
            --this.preallocated;
        } else {
            if (this.bufferuse == this.wiredata.length) {
                byte[][] byArrayArray = new byte[this.wiredata.length + 20][];
                System.arraycopy(this.wiredata, 0, byArrayArray, 0, this.wiredata.length);
                this.wiredata = byArrayArray;
            }
            this.wiredata[this.bufferuse++] = new byte[]{by};
            ++this.bytecounter;
        }
    }

    public long demarshallint(byte[] byArray, int n, int n2) {
        return this.big ? Message.demarshallintBig(byArray, n, n2) : Message.demarshallintLittle(byArray, n, n2);
    }

    public static long demarshallint(byte[] byArray, int n, byte by, int n2) {
        return by == 66 ? Message.demarshallintBig(byArray, n, n2) : Message.demarshallintLittle(byArray, n, n2);
    }

    public static long demarshallintBig(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l <<= 8;
            l |= (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    public static long demarshallintLittle(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = n2 - 1; i >= 0; --i) {
            l <<= 8;
            l |= (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    public void appendint(long l, int n) {
        byte[] byArray = new byte[n];
        this.marshallint(l, byArray, 0, n);
        this.appendBytes(byArray);
    }

    public void marshallint(long l, byte[] byArray, int n, int n2) {
        if (this.big) {
            Message.marshallintBig(l, byArray, n, n2);
        } else {
            Message.marshallintLittle(l, byArray, n, n2);
        }
    }

    public static void marshallintBig(long l, byte[] byArray, int n, int n2) {
        for (int i = n2 - 1; i >= 0; --i) {
            byArray[i + n] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static void marshallintLittle(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[i + n] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public byte[][] getWireData() {
        return this.wiredata;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSimpleName());
        stringBuffer.append('(');
        stringBuffer.append(this.flags);
        stringBuffer.append(',');
        stringBuffer.append(this.serial);
        stringBuffer.append(')');
        stringBuffer.append(' ');
        stringBuffer.append('{');
        stringBuffer.append(' ');
        if (this.headers.size() == 0) {
            stringBuffer.append('}');
        } else {
            for (Byte objectArray : this.headers.keySet()) {
                stringBuffer.append(Message.getHeaderFieldName(objectArray));
                stringBuffer.append('=');
                stringBuffer.append('>');
                stringBuffer.append(this.headers.get(objectArray).toString());
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            stringBuffer.setCharAt(stringBuffer.length() - 2, ' ');
            stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        }
        stringBuffer.append(' ');
        stringBuffer.append('{');
        stringBuffer.append(' ');
        Object[] objectArray = null;
        try {
            objectArray = this.getParameters();
        }
        catch (DBusException dBusException) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
        }
        if (null == objectArray || 0 == objectArray.length) {
            stringBuffer.append('}');
        } else {
            for (Object object : objectArray) {
                if (object instanceof Object[]) {
                    stringBuffer.append(Arrays.deepToString((Object[])object));
                } else if (object instanceof byte[]) {
                    stringBuffer.append(Arrays.toString((byte[])object));
                } else if (object instanceof int[]) {
                    stringBuffer.append(Arrays.toString((int[])object));
                } else if (object instanceof short[]) {
                    stringBuffer.append(Arrays.toString((short[])object));
                } else if (object instanceof long[]) {
                    stringBuffer.append(Arrays.toString((long[])object));
                } else if (object instanceof boolean[]) {
                    stringBuffer.append(Arrays.toString((boolean[])object));
                } else if (object instanceof double[]) {
                    stringBuffer.append(Arrays.toString((double[])object));
                } else if (object instanceof float[]) {
                    stringBuffer.append(Arrays.toString((float[])object));
                } else {
                    stringBuffer.append(object.toString());
                }
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            stringBuffer.setCharAt(stringBuffer.length() - 2, ' ');
            stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        }
        return stringBuffer.toString();
    }

    public Object getHeader(byte by) {
        return this.headers.get(by);
    }

    private int appendone(byte[] byArray, int n, Object object) throws DBusException {
        try {
            int n2 = n;
            this.pad(byArray[n2]);
            switch (byArray[n2]) {
                case 121: {
                    this.appendByte(((Number)object).byteValue());
                    break;
                }
                case 98: {
                    this.appendint((Boolean)object != false ? 1L : 0L, 4);
                    break;
                }
                case 100: {
                    long l = Double.doubleToLongBits(((Number)object).doubleValue());
                    this.appendint(l, 8);
                    break;
                }
                case 102: {
                    int n3 = Float.floatToIntBits(((Number)object).floatValue());
                    this.appendint(n3, 4);
                    break;
                }
                case 117: {
                    this.appendint(((Number)object).longValue(), 4);
                    break;
                }
                case 120: {
                    this.appendint(((Number)object).longValue(), 8);
                    break;
                }
                case 116: {
                    if (this.big) {
                        this.appendint(((UInt64)object).top(), 4);
                        this.appendint(((UInt64)object).bottom(), 4);
                        break;
                    }
                    this.appendint(((UInt64)object).bottom(), 4);
                    this.appendint(((UInt64)object).top(), 4);
                    break;
                }
                case 105: {
                    this.appendint(((Number)object).intValue(), 4);
                    break;
                }
                case 113: {
                    this.appendint(((Number)object).intValue(), 2);
                    break;
                }
                case 110: {
                    this.appendint(((Number)object).shortValue(), 2);
                    break;
                }
                case 111: 
                case 115: {
                    String string = object.toString();
                    byte[] byArray2 = null;
                    try {
                        byArray2 = string.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        throw new DBusException(Gettext._("System does not support UTF-8 encoding"));
                    }
                    this.appendint(byArray2.length, 4);
                    this.appendBytes(byArray2);
                    this.appendBytes(padding[1]);
                    break;
                }
                case 103: {
                    String string = object instanceof Type[] ? Marshalling.getDBusType((Type[])object) : (String)object;
                    byte[] byArray3 = string.getBytes();
                    this.preallocate(2 + byArray3.length);
                    this.appendByte((byte)byArray3.length);
                    this.appendBytes(byArray3);
                    this.appendByte((byte)0);
                    break;
                }
                case 97: {
                    byte[] byArray4 = new byte[4];
                    this.appendBytes(byArray4);
                    this.pad(byArray[++n2]);
                    long l = this.bytecounter;
                    if (object.getClass().isArray() && object.getClass().getComponentType().isPrimitive()) {
                        byte[] n18;
                        int n4 = Message.getAlignment(byArray[n2]);
                        int n5 = Array.getLength(object);
                        switch (byArray[n2]) {
                            case 121: {
                                n18 = (byte[])object;
                                break;
                            }
                            case 105: 
                            case 110: 
                            case 120: {
                                n18 = new byte[n5 * n4];
                                int n10 = 0;
                                int n11 = 0;
                                while (n10 < n5) {
                                    this.marshallint(Array.getLong(object, n10), n18, n11, n4);
                                    ++n10;
                                    n11 += n4;
                                }
                                break;
                            }
                            case 98: {
                                n18 = new byte[n5 * n4];
                                int n12 = 0;
                                int n13 = 0;
                                while (n12 < n5) {
                                    this.marshallint(Array.getBoolean(object, n12) ? 1L : 0L, n18, n13, n4);
                                    ++n12;
                                    n13 += n4;
                                }
                                break;
                            }
                            case 100: {
                                n18 = new byte[n5 * n4];
                                if (object instanceof float[]) {
                                    int n14 = 0;
                                    int n15 = 0;
                                    while (n14 < n5) {
                                        this.marshallint(Double.doubleToRawLongBits(((float[])object)[n14]), n18, n15, n4);
                                        ++n14;
                                        n15 += n4;
                                    }
                                } else {
                                    int n3 = 0;
                                    int n6 = 0;
                                    while (n3 < n5) {
                                        this.marshallint(Double.doubleToRawLongBits(((double[])object)[n3]), n18, n6, n4);
                                        ++n3;
                                        n6 += n4;
                                    }
                                }
                                break;
                            }
                            case 102: {
                                n18 = new byte[n5 * n4];
                                int byArray6 = 0;
                                int string = 0;
                                while (byArray6 < n5) {
                                    this.marshallint(Float.floatToRawIntBits(((float[])object)[byArray6]), n18, string, n4);
                                    ++byArray6;
                                    string += n4;
                                }
                                break;
                            }
                            default: {
                                throw new MarshallingException(Gettext._("Primative array being sent as non-primative array."));
                            }
                        }
                        this.appendBytes(n18);
                    } else if (object instanceof List) {
                        Object[] objectArray = ((List)object).toArray();
                        int n16 = n2;
                        this.ensureBuffers(objectArray.length * 4);
                        for (Object object5 : objectArray) {
                            n16 = this.appendone(byArray, n2, object5);
                        }
                        if (n2 == n16) {
                            Vector<Type> object4 = new Vector<Type>();
                            byte[] byArray2 = new byte[byArray.length - n16];
                            System.arraycopy(byArray, n16, byArray2, 0, byArray2.length);
                            String string = new String(byArray2);
                            int n7 = Marshalling.getJavaType(string, object4, 1);
                            n16 += n7 - 1;
                        }
                        n2 = n16;
                    } else if (object instanceof Map) {
                        int objectArray = n2;
                        this.ensureBuffers(((Map)object).size() * 6);
                        for (Map.Entry entry : ((Map)object).entrySet()) {
                            objectArray = this.appendone(byArray, n2, entry);
                        }
                        if (n2 == objectArray) {
                            Vector vector = new Vector();
                            byte[] variant = new byte[byArray.length - objectArray];
                            System.arraycopy(byArray, objectArray, variant, 0, variant.length);
                            String string = new String(variant);
                            int n8 = Marshalling.getJavaType(string, vector, 1);
                            objectArray += n8;
                        }
                        n2 = objectArray;
                    } else {
                        Object[] objectArray = (Object[])object;
                        this.ensureBuffers(objectArray.length * 4);
                        int n20 = n2;
                        for (Object object2 : objectArray) {
                            n20 = this.appendone(byArray, n2, object2);
                        }
                        n2 = n20;
                    }
                    this.marshallint(this.bytecounter - l, byArray4, 0, 4);
                    break;
                }
                case 40: {
                    Object[] objectArray = object instanceof Container ? ((Container)object).getParameters() : (Object[])object;
                    this.ensureBuffers(objectArray.length * 4);
                    int n21 = 0;
                    ++n2;
                    while (byArray[n2] != 41) {
                        n2 = this.appendone(byArray, n2, objectArray[n21++]);
                        ++n2;
                    }
                    break;
                }
                case 123: {
                    if (object instanceof Map.Entry) {
                        ++n2;
                        n2 = this.appendone(byArray, n2, ((Map.Entry)object).getKey());
                        ++n2;
                        n2 = this.appendone(byArray, n2, ((Map.Entry)object).getValue());
                        ++n2;
                        break;
                    }
                    Object[] objectArray = (Object[])object;
                    int n22 = 0;
                    ++n2;
                    while (byArray[n2] != 125) {
                        n2 = this.appendone(byArray, n2, objectArray[n22++]);
                        ++n2;
                    }
                    break;
                }
                case 118: {
                    if (object instanceof Variant) {
                        Variant variant = (Variant)object;
                        this.appendone(new byte[]{103}, 0, variant.getSig());
                        this.appendone(variant.getSig().getBytes(), 0, variant.getValue());
                        break;
                    }
                    if (object instanceof Object[]) {
                        Object[] objectArray = (Object[])object;
                        this.appendone(new byte[]{103}, 0, objectArray[0]);
                        this.appendone(((String)objectArray[0]).getBytes(), 0, objectArray[1]);
                        break;
                    }
                    String string = Marshalling.getDBusType(object.getClass())[0];
                    this.appendone(new byte[]{103}, 0, string);
                    this.appendone(string.getBytes(), 0, object);
                }
            }
            return n2;
        }
        catch (ClassCastException classCastException) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new MarshallingException(MessageFormat.format(Gettext._("Trying to marshall to unconvertable type (from {0} to {1})."), object.getClass().getName(), byArray[n]));
        }
    }

    public void pad(byte by) {
        int n = Message.getAlignment(by);
        int n2 = (int)((this.bytecounter - (long)this.preallocated) % (long)n);
        if (0 == n2) {
            return;
        }
        n -= n2;
        if (this.preallocated > 0) {
            this.paofs += n;
            this.preallocated -= n;
        } else {
            this.appendBytes(padding[n]);
        }
    }

    public static int getAlignment(byte by) {
        switch (by) {
            case 2: 
            case 110: 
            case 113: {
                return 2;
            }
            case 4: 
            case 97: 
            case 98: 
            case 102: 
            case 105: 
            case 111: 
            case 115: 
            case 117: {
                return 4;
            }
            case 8: 
            case 40: 
            case 41: 
            case 100: 
            case 101: 
            case 114: 
            case 116: 
            case 120: 
            case 123: 
            case 125: {
                return 8;
            }
        }
        return 1;
    }

    public void append(String string, Object ... objectArray) throws DBusException {
        byte[] byArray = string.getBytes();
        int n = 0;
        for (int i = 0; i < byArray.length && n < objectArray.length; ++i, ++n) {
            i = this.appendone(byArray, i, objectArray[n]);
        }
    }

    public int align(int n, byte by) {
        int n2 = Message.getAlignment(by);
        if (0 == n % n2) {
            return n;
        }
        return n + (n2 - n % n2);
    }

    private Object extractone(byte[] byArray, byte[] byArray2, int[] nArray, boolean bl) throws DBusException {
        Object object = null;
        nArray[1] = this.align(nArray[1], byArray[nArray[0]]);
        switch (byArray[nArray[0]]) {
            case 121: {
                int n = nArray[1];
                nArray[1] = n + 1;
                object = byArray2[n];
                break;
            }
            case 117: {
                object = new UInt32(this.demarshallint(byArray2, nArray[1], 4));
                nArray[1] = nArray[1] + 4;
                break;
            }
            case 105: {
                object = (int)this.demarshallint(byArray2, nArray[1], 4);
                nArray[1] = nArray[1] + 4;
                break;
            }
            case 110: {
                object = (short)this.demarshallint(byArray2, nArray[1], 2);
                nArray[1] = nArray[1] + 2;
                break;
            }
            case 113: {
                object = new UInt16((int)this.demarshallint(byArray2, nArray[1], 2));
                nArray[1] = nArray[1] + 2;
                break;
            }
            case 120: {
                object = this.demarshallint(byArray2, nArray[1], 8);
                nArray[1] = nArray[1] + 8;
                break;
            }
            case 116: {
                long l;
                long l2;
                if (this.big) {
                    l2 = this.demarshallint(byArray2, nArray[1], 4);
                    nArray[1] = nArray[1] + 4;
                    l = this.demarshallint(byArray2, nArray[1], 4);
                } else {
                    l = this.demarshallint(byArray2, nArray[1], 4);
                    nArray[1] = nArray[1] + 4;
                    l2 = this.demarshallint(byArray2, nArray[1], 4);
                }
                object = new UInt64(l2, l);
                nArray[1] = nArray[1] + 4;
                break;
            }
            case 100: {
                long l = this.demarshallint(byArray2, nArray[1], 8);
                nArray[1] = nArray[1] + 8;
                object = Double.longBitsToDouble(l);
                break;
            }
            case 102: {
                int n = (int)this.demarshallint(byArray2, nArray[1], 4);
                nArray[1] = nArray[1] + 4;
                object = Float.valueOf(Float.intBitsToFloat(n));
                break;
            }
            case 98: {
                int n = (int)this.demarshallint(byArray2, nArray[1], 4);
                nArray[1] = nArray[1] + 4;
                object = 1 == n ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 97: {
                long l = this.demarshallint(byArray2, nArray[1], 4);
                nArray[1] = nArray[1] + 4;
                nArray[0] = nArray[0] + 1;
                byte by = (byte)Message.getAlignment(byArray[nArray[0]]);
                nArray[1] = this.align(nArray[1], byArray[nArray[0]]);
                int n = (int)(l / (long)by);
                if (n > 0x4000000) {
                    throw new MarshallingException(Gettext._("Arrays must not exceed ") + 0x4000000);
                }
                switch (byArray[nArray[0]]) {
                    case 121: {
                        object = new byte[n];
                        System.arraycopy(byArray2, nArray[1], object, 0, n);
                        nArray[1] = (int)((long)nArray[1] + l);
                        break;
                    }
                    case 110: {
                        object = new short[n];
                        for (int i = 0; i < n; ++i) {
                            ((short[])object)[i] = (short)this.demarshallint(byArray2, nArray[1], by);
                            nArray[1] = nArray[1] + by;
                        }
                        break;
                    }
                    case 105: {
                        object = new int[n];
                        for (int i = 0; i < n; ++i) {
                            ((int[])object)[i] = (int)this.demarshallint(byArray2, nArray[1], by);
                            nArray[1] = nArray[1] + by;
                        }
                        break;
                    }
                    case 120: {
                        object = new long[n];
                        for (int i = 0; i < n; ++i) {
                            ((long[])object)[i] = this.demarshallint(byArray2, nArray[1], by);
                            nArray[1] = nArray[1] + by;
                        }
                        break;
                    }
                    case 98: {
                        object = new boolean[n];
                        for (int i = 0; i < n; ++i) {
                            ((boolean[])object)[i] = 1L == this.demarshallint(byArray2, nArray[1], by);
                            nArray[1] = nArray[1] + by;
                        }
                        break;
                    }
                    case 102: {
                        object = new float[n];
                        for (int i = 0; i < n; ++i) {
                            ((float[])object)[i] = Float.intBitsToFloat((int)this.demarshallint(byArray2, nArray[1], by));
                            nArray[1] = nArray[1] + by;
                        }
                        break;
                    }
                    case 100: {
                        object = new double[n];
                        for (int i = 0; i < n; ++i) {
                            ((double[])object)[i] = Double.longBitsToDouble(this.demarshallint(byArray2, nArray[1], by));
                            nArray[1] = nArray[1] + by;
                        }
                        break;
                    }
                    case 123: {
                        if (0L == l) {
                            Vector<Type> vector = new Vector<Type>();
                            byte[] byArray3 = new byte[byArray.length - nArray[0]];
                            System.arraycopy(byArray, nArray[0], byArray3, 0, byArray3.length);
                            String string = new String(byArray3);
                            int n2 = Marshalling.getJavaType(string, vector, 1) - 1;
                            nArray[0] = nArray[0] + n2;
                        }
                        int n3 = nArray[0];
                        long l3 = (long)nArray[1] + l;
                        Vector<Object[]> vector = new Vector<Object[]>();
                        while ((long)nArray[1] < l3) {
                            nArray[0] = n3;
                            vector.add((Object[])this.extractone(byArray, byArray2, nArray, true));
                        }
                        object = new DBusMap((Object[][])vector.toArray((T[])new Object[0][]));
                        break;
                    }
                    default: {
                        Vector<Type> vector;
                        if (0L == l) {
                            vector = new Vector<Type>();
                            byte[] byArray4 = new byte[byArray.length - nArray[0]];
                            System.arraycopy(byArray, nArray[0], byArray4, 0, byArray4.length);
                            String string = new String(byArray4);
                            int n4 = Marshalling.getJavaType(string, vector, 1) - 1;
                            nArray[0] = nArray[0] + n4;
                        }
                        int n5 = nArray[0];
                        long l4 = (long)nArray[1] + l;
                        vector = new Vector();
                        while ((long)nArray[1] < l4) {
                            nArray[0] = n5;
                            vector.add((Type)this.extractone(byArray, byArray2, nArray, true));
                        }
                        object = vector;
                    }
                }
                if (!bl || object instanceof List || object instanceof Map) break;
                object = ArrayFrob.listify(object);
                break;
            }
            case 40: {
                Vector<Object> vector = new Vector<Object>();
                while (byArray[nArray[0] = nArray[0] + 1] != 41) {
                    vector.add(this.extractone(byArray, byArray2, nArray, true));
                }
                object = vector.toArray();
                break;
            }
            case 123: {
                Object[] objectArray = new Object[2];
                nArray[0] = nArray[0] + 1;
                objectArray[0] = this.extractone(byArray, byArray2, nArray, true);
                nArray[0] = nArray[0] + 1;
                objectArray[1] = this.extractone(byArray, byArray2, nArray, true);
                nArray[0] = nArray[0] + 1;
                object = objectArray;
                break;
            }
            case 118: {
                int[] nArray2 = new int[]{0, nArray[1]};
                String string = (String)this.extract("g", byArray2, nArray2)[0];
                nArray2[0] = 0;
                object = new Variant<Object>(this.extract(string, byArray2, nArray2)[0], string);
                nArray[1] = nArray2[1];
                break;
            }
            case 115: {
                int n = (int)this.demarshallint(byArray2, nArray[1], 4);
                nArray[1] = nArray[1] + 4;
                try {
                    object = new String(byArray2, nArray[1], n, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (AbstractConnection.EXCEPTION_DEBUG) {
                        // empty if block
                    }
                    throw new DBusException(Gettext._("System does not support UTF-8 encoding"));
                }
                nArray[1] = nArray[1] + (n + 1);
                break;
            }
            case 111: {
                int n = (int)this.demarshallint(byArray2, nArray[1], 4);
                nArray[1] = nArray[1] + 4;
                object = new ObjectPath(this.getSource(), new String(byArray2, nArray[1], n));
                nArray[1] = nArray[1] + (n + 1);
                break;
            }
            case 103: {
                int n = nArray[1];
                nArray[1] = n + 1;
                int n6 = byArray2[n] & 0xFF;
                object = new String(byArray2, nArray[1], n6);
                nArray[1] = nArray[1] + (n6 + 1);
                break;
            }
            default: {
                throw new UnknownTypeCodeException(byArray[nArray[0]]);
            }
        }
        return object;
    }

    public Object[] extract(String string, byte[] byArray, int n) throws DBusException {
        return this.extract(string, byArray, new int[]{0, n});
    }

    public Object[] extract(String string, byte[] byArray, int[] nArray) throws DBusException {
        Vector<Object> vector = new Vector<Object>();
        byte[] byArray2 = string.getBytes();
        int[] nArray2 = nArray;
        while (nArray2[0] < byArray2.length) {
            vector.add(this.extractone(byArray2, byArray, nArray2, false));
            nArray2[0] = nArray2[0] + 1;
        }
        return vector.toArray();
    }

    public String getSource() {
        return (String)this.headers.get((byte)7);
    }

    public String getDestination() {
        return (String)this.headers.get((byte)6);
    }

    public String getInterface() {
        return (String)this.headers.get((byte)2);
    }

    public String getPath() {
        Object object = this.headers.get((byte)1);
        if (null == object) {
            return null;
        }
        return object.toString();
    }

    public String getName() {
        if (this instanceof Error) {
            return (String)this.headers.get((byte)4);
        }
        return (String)this.headers.get((byte)3);
    }

    public String getSig() {
        return (String)this.headers.get((byte)8);
    }

    public int getFlags() {
        return this.flags;
    }

    public long getSerial() {
        return this.serial;
    }

    public long getReplySerial() {
        Number number = (Number)this.headers.get((byte)5);
        if (null == number) {
            return 0L;
        }
        return number.longValue();
    }

    public Object[] getParameters() throws DBusException {
        if (null == this.args && null != this.body) {
            String string = (String)this.headers.get((byte)8);
            this.args = null != string && 0 != this.body.length ? this.extract(string, this.body, 0) : new Object[0];
        }
        return this.args;
    }

    protected void setArgs(Object[] objectArray) {
        this.args = objectArray;
    }

    public void setSource(String string) throws DBusException {
        if (null != this.body) {
            this.wiredata = new byte[20][];
            this.bufferuse = 0;
            this.bytecounter = 0L;
            this.preallocate(12);
            this.append("yyyyuu", this.big ? (byte)66 : 108, this.type, this.flags, this.protover, this.bodylen, this.serial);
            this.headers.put((byte)7, string);
            Object[][] objectArrayArray = new Object[this.headers.size()][];
            int n = 0;
            for (Byte by : this.headers.keySet()) {
                objectArrayArray[n] = new Object[2];
                objectArrayArray[n][0] = by;
                objectArrayArray[n][1] = this.headers.get(by);
                ++n;
            }
            this.append("a(yv)", new Object[]{objectArrayArray});
            this.pad((byte)8);
            this.appendBytes(this.body);
        }
    }

    public static interface ArgumentType {
        public static final String BYTE_STRING = "y";
        public static final String BOOLEAN_STRING = "b";
        public static final String INT16_STRING = "n";
        public static final String UINT16_STRING = "q";
        public static final String INT32_STRING = "i";
        public static final String UINT32_STRING = "u";
        public static final String INT64_STRING = "x";
        public static final String UINT64_STRING = "t";
        public static final String DOUBLE_STRING = "d";
        public static final String FLOAT_STRING = "f";
        public static final String STRING_STRING = "s";
        public static final String OBJECT_PATH_STRING = "o";
        public static final String SIGNATURE_STRING = "g";
        public static final String ARRAY_STRING = "a";
        public static final String VARIANT_STRING = "v";
        public static final String STRUCT_STRING = "r";
        public static final String STRUCT1_STRING = "(";
        public static final String STRUCT2_STRING = ")";
        public static final String DICT_ENTRY_STRING = "e";
        public static final String DICT_ENTRY1_STRING = "{";
        public static final String DICT_ENTRY2_STRING = "}";
        public static final byte BYTE = 121;
        public static final byte BOOLEAN = 98;
        public static final byte INT16 = 110;
        public static final byte UINT16 = 113;
        public static final byte INT32 = 105;
        public static final byte UINT32 = 117;
        public static final byte INT64 = 120;
        public static final byte UINT64 = 116;
        public static final byte DOUBLE = 100;
        public static final byte FLOAT = 102;
        public static final byte STRING = 115;
        public static final byte OBJECT_PATH = 111;
        public static final byte SIGNATURE = 103;
        public static final byte ARRAY = 97;
        public static final byte VARIANT = 118;
        public static final byte STRUCT = 114;
        public static final byte STRUCT1 = 40;
        public static final byte STRUCT2 = 41;
        public static final byte DICT_ENTRY = 101;
        public static final byte DICT_ENTRY1 = 123;
        public static final byte DICT_ENTRY2 = 125;
    }

    public static interface HeaderField {
        public static final byte PATH = 1;
        public static final byte INTERFACE = 2;
        public static final byte MEMBER = 3;
        public static final byte ERROR_NAME = 4;
        public static final byte REPLY_SERIAL = 5;
        public static final byte DESTINATION = 6;
        public static final byte SENDER = 7;
        public static final byte SIGNATURE = 8;
    }

    public static interface MessageType {
        public static final byte METHOD_CALL = 1;
        public static final byte METHOD_RETURN = 2;
        public static final byte ERROR = 3;
        public static final byte SIGNAL = 4;
    }

    public static interface Flags {
        public static final byte NO_REPLY_EXPECTED = 1;
        public static final byte NO_AUTO_START = 2;
        public static final byte ASYNC = 64;
    }

    public static interface Endian {
        public static final byte BIG = 66;
        public static final byte LITTLE = 108;
    }
}

