/*
 * Decompiled with CFR 0.152.
 */
package OSTdaemon;

import OSTdaemon.DaemonListener;
import endrov.typeImageset.BioformatsSliceIO;
import endrov.typeImageset.EvPixels;
import endrov.util.ProgressHandle;
import endrov.util.io.EvXmlUtil;
import java.awt.RenderingHints;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import loci.formats.IFormatReader;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSTdaemon
extends Thread {
    public String pathInput = ".";
    public String pathConverted;
    public String pathOutput;
    public HashMap<String, Integer> compressionLevel = new HashMap();
    public HashMap<String, String> outputFormat = new HashMap();
    public int ostVersion = 2;
    public boolean deleteInput = false;
    public HashSet<String> makeMaxChannel = new HashSet();
    private boolean shutDown;
    private boolean isRunning;
    private boolean skipBlackSlices = false;
    private boolean skipWhiteSlices = false;
    private DaemonListener daemonListener;

    public void shutDown() {
        this.shutDown = true;
    }

    public void go() {
        this.shutDown = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public OSTdaemon(DaemonListener listener) {
        this.daemonListener = listener;
    }

    public void log(String s) {
        if (this.daemonListener != null) {
            this.daemonListener.daemonLog(s);
        }
    }

    public void error(String s, Exception e) {
        if (this.daemonListener != null) {
            this.daemonListener.daemonError(s, e);
        }
    }

    public void readConfig(String filename) {
        this.log("Reading config file " + filename);
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = input.readLine()) != null) {
                String s;
                String channel;
                String path;
                StringTokenizer tok = new StringTokenizer(line);
                if (!tok.hasMoreTokens()) continue;
                String cmd = tok.nextToken();
                if (cmd.equals("pathinput")) {
                    path = tok.nextToken();
                    File f = new File(path);
                    this.pathInput = f.getAbsolutePath();
                    this.log("Set pathInput = " + this.pathInput);
                    continue;
                }
                if (cmd.equals("pathoutput")) {
                    path = tok.nextToken();
                    File f = new File(path);
                    this.pathOutput = f.getAbsolutePath();
                    this.log("Set pathOutput = " + this.pathOutput);
                    continue;
                }
                if (cmd.equals("pathconverted")) {
                    path = tok.nextToken();
                    File f = new File(path);
                    this.pathConverted = f.getAbsolutePath();
                    this.log("Set pathConverted = " + this.pathConverted);
                    continue;
                }
                if (cmd.equals("compression")) {
                    channel = tok.nextToken();
                    int level = Integer.parseInt(tok.nextToken());
                    this.compressionLevel.put(channel, level);
                    this.log("Set compression level for " + channel + " to " + level);
                    continue;
                }
                if (cmd.equals("outputformat")) {
                    channel = tok.nextToken();
                    String format = tok.nextToken();
                    this.outputFormat.put(channel, format);
                    this.log("Set output format for " + channel + " to " + format);
                    continue;
                }
                if (cmd.equals("addmax")) {
                    channel = tok.nextToken();
                    this.makeMaxChannel.add(channel);
                    this.log("Added maxSliceGeneration for " + channel);
                    continue;
                }
                if (cmd.equals("removemax")) {
                    channel = tok.nextToken();
                    this.makeMaxChannel.remove(channel);
                    this.log("Removed maxSliceGeneration for " + channel);
                    continue;
                }
                if (cmd.equals("ostversion")) {
                    String versions = tok.nextToken();
                    this.ostVersion = Integer.parseInt(versions);
                    this.log("Set OST output version to " + this.ostVersion);
                    continue;
                }
                if (cmd.equals("deleteinput")) {
                    String deleteInputs = tok.nextToken();
                    this.deleteInput = Integer.parseInt(deleteInputs) == 1;
                    this.log("Delete input file after conversion: " + this.deleteInput);
                    continue;
                }
                if (cmd.equals("skipblackslices")) {
                    s = tok.nextToken();
                    this.skipBlackSlices = Integer.parseInt(s) == 1;
                    this.log("Skip black slices: " + this.skipBlackSlices);
                    continue;
                }
                if (cmd.equals("skipwhiteslices")) {
                    s = tok.nextToken();
                    this.skipWhiteSlices = Integer.parseInt(s) == 1;
                    this.log("Skip white slices: " + this.skipWhiteSlices);
                    continue;
                }
                if (cmd.equals("setmax")) {
                    String log = "maxSliceGeneration for these channels only: ";
                    this.makeMaxChannel.clear();
                    while (tok.hasMoreTokens()) {
                        String channel2 = tok.nextToken();
                        this.makeMaxChannel.add(channel2);
                        log = String.valueOf(log) + channel2 + " ";
                    }
                    this.log(log);
                    continue;
                }
                this.log("Unknown parameter in config file: " + cmd);
            }
            input.close();
        }
        catch (Exception e) {
            this.error(null, e);
        }
    }

    public int getCompressionLevel(String channel) {
        if (this.compressionLevel.containsKey(channel)) {
            return this.compressionLevel.get(channel);
        }
        return 100;
    }

    public String getOutputFormat(String channel) {
        if (this.outputFormat.containsKey(channel)) {
            return this.outputFormat.get(channel);
        }
        if (this.getCompressionLevel(channel) < 100) {
            return "jpg";
        }
        return "png";
    }

    public File getImagesetFile(String imageset) {
        return new File(this.pathOutput, String.valueOf(imageset) + ".ost");
    }

    public File getChannelFile(String imageset, String channel) {
        return new File(this.getImagesetFile(imageset), "blob-ch" + channel);
    }

    private File outputImageName(String argImageset, String argChannel, String ext, int argStack, int slice) {
        if (this.ostVersion == 2) {
            File toDir = new File(this.getChannelFile(argImageset, argChannel), OSTdaemon.pad(argStack, 8));
            toDir.mkdirs();
            File toFile = new File(toDir, "b" + OSTdaemon.pad(slice, 8) + "." + ext);
            return toFile;
        }
        return null;
    }

    public void readMeta1(File from) {
        String filename = from.getName();
        String argImageset = filename.substring(0, filename.indexOf(45));
        String argChannel = OSTdaemon.chopFileEnding(filename.substring(argImageset.length() + 1));
        this.log("Reading metafile for " + argImageset + " / " + argChannel);
        File to = new File(this.getImagesetFile(argImageset), "data");
        if (to.exists() || to.mkdirs()) {
            try {
                OSTdaemon.copyFile(from, new File(to, "rmd-" + argChannel + ".txt"));
                this.moveToConverted(from);
            }
            catch (Exception e) {
                this.error(null, e);
            }
        } else {
            this.log("Failed to make directory " + to.getAbsolutePath());
        }
    }

    public void copyMaxMeta(String argImageset, String argChannel) throws Exception {
        File imagesetDir = this.getImagesetFile(argImageset);
        if (imagesetDir.exists()) {
            File totalFile = new File(imagesetDir, "rmd.ostxml");
            Document rmd = EvXmlUtil.readXML((File)totalFile);
            Element root = rmd.getRootElement();
            Element imagesetEl = root.getChild("imageset");
            Element ostchild = imagesetEl.getChild("_ostchild");
            Element elFP = null;
            for (Object e : ostchild.getChildren()) {
                String thisName;
                Element ee = (Element)e;
                if (!ee.getName().equals("channel") || !(thisName = ee.getAttributeValue("id")).equals(argChannel)) continue;
                elFP = ee;
            }
            if (elFP == null) {
                System.out.println("No " + argChannel);
                return;
            }
            elFP = (Element)elFP.clone();
            elFP.setAttribute("ostblobid", "blob-ch" + argChannel);
            elFP.setAttribute("id", String.valueOf(argChannel) + "max");
            ostchild.addContent((Content)elFP);
            EvXmlUtil.writeXmlData((Document)rmd, (File)totalFile);
        }
    }

    public void readMeta2(File from) {
        if (this.ostVersion == 2) {
            String filename = from.getName();
            String argImageset = filename.substring(0, filename.indexOf(45));
            File imagesetDir = this.getImagesetFile(argImageset);
            imagesetDir.mkdirs();
            File totalFile = new File(imagesetDir, "rmd.ostxml");
            try {
                Document total = null;
                total = totalFile.exists() ? EvXmlUtil.readXML((File)totalFile) : new Document(new Element("ost"));
                Document newrmd = EvXmlUtil.readXML((File)from);
                EvXmlUtil.mergeXML((Element)total.getRootElement(), (Element)newrmd.getRootElement());
                EvXmlUtil.writeXmlData((Document)total, (File)totalFile);
                this.moveToConverted(from);
            }
            catch (Exception e) {
                this.error("Problem merging XML", e);
            }
        } else {
            this.error("Unsupported version number", null);
        }
    }

    public void copyMeta2(File from) {
        String filename = from.getName();
        String argImageset = filename.substring(0, filename.indexOf(45));
        File imagesetDir = this.getImagesetFile(argImageset);
        imagesetDir.mkdirs();
        File totalFile = new File(imagesetDir, "rmd.ostxml");
        try {
            Document newrmd = EvXmlUtil.readXML((File)from);
            EvXmlUtil.writeXmlData((Document)newrmd, (File)totalFile);
            this.moveToConverted(from);
            for (String ch : this.makeMaxChannel) {
                this.copyMaxMeta(argImageset, ch);
            }
        }
        catch (Exception e) {
            this.error("Problem copying RMD ", e);
        }
    }

    public void copyExtra(File from) {
        String filename = from.getName();
        String argImageset = filename.substring(0, filename.indexOf(45));
        String argFilename = filename.substring(argImageset.length() + 1 + 4 + 1);
        File toDir = new File(this.getImagesetFile(argImageset), "data");
        if (toDir.exists() || toDir.mkdirs()) {
            File to = new File(toDir.getAbsolutePath(), argFilename);
            this.log("Copying file " + from.getAbsolutePath() + " to " + to.getAbsolutePath());
            try {
                OSTdaemon.copyFile(from, to);
                this.moveToConverted(from);
            }
            catch (Exception e) {
                this.error(null, e);
            }
        } else {
            this.log("Error creating directory " + toDir.getAbsolutePath());
        }
    }

    public static List<BufferedImage> readStackBioformats(File filename) throws Exception {
        loci.formats.ImageReader imageReader = new loci.formats.ImageReader();
        imageReader.setId(filename.getPath());
        int count = imageReader.getImageCount();
        int subid = 0;
        LinkedList<BufferedImage> list = new LinkedList<BufferedImage>();
        int id = 0;
        while (id < count) {
            EvPixels pixels = (EvPixels)new BioformatsSliceIO((IFormatReader)imageReader, 0, id, (Object)filename, false).get(new ProgressHandle());
            BufferedImage i = pixels.quickReadOnlyAWT();
            int w = i.getWidth();
            int h = i.getHeight();
            BufferedImage im = new BufferedImage(w, h, 10);
            float[][] matrix = new float[][]{{0.0f, 0.0f, 0.0f}};
            if (i.getRaster().getNumBands() == 1) {
                matrix = new float[][]{{0.0f}};
            } else if (i.getRaster().getNumBands() == 2) {
                matrix = new float[][]{{0.0f, 0.0f}};
            } else if (i.getRaster().getNumBands() == 3) {
                matrix = new float[][]{{0.0f, 0.0f, 0.0f}};
            }
            matrix[0][subid] = 1.0f;
            BandCombineOp op = new BandCombineOp(matrix, new RenderingHints(null));
            op.filter(i.getRaster(), im.getRaster());
            list.add(im);
            ++id;
        }
        imageReader.close();
        return list;
    }

    public static List<BufferedImage> readStackJAI(File from) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(from);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
        if (!readers.hasNext()) {
            throw new RuntimeException("no image reader found");
        }
        ImageReader reader = readers.next();
        reader.setInput(stream);
        int n = reader.getNumImages(true);
        System.out.println("numImages = " + n);
        LinkedList<BufferedImage> imlist = new LinkedList<BufferedImage>();
        int i = 0;
        while (i < n) {
            BufferedImage image = reader.read(i);
            imlist.add(image);
            ++i;
        }
        stream.close();
        return imlist;
    }

    public BufferedImage readSliceHelper(File from) {
        try {
            if (from.getName().endsWith(".tif") || from.getName().endsWith(".tiff")) {
                ImageReader imr = ImageIO.getImageReadersByFormatName("tiff").next();
                imr.setInput(new FileImageInputStream(from));
                WritableRaster ir = imr.read(0).getRaster();
                int type = ir.getSampleModel().getDataType();
                if (type == 0) {
                    type = 10;
                }
                BufferedImage bim = new BufferedImage(ir.getWidth(), ir.getHeight(), type);
                WritableRaster wr = bim.getRaster();
                wr.setRect(ir);
                return bim;
            }
            return ImageIO.read(from);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void convertSlice(File from) {
        String filename = from.getName();
        String argImageset = filename.substring(0, filename.indexOf(45));
        String rest = filename.substring(argImageset.length() + 1);
        String argChannel = rest.substring(0, rest.indexOf(45));
        String rest2 = rest.substring(argChannel.length() + 1);
        String argFrameS = rest2.substring(0, rest2.indexOf(45));
        String rest3 = rest2.substring(argFrameS.length() + 1);
        int argFrame = Integer.parseInt(argFrameS);
        int argSlice = Integer.parseInt(OSTdaemon.chopFileEnding(rest3));
        this.log("Converting slice " + argImageset + " / " + argChannel + " / " + argFrame + " / " + argSlice);
        try {
            BufferedImage im = this.readSliceHelper(from);
            if (im == null) {
                this.error("Could not read " + from, null);
                return;
            }
            File toFile = this.outputImageName(argImageset, argChannel, this.getOutputFormat(argChannel), argFrame, argSlice);
            this.saveImage(im, toFile, (float)this.getCompressionLevel(argChannel) / 100.0f);
            if (this.makeMaxChannel.contains(argChannel)) {
                this.log("Max not supported for slices yet");
            }
        }
        catch (Exception e) {
            this.error(null, e);
        }
        this.moveToConverted(from);
    }

    public BufferedImage calcMaxStack(List<BufferedImage> imlist) {
        LinkedList<BufferedImage> newlist = new LinkedList<BufferedImage>();
        for (BufferedImage im : imlist) {
            if (this.skipBlackSlices && OSTdaemon.isBlackSlice(im) || this.skipWhiteSlices && OSTdaemon.isWhiteSlice(im)) continue;
            newlist.add(im);
        }
        imlist = newlist;
        Iterator<BufferedImage> it = imlist.iterator();
        BufferedImage fim = it.next();
        int height = fim.getHeight();
        int width = fim.getWidth();
        BufferedImage maxim = fim.getSubimage(0, 0, width, height);
        WritableRaster maxRaster = maxim.getRaster();
        while (it.hasNext()) {
            BufferedImage im = it.next();
            WritableRaster imRaster = im.getRaster();
            int ay = 0;
            while (ay < height) {
                int ax = 0;
                while (ax < width) {
                    double lastSample;
                    double s = imRaster.getSampleDouble(ax, ay, 0);
                    if (s > (lastSample = maxRaster.getSampleDouble(ax, ay, 0))) {
                        maxRaster.setSample(ax, ay, 0, s);
                    }
                    ++ax;
                }
                ++ay;
            }
        }
        return maxim;
    }

    public void convertStack(File from) {
        String filename = from.getName();
        String argImageset = filename.substring(0, filename.indexOf(45));
        String rest = filename.substring(argImageset.length() + 1);
        String argChannel = rest.substring(0, rest.indexOf(45));
        String rest2 = rest.substring(argChannel.length() + 1);
        int argFrame = Integer.parseInt(OSTdaemon.chopFileEnding(rest2));
        this.log("Converting stack " + argImageset + " / " + argChannel + " / " + argFrame);
        try {
            System.out.println("read stack");
            List<BufferedImage> slices = OSTdaemon.readStackBioformats(from);
            System.out.println("storing slices");
            int newz = 0;
            int numz = slices.size();
            int i = 0;
            while (i < numz) {
                BufferedImage im = slices.get(i);
                if (!(this.skipBlackSlices && OSTdaemon.isBlackSlice(im) || this.skipWhiteSlices && OSTdaemon.isWhiteSlice(im))) {
                    File toFile = this.outputImageName(argImageset, argChannel, this.getOutputFormat(argChannel), argFrame, newz);
                    this.saveImage(im, toFile, (float)this.getCompressionLevel(argChannel) / 100.0f);
                    ++newz;
                } else {
                    System.out.println("Skipping slice " + i);
                }
                ++i;
            }
            System.out.println("make max");
            if (this.makeMaxChannel.contains(argChannel)) {
                this.log("Making max channel");
                BufferedImage im = this.calcMaxStack(slices);
                File toFile = this.outputImageName(argImageset, String.valueOf(argChannel) + "max", this.getOutputFormat(String.valueOf(argChannel) + "max"), argFrame, 0);
                this.saveImage(im, toFile, (float)this.getCompressionLevel(argChannel) / 100.0f);
            }
            this.moveToConverted(from);
        }
        catch (Exception e) {
            this.error(null, e);
        }
    }

    public void saveImage(BufferedImage im, File toFile, float quality) throws Exception {
        String fileEnding = OSTdaemon.getFileEnding(toFile.getName());
        if (fileEnding.equals("jpg") || fileEnding.equals("jpeg")) {
            OSTdaemon.saveJPEG(im, toFile, quality);
        } else {
            ImageIO.write((RenderedImage)im, fileEnding, toFile);
        }
    }

    public static void saveJPEG(BufferedImage im, File out, float quality) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(quality);
        FileImageOutputStream toStream = new FileImageOutputStream(out);
        writer.setOutput(toStream);
        writer.write(null, new IIOImage(im, null, null), iwp);
    }

    private boolean isImageFile(String filename) {
        return filename.endsWith(".tif") || filename.endsWith(".tiff") || filename.endsWith(".png") || filename.endsWith(".jpeg") || filename.endsWith(".jpg") || filename.endsWith(".bmp") || filename.endsWith(".pict");
    }

    private boolean isStack(String filename) {
        int numdash = 0;
        while (filename.indexOf(45) >= 0) {
            ++numdash;
            filename = filename.substring(filename.indexOf(45) + 1);
        }
        return numdash == 2;
    }

    private static String getFileEnding(String s) {
        return s.substring(s.lastIndexOf(46) + 1);
    }

    public static String chopFileEnding(String s) {
        int pos = s.lastIndexOf(46);
        if (pos >= 0) {
            return s.substring(0, pos);
        }
        return s;
    }

    public void moveToConverted(File from) {
        if (this.deleteInput) {
            from.delete();
            this.log("Deleted converted " + from.getAbsolutePath());
        } else {
            File to = new File(this.pathConverted, from.getName());
            if (from.renameTo(to)) {
                this.log("Moved " + from.getAbsolutePath() + " to " + to.getAbsolutePath());
            } else {
                this.log("Failed to move " + from.getAbsolutePath() + " to " + to.getAbsolutePath());
            }
        }
    }

    public static boolean isBlackSlice(BufferedImage im) {
        WritableRaster r = im.getRaster();
        double p = r.getSampleDouble(0, 0, 0);
        return p < 0.01;
    }

    public static boolean isWhiteSlice(BufferedImage im) {
        WritableRaster r = im.getRaster();
        double p = r.getSampleDouble(0, 0, 0);
        return p > 254.99;
    }

    private void shutDownLoop() {
        if (this.shutDown) {
            this.log("Stopped");
            this.isRunning = false;
            while (this.shutDown) {
                try {
                    OSTdaemon.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.isRunning = true;
            this.log("Started");
        }
    }

    public void dealWithFile(File file) {
        Incoming inc = new Incoming();
        String inp = file.getName().substring(1);
        inc.filename = inp.substring(inp.indexOf("--") + 2);
        inp = inp.substring(0, inp.indexOf("--"));
        StringTokenizer tok = new StringTokenizer(inp, "-");
        System.out.println(inc.filename);
        if (tok.hasMoreElements()) {
            inc.cmd = tok.nextToken().toLowerCase();
        }
        while (tok.hasMoreElements()) {
            String te = tok.nextToken();
            if (te.indexOf(95) >= 0) {
                String attr = te.substring(0, te.indexOf(95));
                String value = te.substring(te.indexOf(95) + 1);
                System.out.println(String.valueOf(attr) + " - " + value);
                inc.param.put(attr, value);
                continue;
            }
            inc.param.put(te, null);
        }
        if (!(inc.cmd.equals("image") || inc.cmd.equals("data") || inc.cmd.equals("newxml"))) {
            inc.cmd.equals("incxml");
        }
    }

    @Override
    public void run() {
        this.shutDown = true;
        while (true) {
            this.shutDownLoop();
            try {
                File dir = new File(this.pathInput);
                if (!dir.exists()) {
                    this.log("ERROR: input directory does not exist");
                } else {
                    File[] fileArray = dir.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        this.shutDownLoop();
                        if (file.exists()) {
                            String filename = file.getName();
                            if (!file.getName().startsWith(".")) {
                                this.log(filename);
                                if (filename.startsWith("-")) {
                                    this.dealWithFile(file);
                                } else if (filename.equals("settings")) {
                                    this.readConfig(file.getAbsolutePath());
                                } else if (filename.endsWith(".rmd")) {
                                    this.readMeta1(file);
                                } else if (filename.endsWith("-new.xml")) {
                                    this.copyMeta2(file);
                                } else if (filename.endsWith(".xml")) {
                                    this.readMeta2(file);
                                } else if (filename.indexOf("-data-") >= 0) {
                                    this.copyExtra(file);
                                } else if (this.isImageFile(filename)) {
                                    if (this.isStack(filename)) {
                                        this.convertStack(file);
                                    } else {
                                        this.convertSlice(file);
                                    }
                                } else {
                                    this.log("File does not match rules: " + filename);
                                }
                            }
                        } else {
                            System.out.println("Main loop: Could not find file: " + file.getAbsolutePath() + " (probably removed by user)");
                        }
                        ++n2;
                    }
                }
            }
            catch (RuntimeException e) {
                this.daemonListener.daemonError("Internal error", e);
            }
            try {
                OSTdaemon.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static String pad(int i, int pad) {
        String s = "" + i;
        while (s.length() < pad) {
            s = "0" + s;
        }
        return s;
    }

    public static void copyFile(File in, File out) throws Exception {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    private static class Incoming {
        public String filename;
        public String cmd = "";
        public Map<String, String> param = new HashMap<String, String>();

        private Incoming() {
        }
    }
}

