/*
 * Decompiled with CFR 0.152.
 */
package OSTdaemon;

import OSTdaemon.DaemonListener;
import OSTdaemon.OSTdaemon;
import endrov.core.log.EvLog;
import endrov.core.log.EvLogStdout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GUI
extends JFrame
implements ActionListener,
WindowListener,
DaemonListener {
    static final long serialVersionUID = 0L;
    JTextArea logPanel = new JTextArea();
    JButton bQuit = new JButton("Quit");
    JButton bConfig = new JButton("Read config");
    JButton bStartstop = new JButton("Start");
    OSTdaemon daemon = new OSTdaemon(this);
    private boolean toQuit = false;

    public GUI(String daemonConfig) {
        this.setTitle("OST Daemon");
        this.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.logPanel, 20, 30);
        JPanel bp = new JPanel(new GridLayout(1, 1));
        bp.add(this.bStartstop);
        bp.add(this.bConfig);
        bp.add(this.bQuit);
        this.add((Component)sp, "Center");
        this.add((Component)bp, "South");
        this.bQuit.addActionListener(this);
        this.bConfig.addActionListener(this);
        this.bStartstop.addActionListener(this);
        this.pack();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.setBounds(100, 50, 600, 500);
        this.setVisible(true);
        this.daemon.readConfig(daemonConfig);
        this.daemon.start();
    }

    public void daemonLog(String s) {
        int textLen = 25000;
        GregorianCalendar cal = new GregorianCalendar();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String date = year + OSTdaemon.pad(month, 2) + OSTdaemon.pad(day, 2) + " " + OSTdaemon.pad(hour, 2) + ":" + OSTdaemon.pad(min, 2) + ":" + OSTdaemon.pad(sec, 2);
        String newText = String.valueOf(date) + ": " + s + "\n" + this.logPanel.getText();
        if (newText.length() > textLen) {
            newText = newText.substring(0, textLen);
        }
        this.logPanel.setText(newText);
        if (s.equals("Stopped")) {
            this.bStartstop.setText("Start");
            if (this.toQuit) {
                System.exit(0);
            }
        }
    }

    public void daemonError(String s, Exception e) {
        String total = "";
        if (s != null) {
            total = String.valueOf(s) + "\n";
        }
        if (e != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            total = String.valueOf(total) + e.getMessage() + "\n" + sw.toString();
        }
        this.daemonLog(total);
        if (e != null) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void quit() {
        int answer = JOptionPane.showConfirmDialog(null, "Do you really want to quit?", "Confirm", 0);
        if (answer == 0) {
            if (!this.daemon.isRunning()) {
                System.exit(0);
            } else {
                this.toQuit = true;
                this.daemon.shutDown();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bQuit) {
            this.quit();
        } else if (e.getSource() == this.bConfig) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                String filename = chooser.getSelectedFile().getAbsolutePath();
                this.daemon.readConfig(filename);
            }
        } else if (e.getSource() == this.bStartstop) {
            if (this.daemon.isRunning()) {
                this.bStartstop.setText("Shutting down");
                this.daemon.shutDown();
            } else {
                this.daemon.go();
                this.bStartstop.setText("Stop");
            }
        }
    }

    public void windowClosing(WindowEvent e) {
        this.quit();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] arg) {
        EvLog.addListener((EvLog)new EvLogStdout());
        String daemonConfig = "OSTdaemon/config.txt";
        if (arg.length > 0) {
            daemonConfig = arg[0];
        }
        new GUI(daemonConfig);
    }
}

