/*
 * Decompiled with CFR 0.152.
 */
package ome.util.actions;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.InternalException;
import ome.util.SqlAction;
import ome.util.actions.PsqlStrings;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresSqlAction
extends SqlAction.Impl {
    private final SimpleJdbcOperations jdbc;
    private static final String synchronizeJobsSql = PsqlStrings.getString("sql_action.sync_jobs");
    private static final String findRepoFileSql = PsqlStrings.getString("sql_action.find_repo_file");
    public static final String insertFormatSql = PsqlStrings.getString("sql_action.insert_format");
    private static final String logLoaderQuerySql = PsqlStrings.getString("sql_action.log_loader_query");
    private static final String logLoaderInsertSql = PsqlStrings.getString("sql_action.log_loader_insert");
    private static final String logLoaderUpdateSql = PsqlStrings.getString("sql_action.log_loader_update");
    private static final String logLoaderDeleteSql = PsqlStrings.getString("sql_action.log_loader_delete");

    public PostgresSqlAction(SimpleJdbcOperations jdbc) {
        this.jdbc = jdbc;
    }

    @Override
    protected SimpleJdbcOperations _jdbc() {
        return this.jdbc;
    }

    @Override
    protected String _lookup(String key) {
        return PsqlStrings.getString("sql_action." + key);
    }

    @Override
    public void prepareSession(long eventId, long userId, long groupId) {
        JdbcTemplate jt = (JdbcTemplate)this._jdbc().getJdbcOperations();
        SimpleJdbcCall call = new SimpleJdbcCall(jt).withFunctionName("_prepare_session");
        MapSqlParameterSource in = new MapSqlParameterSource();
        in.addValue("_event_id", (Object)eventId);
        in.addValue("_user_id", (Object)userId);
        in.addValue("_group_id", (Object)groupId);
        call.executeFunction(Void.TYPE, (SqlParameterSource)in);
    }

    @Override
    public boolean activeSession(String sessionUUID) {
        int count = this._jdbc().queryForInt(this._lookup("active_session"), new Object[]{sessionUUID});
        return count > 0;
    }

    @Override
    public int synchronizeJobs(List<Long> ids) {
        int count = 0;
        if (ids.size() > 0) {
            HashMap<String, List<Long>> m = new HashMap<String, List<Long>>();
            m.put("ids", ids);
            count += this._jdbc().update(synchronizeJobsSql + this._lookup("id_not_in"), m);
        } else {
            count += this._jdbc().update(synchronizeJobsSql, new Object[0]);
        }
        return count;
    }

    @Override
    public Long findRepoFile(String uuid, String dirname, String basename, String mimetype) {
        if (mimetype != null) {
            return this._jdbc().queryForLong(findRepoFileSql + this._lookup("and_mimetype"), new Object[]{uuid, dirname, basename, mimetype});
        }
        return this._jdbc().queryForLong(findRepoFileSql, new Object[]{uuid, dirname, basename});
    }

    @Override
    public String findRepoFilePath(String uuid, long id) {
        try {
            return (String)this._jdbc().queryForObject(this._lookup("find_repo_file_path"), String.class, new Object[]{id, uuid});
        }
        catch (EmptyResultDataAccessException erdae) {
            return null;
        }
    }

    @Override
    public List<Long> findRepoPixels(String uuid, String dirname, String basename) {
        return this._jdbc().query(this._lookup("find_repo_pixels"), (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet arg0, int arg1) throws SQLException {
                return arg0.getLong(1);
            }
        }, new Object[]{uuid, dirname, basename});
    }

    @Override
    public Long findRepoImageFromPixels(long id) {
        return this._jdbc().queryForLong(this._lookup("find_repo_image_from_pixels"), new Object[]{id});
    }

    @Override
    public int repoScriptCount(String uuid) {
        return this._jdbc().queryForInt(this._lookup("repo_script_count"), new Object[]{uuid});
    }

    @Override
    public Long nextSessionId() {
        return this._jdbc().queryForLong(this._lookup("next_session"), new Object[0]);
    }

    @Override
    public List<Long> fileIdsInDb(String uuid) {
        return this._jdbc().query(this._lookup("file_id_in_db"), (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet arg0, int arg1) throws SQLException {
                return arg0.getLong(1);
            }
        }, new Object[]{uuid});
    }

    @Override
    public Map<String, Object> repoFile(long value) {
        return this._jdbc().queryForMap(this._lookup("repo_file"), new Object[]{value});
    }

    @Override
    public long countFormat(String name) {
        return this._jdbc().queryForLong(this._lookup("count_format"), new Object[]{name});
    }

    @Override
    public int insertFormat(String name) {
        return this._jdbc().update(insertFormatSql, new Object[]{name});
    }

    @Override
    public int closeSessions(String uuid) {
        return this._jdbc().update(this._lookup("update_session"), new Object[]{uuid});
    }

    @Override
    public long nodeId(String internal_uuid) {
        return this._jdbc().queryForLong(this._lookup("internal_uuid"), new Object[]{internal_uuid});
    }

    @Override
    public int insertSession(Map<String, Object> params) {
        return this._jdbc().update(this._lookup("insert_session"), params);
    }

    @Override
    public Long sessionId(String uuid) {
        return this._jdbc().queryForLong(this._lookup("session_id"), new Object[]{uuid});
    }

    @Override
    public int isFileInRepo(String uuid, long id) {
        return this._jdbc().queryForInt(this._lookup("is_file_in_repo"), new Object[]{uuid, id});
    }

    @Override
    public int removePassword(Long id) {
        return this._jdbc().update(this._lookup("remove_pass"), new Object[]{id});
    }

    @Override
    public Date now() {
        return (Date)this._jdbc().queryForObject(this._lookup("now"), Date.class, new Object[0]);
    }

    @Override
    public int updateConfiguration(String key, String value) {
        return this._jdbc().update(this._lookup("update_config"), new Object[]{value, key});
    }

    @Override
    public String dbVersion() {
        return (String)this._jdbc().query(this._lookup("db_version"), (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet arg0, int arg1) throws SQLException {
                String v = arg0.getString("currentversion");
                int p = arg0.getInt("currentpatch");
                return v + "__" + p;
            }
        }, new Object[0]).get(0);
    }

    @Override
    public String dbUuid() {
        return (String)this._jdbc().query(this._lookup("db_uuid"), (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet arg0, int arg1) throws SQLException {
                String s = arg0.getString("value");
                return s;
            }
        }, new Object[0]).get(0);
    }

    @Override
    public long selectCurrentEventLog(String key) {
        return this._jdbc().queryForLong(logLoaderQuerySql, new Object[]{key});
    }

    @Override
    public void setCurrentEventLog(long id, String key) {
        int count = this._jdbc().update(logLoaderUpdateSql, new Object[]{id, key});
        if (count == 0) {
            this._jdbc().update(logLoaderInsertSql, new Object[]{key, id});
        }
    }

    @Override
    public void delCurrentEventLog(String key) {
        this._jdbc().update(logLoaderDeleteSql, new Object[]{key});
    }

    @Override
    public long nextValue(String segmentValue, int incrementSize) {
        return this._jdbc().queryForLong(this._lookup("next_val"), new Object[]{segmentValue, incrementSize});
    }

    @Override
    public long currValue(String segmentName) {
        try {
            long next_value = this._jdbc().queryForLong(this._lookup("curr_val"), new Object[]{segmentName});
            return next_value;
        }
        catch (EmptyResultDataAccessException erdae) {
            return -1L;
        }
    }

    @Override
    public void insertLogs(List<Object[]> batchData) {
        this._jdbc().batchUpdate(this._lookup("insert_logs"), batchData);
    }

    @Override
    public List<Map<String, Object>> roiByImageAndNs(long imageId, String ns) {
        String queryString = this._lookup("roi_by_image_and_ns");
        List mapList = this._jdbc().queryForList(queryString, new Object[]{imageId, ns});
        return mapList;
    }

    @Override
    public List<Long> getShapeIds(long roiId) {
        return this._jdbc().query(this._lookup("shape_ids"), (RowMapper)new SqlAction.IdRowMapper(), new Object[]{roiId});
    }

    @Override
    public boolean setUserPassword(Long experimenterID, String password) {
        int results = this._jdbc().update(this._lookup("update_password"), new Object[]{password, experimenterID});
        if (results < 1) {
            results = this._jdbc().update(this._lookup("insert_password"), new Object[]{experimenterID, password, null});
        }
        return results >= 1;
    }

    @Override
    public String getPasswordHash(Long experimenterID) {
        String stored;
        try {
            stored = (String)this._jdbc().queryForObject(this._lookup("password_hash"), String.class, new Object[]{experimenterID});
        }
        catch (EmptyResultDataAccessException e) {
            stored = null;
        }
        return stored;
    }

    @Override
    public Long getUserId(String userName) {
        Long id;
        try {
            id = (Long)this._jdbc().queryForObject(this._lookup("user_id"), Long.class, new Object[]{userName});
        }
        catch (EmptyResultDataAccessException e) {
            id = null;
        }
        return id;
    }

    @Override
    public List<String> getUserGroups(String userName) {
        List roles;
        try {
            roles = this._jdbc().query(this._lookup("user_groups"), (RowMapper)new RowMapper<String>(){

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getString(1);
                }
            }, new Object[]{userName});
        }
        catch (EmptyResultDataAccessException e) {
            roles = null;
        }
        return roles == null ? new ArrayList() : roles;
    }

    @Override
    public void setFileRepo(long id, String repoId) {
        this._jdbc().update(this._lookup("set_file_repo"), new Object[]{repoId, id});
    }

    @Override
    public void setPixelsNamePathRepo(long pixId, String name, String path, String repoId) {
        this._jdbc().update(this._lookup("update_pixels_name"), new Object[]{name, pixId});
        this._jdbc().update(this._lookup("update_pixels_path"), new Object[]{path, pixId});
        this._jdbc().update(this._lookup("update_pixels_repo"), new Object[]{repoId, pixId});
    }

    @Override
    public List<Long> getDeletedIds(String entityType) {
        String sql = this._lookup("get_delete_ids");
        RowMapper<Long> mapper = new RowMapper<Long>(){

            public Long mapRow(ResultSet resultSet, int rowNum) throws SQLException {
                Long id = new Long(resultSet.getString(1));
                return id;
            }
        };
        List list = this._jdbc().query(sql, (RowMapper)mapper, new Object[]{entityType});
        return list;
    }

    @Override
    public void createSavepoint(String savepoint) {
        this.call("SAVEPOINT DEL", savepoint);
    }

    @Override
    public void releaseSavepoint(String savepoint) {
        this.call("RELEASE SAVEPOINT DEL", savepoint);
    }

    @Override
    public void rollbackSavepoint(String savepoint) {
        this.call("ROLLBACK TO SAVEPOINT DEL", savepoint);
    }

    private void call(final String call, final String savepoint) {
        this._jdbc().getJdbcOperations().execute(new ConnectionCallback(){

            public Object doInConnection(Connection connection) throws SQLException {
                connection.prepareCall(call + savepoint).execute();
                return null;
            }
        });
    }

    @Override
    public void deferConstraints() {
        this._jdbc().getJdbcOperations().execute(new ConnectionCallback(){

            public Object doInConnection(Connection connection) throws SQLException {
                Statement statement = connection.createStatement();
                statement.execute("set constraints all deferred;");
                return null;
            }
        });
    }

    @Override
    public Set<String> currentUserNames() {
        List names = this._jdbc().query(this._lookup("current_user_names"), (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet arg0, int arg1) throws SQLException {
                return arg0.getString(1);
            }
        }, new Object[0]);
        return new HashSet<String>(names);
    }

    @Override
    public int setFileParam(long id, String key, String value) {
        Map<String, String> params = this.getFileParams(id);
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put(key, value);
        return this.setFileParams(id, params);
    }

    @Override
    public int setFileParams(long id, Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return this._jdbc().update(this._lookup("set_file_params_null"), new Object[]{id});
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        sb.append(this._lookup("set_file_params_1"));
        for (String key : params.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(this._lookup("set_file_params_2"));
            }
            sb.append(this._lookup("set_file_params_3"));
            list.add(key);
            list.add(params.get(key));
        }
        sb.append(this._lookup("set_file_params4"));
        list.add(id);
        return this._jdbc().update(sb.toString(), list.toArray(new Object[list.size()]));
    }

    @Override
    public Map<String, String> getFileParams(long id) throws InternalException {
        try {
            return (Map)this._jdbc().queryForObject(this._lookup("get_file_params"), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet arg0, int arg1) throws SQLException {
                    HashMap<String, String> params = new HashMap<String, String>();
                    Array arr1 = arg0.getArray(1);
                    if (arr1 == null) {
                        return params;
                    }
                    String[][] arr2 = (String[][])arr1.getArray();
                    for (int i = 0; i < arr2.length; ++i) {
                        params.put(arr2[i][0], arr2[i][1]);
                    }
                    return params;
                }
            }, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (UncategorizedSQLException e) {
            throw new InternalException("Potential jdbc jar error.");
        }
    }

    @Override
    public List<String> getFileParamKeys(long id) throws InternalException {
        try {
            return (List)this._jdbc().queryForObject(this._lookup("get_file_param_keys"), (RowMapper)new RowMapper<List<String>>(){

                public List<String> mapRow(ResultSet arg0, int arg1) throws SQLException {
                    ArrayList<String> keys = new ArrayList<String>();
                    Array arr1 = arg0.getArray(1);
                    if (arr1 == null) {
                        return keys;
                    }
                    String[][] arr2 = (String[][])arr1.getArray();
                    for (int i = 0; i < arr2.length; ++i) {
                        keys.add(arr2[i][0]);
                    }
                    return keys;
                }
            }, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (UncategorizedSQLException e) {
            throw new InternalException("Potential jdbc jar error.");
        }
    }

    @Override
    public int setPixelsParam(long id, String key, String value) {
        Map<String, String> params = this.getPixelsParams(id);
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put(key, value);
        return this.setPixelsParams(id, params);
    }

    @Override
    public int setPixelsParams(long id, Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return this._jdbc().update(this._lookup("set_pixel_params_null"), new Object[]{id});
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        sb.append(this._lookup("set_pixels_params_1"));
        for (String key : params.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(this._lookup("set_pixels_params_2"));
            }
            sb.append(this._lookup("set_pixels_params_3"));
            list.add(key);
            list.add(params.get(key));
        }
        sb.append(this._lookup("set_pixels_params_4"));
        list.add(id);
        return this._jdbc().update(sb.toString(), list.toArray(new Object[list.size()]));
    }

    @Override
    public Map<String, String> getPixelsParams(long id) throws InternalException {
        try {
            return (Map)this._jdbc().queryForObject(this._lookup("get_pixels_params"), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet arg0, int arg1) throws SQLException {
                    HashMap<String, String> params = new HashMap<String, String>();
                    Array arr1 = arg0.getArray(1);
                    if (arr1 == null) {
                        return params;
                    }
                    String[][] arr2 = (String[][])arr1.getArray();
                    for (int i = 0; i < arr2.length; ++i) {
                        params.put(arr2[i][0], arr2[i][1]);
                    }
                    return params;
                }
            }, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (UncategorizedSQLException e) {
            throw new InternalException("Potential jdbc jar error.");
        }
    }

    @Override
    public List<String> getPixelsParamKeys(long id) throws InternalException {
        try {
            return (List)this._jdbc().queryForObject(this._lookup("get_pixels_params_keys"), (RowMapper)new RowMapper<List<String>>(){

                public List<String> mapRow(ResultSet arg0, int arg1) throws SQLException {
                    ArrayList<String> keys = new ArrayList<String>();
                    Array arr1 = arg0.getArray(1);
                    if (arr1 == null) {
                        return keys;
                    }
                    String[][] arr2 = (String[][])arr1.getArray();
                    for (int i = 0; i < arr2.length; ++i) {
                        keys.add(arr2[i][0]);
                    }
                    return keys;
                }
            }, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (UncategorizedSQLException e) {
            throw new InternalException("Potential jdbc jar error.");
        }
    }

    @Override
    public List<String> getPixelsNamePathRepo(long id) throws InternalException {
        try {
            return (List)this._jdbc().queryForObject(this._lookup("get_pixels_name_path_repo"), (RowMapper)new RowMapper<List<String>>(){

                public List<String> mapRow(ResultSet arg0, int arg1) throws SQLException {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(arg0.getString(1));
                    values.add(arg0.getString(2));
                    values.add(arg0.getString(3));
                    return values;
                }
            }, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (UncategorizedSQLException e) {
            throw new InternalException("Potential jdbc jar error.");
        }
    }
}

