/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PixelData {
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 5;
    public static final int BIT = 6;
    protected String pixelsType;
    protected ByteBuffer data;
    protected boolean isSigned;
    protected boolean isFloat;
    protected int javaType;
    protected int bytesPerPixel;
    protected double minimum;
    protected double maximum;

    public PixelData(String pixelsType, ByteBuffer data) {
        this.data = data;
        this.pixelsType = pixelsType;
        this.bytesPerPixel = this.bytesPerPixel();
        if (pixelsType.equals("int8")) {
            this.isSigned = true;
            this.isFloat = false;
            this.javaType = 0;
            this.minimum = -2.147483648E9;
            this.maximum = 2.147483647E9;
        } else if (pixelsType.equals("uint8")) {
            this.isSigned = false;
            this.isFloat = false;
            this.javaType = 0;
            this.minimum = 0.0;
            this.maximum = 255.0;
        } else if (pixelsType.equals("int16")) {
            this.isSigned = true;
            this.isFloat = false;
            this.javaType = 1;
            this.minimum = -32768.0;
            this.maximum = 32767.0;
        } else if (pixelsType.equals("uint16")) {
            this.isSigned = false;
            this.isFloat = false;
            this.javaType = 1;
            this.minimum = 0.0;
            this.maximum = 65535.0;
        } else if (pixelsType.equals("int32")) {
            this.isSigned = true;
            this.isFloat = false;
            this.javaType = 2;
            this.minimum = -2.147483648E9;
            this.maximum = 2.147483647E9;
        } else if (pixelsType.equals("uint32")) {
            this.isSigned = false;
            this.isFloat = false;
            this.javaType = 2;
            this.minimum = 0.0;
            this.maximum = 4.294967295E9;
        } else if (pixelsType.equals("float")) {
            this.isSigned = true;
            this.isFloat = true;
            this.javaType = 4;
            this.minimum = 1.4E-45f;
            this.maximum = 3.4028234663852886E38;
        } else if (pixelsType.equals("double")) {
            this.isSigned = true;
            this.isFloat = true;
            this.javaType = 5;
            this.minimum = Double.MIN_VALUE;
            this.maximum = Double.MAX_VALUE;
        } else if (pixelsType.equals("bit")) {
            this.isSigned = false;
            this.isFloat = false;
            this.javaType = 6;
            this.minimum = 0.0;
            this.maximum = 1.0;
        } else {
            throw new IllegalArgumentException("Unknown pixel type: " + pixelsType);
        }
    }

    public boolean in(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (!this.pixelsType.equals(strings[i])) continue;
            return true;
        }
        return false;
    }

    public int bytesPerPixel() {
        if (this.pixelsType.equals("bit")) {
            return 1;
        }
        return PixelData.getBitDepth(this.pixelsType) / 8;
    }

    public int javaType() {
        return this.javaType;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isFloat() {
        return this.isFloat;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setPixelValue(int offset, double value) {
        this.setPixelValueDirect(offset * this.bytesPerPixel, value);
    }

    public void setPixelValueDirect(int offset, double value) {
        switch (this.javaType) {
            case 6: {
                int byteOffset = offset / 8;
                byte x = this.data.get(byteOffset);
                if (value == 0.0) {
                    this.data.put(byteOffset, (byte)(x & ~(1 << 7 - offset % 8)));
                    break;
                }
                this.data.put(byteOffset, (byte)(x | 1 << 7 - offset % 8));
                break;
            }
            case 0: {
                this.data.put(offset, (byte)value);
                break;
            }
            case 1: {
                this.data.putShort(offset, (short)value);
                break;
            }
            case 2: {
                this.data.putInt(offset, (int)value);
                break;
            }
            case 4: {
                this.data.putFloat(offset, (float)value);
                break;
            }
            case 5: {
                this.data.putDouble(offset, value);
            }
        }
    }

    public double getPixelValue(int offset) {
        return this.getPixelValueDirect(offset * this.bytesPerPixel);
    }

    public double getPixelValueDirect(int offset) {
        if (this.isSigned()) {
            switch (this.javaType) {
                case 0: {
                    return this.data.get(offset);
                }
                case 1: {
                    return this.data.getShort(offset);
                }
                case 2: {
                    return this.data.getInt(offset);
                }
                case 4: {
                    return this.data.getFloat(offset);
                }
                case 5: {
                    return this.data.getDouble(offset);
                }
            }
        } else {
            switch (this.javaType) {
                case 6: {
                    return this.data.get(offset / 8) >> 7 - offset % 8 & 1;
                }
                case 0: {
                    return (short)(this.data.get(offset) & 0xFF);
                }
                case 1: {
                    return this.data.getShort(offset) & 0xFFFF;
                }
                case 2: {
                    return (long)this.data.getInt(offset) & 0xFFFFFFFFL;
                }
                case 4: {
                    return this.data.getFloat(offset);
                }
                case 5: {
                    return this.data.getDouble(offset);
                }
            }
        }
        throw new RuntimeException("Unknown pixel type.");
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public ByteOrder getOrder() {
        return this.data.order();
    }

    public void setOrder(ByteOrder order) {
        this.data.order(order);
    }

    public int size() {
        return this.data.capacity() / this.bytesPerPixel;
    }

    public static int getBitDepth(String type) {
        if (type.equals("int8") || type.equals("uint8")) {
            return 8;
        }
        if (type.equals("int16") || type.equals("uint16")) {
            return 16;
        }
        if (type.equals("int32") || type.equals("uint32") || type.equals("float")) {
            return 32;
        }
        if (type.equals("double")) {
            return 64;
        }
        if (type.equals("bit")) {
            return 1;
        }
        throw new RuntimeException("Pixels type '" + type + "' unsupported by nio.");
    }
}

