/*
 * Decompiled with CFR 0.152.
 */
package ome.model.roi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.roi.Shape;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="line")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Line
extends Shape
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "line_owner_filter";
    public static final String GROUP_FILTER = "line_group_filter";
    public static final String EVENT_FILTER = "line_event_filter";
    public static final String PERMS_FILTER = "line_perms_filter";
    protected Double x1 = null;
    protected Double y1 = null;
    protected Double x2 = null;
    protected Double y2 = null;
    protected String textValue = null;
    public static final String X1 = "ome.model.roi.Line_x1";
    public static final String Y1 = "ome.model.roi.Line_y1";
    public static final String X2 = "ome.model.roi.Line_x2";
    public static final String Y2 = "ome.model.roi.Line_y2";
    public static final String TEXTVALUE = "ome.model.roi.Line_textValue";
    public static final Set<String> FIELDS;

    public Line() {
        this(null, true);
    }

    protected Line(Long id) {
        this(id, true);
    }

    public Line(Long id, boolean loaded) {
        super(id, loaded);
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="x1", updatable=true)
    public Double getX1() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.x1;
    }

    public void setX1(Double x1) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.x1 = x1;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="y1", updatable=true)
    public Double getY1() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.y1;
    }

    public void setY1(Double y1) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.y1 = y1;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="x2", updatable=true)
    public Double getX2() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.x2;
    }

    public void setX2(Double x2) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.x2 = x2;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="y2", updatable=true)
    public Double getY2() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.y2;
    }

    public void setY2(Double y2) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.y2 = y2;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="textValue", updatable=true)
    public String getTextValue() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.textValue = textValue;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Line newInstance() {
        return new Line();
    }

    public Line proxy() {
        return new Line(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.x1 = (Double)__filter.filter(X1, this.x1);
            this.y1 = (Double)__filter.filter(Y1, this.y1);
            this.x2 = (Double)__filter.filter(X2, this.x2);
            this.y2 = (Double)__filter.filter(Y2, this.y2);
            this.textValue = (String)__filter.filter(TEXTVALUE, this.textValue);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(X1)) {
            return this.getX1();
        }
        if (field.equals(Y1)) {
            return this.getY1();
        }
        if (field.equals(X2)) {
            return this.getX2();
        }
        if (field.equals(Y2)) {
            return this.getY2();
        }
        if (field.equals(TEXTVALUE)) {
            return this.getTextValue();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(X1)) {
            this.setX1((Double)value);
        } else if (field.equals(Y1)) {
            this.setY1((Double)value);
        } else if (field.equals(X2)) {
            this.setX2((Double)value);
        } else if (field.equals(Y2)) {
            this.setY2((Double)value);
        } else if (field.equals(TEXTVALUE)) {
            this.setTextValue((String)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.x1 = null;
        this.y1 = null;
        this.x2 = null;
        this.y2 = null;
        this.textValue = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(X1);
        raw.addAll(Shape.FIELDS);
        raw.add(Y1);
        raw.addAll(Shape.FIELDS);
        raw.add(X2);
        raw.addAll(Shape.FIELDS);
        raw.add(Y2);
        raw.addAll(Shape.FIELDS);
        raw.add(TEXTVALUE);
        raw.addAll(Shape.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

