/*
 * Decompiled with CFR 0.152.
 */
package ome.model.experiment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.LightSettings;
import ome.model.enums.MicrobeamManipulationType;
import ome.model.experiment.Experiment;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="microbeammanipulation_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="microbeammanipulation_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="microbeammanipulation_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="microbeammanipulation_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="microbeammanipulation_owner_filter_LIGHTSOURCESETTINGS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="microbeammanipulation_group_filter_LIGHTSOURCESETTINGS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="microbeammanipulation_event_filter_LIGHTSOURCESETTINGS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="microbeammanipulation_perms_filter_LIGHTSOURCESETTINGS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="microbeammanipulation_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="microbeammanipulation_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="microbeammanipulation_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="microbeammanipulation_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="microbeammanipulation", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_microbeammanipulation", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_microbeammanipulation"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class MicrobeamManipulation
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "microbeammanipulation_owner_filter";
    public static final String GROUP_FILTER = "microbeammanipulation_group_filter";
    public static final String EVENT_FILTER = "microbeammanipulation_event_filter";
    public static final String PERMS_FILTER = "microbeammanipulation_perms_filter";
    public static final String ID = "ome.model.experiment.MicrobeamManipulation_id";
    protected Long id;
    public static final String VERSION = "ome.model.experiment.MicrobeamManipulation_version";
    protected Integer version = 0;
    protected MicrobeamManipulationType type = null;
    protected Set<LightSettings> lightSourceSettings = new HashSet<LightSettings>();
    public static final String OWNER_FILTER_LIGHTSOURCESETTINGS = "microbeammanipulation_owner_filter_LIGHTSOURCESETTINGS";
    public static final String GROUP_FILTER_LIGHTSOURCESETTINGS = "microbeammanipulation_group_filter_LIGHTSOURCESETTINGS";
    public static final String EVENT_FILTER_LIGHTSOURCESETTINGS = "microbeammanipulation_event_filter_LIGHTSOURCESETTINGS";
    public static final String PERMS_FILTER_LIGHTSOURCESETTINGS = "microbeammanipulation_perms_filter_LIGHTSOURCESETTINGS";
    protected Experiment experiment = null;
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String TYPE = "ome.model.experiment.MicrobeamManipulation_type";
    public static final String LIGHTSOURCESETTINGS = "ome.model.experiment.MicrobeamManipulation_lightSourceSettings";
    public static final String EXPERIMENT = "ome.model.experiment.MicrobeamManipulation_experiment";
    public static final String DESCRIPTION = "ome.model.experiment.MicrobeamManipulation_description";
    public static final String DETAILS = "ome.model.experiment.MicrobeamManipulation_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public MicrobeamManipulation() {
        this(null, true);
    }

    protected MicrobeamManipulation(Long id) {
        this(id, true);
    }

    public MicrobeamManipulation(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public MicrobeamManipulation(MicrobeamManipulationType _type, Experiment _experiment) {
        this(null, true);
        this.setType(_type);
        this.setExperiment(_experiment);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_microbeammanipulation")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=MicrobeamManipulationType.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="type", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKmicrobeammanipulation_type_microbeammanipulationtype")
    public MicrobeamManipulationType getType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.type;
    }

    public void setType(MicrobeamManipulationType type) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.type = type;
    }

    @OneToMany(mappedBy="microbeamManipulation", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="microbeammanipulation_owner_filter_LIGHTSOURCESETTINGS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="microbeammanipulation_group_filter_LIGHTSOURCESETTINGS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="microbeammanipulation_event_filter_LIGHTSOURCESETTINGS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="microbeammanipulation_perms_filter_LIGHTSOURCESETTINGS", condition=":permsStr = permissions")})
    protected Set<LightSettings> getLightSourceSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.lightSourceSettings;
    }

    protected void setLightSourceSettings(Set<LightSettings> lightSourceSettings) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.lightSourceSettings = lightSourceSettings;
    }

    public int sizeOfLightSourceSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.lightSourceSettings == null ? -1 : this.lightSourceSettings.size();
    }

    public Iterator<LightSettings> iterateLightSourceSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSourceSettings() == null) {
            return new EmptyIterator<LightSettings>();
        }
        return this.getLightSourceSettings().iterator();
    }

    public Collection<LightSettings> unmodifiableLightSourceSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSourceSettings() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getLightSourceSettings());
    }

    public <E> List<E> collectLightSourceSettings(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<LightSettings> it = this.iterateLightSourceSettings();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addLightSettings(LightSettings target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSourceSettings() == null) {
            this.throwNullCollectionException("LightSourceSettings");
        }
        this.getLightSourceSettings().add(target);
        if (target != null) {
            target.setMicrobeamManipulation(this);
        }
    }

    public void addLightSettingsSet(Collection<LightSettings> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSourceSettings() == null) {
            this.throwNullCollectionException("LightSourceSettings");
        }
        this.getLightSourceSettings().addAll(targets);
        for (LightSettings target : targets) {
            if (target == null) continue;
            target.setMicrobeamManipulation(this);
        }
    }

    public void removeLightSettings(LightSettings target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSourceSettings() == null) {
            this.throwNullCollectionException("LightSourceSettings");
        }
        this.getLightSourceSettings().remove(target);
        target.setMicrobeamManipulation(null);
    }

    public void removeLightSettingsSet(Collection<LightSettings> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSourceSettings() == null) {
            this.throwNullCollectionException("LightSourceSettings");
        }
        this.getLightSourceSettings().removeAll(targets);
        for (LightSettings target : targets) {
            target.setMicrobeamManipulation(null);
        }
    }

    public void clearLightSourceSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSourceSettings() == null) {
            this.throwNullCollectionException("LightSourceSettings");
        }
        this.getLightSourceSettings().clear();
        Iterator<LightSettings> it = this.iterateLightSourceSettings();
        while (it.hasNext()) {
            LightSettings target = it.next();
            target.setMicrobeamManipulation(null);
        }
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Experiment.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="experiment", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKmicrobeammanipulation_experiment_experiment")
    public Experiment getExperiment() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.experiment;
    }

    public void setExperiment(Experiment experiment) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.experiment = experiment;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public MicrobeamManipulation newInstance() {
        return new MicrobeamManipulation();
    }

    public MicrobeamManipulation proxy() {
        return new MicrobeamManipulation(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.type = (MicrobeamManipulationType)__filter.filter(TYPE, this.type);
            this.lightSourceSettings = (Set)__filter.filter(LIGHTSOURCESETTINGS, this.lightSourceSettings);
            this.experiment = (Experiment)__filter.filter(EXPERIMENT, this.experiment);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(LIGHTSOURCESETTINGS)) {
            return this.getLightSourceSettings();
        }
        if (field.equals(EXPERIMENT)) {
            return this.getExperiment();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(TYPE)) {
            this.setType((MicrobeamManipulationType)value);
        } else if (field.equals(LIGHTSOURCESETTINGS)) {
            this.setLightSourceSettings((Set)value);
        } else if (field.equals(EXPERIMENT)) {
            this.setExperiment((Experiment)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.type = null;
        this.lightSourceSettings = null;
        this.experiment = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(TYPE);
        raw.add(LIGHTSOURCESETTINGS);
        raw.add(EXPERIMENT);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKmicrobeammanipulation_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKmicrobeammanipulation_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKmicrobeammanipulation_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKmicrobeammanipulation_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKmicrobeammanipulation_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

