/*
 * Decompiled with CFR 0.152.
 */
package ome.model.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.PixelsAnnotationLink;
import ome.model.core.Channel;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.core.PixelsOriginalFileMap;
import ome.model.core.PlaneInfo;
import ome.model.display.RenderingDef;
import ome.model.display.Thumbnail;
import ome.model.enums.DimensionOrder;
import ome.model.enums.PixelsType;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="pixels_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="pixels_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="pixels_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="pixels_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="pixels_owner_filter_PLANEINFO", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="pixels_group_filter_PLANEINFO", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="pixels_event_filter_PLANEINFO", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="pixels_perms_filter_PLANEINFO", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="pixels_owner_filter_PIXELSFILEMAPS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="pixels_group_filter_PIXELSFILEMAPS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="pixels_event_filter_PIXELSFILEMAPS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="pixels_perms_filter_PIXELSFILEMAPS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="pixels_owner_filter_CHANNELS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="pixels_group_filter_CHANNELS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="pixels_event_filter_CHANNELS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="pixels_perms_filter_CHANNELS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="pixels_owner_filter_SETTINGS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="pixels_group_filter_SETTINGS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="pixels_event_filter_SETTINGS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="pixels_perms_filter_SETTINGS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="pixels_owner_filter_THUMBNAILS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="pixels_group_filter_THUMBNAILS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="pixels_event_filter_THUMBNAILS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="pixels_perms_filter_THUMBNAILS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="pixels_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="pixels_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="pixels_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="pixels_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="pixels_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="pixels_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="pixels_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="pixels_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="pixels", uniqueConstraints={@UniqueConstraint(columnNames={"image", "image_index"})})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_pixels", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_pixels"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
@Check(constraints="sizeX > 0 and sizeY > 0 and sizeZ > 0 and sizeC > 0 and sizeT > 0")
public class Pixels
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "pixels_owner_filter";
    public static final String GROUP_FILTER = "pixels_group_filter";
    public static final String EVENT_FILTER = "pixels_event_filter";
    public static final String PERMS_FILTER = "pixels_perms_filter";
    public static final String ID = "ome.model.core.Pixels_id";
    protected Long id;
    public static final String VERSION = "ome.model.core.Pixels_version";
    protected Integer version = 0;
    protected Image image = null;
    protected Pixels relatedTo = null;
    protected PixelsType pixelsType = null;
    protected Integer sizeX = null;
    protected Integer sizeY = null;
    protected Integer sizeZ = null;
    protected Integer sizeC = null;
    protected Integer sizeT = null;
    protected String sha1 = null;
    protected DimensionOrder dimensionOrder = null;
    protected Double physicalSizeX = null;
    protected Double physicalSizeY = null;
    protected Double physicalSizeZ = null;
    protected Integer waveStart = null;
    protected Integer waveIncrement = null;
    protected Double timeIncrement = null;
    protected String methodology = null;
    protected Set<PlaneInfo> planeInfo = new HashSet<PlaneInfo>();
    public static final String OWNER_FILTER_PLANEINFO = "pixels_owner_filter_PLANEINFO";
    public static final String GROUP_FILTER_PLANEINFO = "pixels_group_filter_PLANEINFO";
    public static final String EVENT_FILTER_PLANEINFO = "pixels_event_filter_PLANEINFO";
    public static final String PERMS_FILTER_PLANEINFO = "pixels_perms_filter_PLANEINFO";
    protected Set<PixelsOriginalFileMap> pixelsFileMaps = new HashSet<PixelsOriginalFileMap>();
    public static final String OWNER_FILTER_PIXELSFILEMAPS = "pixels_owner_filter_PIXELSFILEMAPS";
    public static final String GROUP_FILTER_PIXELSFILEMAPS = "pixels_group_filter_PIXELSFILEMAPS";
    public static final String EVENT_FILTER_PIXELSFILEMAPS = "pixels_event_filter_PIXELSFILEMAPS";
    public static final String PERMS_FILTER_PIXELSFILEMAPS = "pixels_perms_filter_PIXELSFILEMAPS";
    private Map<Long, Long> pixelsFileMapsCountPerOwner = null;
    protected List<Channel> channels = new ArrayList<Channel>();
    public static final String OWNER_FILTER_CHANNELS = "pixels_owner_filter_CHANNELS";
    public static final String GROUP_FILTER_CHANNELS = "pixels_group_filter_CHANNELS";
    public static final String EVENT_FILTER_CHANNELS = "pixels_event_filter_CHANNELS";
    public static final String PERMS_FILTER_CHANNELS = "pixels_perms_filter_CHANNELS";
    protected Set<RenderingDef> settings = new HashSet<RenderingDef>();
    public static final String OWNER_FILTER_SETTINGS = "pixels_owner_filter_SETTINGS";
    public static final String GROUP_FILTER_SETTINGS = "pixels_group_filter_SETTINGS";
    public static final String EVENT_FILTER_SETTINGS = "pixels_event_filter_SETTINGS";
    public static final String PERMS_FILTER_SETTINGS = "pixels_perms_filter_SETTINGS";
    protected Set<Thumbnail> thumbnails = new HashSet<Thumbnail>();
    public static final String OWNER_FILTER_THUMBNAILS = "pixels_owner_filter_THUMBNAILS";
    public static final String GROUP_FILTER_THUMBNAILS = "pixels_group_filter_THUMBNAILS";
    public static final String EVENT_FILTER_THUMBNAILS = "pixels_event_filter_THUMBNAILS";
    public static final String PERMS_FILTER_THUMBNAILS = "pixels_perms_filter_THUMBNAILS";
    protected Set<PixelsAnnotationLink> annotationLinks = new HashSet<PixelsAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "pixels_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "pixels_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "pixels_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "pixels_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String IMAGE = "ome.model.core.Pixels_image";
    public static final String RELATEDTO = "ome.model.core.Pixels_relatedTo";
    public static final String PIXELSTYPE = "ome.model.core.Pixels_pixelsType";
    public static final String SIZEX = "ome.model.core.Pixels_sizeX";
    public static final String SIZEY = "ome.model.core.Pixels_sizeY";
    public static final String SIZEZ = "ome.model.core.Pixels_sizeZ";
    public static final String SIZEC = "ome.model.core.Pixels_sizeC";
    public static final String SIZET = "ome.model.core.Pixels_sizeT";
    public static final String SHA1 = "ome.model.core.Pixels_sha1";
    public static final String DIMENSIONORDER = "ome.model.core.Pixels_dimensionOrder";
    public static final String PHYSICALSIZEX = "ome.model.core.Pixels_physicalSizeX";
    public static final String PHYSICALSIZEY = "ome.model.core.Pixels_physicalSizeY";
    public static final String PHYSICALSIZEZ = "ome.model.core.Pixels_physicalSizeZ";
    public static final String WAVESTART = "ome.model.core.Pixels_waveStart";
    public static final String WAVEINCREMENT = "ome.model.core.Pixels_waveIncrement";
    public static final String TIMEINCREMENT = "ome.model.core.Pixels_timeIncrement";
    public static final String METHODOLOGY = "ome.model.core.Pixels_methodology";
    public static final String PLANEINFO = "ome.model.core.Pixels_planeInfo";
    public static final String PIXELSFILEMAPSCOUNTPEROWNER = "ome.model.core.Pixels_pixelsFileMapsCountPerOwner";
    public static final String PIXELSFILEMAPS = "ome.model.core.Pixels_pixelsFileMaps";
    public static final String CHANNELS = "ome.model.core.Pixels_channels";
    public static final String SETTINGS = "ome.model.core.Pixels_settings";
    public static final String THUMBNAILS = "ome.model.core.Pixels_thumbnails";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.core.Pixels_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.core.Pixels_annotationLinks";
    public static final String DETAILS = "ome.model.core.Pixels_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Pixels() {
        this(null, true);
    }

    protected Pixels(Long id) {
        this(id, true);
    }

    public Pixels(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Pixels(Image _image, PixelsType _pixelsType, Integer _sizeX, Integer _sizeY, Integer _sizeZ, Integer _sizeC, Integer _sizeT, String _sha1, DimensionOrder _dimensionOrder) {
        this(null, true);
        this.setImage(_image);
        this.setPixelsType(_pixelsType);
        this.setSizeX(_sizeX);
        this.setSizeY(_sizeY);
        this.setSizeZ(_sizeZ);
        this.setSizeC(_sizeC);
        this.setSizeT(_sizeT);
        this.setSha1(_sha1);
        this.setDimensionOrder(_dimensionOrder);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_pixels")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Image.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="image", nullable=false, unique=false, insertable=false, updatable=false)
    @ForeignKey(name="FKpixels_image_image")
    public Image getImage() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.image;
    }

    public void setImage(Image image) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.image = image;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Pixels.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="relatedTo", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKpixels_relatedTo_pixels")
    public Pixels getRelatedTo() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.relatedTo;
    }

    public void setRelatedTo(Pixels relatedTo) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.relatedTo = relatedTo;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=PixelsType.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="pixelsType", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKpixels_pixelsType_pixelstype")
    public PixelsType getPixelsType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixelsType;
    }

    public void setPixelsType(PixelsType pixelsType) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pixelsType = pixelsType;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="sizeX", updatable=true)
    public Integer getSizeX() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sizeX;
    }

    public void setSizeX(Integer sizeX) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sizeX = sizeX;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="sizeY", updatable=true)
    public Integer getSizeY() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sizeY;
    }

    public void setSizeY(Integer sizeY) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sizeY = sizeY;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="sizeZ", updatable=true)
    public Integer getSizeZ() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sizeZ;
    }

    public void setSizeZ(Integer sizeZ) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sizeZ = sizeZ;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="sizeC", updatable=true)
    public Integer getSizeC() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sizeC;
    }

    public void setSizeC(Integer sizeC) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sizeC = sizeC;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="sizeT", updatable=true)
    public Integer getSizeT() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sizeT;
    }

    public void setSizeT(Integer sizeT) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sizeT = sizeT;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="sha1", updatable=true)
    public String getSha1() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sha1;
    }

    public void setSha1(String sha1) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sha1 = sha1;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=DimensionOrder.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="dimensionOrder", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKpixels_dimensionOrder_dimensionorder")
    public DimensionOrder getDimensionOrder() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.dimensionOrder;
    }

    public void setDimensionOrder(DimensionOrder dimensionOrder) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.dimensionOrder = dimensionOrder;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="physicalSizeX", updatable=true)
    public Double getPhysicalSizeX() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.physicalSizeX;
    }

    public void setPhysicalSizeX(Double physicalSizeX) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.physicalSizeX = physicalSizeX;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="physicalSizeY", updatable=true)
    public Double getPhysicalSizeY() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.physicalSizeY;
    }

    public void setPhysicalSizeY(Double physicalSizeY) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.physicalSizeY = physicalSizeY;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="physicalSizeZ", updatable=true)
    public Double getPhysicalSizeZ() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.physicalSizeZ;
    }

    public void setPhysicalSizeZ(Double physicalSizeZ) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.physicalSizeZ = physicalSizeZ;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="waveStart", updatable=true)
    public Integer getWaveStart() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.waveStart;
    }

    public void setWaveStart(Integer waveStart) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.waveStart = waveStart;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="waveIncrement", updatable=true)
    public Integer getWaveIncrement() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.waveIncrement;
    }

    public void setWaveIncrement(Integer waveIncrement) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.waveIncrement = waveIncrement;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="timeIncrement", updatable=true)
    public Double getTimeIncrement() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.timeIncrement;
    }

    public void setTimeIncrement(Double timeIncrement) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.timeIncrement = timeIncrement;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="methodology", updatable=true)
    public String getMethodology() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.methodology;
    }

    public void setMethodology(String methodology) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.methodology = methodology;
    }

    @OneToMany(mappedBy="pixels", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="pixels_owner_filter_PLANEINFO", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="pixels_group_filter_PLANEINFO", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="pixels_event_filter_PLANEINFO", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="pixels_perms_filter_PLANEINFO", condition=":permsStr = permissions")})
    protected Set<PlaneInfo> getPlaneInfo() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.planeInfo;
    }

    protected void setPlaneInfo(Set<PlaneInfo> planeInfo) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.planeInfo = planeInfo;
    }

    public int sizeOfPlaneInfo() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.planeInfo == null ? -1 : this.planeInfo.size();
    }

    public Iterator<PlaneInfo> iteratePlaneInfo() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlaneInfo() == null) {
            return new EmptyIterator<PlaneInfo>();
        }
        return this.getPlaneInfo().iterator();
    }

    public Collection<PlaneInfo> unmodifiablePlaneInfo() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlaneInfo() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getPlaneInfo());
    }

    public <E> List<E> collectPlaneInfo(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<PlaneInfo> it = this.iteratePlaneInfo();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addPlaneInfo(PlaneInfo target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlaneInfo() == null) {
            this.throwNullCollectionException("PlaneInfo");
        }
        this.getPlaneInfo().add(target);
        if (target != null) {
            target.setPixels(this);
        }
    }

    public void addPlaneInfoSet(Collection<PlaneInfo> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlaneInfo() == null) {
            this.throwNullCollectionException("PlaneInfo");
        }
        this.getPlaneInfo().addAll(targets);
        for (PlaneInfo target : targets) {
            if (target == null) continue;
            target.setPixels(this);
        }
    }

    public void removePlaneInfo(PlaneInfo target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlaneInfo() == null) {
            this.throwNullCollectionException("PlaneInfo");
        }
        this.getPlaneInfo().remove(target);
        target.setPixels(null);
    }

    public void removePlaneInfoSet(Collection<PlaneInfo> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlaneInfo() == null) {
            this.throwNullCollectionException("PlaneInfo");
        }
        this.getPlaneInfo().removeAll(targets);
        for (PlaneInfo target : targets) {
            target.setPixels(null);
        }
    }

    public void clearPlaneInfo() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPlaneInfo() == null) {
            this.throwNullCollectionException("PlaneInfo");
        }
        this.getPlaneInfo().clear();
        Iterator<PlaneInfo> it = this.iteratePlaneInfo();
        while (it.hasNext()) {
            PlaneInfo target = it.next();
            target.setPixels(null);
        }
    }

    @OneToMany(mappedBy="child", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="pixels_owner_filter_PIXELSFILEMAPS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="pixels_group_filter_PIXELSFILEMAPS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="pixels_event_filter_PIXELSFILEMAPS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="pixels_perms_filter_PIXELSFILEMAPS", condition=":permsStr = permissions")})
    protected Set<PixelsOriginalFileMap> getPixelsFileMaps() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixelsFileMaps;
    }

    protected void setPixelsFileMaps(Set<PixelsOriginalFileMap> pixelsFileMaps) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pixelsFileMaps = pixelsFileMaps;
    }

    public int sizeOfPixelsFileMaps() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixelsFileMaps == null ? -1 : this.pixelsFileMaps.size();
    }

    public Iterator<PixelsOriginalFileMap> iteratePixelsFileMaps() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            return new EmptyIterator<PixelsOriginalFileMap>();
        }
        return this.getPixelsFileMaps().iterator();
    }

    public Collection<PixelsOriginalFileMap> unmodifiablePixelsFileMaps() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getPixelsFileMaps());
    }

    public <E> List<E> collectPixelsFileMaps(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<PixelsOriginalFileMap> it = this.iteratePixelsFileMaps();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addPixelsOriginalFileMap(PixelsOriginalFileMap target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().add(target);
        if (target != null) {
            target.setChild(this);
        }
    }

    public void addPixelsOriginalFileMapSet(Collection<PixelsOriginalFileMap> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().addAll(targets);
        for (PixelsOriginalFileMap target : targets) {
            if (target == null) continue;
            target.setChild(this);
        }
    }

    public void removePixelsOriginalFileMap(PixelsOriginalFileMap target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().remove(target);
        target.setChild(null);
    }

    public void removePixelsOriginalFileMapSet(Collection<PixelsOriginalFileMap> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().removeAll(targets);
        for (PixelsOriginalFileMap target : targets) {
            target.setChild(null);
        }
    }

    public PixelsOriginalFileMap linkOriginalFile(OriginalFile addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        PixelsOriginalFileMap link = new PixelsOriginalFileMap();
        link.link(addition, this);
        this.addPixelsOriginalFileMap(link, true);
        return link;
    }

    public void addPixelsOriginalFileMap(PixelsOriginalFileMap link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().add(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().addPixelsOriginalFileMap(link, false);
        }
    }

    public Iterator<OriginalFile> linkedOriginalFileIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            return new EmptyIterator<OriginalFile>();
        }
        final Iterator<PixelsOriginalFileMap> it = this.getPixelsFileMaps().iterator();
        return new Iterator<OriginalFile>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public OriginalFile next() {
                if (it == null) {
                    throw new NoSuchElementException("pixelsFileMaps is null; no elements.");
                }
                PixelsOriginalFileMap link = (PixelsOriginalFileMap)it.next();
                return link.parent();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<PixelsOriginalFileMap> findPixelsOriginalFileMap(OriginalFile target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<PixelsOriginalFileMap> it = this.iteratePixelsFileMaps();
        HashSet<PixelsOriginalFileMap> result = new HashSet<PixelsOriginalFileMap>();
        while (it.hasNext()) {
            PixelsOriginalFileMap link = it.next();
            if (link.parent() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<OriginalFile> linkedOriginalFileList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<OriginalFile> it = this.linkedOriginalFileIterator();
        ArrayList<OriginalFile> list = new ArrayList<OriginalFile>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedOriginalFile(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<OriginalFile> it = this.linkedOriginalFileIterator();
        while (it.hasNext()) {
            OriginalFile obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkOriginalFile(OriginalFile removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<PixelsOriginalFileMap> toRemove = this.findPixelsOriginalFileMap(removal);
        Iterator<PixelsOriginalFileMap> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removePixelsOriginalFileMap(it.next(), true);
        }
    }

    public void removePixelsOriginalFileMap(PixelsOriginalFileMap link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().remove(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().removePixelsOriginalFileMap(link, false);
        }
    }

    public void clearOriginalFileLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<PixelsOriginalFileMap> list = new ArrayList<PixelsOriginalFileMap>(this.getPixelsFileMaps());
        for (PixelsOriginalFileMap link : list) {
            this.removePixelsOriginalFileMap(link, true);
        }
    }

    protected void setPixelsFileMapsCountPerOwner(Map<Long, Long> map) {
        this.pixelsFileMapsCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Pixels_pixelsFileMaps")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Pixels_pixelsFileMaps_by_owner", joinColumns={@JoinColumn(name="Pixels_id")})
    public Map<Long, Long> getPixelsFileMapsCountPerOwner() {
        return this.pixelsFileMapsCountPerOwner;
    }

    @JoinColumn(name="pixels", nullable=false)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @IndexColumn(name="pixels_index", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="pixels_owner_filter_CHANNELS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="pixels_group_filter_CHANNELS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="pixels_event_filter_CHANNELS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="pixels_perms_filter_CHANNELS", condition=":permsStr = permissions")})
    protected List<Channel> getChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.channels;
    }

    protected void setChannels(List<Channel> channels) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.channels = channels;
    }

    public int sizeOfChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.channels == null ? -1 : this.channels.size();
    }

    public Iterator<Channel> iterateChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            return new EmptyIterator<Channel>();
        }
        return this.getChannels().iterator();
    }

    public Collection<Channel> unmodifiableChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getChannels());
    }

    public <E> List<E> collectChannels(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Channel> it = this.iterateChannels();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addChannel(Channel target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().add(target);
        if (target != null && target.isLoaded()) {
            target.setPixels(this);
        }
    }

    public void addChannelSet(Collection<Channel> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().addAll(targets);
        for (Channel target : targets) {
            if (target == null || !target.isLoaded()) continue;
            target.setPixels(this);
        }
    }

    public void removeChannel(Channel target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().remove(target);
        if (target.isLoaded()) {
            target.setPixels(null);
        }
    }

    public void removeChannelSet(Collection<Channel> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().removeAll(targets);
        for (Channel target : targets) {
            if (!target.isLoaded()) continue;
            target.setPixels(null);
        }
    }

    public void clearChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().clear();
        Iterator<Channel> it = this.iterateChannels();
        while (it.hasNext()) {
            Channel target = it.next();
            target.setPixels(null);
        }
    }

    public Channel getChannel(int index) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        return this.getChannels().get(index);
    }

    public Channel setChannel(int index, Channel element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        Channel old = this.getChannels().set(index, element);
        if (element != null && element.isLoaded()) {
            element.setPixels(this);
        }
        return old;
    }

    @Transient
    public Channel getPrimaryChannel() throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        return this.getChannels().get(0);
    }

    public Channel setPrimaryChannel(Channel element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        List<Channel> list = this.getChannels();
        int index = list.indexOf(element);
        Channel old = list.get(0);
        list.set(index, old);
        list.set(0, element);
        return old;
    }

    @OneToMany(mappedBy="pixels", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="pixels_owner_filter_SETTINGS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="pixels_group_filter_SETTINGS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="pixels_event_filter_SETTINGS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="pixels_perms_filter_SETTINGS", condition=":permsStr = permissions")})
    protected Set<RenderingDef> getSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.settings;
    }

    protected void setSettings(Set<RenderingDef> settings) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.settings = settings;
    }

    public int sizeOfSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.settings == null ? -1 : this.settings.size();
    }

    public Iterator<RenderingDef> iterateSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSettings() == null) {
            return new EmptyIterator<RenderingDef>();
        }
        return this.getSettings().iterator();
    }

    public Collection<RenderingDef> unmodifiableSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSettings() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getSettings());
    }

    public <E> List<E> collectSettings(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<RenderingDef> it = this.iterateSettings();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addRenderingDef(RenderingDef target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSettings() == null) {
            this.throwNullCollectionException("Settings");
        }
        this.getSettings().add(target);
        if (target != null) {
            target.setPixels(this);
        }
    }

    public void addRenderingDefSet(Collection<RenderingDef> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSettings() == null) {
            this.throwNullCollectionException("Settings");
        }
        this.getSettings().addAll(targets);
        for (RenderingDef target : targets) {
            if (target == null) continue;
            target.setPixels(this);
        }
    }

    public void removeRenderingDef(RenderingDef target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSettings() == null) {
            this.throwNullCollectionException("Settings");
        }
        this.getSettings().remove(target);
        target.setPixels(null);
    }

    public void removeRenderingDefSet(Collection<RenderingDef> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSettings() == null) {
            this.throwNullCollectionException("Settings");
        }
        this.getSettings().removeAll(targets);
        for (RenderingDef target : targets) {
            target.setPixels(null);
        }
    }

    public void clearSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSettings() == null) {
            this.throwNullCollectionException("Settings");
        }
        this.getSettings().clear();
        Iterator<RenderingDef> it = this.iterateSettings();
        while (it.hasNext()) {
            RenderingDef target = it.next();
            target.setPixels(null);
        }
    }

    @OneToMany(mappedBy="pixels", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="pixels_owner_filter_THUMBNAILS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="pixels_group_filter_THUMBNAILS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="pixels_event_filter_THUMBNAILS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="pixels_perms_filter_THUMBNAILS", condition=":permsStr = permissions")})
    protected Set<Thumbnail> getThumbnails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.thumbnails;
    }

    protected void setThumbnails(Set<Thumbnail> thumbnails) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.thumbnails = thumbnails;
    }

    public int sizeOfThumbnails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.thumbnails == null ? -1 : this.thumbnails.size();
    }

    public Iterator<Thumbnail> iterateThumbnails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getThumbnails() == null) {
            return new EmptyIterator<Thumbnail>();
        }
        return this.getThumbnails().iterator();
    }

    public Collection<Thumbnail> unmodifiableThumbnails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getThumbnails() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getThumbnails());
    }

    public <E> List<E> collectThumbnails(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Thumbnail> it = this.iterateThumbnails();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addThumbnail(Thumbnail target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getThumbnails() == null) {
            this.throwNullCollectionException("Thumbnails");
        }
        this.getThumbnails().add(target);
        if (target != null) {
            target.setPixels(this);
        }
    }

    public void addThumbnailSet(Collection<Thumbnail> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getThumbnails() == null) {
            this.throwNullCollectionException("Thumbnails");
        }
        this.getThumbnails().addAll(targets);
        for (Thumbnail target : targets) {
            if (target == null) continue;
            target.setPixels(this);
        }
    }

    public void removeThumbnail(Thumbnail target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getThumbnails() == null) {
            this.throwNullCollectionException("Thumbnails");
        }
        this.getThumbnails().remove(target);
        target.setPixels(null);
    }

    public void removeThumbnailSet(Collection<Thumbnail> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getThumbnails() == null) {
            this.throwNullCollectionException("Thumbnails");
        }
        this.getThumbnails().removeAll(targets);
        for (Thumbnail target : targets) {
            target.setPixels(null);
        }
    }

    public void clearThumbnails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getThumbnails() == null) {
            this.throwNullCollectionException("Thumbnails");
        }
        this.getThumbnails().clear();
        Iterator<Thumbnail> it = this.iterateThumbnails();
        while (it.hasNext()) {
            Thumbnail target = it.next();
            target.setPixels(null);
        }
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="pixels_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="pixels_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="pixels_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="pixels_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<PixelsAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<PixelsAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<PixelsAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<PixelsAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<PixelsAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<PixelsAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addPixelsAnnotationLink(PixelsAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addPixelsAnnotationLinkSet(Collection<PixelsAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (PixelsAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removePixelsAnnotationLink(PixelsAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removePixelsAnnotationLinkSet(Collection<PixelsAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (PixelsAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public PixelsAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        PixelsAnnotationLink link = new PixelsAnnotationLink();
        link.link(this, addition);
        this.addPixelsAnnotationLink(link, true);
        return link;
    }

    public void addPixelsAnnotationLink(PixelsAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<PixelsAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                PixelsAnnotationLink link = (PixelsAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<PixelsAnnotationLink> findPixelsAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<PixelsAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<PixelsAnnotationLink> result = new HashSet<PixelsAnnotationLink>();
        while (it.hasNext()) {
            PixelsAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<PixelsAnnotationLink> toRemove = this.findPixelsAnnotationLink(removal);
        Iterator<PixelsAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removePixelsAnnotationLink(it.next(), true);
        }
    }

    public void removePixelsAnnotationLink(PixelsAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<PixelsAnnotationLink> list = new ArrayList<PixelsAnnotationLink>(this.getAnnotationLinks());
        for (PixelsAnnotationLink link : list) {
            this.removePixelsAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Pixels_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Pixels_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Pixels_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Pixels newInstance() {
        return new Pixels();
    }

    public Pixels proxy() {
        return new Pixels(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.image = (Image)__filter.filter(IMAGE, this.image);
            this.relatedTo = (Pixels)__filter.filter(RELATEDTO, this.relatedTo);
            this.pixelsType = (PixelsType)__filter.filter(PIXELSTYPE, this.pixelsType);
            this.sizeX = (Integer)__filter.filter(SIZEX, this.sizeX);
            this.sizeY = (Integer)__filter.filter(SIZEY, this.sizeY);
            this.sizeZ = (Integer)__filter.filter(SIZEZ, this.sizeZ);
            this.sizeC = (Integer)__filter.filter(SIZEC, this.sizeC);
            this.sizeT = (Integer)__filter.filter(SIZET, this.sizeT);
            this.sha1 = (String)__filter.filter(SHA1, this.sha1);
            this.dimensionOrder = (DimensionOrder)__filter.filter(DIMENSIONORDER, this.dimensionOrder);
            this.physicalSizeX = (Double)__filter.filter(PHYSICALSIZEX, this.physicalSizeX);
            this.physicalSizeY = (Double)__filter.filter(PHYSICALSIZEY, this.physicalSizeY);
            this.physicalSizeZ = (Double)__filter.filter(PHYSICALSIZEZ, this.physicalSizeZ);
            this.waveStart = (Integer)__filter.filter(WAVESTART, this.waveStart);
            this.waveIncrement = (Integer)__filter.filter(WAVEINCREMENT, this.waveIncrement);
            this.timeIncrement = (Double)__filter.filter(TIMEINCREMENT, this.timeIncrement);
            this.methodology = (String)__filter.filter(METHODOLOGY, this.methodology);
            this.planeInfo = (Set)__filter.filter(PLANEINFO, this.planeInfo);
            this.pixelsFileMapsCountPerOwner = __filter.filter(PIXELSFILEMAPSCOUNTPEROWNER, this.pixelsFileMapsCountPerOwner);
            this.pixelsFileMaps = (Set)__filter.filter(PIXELSFILEMAPS, this.pixelsFileMaps);
            this.channels = (List)__filter.filter(CHANNELS, this.channels);
            this.settings = (Set)__filter.filter(SETTINGS, this.settings);
            this.thumbnails = (Set)__filter.filter(THUMBNAILS, this.thumbnails);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(IMAGE)) {
            return this.getImage();
        }
        if (field.equals(RELATEDTO)) {
            return this.getRelatedTo();
        }
        if (field.equals(PIXELSTYPE)) {
            return this.getPixelsType();
        }
        if (field.equals(SIZEX)) {
            return this.getSizeX();
        }
        if (field.equals(SIZEY)) {
            return this.getSizeY();
        }
        if (field.equals(SIZEZ)) {
            return this.getSizeZ();
        }
        if (field.equals(SIZEC)) {
            return this.getSizeC();
        }
        if (field.equals(SIZET)) {
            return this.getSizeT();
        }
        if (field.equals(SHA1)) {
            return this.getSha1();
        }
        if (field.equals(DIMENSIONORDER)) {
            return this.getDimensionOrder();
        }
        if (field.equals(PHYSICALSIZEX)) {
            return this.getPhysicalSizeX();
        }
        if (field.equals(PHYSICALSIZEY)) {
            return this.getPhysicalSizeY();
        }
        if (field.equals(PHYSICALSIZEZ)) {
            return this.getPhysicalSizeZ();
        }
        if (field.equals(WAVESTART)) {
            return this.getWaveStart();
        }
        if (field.equals(WAVEINCREMENT)) {
            return this.getWaveIncrement();
        }
        if (field.equals(TIMEINCREMENT)) {
            return this.getTimeIncrement();
        }
        if (field.equals(METHODOLOGY)) {
            return this.getMethodology();
        }
        if (field.equals(PLANEINFO)) {
            return this.getPlaneInfo();
        }
        if (field.equals(PIXELSFILEMAPSCOUNTPEROWNER)) {
            return this.getPixelsFileMapsCountPerOwner();
        }
        if (field.equals(PIXELSFILEMAPS)) {
            return this.getPixelsFileMaps();
        }
        if (field.equals(CHANNELS)) {
            return this.getChannels();
        }
        if (field.equals(SETTINGS)) {
            return this.getSettings();
        }
        if (field.equals(THUMBNAILS)) {
            return this.getThumbnails();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(IMAGE)) {
            this.setImage((Image)value);
        } else if (field.equals(RELATEDTO)) {
            this.setRelatedTo((Pixels)value);
        } else if (field.equals(PIXELSTYPE)) {
            this.setPixelsType((PixelsType)value);
        } else if (field.equals(SIZEX)) {
            this.setSizeX((Integer)value);
        } else if (field.equals(SIZEY)) {
            this.setSizeY((Integer)value);
        } else if (field.equals(SIZEZ)) {
            this.setSizeZ((Integer)value);
        } else if (field.equals(SIZEC)) {
            this.setSizeC((Integer)value);
        } else if (field.equals(SIZET)) {
            this.setSizeT((Integer)value);
        } else if (field.equals(SHA1)) {
            this.setSha1((String)value);
        } else if (field.equals(DIMENSIONORDER)) {
            this.setDimensionOrder((DimensionOrder)value);
        } else if (field.equals(PHYSICALSIZEX)) {
            this.setPhysicalSizeX((Double)value);
        } else if (field.equals(PHYSICALSIZEY)) {
            this.setPhysicalSizeY((Double)value);
        } else if (field.equals(PHYSICALSIZEZ)) {
            this.setPhysicalSizeZ((Double)value);
        } else if (field.equals(WAVESTART)) {
            this.setWaveStart((Integer)value);
        } else if (field.equals(WAVEINCREMENT)) {
            this.setWaveIncrement((Integer)value);
        } else if (field.equals(TIMEINCREMENT)) {
            this.setTimeIncrement((Double)value);
        } else if (field.equals(METHODOLOGY)) {
            this.setMethodology((String)value);
        } else if (field.equals(PLANEINFO)) {
            this.setPlaneInfo((Set)value);
        } else if (field.equals(PIXELSFILEMAPSCOUNTPEROWNER)) {
            this.setPixelsFileMapsCountPerOwner((Map)value);
        } else if (field.equals(PIXELSFILEMAPS)) {
            this.setPixelsFileMaps((Set)value);
        } else if (field.equals(CHANNELS)) {
            this.setChannels((List)value);
        } else if (field.equals(SETTINGS)) {
            this.setSettings((Set)value);
        } else if (field.equals(THUMBNAILS)) {
            this.setThumbnails((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.image = null;
        this.relatedTo = null;
        this.pixelsType = null;
        this.sizeX = null;
        this.sizeY = null;
        this.sizeZ = null;
        this.sizeC = null;
        this.sizeT = null;
        this.sha1 = null;
        this.dimensionOrder = null;
        this.physicalSizeX = null;
        this.physicalSizeY = null;
        this.physicalSizeZ = null;
        this.waveStart = null;
        this.waveIncrement = null;
        this.timeIncrement = null;
        this.methodology = null;
        this.planeInfo = null;
        this.pixelsFileMapsCountPerOwner = null;
        this.pixelsFileMaps = null;
        this.channels = null;
        this.settings = null;
        this.thumbnails = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(IMAGE);
        raw.add(RELATEDTO);
        raw.add(PIXELSTYPE);
        raw.add(SIZEX);
        raw.add(SIZEY);
        raw.add(SIZEZ);
        raw.add(SIZEC);
        raw.add(SIZET);
        raw.add(SHA1);
        raw.add(DIMENSIONORDER);
        raw.add(PHYSICALSIZEX);
        raw.add(PHYSICALSIZEY);
        raw.add(PHYSICALSIZEZ);
        raw.add(WAVESTART);
        raw.add(WAVEINCREMENT);
        raw.add(TIMEINCREMENT);
        raw.add(METHODOLOGY);
        raw.add(PLANEINFO);
        raw.add(PIXELSFILEMAPSCOUNTPEROWNER);
        raw.add(PIXELSFILEMAPS);
        raw.add(CHANNELS);
        raw.add(SETTINGS);
        raw.add(THUMBNAILS);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKpixels_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKpixels_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKpixels_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKpixels_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKpixels_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

