/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.codomain;

import omeis.providers.re.codomain.CodomainMap;
import omeis.providers.re.codomain.CodomainMapContext;
import omeis.providers.re.codomain.ContrastStretchingMap;

public class ContrastStretchingContext
extends CodomainMapContext {
    private int xStart;
    private int yStart;
    private int xEnd;
    private int yEnd;
    private double a0;
    private double b0;
    private double a1;
    private double b1;
    private double a2;
    private double b2;

    private void verifyInputInterval(int start, int end) {
        if (start >= end) {
            throw new IllegalArgumentException(start + " cannot greater than " + end + " in contrast stretching context.");
        }
        if (start < this.intervalStart) {
            throw new IllegalArgumentException(start + " cannot lower than " + this.intervalStart + " in contrast stretching context.");
        }
        if (end > this.intervalEnd) {
            throw new IllegalArgumentException(end + " cannot be greater than " + this.intervalStart + " in contrast stretching context.");
        }
    }

    private void setFirstLineCoefficient(int intervalStart) {
        double r = this.xStart - intervalStart;
        this.a0 = r == 0.0 ? 0.0 : (double)(this.yStart - intervalStart) / r;
        this.b0 = (double)intervalStart * (1.0 - this.a0);
    }

    private void setSecondLineCoefficient() {
        double r = this.xEnd - this.xStart;
        this.a1 = r == 0.0 ? 0.0 : (double)(this.yEnd - this.yStart) / r;
        this.b1 = (double)this.yStart - this.a1 * (double)this.xStart;
    }

    private void setThirdLineCoefficient(int intervalEnd) {
        double r = intervalEnd - this.xEnd;
        this.a2 = r == 0.0 ? 0.0 : (double)(intervalEnd - this.yEnd) / r;
        this.b2 = (double)intervalEnd * (1.0 - this.a2);
    }

    void buildContext() {
        if (this.xStart < this.intervalStart) {
            this.xStart = this.intervalStart;
        }
        if (this.yStart < this.intervalStart) {
            this.yStart = this.intervalStart;
        }
        if (this.xEnd > this.intervalEnd) {
            this.xEnd = this.intervalEnd;
        }
        if (this.yEnd > this.intervalEnd) {
            this.yEnd = this.intervalEnd;
        }
        this.setFirstLineCoefficient(this.intervalStart);
        this.setSecondLineCoefficient();
        this.setThirdLineCoefficient(this.intervalEnd);
    }

    CodomainMap getCodomainMap() {
        return new ContrastStretchingMap();
    }

    public CodomainMapContext copy() {
        ContrastStretchingContext copy = new ContrastStretchingContext();
        copy.intervalEnd = this.intervalEnd;
        copy.intervalStart = this.intervalStart;
        copy.xStart = this.xStart;
        copy.yStart = this.yStart;
        copy.xEnd = this.xEnd;
        copy.yEnd = this.yEnd;
        copy.a0 = this.a0;
        copy.a1 = this.a1;
        copy.a2 = this.a2;
        copy.b0 = this.b0;
        copy.b1 = this.b1;
        copy.b2 = this.b2;
        return copy;
    }

    public void setCoordinates(int xStart, int yStart, int xEnd, int yEnd) {
        this.verifyInputInterval(xStart, xEnd);
        this.verifyInputInterval(yStart, yEnd);
        this.xStart = xStart;
        this.xEnd = xEnd;
        this.yStart = yStart;
        this.yEnd = yEnd;
    }

    public void setXStart(int v) {
        this.verifyInputInterval(v, this.xEnd);
        this.xStart = v;
    }

    public void setXEnd(int v) {
        this.verifyInputInterval(this.xStart, v);
        this.xEnd = v;
    }

    public void setYStart(int v) {
        this.verifyInputInterval(v, this.yEnd);
        this.yStart = v;
    }

    public void setYEnd(int v) {
        this.verifyInputInterval(this.yStart, v);
        this.yEnd = v;
    }

    public int getXEnd() {
        return this.xEnd;
    }

    public int getXStart() {
        return this.xStart;
    }

    public int getYEnd() {
        return this.yEnd;
    }

    public int getYStart() {
        return this.yStart;
    }

    public double getA0() {
        return this.a0;
    }

    public double getA1() {
        return this.a1;
    }

    public double getA2() {
        return this.a2;
    }

    public double getB0() {
        return this.b0;
    }

    public double getB1() {
        return this.b1;
    }

    public double getB2() {
        return this.b2;
    }
}

