/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.util.Arrays;
import omeis.providers.re.RGBBuffer;

public class RGBAIntBuffer
extends RGBBuffer {
    private static final long serialVersionUID = 5319594152383817324L;
    private int[] dataBuf;
    private int sizeX1;
    private int sizeX2;

    public RGBAIntBuffer(int sizeX1, int sizeX2) {
        this.sizeX1 = sizeX1;
        this.sizeX2 = sizeX2;
        this.dataBuf = new int[sizeX1 * sizeX2];
    }

    public void setRedValue(int index, int value) {
        this.dataBuf[index] = this.dataBuf[index] | value << 24;
    }

    public void setGreenValue(int index, int value) {
        this.dataBuf[index] = this.dataBuf[index] | value << 16;
    }

    public void setBlueValue(int index, int value) {
        this.dataBuf[index] = this.dataBuf[index] | value << 8;
    }

    public byte getRedValue(int index) {
        return (byte)((this.dataBuf[index] & 0xFF000000) >> 24);
    }

    public byte getGreenValue(int index) {
        return (byte)((this.dataBuf[index] & 0xFF0000) >> 16);
    }

    public byte getBlueValue(int index) {
        return (byte)((this.dataBuf[index] & 0xFF00) >> 8);
    }

    public int[] getDataBuffer() {
        return this.dataBuf;
    }

    public void zero() {
        Arrays.fill(this.dataBuf, 0);
    }
}

