/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ome.annotations.RevisionDate;
import ome.annotations.RevisionNumber;
import ome.conditions.InternalException;

@RevisionDate(value="$Date: 1970-01-01 00:00:01 +0100 (Thu, 01 Jan 1970) $")
@RevisionNumber(value="$Revision: 2500 $")
public abstract class Version {
    public static final String SVN_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss Z (EEE, dd MMM yyyy)";
    private static volatile SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss Z (EEE, dd MMM yyyy)");

    public static Integer getRevision(Class klass) {
        if (klass == null) {
            return null;
        }
        RevisionNumber rev = klass.getAnnotation(RevisionNumber.class);
        if (rev != null && rev.value() != null) {
            String sRevision = rev.value();
            sRevision = Version.stringFromSvnString(sRevision);
            return Integer.valueOf(sRevision);
        }
        return null;
    }

    public static Date getDate(Class klass) {
        if (klass == null) {
            return null;
        }
        RevisionDate rev = klass.getAnnotation(RevisionDate.class);
        if (rev != null && rev.value() != null) {
            Date date;
            String sDate = rev.value();
            sDate = Version.stringFromSvnString(sDate);
            try {
                date = formatter.parse(sDate);
            }
            catch (ParseException e) {
                throw new InternalException(String.format("Failed to parse date %s with formatter %s", sDate, formatter));
            }
            return date;
        }
        return null;
    }

    public static String stringFromSvnString(String keyword) {
        if (keyword == null) {
            return null;
        }
        int begin = keyword.indexOf(" ") + 1;
        int end = keyword.lastIndexOf(" ");
        if (begin < 0 || end < 0 || end - begin < 1) {
            return null;
        }
        String s = keyword.substring(begin, end);
        return s;
    }
}

