/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ome.annotations.RevisionDate;
import ome.annotations.RevisionNumber;
import ome.model.internal.Permissions;
import ome.system.EventContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RevisionDate(value="$Date: 2006-12-15 11:39:34 +0100 (Fri, 15 Dec 2006) $")
@RevisionNumber(value="$Revision: 1167 $")
public class SimpleEventContext
implements EventContext,
Serializable {
    private static final long serialVersionUID = -391820349350359539L;
    protected Long shareId;
    protected Long csId;
    protected Long cgId;
    protected Long cuId;
    protected Long ceId;
    protected String csName;
    protected String cgName;
    protected String cuName;
    protected String ceType;
    protected boolean isAdmin;
    protected boolean isReadOnly;
    protected List<Long> memberOfGroups;
    protected List<Long> leaderOfGroups;
    protected Permissions umask;
    protected Permissions groupPermissions;

    protected SimpleEventContext() {
    }

    public SimpleEventContext(EventContext ec) {
        if (ec == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        this.copy(ec);
    }

    protected void copy(EventContext ec) {
        this.shareId = ec.getCurrentShareId();
        this.csId = ec.getCurrentSessionId();
        this.cgId = ec.getCurrentGroupId();
        this.cuId = ec.getCurrentUserId();
        this.csName = ec.getCurrentSessionUuid();
        this.cgName = ec.getCurrentGroupName();
        this.cuName = ec.getCurrentUserName();
        this.ceType = ec.getCurrentEventType();
        this.memberOfGroups = new ArrayList<Long>(ec.getMemberOfGroupsList());
        this.leaderOfGroups = new ArrayList<Long>(ec.getLeaderOfGroupsList());
        this.groupPermissions = ec.getCurrentGroupPermissions();
        try {
            this.isAdmin = ec.isCurrentUserAdmin();
            this.isReadOnly = ec.isReadOnly();
            this.ceId = ec.getCurrentEventId();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public Long getCurrentShareId() {
        return this.shareId;
    }

    @Override
    public Long getCurrentSessionId() {
        return this.csId;
    }

    @Override
    public String getCurrentSessionUuid() {
        return this.csName;
    }

    @Override
    public Long getCurrentGroupId() {
        return this.cgId;
    }

    @Override
    public String getCurrentGroupName() {
        return this.cgName;
    }

    @Override
    public Long getCurrentUserId() {
        return this.cuId;
    }

    @Override
    public String getCurrentUserName() {
        return this.cuName;
    }

    @Override
    public boolean isCurrentUserAdmin() {
        return this.isAdmin;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public List<Long> getMemberOfGroupsList() {
        return this.memberOfGroups;
    }

    @Override
    public List<Long> getLeaderOfGroupsList() {
        return this.leaderOfGroups;
    }

    @Override
    public Long getCurrentEventId() {
        return this.ceId;
    }

    @Override
    public String getCurrentEventType() {
        return this.ceType;
    }

    public Permissions getCurrentUmask() {
        return this.umask;
    }

    @Override
    public Permissions getCurrentGroupPermissions() {
        return this.groupPermissions;
    }
}

