/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import ome.system.EventContext;
import ome.system.Preference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.PropertyPlaceholderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceContext
extends PropertyPlaceholderConfigurer {
    private static final Log log = LogFactory.getLog(PreferenceContext.class);
    private final Map<String, Preference> preferences = new ConcurrentHashMap<String, Preference>();
    private PropertyPlaceholderHelper helper;
    private String path;

    public PreferenceContext() {
        this.setSystemPropertiesMode(2);
        this.setIgnoreResourceNotFound(true);
        this.helper = new PropertyPlaceholderHelper("${", "}", ":", false);
    }

    public String getProperty(String key) {
        try {
            key = "${" + key + "}";
            return this.helper.replacePlaceholders(key, (PropertyPlaceholderHelper.PlaceholderResolver)new PropertyPlaceholderConfigurerResolver(this.mergeProperties()));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        catch (BeanDefinitionStoreException bdse) {
            return null;
        }
        catch (IOException e) {
            log.error((Object)"Error on mergeProperties()", (Throwable)e);
            return null;
        }
        catch (Exception exc) {
            log.error((Object)"Other exception on getProperty", (Throwable)exc);
            return null;
        }
    }

    public void setProperty(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public void setPreferences(List<Preference> preferences) {
        for (Preference pref : preferences) {
            this.preferences.put(pref.getName(), pref);
        }
    }

    public String resolveAlias(String key) {
        if (this.preferences.containsKey(key)) {
            return key;
        }
        for (String current : this.preferences.keySet()) {
            Preference preference = this.preferences.get(current);
            if (!preference.hasAlias(key)) continue;
            return current;
        }
        return key;
    }

    public boolean checkDatabase(String key) {
        Preference preference = this.getPreferenceOrDefault(key);
        return preference.isDb();
    }

    public boolean canRead(EventContext ec, String key) {
        Preference preference = this.getPreferenceOrDefault(key);
        switch (preference.getVisibility()) {
            case all: {
                return true;
            }
            case admin: {
                return ec.isCurrentUserAdmin();
            }
        }
        return false;
    }

    private Preference getPreferenceOrDefault(String key) {
        Preference preference = this.preferences.get(key);
        if (preference == null) {
            preference = new Preference();
        }
        return preference;
    }

    private class PropertyPlaceholderConfigurerResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Properties props;

        private PropertyPlaceholderConfigurerResolver(Properties props) {
            this.props = props;
        }

        public String resolvePlaceholder(String placeholderName) {
            return PreferenceContext.this.resolvePlaceholder(placeholderName, this.props, 2);
        }
    }
}

