/*
 * Decompiled with CFR 0.152.
 */
package ome.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import ome.annotations.AnnotationUtils;
import ome.annotations.NotNull;
import ome.annotations.ValidSet;
import ome.annotations.Validate;
import ome.conditions.ApiUsageException;
import ome.conditions.ValidationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApiConstraintChecker {
    private static Log log = LogFactory.getLog(ApiConstraintChecker.class);

    public static void errorOnViolation(Class implClass, Method mthd, Object[] args) throws ValidationException {
        if (implClass == null || mthd == null) {
            throw new ApiUsageException("ApiConstraintChecker expects non null class and method arguments.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking: " + mthd));
        }
        if (args == null) {
            args = new Object[]{};
        }
        Class<?>[] paramTypes = mthd.getParameterTypes();
        boolean[] validated = new boolean[args.length];
        Object[] allAnnotations = AnnotationUtils.findParameterAnnotations(implClass, mthd);
        for (int j = 0; j < allAnnotations.length; ++j) {
            int i;
            Annotation[][] anns = (Annotation[][])allAnnotations[j];
            if (anns == null) continue;
            for (i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Annotation[] annotations = anns[i];
                int n = i;
                validated[n] = validated[n] | false;
                for (Annotation annotation : annotations) {
                    if (NotNull.class.equals(annotation.annotationType())) {
                        if (null != arg) continue;
                        String msg = "Argument " + i + " to " + mthd + " may not be null.";
                        log.warn((Object)msg);
                        throw new ApiUsageException(msg);
                    }
                    if (!Validate.class.equals(annotation.annotationType())) continue;
                    validated[i] = true;
                    Validate validator = (Validate)annotation;
                    Class[] validClasses = validator.value();
                    ValidSet validSet = new ValidSet(validClasses);
                    String msg = "Argument " + i + " must be of a type in:" + validSet;
                    if (null == arg) continue;
                    if (arg instanceof Collection) {
                        Collection coll = (Collection)arg;
                        for (Object object : coll) {
                            if (object == null || validSet.isValid(object.getClass())) continue;
                            throw new ApiUsageException(msg);
                        }
                        continue;
                    }
                    if (validSet.isValid(arg.getClass())) continue;
                    throw new ApiUsageException(msg);
                }
            }
            for (i = 0; i < validated.length; ++i) {
                if (paramTypes[i].equals(Object.class) || !(args[i] instanceof Collection) || validated[i]) continue;
                throw new ValidationException(mthd + " is missing a required @" + Validate.class.getName() + " annotation. This should be added to one of the " + " implemented interfaces. Refusing to proceed...");
            }
        }
    }
}

