/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

public class VarMap {
    private boolean caseSensitive = true;
    private String[] name = new String[2];
    private double[] value = new double[2];
    private int numVars = 0;

    public VarMap() {
        this(true);
    }

    public VarMap(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public double getValue(String varName) {
        int i = 0;
        while (i < this.numVars) {
            if (this.caseSensitive && this.name[i].equals(varName) || !this.caseSensitive && this.name[i].equalsIgnoreCase(varName)) {
                return this.value[i];
            }
            ++i;
        }
        throw new RuntimeException("variable value has not been set: " + varName);
    }

    public void setValue(String varName, double val) {
        if (varName == null) {
            throw new IllegalArgumentException("varName cannot be null");
        }
        int i = 0;
        while (i < this.numVars) {
            if (this.caseSensitive && this.name[i].equals(varName) || !this.caseSensitive && this.name[i].equalsIgnoreCase(varName)) {
                this.value[i] = val;
                return;
            }
            ++i;
        }
        if (this.numVars == this.name.length) {
            String[] tmp1 = new String[2 * this.numVars];
            double[] tmp2 = new double[tmp1.length];
            int i2 = 0;
            while (i2 < this.numVars) {
                tmp1[i2] = this.name[i2];
                tmp2[i2] = this.value[i2];
                ++i2;
            }
            this.name = tmp1;
            this.value = tmp2;
        }
        this.name[this.numVars] = varName;
        this.value[this.numVars] = val;
        ++this.numVars;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String[] getVariableNames() {
        String[] arr = new String[this.numVars];
        int i = 0;
        while (i < arr.length) {
            arr[i] = this.name[i];
            ++i;
        }
        return arr;
    }

    public double[] getValues() {
        double[] arr = new double[this.numVars];
        int i = 0;
        while (i < arr.length) {
            arr[i] = this.value[i];
            ++i;
        }
        return arr;
    }

    public void remove(String varName) {
        int i = 0;
        while (i < this.numVars) {
            if (this.caseSensitive && this.name[i].equals(varName) || !this.caseSensitive && this.name[i].equalsIgnoreCase(varName)) {
                int j = i + 1;
                while (j < this.numVars) {
                    this.name[j - 1] = this.name[j];
                    this.value[j - 1] = this.value[j];
                    ++j;
                }
                --this.numVars;
                this.name[this.numVars] = null;
                this.value[this.numVars] = 0.0;
                break;
            }
            ++i;
        }
    }
}

