/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;

public class NaturalCubicSpline
extends ParametricCurve {
    private static double[][] pt = new double[0][];
    private static double[][] data = new double[0][];
    private static int ci = 0;
    private boolean closed = false;

    public NaturalCubicSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    protected void eval(double[] p) {
        int n = p.length - 1;
        double t = p[n];
        double t2 = t * t;
        double t3 = t2 * t;
        int j = 0;
        int i = 0;
        while (i < n) {
            p[i] = data[j++][ci] + data[j++][ci] * t + data[j++][ci] * t2 + data[j++][ci] * t3;
            ++i;
        }
    }

    private static void precalc(int n, int dim, boolean closed) {
        --n;
        double[] a = data[4 * dim];
        double[] b = data[4 * dim + 1];
        double[] c = data[4 * dim + 2];
        int k = 0;
        if (closed) {
            double[] d = data[4 * dim + 3];
            int j = 0;
            while (j < dim) {
                double e = 0.25;
                a[1] = 0.25;
                d[1] = 0.25;
                b[0] = e * 3.0 * (pt[1][j] - pt[n][j]);
                double h = 4.0;
                double f = 3.0 * (pt[0][j] - pt[n - 1][j]);
                double g = 1.0;
                int i = 1;
                while (i < n) {
                    a[i + 1] = e = 1.0 / (4.0 - a[i]);
                    d[i + 1] = -e * d[i];
                    b[i] = e * (3.0 * (pt[i + 1][j] - pt[i - 1][j]) - b[i - 1]);
                    h -= g * d[i];
                    f -= g * b[i - 1];
                    g = -a[i] * g;
                    ++i;
                }
                b[n] = f - (g + 1.0) * b[n - 1];
                c[n] = b[n] / (h -= (g + 1.0) * (a[n] + d[n]));
                c[n - 1] = b[n - 1] - (a[n] + d[n]) * c[n];
                i = n - 2;
                while (i >= 0) {
                    c[i] = b[i] - a[i + 1] * c[i + 1] - d[i + 1] * c[n];
                    --i;
                }
                double[] w = data[k++];
                double[] x = data[k++];
                double[] y = data[k++];
                double[] z = data[k++];
                int i2 = 0;
                while (i2 < n) {
                    w[i2] = pt[i2][j];
                    x[i2] = c[i2];
                    y[i2] = 3.0 * (pt[i2 + 1][j] - pt[i2][j]) - 2.0 * c[i2] - c[i2 + 1];
                    z[i2] = 2.0 * (pt[i2][j] - pt[i2 + 1][j]) + c[i2] + c[i2 + 1];
                    ++i2;
                }
                w[n] = pt[n][j];
                x[n] = c[n];
                y[n] = 3.0 * (pt[0][j] - pt[n][j]) - 2.0 * c[n] - c[0];
                z[n] = 2.0 * (pt[n][j] - pt[0][j]) + c[n] + c[0];
                ++j;
            }
        } else {
            int j = 0;
            while (j < dim) {
                a[0] = 0.5;
                int i = 1;
                while (i < n) {
                    a[i] = 1.0 / (4.0 - a[i - 1]);
                    ++i;
                }
                a[n] = 1.0 / (2.0 - a[n - 1]);
                b[0] = a[0] * (3.0 * (pt[1][j] - pt[0][j]));
                i = 1;
                while (i < n) {
                    b[i] = a[i] * (3.0 * (pt[i + 1][j] - pt[i - 1][j]) - b[i - 1]);
                    ++i;
                }
                b[n] = a[n] * (3.0 * (pt[n][j] - pt[n - 1][j]) - b[n - 1]);
                c[n] = b[n];
                i = n - 1;
                while (i >= 0) {
                    c[i] = b[i] - a[i] * c[i + 1];
                    --i;
                }
                double[] w = data[k++];
                double[] x = data[k++];
                double[] y = data[k++];
                double[] z = data[k++];
                int i3 = 0;
                while (i3 < n) {
                    w[i3] = pt[i3][j];
                    x[i3] = c[i3];
                    y[i3] = 3.0 * (pt[i3 + 1][j] - pt[i3][j]) - 2.0 * c[i3] - c[i3 + 1];
                    z[i3] = 2.0 * (pt[i3][j] - pt[i3 + 1][j]) + c[i3] + c[i3 + 1];
                    ++i3;
                }
                w[n] = pt[n][j];
                x[n] = 0.0;
                y[n] = 0.0;
                z[n] = 0.0;
                ++j;
            }
        }
    }

    public void setClosed(boolean b) {
        this.closed = b;
    }

    public boolean getClosed() {
        return this.closed;
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    @Override
    public void appendTo(MultiPath mp) {
        int i;
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            return;
        }
        int n = this.gi.getGroupSize();
        if (n < 2) {
            return;
        }
        int dim = mp.getDimension();
        int x = 3 + 4 * dim + 1;
        if (data.length < x) {
            double[][] temp = new double[x][];
            i = 0;
            while (i < data.length) {
                temp[i] = data[i];
                ++i;
            }
            data = temp;
        }
        if (pt.length < n) {
            int m = 2 * n;
            pt = new double[m][];
            i = 0;
            while (i < data.length) {
                NaturalCubicSpline.data[i] = new double[m];
                ++i;
            }
        }
        this.gi.set(0, 0);
        int i2 = 0;
        while (i2 < n) {
            NaturalCubicSpline.pt[i2] = this.cp.getPoint(this.gi.next()).getLocation();
            ++i2;
        }
        NaturalCubicSpline.precalc(n, dim, this.closed);
        ci = 0;
        double[] p = new double[dim + 1];
        this.eval(p);
        if (this.connect) {
            mp.lineTo(p);
        } else {
            mp.moveTo(p);
        }
        i = 0;
        while (i < n) {
            ci = i++;
            BinaryCurveApproximationAlgorithm.genPts(this, 0.0, 1.0, mp);
        }
    }

    @Override
    public void resetMemory() {
        if (pt.length > 0) {
            pt = new double[0][];
        }
        if (data.length > 0) {
            data = new double[0][];
        }
    }
}

