/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;

public class CubicBSpline
extends ParametricCurve {
    private static int section = 0;
    private static int numPoints = 0;
    private static double[][] pt = new double[4][];
    private static double[] b = new double[4];
    private boolean interpolateEndpoints = false;

    public CubicBSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    protected void eval(double[] p) {
        double t = p[p.length - 1];
        double t2 = t * t;
        double t3 = t2 * t;
        double u = 1.0 - t;
        double u2 = u * u;
        double u3 = u2 * u;
        if (numPoints == 4) {
            CubicBSpline.b[0] = u2 * u;
            CubicBSpline.b[1] = 3.0 * u2 * t;
            CubicBSpline.b[2] = 3.0 * u * t2;
            CubicBSpline.b[3] = t3;
        } else if (numPoints == 5) {
            if (section == 0) {
                CubicBSpline.b[0] = u3;
                CubicBSpline.b[1] = 7.0 * t3 / 4.0 - 9.0 * t2 / 2.0 + 3.0 * t;
                CubicBSpline.b[2] = -t3 + 3.0 * t2 / 2.0;
                CubicBSpline.b[3] = t3 / 4.0;
            } else {
                CubicBSpline.b[0] = u3 / 4.0;
                CubicBSpline.b[1] = -u3 + 3.0 * u2 / 2.0;
                CubicBSpline.b[2] = 7.0 * u3 / 4.0 - 9.0 * u2 / 2.0 + 3.0 * u;
                CubicBSpline.b[3] = t3;
            }
        } else if (numPoints == 6) {
            if (section == 0) {
                CubicBSpline.b[0] = u3;
                CubicBSpline.b[1] = 7.0 * t3 / 4.0 - 9.0 * t2 / 2.0 + 3.0 * t;
                CubicBSpline.b[2] = -11.0 * t3 / 12.0 + 3.0 * t2 / 2.0;
                CubicBSpline.b[3] = t3 / 6.0;
            } else if (section == 1) {
                CubicBSpline.b[0] = u3 / 4.0;
                CubicBSpline.b[1] = 7.0 * t3 / 12.0 - 5.0 * t2 / 4.0 + t / 4.0 + 0.5833333333333334;
                CubicBSpline.b[2] = -7.0 * t3 / 12.0 + t2 / 2.0 + t / 2.0 + 0.16666666666666666;
                CubicBSpline.b[3] = t3 / 4.0;
            } else {
                CubicBSpline.b[0] = u3 / 6.0;
                CubicBSpline.b[1] = -11.0 * u3 / 12.0 + 3.0 * u2 / 2.0;
                CubicBSpline.b[2] = 7.0 * u3 / 4.0 - 9.0 * u2 / 2.0 + 3.0 * u;
                CubicBSpline.b[3] = t3;
            }
        } else if (section == 0) {
            CubicBSpline.b[0] = u3;
            CubicBSpline.b[1] = 7.0 * t3 / 4.0 - 9.0 * t2 / 2.0 + 3.0 * t;
            CubicBSpline.b[2] = -11.0 * t3 / 12.0 + 3.0 * t2 / 2.0;
            CubicBSpline.b[3] = t3 / 6.0;
        } else if (section == 1) {
            CubicBSpline.b[0] = u3 / 4.0;
            CubicBSpline.b[1] = 7.0 * t3 / 12.0 - 5.0 * t2 / 4.0 + t / 4.0 + 0.5833333333333334;
            CubicBSpline.b[2] = -t3 / 2.0 + t2 / 2.0 + t / 2.0 + 0.16666666666666666;
            CubicBSpline.b[3] = t3 / 6.0;
        } else if (section == 2) {
            CubicBSpline.b[0] = u3 / 6.0;
            CubicBSpline.b[1] = t3 / 2.0 - t2 + 0.6666666666666666;
            CubicBSpline.b[2] = (-t3 + t2 + t) / 2.0 + 0.16666666666666666;
            CubicBSpline.b[3] = t3 / 6.0;
        } else if (section == 3) {
            CubicBSpline.b[0] = u3 / 6.0;
            CubicBSpline.b[1] = -u3 / 2.0 + u2 / 2.0 + u / 2.0 + 0.16666666666666666;
            CubicBSpline.b[2] = 7.0 * u3 / 12.0 - 5.0 * u2 / 4.0 + u / 4.0 + 0.5833333333333334;
            CubicBSpline.b[3] = t3 / 4.0;
        } else {
            CubicBSpline.b[0] = u3 / 6.0;
            CubicBSpline.b[1] = -11.0 * u3 / 12.0 + 3.0 * u2 / 2.0;
            CubicBSpline.b[2] = 7.0 * u3 / 4.0 - 9.0 * u2 / 2.0 + 3.0 * u;
            CubicBSpline.b[3] = t3;
        }
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < p.length - 1) {
                p[j] = p[j] + pt[i][j] * b[i];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    public void setInterpolateEndpoints(boolean b) {
        this.interpolateEndpoints = b;
    }

    public boolean getInterpolateEndpoints() {
        return this.interpolateEndpoints;
    }

    @Override
    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            return;
        }
        int n = this.gi.getGroupSize();
        if (n < 4) {
            return;
        }
        if (this.interpolateEndpoints) {
            numPoints = n;
            section = 0;
        } else {
            numPoints = -1;
            section = 2;
        }
        this.gi.set(0, 0);
        int index_i = 0;
        int count_j = 0;
        int i = 0;
        while (i < 4) {
            CubicBSpline.pt[i] = this.cp.getPoint(this.gi.next()).getLocation();
            ++i;
        }
        double[] d = new double[mp.getDimension() + 1];
        this.eval(d);
        if (this.connect) {
            mp.lineTo(d);
        } else {
            mp.moveTo(d);
        }
        int j = 3;
        while (true) {
            BinaryCurveApproximationAlgorithm.genPts(this, 0.0, 1.0, mp);
            if (++j == n) break;
            this.gi.set(index_i, count_j);
            this.gi.next();
            index_i = this.gi.index_i();
            count_j = this.gi.count_j();
            int i2 = 0;
            while (i2 < 4) {
                CubicBSpline.pt[i2] = this.cp.getPoint(this.gi.next()).getLocation();
                ++i2;
            }
            if (!this.interpolateEndpoints) continue;
            if (n < 7) {
                ++section;
                continue;
            }
            if (section != 2) {
                ++section;
            }
            if (section != 2 || j != n - 2) continue;
            ++section;
        }
    }
}

