/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;
import com.graphbuilder.curve.ValueVector;

public class BSpline
extends ParametricCurve {
    public static final int UNIFORM_CLAMPED = 0;
    public static final int UNIFORM_UNCLAMPED = 1;
    public static final int NON_UNIFORM = 2;
    private static int[] a = new int[0];
    private static int[] c = new int[0];
    private static double[] knot = new double[0];
    private ValueVector knotVector = new ValueVector(new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0}, 8);
    private double t_min = 0.0;
    private double t_max = 1.0;
    private int sampleLimit = 1;
    private int degree = 4;
    private int knotVectorType = 0;
    private boolean useDefaultInterval = true;

    public BSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    protected void eval(double[] p) {
        int dim = p.length - 1;
        double t = p[dim];
        int numPts = this.gi.getGroupSize();
        this.gi.set(0, 0);
        int i = 0;
        while (i < numPts) {
            double w = this.N(t, i);
            double[] loc = this.cp.getPoint(this.gi.next()).getLocation();
            int j = 0;
            while (j < dim) {
                int n = j;
                p[n] = p[n] + loc[j] * w;
                ++j;
            }
            ++i;
        }
    }

    public void setInterval(double t_min, double t_max) {
        if (t_min > t_max) {
            throw new IllegalArgumentException("t_min <= t_max required.");
        }
        this.t_min = t_min;
        this.t_max = t_max;
    }

    public double t_min() {
        return this.t_min;
    }

    public double t_max() {
        return this.t_max;
    }

    @Override
    public int getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Sample-limit >= 0 required.");
        }
        this.sampleLimit = limit;
    }

    public int getDegree() {
        return this.degree - 1;
    }

    public void setDegree(int d) {
        if (d <= 0) {
            throw new IllegalArgumentException("Degree > 0 required.");
        }
        this.degree = d + 1;
    }

    public ValueVector getKnotVector() {
        return this.knotVector;
    }

    public void setKnotVector(ValueVector v) {
        if (v == null) {
            throw new IllegalArgumentException("Knot-vector cannot be null.");
        }
        this.knotVector = v;
    }

    public boolean getUseDefaultInterval() {
        return this.useDefaultInterval;
    }

    public void setUseDefaultInterval(boolean b) {
        this.useDefaultInterval = b;
    }

    public int getKnotVectorType() {
        return this.knotVectorType;
    }

    public void setKnotVectorType(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("Unknown knot-vector type.");
        }
        this.knotVectorType = type;
    }

    @Override
    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            return;
        }
        int numPts = this.gi.getGroupSize();
        int f = numPts - this.degree;
        if (f < 0) {
            return;
        }
        int x = numPts + this.degree;
        if (knot.length < x) {
            knot = new double[2 * x];
        }
        double t1 = this.t_min;
        double t2 = this.t_max;
        if (this.knotVectorType == 2) {
            if (this.knotVector.size() != x) {
                return;
            }
            BSpline.knot[0] = this.knotVector.get(0);
            int i = 1;
            while (i < x) {
                BSpline.knot[i] = this.knotVector.get(i);
                if (knot[i] < knot[i - 1]) {
                    return;
                }
                ++i;
            }
        } else if (this.knotVectorType == 1) {
            double grad = 1.0 / (double)(x - 1);
            int i = 0;
            while (i < x) {
                BSpline.knot[i] = (double)i * grad;
                ++i;
            }
            if (this.useDefaultInterval) {
                t1 = (double)(this.degree - 1) * grad;
                t2 = 1.0 - (double)(this.degree - 1) * grad;
            }
        } else if (this.knotVectorType == 0) {
            double grad = 1.0 / (double)(f + 1);
            int i = 0;
            while (i < this.degree) {
                BSpline.knot[i] = 0.0;
                ++i;
            }
            int j = this.degree;
            int i2 = 1;
            while (i2 <= f) {
                BSpline.knot[j++] = (double)i2 * grad;
                ++i2;
            }
            i2 = j;
            while (i2 < x) {
                BSpline.knot[i2] = 1.0;
                ++i2;
            }
            if (this.useDefaultInterval) {
                t1 = 0.0;
                t2 = 1.0;
            }
        }
        if (a.length < this.degree) {
            a = new int[2 * this.degree];
            c = new int[2 * this.degree];
        }
        double[] p = new double[mp.getDimension() + 1];
        p[mp.getDimension()] = t1;
        this.eval(p);
        if (this.connect) {
            mp.lineTo(p);
        } else {
            mp.moveTo(p);
        }
        BinaryCurveApproximationAlgorithm.genPts(this, t1, t2, mp);
    }

    protected double N(double t, int i) {
        double d = 0.0;
        int j = 0;
        block0: while (j < this.degree) {
            double t1 = knot[i + j];
            double t2 = knot[i + j + 1];
            if (t >= t1 && t <= t2 && t1 != t2) {
                int dm2 = this.degree - 2;
                int k = this.degree - j - 1;
                while (k >= 0) {
                    BSpline.a[k] = 0;
                    --k;
                }
                if (j > 0) {
                    k = 0;
                    while (k < j) {
                        BSpline.c[k] = k;
                        ++k;
                    }
                    BSpline.c[j] = Integer.MAX_VALUE;
                } else {
                    BSpline.c[0] = dm2;
                    BSpline.c[1] = this.degree;
                }
                int z = 0;
                while (true) {
                    if (c[z] < c[z + 1] - 1) {
                        double e = 1.0;
                        int bc = 0;
                        int y = dm2 - j;
                        int p = j - 1;
                        int m = dm2;
                        int n = this.degree;
                        while (m >= 0) {
                            int w;
                            if (p >= 0 && c[p] == m) {
                                w = i + bc;
                                double kd = knot[w + n];
                                e *= (kd - t) / (kd - knot[w + 1]);
                                ++bc;
                                --p;
                            } else {
                                w = i + a[y];
                                double kw = knot[w];
                                e *= (t - kw) / (knot[w + n - 1] - kw);
                                --y;
                            }
                            --m;
                            --n;
                        }
                        if (j > 0) {
                            int g = 0;
                            boolean reset = false;
                            while (true) {
                                int n2 = ++g;
                                a[n2] = a[n2] + 1;
                                if (a[g] <= j) break;
                                reset = true;
                            }
                            if (reset) {
                                int h = g - 1;
                                while (h >= 0) {
                                    BSpline.a[h] = a[g];
                                    --h;
                                }
                            }
                        }
                        d += e;
                        int n3 = z;
                        c[n3] = c[n3] + 1;
                        if (c[z] > dm2) break block0;
                        int k2 = 0;
                        while (k2 < z) {
                            BSpline.c[k2] = k2;
                            ++k2;
                        }
                        z = 0;
                        continue;
                    }
                    ++z;
                }
            }
            ++j;
        }
        return d;
    }

    @Override
    public void resetMemory() {
        if (a.length > 0) {
            a = new int[0];
            c = new int[0];
        }
        if (knot.length > 0) {
            knot = new double[0];
        }
    }
}

