/*
 * Decompiled with CFR 0.152.
 */
import com.graphbuilder.curve.ValueVector;
import com.graphbuilder.curve.ValueVectorListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UnsortedValueVectorPanel
extends JPanel {
    public static final int VALUES_ABOVE_BAR = 0;
    public static final int VALUES_BELOW_BAR = 1;
    private ValueVector valueVector = null;
    private Vector vvlVec = new Vector();
    private boolean showValues = true;
    private int numDigits = 3;
    private double min = 0.0;
    private double max = 1.0;
    private Shape knobShape = new Rectangle(0, 0, 7, 7);
    private int knobWidth = 7;
    private int knobHeight = 7;
    private Rectangle2D rect = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private boolean find = true;
    private int mousex = 0;
    private int mousey = 0;
    private int current = 0;
    private int offsety = 0;
    private boolean disabled = true;
    private Color barColor = Color.black;
    private Color knobDrawColor = Color.black;
    private Color knobFillColor = Color.blue;
    private Color barColorDisabled = Color.gray;
    private Color knobDrawColorDisabled = Color.gray;
    private Color knobFillColorDisabled = Color.gray;
    private Color valueTextColorDisabled = Color.gray;
    private int barValueGap = 5;
    private int valuePosition = 0;
    private Color valueTextColor = Color.black;
    private int top = 0;
    private int bottom = 5;
    private int left = 15;
    private int right = 15;
    private boolean doubleClick = false;
    private int currentValueIndex = -1;
    private boolean canInsertAndRemove = false;

    public UnsortedValueVectorPanel(boolean canInsertAndRemove) {
        Control ctrl = new Control();
        this.addMouseListener(ctrl);
        this.addMouseMotionListener(ctrl);
        this.canInsertAndRemove = canInsertAndRemove;
    }

    public Shape getKnobShape() {
        return this.knobShape;
    }

    public void setKnobShape(Shape s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        Rectangle2D r = s.getBounds2D();
        this.knobWidth = (int)Math.round(r.getWidth());
        this.knobHeight = (int)Math.round(r.getHeight());
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setRange(double min, double max) {
        if (min >= max) {
            throw new IllegalArgumentException("Required: min < max");
        }
        this.min = min;
        this.max = max;
    }

    public void setShowValues(boolean b) {
        this.showValues = b;
    }

    public boolean getShowValues() {
        return this.showValues;
    }

    public void setValuePosition(int p) {
        if (p != 0 && p != 1) {
            throw new IllegalArgumentException("Unknown value position.");
        }
        this.valuePosition = p;
    }

    private void setValue(int i, double val) {
        double oldValue;
        if (val < this.min) {
            val = this.min;
        }
        if (val > this.max) {
            val = this.max;
        }
        if ((oldValue = this.valueVector.get(i)) != val) {
            this.valueVector.set(val, i);
            this.fireValueChanged(this.valueVector, i, oldValue);
        }
    }

    public int getValuePosition() {
        return this.valuePosition;
    }

    public void setNumDigits(int n) {
        this.numDigits = n;
    }

    public int getNumDigits() {
        return this.numDigits;
    }

    public ValueVector getValueVector() {
        return this.valueVector;
    }

    public void setValueVector(ValueVector kv) {
        this.valueVector = kv;
    }

    public Color getKnobFillColor() {
        return this.knobFillColor;
    }

    public void setKnobFillColor(Color c) {
        if (c == null) {
            throw new IllegalArgumentException("Knob fill color cannot be null.");
        }
        this.knobFillColor = c;
    }

    public void setDisabled(boolean b) {
        this.disabled = b;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void paint(Graphics _g) {
        super.paint(_g);
        Graphics2D g = (Graphics2D)_g;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.valueVector == null) {
            String msg = "<No Value-Vector Data Available>";
            TextLayout t = new TextLayout(msg, g.getFont(), g.getFontRenderContext());
            int th = Math.round(t.getAscent() + t.getDescent());
            int tw = Math.round(t.getAdvance());
            int x = (w - tw) / 2;
            int y = (h - th) / 2 + th;
            g.drawString(msg, x, y);
            return;
        }
        int nw = w - (this.left + this.right);
        int nh = h - (this.bottom + this.top);
        int y = this.top;
        int ty = 0;
        int n = this.valueVector.size();
        if (this.showValues) {
            String zero = "0";
            TextLayout t = new TextLayout(zero, g.getFont(), g.getFontRenderContext());
            int ascent = Math.round(t.getAscent());
            int th = ascent + this.barValueGap;
            if (this.valuePosition == 0) {
                ty = this.top + ascent;
                y += th;
                nh -= th;
            } else if (this.valuePosition == 1) {
                ty = this.top + nh - 1;
                nh -= th;
            }
        }
        if (this.disabled) {
            g.setColor(this.barColorDisabled);
        } else {
            g.setColor(this.barColor);
        }
        g.drawRect(this.left, y, nw - 1, nh);
        double xgap = 0.0;
        if (n != 1) {
            xgap = 1.0 * (double)nw / (double)(n - 1);
        }
        int i = 0;
        while (i < n) {
            int x = (int)Math.round(xgap * (double)i + (double)this.left);
            String s = String.valueOf(this.valueVector.get(i));
            int j = this.numDigits + 1;
            if (s.charAt(0) == '-') {
                ++j;
            }
            if (j < s.length()) {
                s = s.substring(0, j);
            }
            TextLayout t = new TextLayout(s, g.getFont(), g.getFontRenderContext());
            int tw = Math.round(t.getAdvance());
            if (this.disabled) {
                g.setColor(this.valueTextColorDisabled);
            } else {
                g.setColor(this.valueTextColor);
            }
            g.drawString(s, x - tw / 2, ty);
            if (i != n - 1) {
                g.drawLine(x, y, x, y + nh);
            }
            int ky = y + (int)Math.round((1.0 - (this.valueVector.get(i) - this.min) / (this.max - this.min)) * (double)nh) - this.knobHeight / 2;
            int kx = x - this.knobWidth / 2;
            if (ky < y - this.knobHeight / 2) {
                ky = y - this.knobHeight / 2;
            }
            if (ky > y + nh - this.knobHeight / 2) {
                ky = y + nh - this.knobHeight / 2;
            }
            if (i == n - 1) {
                --kx;
            }
            g.translate(kx, ky);
            if (this.find) {
                this.rect.setRect(kx, ky, this.knobWidth, this.knobHeight);
                if (this.rect.contains(this.mousex, this.mousey)) {
                    this.find = false;
                    this.current = i;
                    this.offsety = ky + this.knobHeight / 2 - this.mousey;
                    if (this.doubleClick) {
                        this.doubleClick = false;
                        double value = this.valueVector.get(i);
                        this.valueVector.remove(i);
                        this.fireValueRemoved(this.valueVector, i, value);
                        this.current = -1;
                        --n;
                    }
                }
            } else if (this.current != -1) {
                this.setValue(this.current, (1.0 - 1.0 * (double)(this.mousey - y + this.offsety) / (double)nh) * (this.max - this.min) + this.min);
            }
            if (this.disabled) {
                g.setColor(this.knobFillColorDisabled);
            } else {
                g.setColor(this.knobFillColor);
            }
            g.fill(this.knobShape);
            if (this.disabled) {
                g.setColor(this.knobDrawColorDisabled);
            } else {
                g.setColor(this.knobDrawColor);
            }
            g.draw(this.knobShape);
            g.translate(-kx, -ky);
            ++i;
        }
        if (this.doubleClick) {
            this.doubleClick = false;
            int k = 0;
            double val = this.min;
            if (this.mousex >= this.left) {
                if (this.mousex > this.left + nw) {
                    k = n;
                    val = this.max;
                } else {
                    k = (int)((1.0 * (double)this.mousex - (double)this.left) / xgap) + 1;
                    if (k > 0 && k < this.valueVector.size()) {
                        val = (this.valueVector.get(k) + this.valueVector.get(k - 1)) / 2.0;
                    } else if (k < 0) {
                        k = 0;
                    } else if (k > this.valueVector.size()) {
                        k = this.valueVector.size();
                    }
                }
            }
            this.valueVector.insert(val, k);
            this.fireValueInserted(this.valueVector, k, val);
        }
    }

    private void fireValueInserted(ValueVector v, int index, double value) {
        int i = 0;
        while (i < this.getNumValueVectorListeners()) {
            this.getValueVectorListener(i).valueInserted(v, index, value);
            ++i;
        }
    }

    private void fireValueRemoved(ValueVector v, int index, double value) {
        int i = 0;
        while (i < this.getNumValueVectorListeners()) {
            this.getValueVectorListener(i).valueRemoved(v, index, value);
            ++i;
        }
    }

    private void fireValueChanged(ValueVector v, int index, double oldValue) {
        int i = 0;
        while (i < this.getNumValueVectorListeners()) {
            this.getValueVectorListener(i).valueChanged(v, index, oldValue);
            ++i;
        }
    }

    public void addValueVectorListener(ValueVectorListener vvl) {
        if (vvl == null) {
            throw new IllegalArgumentException("cannot add null listener.");
        }
        this.vvlVec.add(vvl);
    }

    public void removeValueVectorListener(ValueVectorListener vvl) {
        this.vvlVec.remove(vvl);
    }

    public ValueVectorListener getValueVectorListener(int i) {
        return (ValueVectorListener)this.vvlVec.get(i);
    }

    public int getNumValueVectorListeners() {
        return this.vvlVec.size();
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel(new BorderLayout());
        UnsortedValueVectorPanel ukvp = new UnsortedValueVectorPanel(true);
        ukvp.setValueVector(new ValueVector());
        panel.add((Component)ukvp, "Center");
        JFrame f = new JFrame();
        f.setSize(400, 400);
        f.setContentPane(panel);
        f.show();
    }

    private class Control
    implements MouseListener,
    MouseMotionListener {
        @Override
        public void mousePressed(MouseEvent evt) {
            if (UnsortedValueVectorPanel.this.disabled) {
                return;
            }
            UnsortedValueVectorPanel.this.mousex = evt.getX();
            UnsortedValueVectorPanel.this.mousey = evt.getY();
            UnsortedValueVectorPanel.this.doubleClick = false;
            if (UnsortedValueVectorPanel.this.canInsertAndRemove && evt.getClickCount() >= 2) {
                UnsortedValueVectorPanel.this.doubleClick = true;
            }
            UnsortedValueVectorPanel.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (UnsortedValueVectorPanel.this.disabled) {
                return;
            }
            UnsortedValueVectorPanel.this.mousex = Integer.MIN_VALUE;
            UnsortedValueVectorPanel.this.mousey = Integer.MIN_VALUE;
            UnsortedValueVectorPanel.this.find = true;
            UnsortedValueVectorPanel.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (UnsortedValueVectorPanel.this.disabled) {
                return;
            }
            UnsortedValueVectorPanel.this.mousex = evt.getX();
            UnsortedValueVectorPanel.this.mousey = evt.getY();
            UnsortedValueVectorPanel.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }
    }
}

