/*
 * Decompiled with CFR 0.152.
 */
import com.graphbuilder.curve.BSpline;
import com.graphbuilder.curve.BezierCurve;
import com.graphbuilder.curve.CardinalSpline;
import com.graphbuilder.curve.CatmullRomSpline;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.CubicBSpline;
import com.graphbuilder.curve.Curve;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.LagrangeCurve;
import com.graphbuilder.curve.NURBSpline;
import com.graphbuilder.curve.NaturalCubicSpline;
import com.graphbuilder.curve.Polyline;
import com.graphbuilder.curve.ValueVector;
import com.graphbuilder.curve.ValueVectorListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditCurvePanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ValueVectorListener {
    private JList curveList = new JList();
    private Vector curveListVec = new Vector();
    private JButton insertButton = new JButton("Insert");
    private JButton removeButton = new JButton("Remove");
    private JLabel controlStringLabel = new JLabel("Control String:");
    private JTextField controlStringTextField = new JTextField(6);
    private JCheckBox connectCheckBox = new JCheckBox("Connect");
    private JLabel tminLabel = new JLabel("t_min:");
    private JLabel tmaxLabel = new JLabel("t_max:");
    private JTextField tminTextField = new JTextField(3);
    private JTextField tmaxTextField = new JTextField(3);
    private JLabel sampleLimitLabel = new JLabel("Sample Limit:");
    private JTextField sampleLimitTextField = new JTextField(2);
    private JLabel alphaLabel = new JLabel("Alpha:");
    private JTextField alphaTextField = new JTextField(4);
    private JLabel degreeLabel = new JLabel("Degree:");
    private JTextField degreeTextField = new JTextField(2);
    private JLabel knotVectorTypeLabel = new JLabel("Knot Vector Type:");
    private JComboBox knotVectorTypeComboBox = new JComboBox<Object>(new Object[]{"Uniform Clamped", "Uniform Unclamped", "Non-Uniform"});
    private JCheckBox useDefaultIntervalCheckBox = new JCheckBox("Use Default Interval");
    private JCheckBox interpolateEndpointsCheckBox = new JCheckBox("Interpolate Endpoints");
    private JCheckBox closedCheckBox = new JCheckBox("Closed");
    private UnsortedValueVectorPanel knotVectorPanel = new UnsortedValueVectorPanel(true);
    private UnsortedValueVectorPanel weightVectorPanel = new UnsortedValueVectorPanel(true);
    private JLabel baseIndexLabel = new JLabel("Base Index:");
    private JTextField baseIndexTextField = new JTextField(3);
    private JLabel baseLengthLabel = new JLabel("Base Length:");
    private JTextField baseLengthTextField = new JTextField(3);
    private JCheckBox interpolateFirstCheckBox = new JCheckBox("Interpolate First");
    private JCheckBox interpolateLastCheckBox = new JCheckBox("Interpolate Last");
    private JCheckBox useWeightVectorCheckBox = new JCheckBox("Use Weight Vector");
    private JDialog pickCurveDialog = null;
    private JList availableCurveList = null;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel listPanel = new JPanel(new BorderLayout());
    private JPanel editPanel = new JPanel(new BorderLayout());
    private ControlPath controlPath = null;
    private JPanel repaintPanel = null;
    private JPanel closePanel = new JPanel(new FlowLayout(2));
    private JButton applyButton = new JButton("Apply");
    private JButton closeButton = new JButton("Close");

    public EditCurvePanel() {
        this.curveList.setPrototypeCellValue("Natural Cubic Spline");
        this.curveList.setCellRenderer(new CurveListCellRenderer());
        this.setLayout(new BorderLayout());
        this.knotVectorPanel.addValueVectorListener(this);
        this.weightVectorPanel.addValueVectorListener(this);
        this.weightVectorPanel.setKnobFillColor(Color.red);
        this.weightVectorPanel.setRange(0.0, 3.0);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.insertButton);
        buttonPanel.add(this.removeButton);
        this.listPanel.add((Component)new JScrollPane(this.curveList), "Center");
        this.listPanel.add((Component)buttonPanel, "South");
        this.add((Component)this.listPanel, "West");
        this.insertButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.curveList.addListSelectionListener(this);
        this.connectCheckBox.addActionListener(this);
        this.interpolateEndpointsCheckBox.addActionListener(this);
        this.closedCheckBox.addActionListener(this);
        this.interpolateFirstCheckBox.addActionListener(this);
        this.interpolateLastCheckBox.addActionListener(this);
        this.knotVectorTypeComboBox.addActionListener(this);
        this.useDefaultIntervalCheckBox.addActionListener(this);
        this.useWeightVectorCheckBox.addActionListener(this);
        this.closePanel.add(this.applyButton);
        this.closePanel.add(this.closeButton);
        this.editPanel.add((Component)this.closePanel, "South");
        this.add((Component)this.editPanel, "Center");
    }

    public void setRepaintPanel(JPanel rp) {
        this.repaintPanel = rp;
    }

    public void setControlPath(ControlPath cp) {
        this.curveListVec = new Vector();
        int i = 0;
        while (i < cp.numCurves()) {
            this.curveListVec.add(cp.getCurve(i));
            ++i;
        }
        this.controlPath = cp;
        this.curveList.setListData(this.curveListVec);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.insertButton) {
            if (this.pickCurveDialog == null) {
                String[] curves = new String[]{"Bezier Curve", "B-Spline", "Cardinal Spline", "Catmull-Rom Spline", "Cubic B-Spline", "Lagrange Curve", "Natural Cubic Spline", "NURB-Spline", "Polyline"};
                this.availableCurveList = new JList<String>(curves);
                Window w = SwingUtilities.windowForComponent(this);
                String title = "Insert Curve";
                this.pickCurveDialog = w instanceof Frame ? new JDialog((Frame)w, title) : (w instanceof Dialog ? new JDialog((Dialog)w, title) : new JDialog(null, title));
                JPanel buttonPanel = new JPanel(new FlowLayout(1));
                buttonPanel.add(this.okButton);
                buttonPanel.add(this.cancelButton);
                JPanel listPanel = new JPanel(new BorderLayout());
                this.availableCurveList.setBorder(BorderFactory.createLineBorder(Color.darkGray));
                listPanel.add((Component)this.availableCurveList, "Center");
                listPanel.add((Component)buttonPanel, "South");
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                this.pickCurveDialog.setContentPane(listPanel);
                this.pickCurveDialog.setModal(true);
                this.pickCurveDialog.pack();
                this.pickCurveDialog.setLocation((d.width - this.pickCurveDialog.getWidth()) / 2, (d.height - this.pickCurveDialog.getHeight()) / 2);
            }
            this.pickCurveDialog.show();
        } else if (src == this.okButton || src == this.cancelButton) {
            String name = (String)this.availableCurveList.getSelectedValue();
            if (src == this.okButton && name != null) {
                Curve c = this.createCurve(name);
                int index = this.curveList.getSelectedIndex();
                if (index < 0) {
                    index = this.curveListVec.size();
                }
                this.curveListVec.insertElementAt(c, index);
                this.curveList.setListData(this.curveListVec);
                this.controlPath.insertCurve(c, index);
                this.curveList.setSelectedValue(c, true);
            }
            this.pickCurveDialog.hide();
        } else if (src == this.removeButton) {
            int[] indices = this.curveList.getSelectedIndices();
            int i = indices.length - 1;
            while (i >= 0) {
                this.curveListVec.removeElementAt(indices[i]);
                this.controlPath.removeCurve(indices[i]);
                --i;
            }
            this.curveList.setListData(this.curveListVec);
            if (indices.length > 0) {
                int index = indices[0];
                if (index >= this.controlPath.numCurves()) {
                    index = this.controlPath.numCurves() - 1;
                }
                if (index >= 0) {
                    this.curveList.setSelectedIndex(index);
                }
            }
        } else if (src == this.connectCheckBox) {
            Curve c = (Curve)this.curveList.getSelectedValue();
            c.setConnect(this.connectCheckBox.isSelected());
        } else if (src == this.interpolateEndpointsCheckBox) {
            CubicBSpline cbs = (CubicBSpline)this.curveList.getSelectedValue();
            cbs.setInterpolateEndpoints(this.interpolateEndpointsCheckBox.isSelected());
        } else if (src == this.interpolateFirstCheckBox) {
            LagrangeCurve lc = (LagrangeCurve)this.curveList.getSelectedValue();
            lc.setInterpolateFirst(this.interpolateFirstCheckBox.isSelected());
        } else if (src == this.interpolateLastCheckBox) {
            LagrangeCurve lc = (LagrangeCurve)this.curveList.getSelectedValue();
            lc.setInterpolateLast(this.interpolateLastCheckBox.isSelected());
        } else if (src == this.closedCheckBox) {
            NaturalCubicSpline ncs = (NaturalCubicSpline)this.curveList.getSelectedValue();
            ncs.setClosed(this.closedCheckBox.isSelected());
        } else if (src == this.useDefaultIntervalCheckBox) {
            BSpline bs = (BSpline)this.curveList.getSelectedValue();
            bs.setUseDefaultInterval(this.useDefaultIntervalCheckBox.isSelected());
        } else if (src == this.knotVectorTypeComboBox) {
            BSpline bs = (BSpline)this.curveList.getSelectedValue();
            int type = this.knotVectorTypeComboBox.getSelectedIndex();
            bs.setKnotVectorType(type);
            this.useDefaultIntervalCheckBox.setEnabled(type != 2);
            this.knotVectorPanel.setDisabled(type != 2);
            this.knotVectorPanel.repaint();
        } else if (src == this.useWeightVectorCheckBox) {
            boolean b = this.useWeightVectorCheckBox.isSelected();
            NURBSpline ns = (NURBSpline)this.curveList.getSelectedValue();
            ns.setUseWeightVector(b);
            this.weightVectorPanel.setDisabled(!b);
            this.weightVectorPanel.repaint();
        } else if (src == this.closeButton) {
            Window w = SwingUtilities.windowForComponent(this);
            w.hide();
        } else if (src == this.applyButton) {
            this.applySettings();
        }
        this.repaintPanel.repaint();
    }

    private void applySettings() {
        JTextField comp = null;
        try {
            Curve c = (Curve)this.curveList.getSelectedValue();
            if (c != null) {
                comp = this.controlStringTextField;
                c.setGroupIterator(new GroupIterator(this.controlStringTextField.getText(), this.controlPath.numPoints()));
            }
            if (c instanceof BezierCurve) {
                BezierCurve bc = (BezierCurve)c;
                comp = this.tminTextField;
                double t_min = Double.parseDouble(this.tminTextField.getText());
                comp = this.tmaxTextField;
                double t_max = Double.parseDouble(this.tmaxTextField.getText());
                bc.setInterval(t_min, t_max);
                comp = this.sampleLimitTextField;
                bc.setSampleLimit(Integer.parseInt(this.sampleLimitTextField.getText()));
            } else if (c instanceof BSpline) {
                BSpline bs = (BSpline)c;
                comp = this.tminTextField;
                double t_min = Double.parseDouble(this.tminTextField.getText());
                comp = this.tmaxTextField;
                double t_max = Double.parseDouble(this.tmaxTextField.getText());
                bs.setInterval(t_min, t_max);
                comp = this.sampleLimitTextField;
                bs.setSampleLimit(Integer.parseInt(this.sampleLimitTextField.getText()));
                comp = this.degreeTextField;
                bs.setDegree(Integer.parseInt(this.degreeTextField.getText()));
            } else if (c instanceof CardinalSpline) {
                CardinalSpline cs = (CardinalSpline)c;
                comp = this.alphaTextField;
                cs.setAlpha(Double.parseDouble(this.alphaTextField.getText()));
            } else if (c instanceof LagrangeCurve) {
                LagrangeCurve lc = (LagrangeCurve)c;
                comp = this.baseIndexTextField;
                lc.setBaseIndex(Integer.parseInt(this.baseIndexTextField.getText()));
                comp = this.baseLengthTextField;
                lc.setBaseLength(Integer.parseInt(this.baseLengthTextField.getText()));
            }
        }
        catch (Throwable err) {
            JOptionPane.showMessageDialog(this, err, "ERROR", 0);
        }
        if (comp != null) {
            ((Component)comp).requestFocus();
        }
    }

    private Curve createCurve(String name) {
        ControlPath cp = this.controlPath;
        GroupIterator gi = new GroupIterator("0:n-1", cp.numPoints());
        if (name.equals("Bezier Curve")) {
            return new BezierCurve(cp, gi);
        }
        if (name.equals("B-Spline")) {
            return new BSpline(cp, gi);
        }
        if (name.equals("Cardinal Spline")) {
            return new CardinalSpline(cp, gi);
        }
        if (name.equals("Catmull-Rom Spline")) {
            return new CatmullRomSpline(cp, gi);
        }
        if (name.equals("Cubic B-Spline")) {
            return new CubicBSpline(cp, gi);
        }
        if (name.equals("Lagrange Curve")) {
            return new LagrangeCurve(cp, gi);
        }
        if (name.equals("Natural Cubic Spline")) {
            return new NaturalCubicSpline(cp, gi);
        }
        if (name.equals("NURB-Spline")) {
            return new NURBSpline(cp, gi);
        }
        return new Polyline(cp, gi);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        Curve c = (Curve)this.curveList.getSelectedValue();
        if (c != null) {
            this.controlStringTextField.setText(c.getGroupIterator().getControlString());
            this.connectCheckBox.setSelected(c.getConnect());
        }
        this.editPanel.removeAll();
        this.editPanel.add((Component)this.closePanel, "South");
        if (c instanceof BezierCurve) {
            this.editPanel.add((Component)this.getBezierCurvePanel(), "Center");
            BezierCurve bc = (BezierCurve)c;
            this.tminTextField.setText(String.valueOf(bc.t_min()));
            this.tmaxTextField.setText(String.valueOf(bc.t_max()));
            this.sampleLimitTextField.setText(String.valueOf(bc.getSampleLimit()));
        } else if (c instanceof BSpline) {
            boolean nurbs = c instanceof NURBSpline;
            this.editPanel.add((Component)this.getBSplinePanel(nurbs), "Center");
            BSpline bs = (BSpline)c;
            this.tminTextField.setText(String.valueOf(bs.t_min()));
            this.tmaxTextField.setText(String.valueOf(bs.t_max()));
            this.sampleLimitTextField.setText(String.valueOf(bs.getSampleLimit()));
            this.degreeTextField.setText(String.valueOf(bs.getDegree()));
            int type = bs.getKnotVectorType();
            this.knotVectorTypeComboBox.setSelectedIndex(type);
            this.useDefaultIntervalCheckBox.setSelected(bs.getUseDefaultInterval());
            this.useDefaultIntervalCheckBox.setEnabled(type != 2);
            this.knotVectorPanel.setValueVector(bs.getKnotVector());
            if (nurbs) {
                NURBSpline ns = (NURBSpline)bs;
                boolean b = ns.getUseWeightVector();
                this.weightVectorPanel.setValueVector(ns.getWeightVector());
                this.useWeightVectorCheckBox.setSelected(b);
                this.weightVectorPanel.setDisabled(!b);
            }
        } else if (c instanceof CardinalSpline) {
            this.editPanel.add((Component)this.getCardinalSplinePanel(), "Center");
            CardinalSpline cs = (CardinalSpline)c;
            this.alphaTextField.setText(String.valueOf(cs.getAlpha()));
        } else if (c instanceof CubicBSpline) {
            this.editPanel.add((Component)this.getCubicBSplinePanel(), "Center");
            CubicBSpline cbs = (CubicBSpline)c;
            this.interpolateEndpointsCheckBox.setSelected(cbs.getInterpolateEndpoints());
        } else if (c instanceof LagrangeCurve) {
            this.editPanel.add((Component)this.getLagrangeCurvePanel(), "Center");
            LagrangeCurve lc = (LagrangeCurve)c;
            this.baseIndexTextField.setText(String.valueOf(lc.getBaseIndex()));
            this.baseLengthTextField.setText(String.valueOf(lc.getBaseLength()));
            this.interpolateFirstCheckBox.setSelected(this.interpolateFirstCheckBox.isSelected());
            this.interpolateLastCheckBox.setSelected(this.interpolateLastCheckBox.isSelected());
            this.knotVectorPanel.setValueVector(lc.getKnotVector());
            this.knotVectorPanel.setDisabled(false);
            this.knotVectorPanel.repaint();
        } else if (c instanceof NaturalCubicSpline) {
            this.editPanel.add((Component)this.getNaturalCubicSplinePanel(), "Center");
            NaturalCubicSpline ncs = (NaturalCubicSpline)c;
            this.closedCheckBox.setSelected(ncs.getClosed());
        } else if (c != null) {
            this.editPanel.add((Component)this.getCurvePanel(), "Center");
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void valueInserted(ValueVector v, int index, double value) {
        this.repaintPanel.repaint();
    }

    @Override
    public void valueRemoved(ValueVector v, int index, double oldValue) {
        this.repaintPanel.repaint();
    }

    @Override
    public void valueChanged(ValueVector v, int index, double oldValue) {
        this.repaintPanel.repaint();
    }

    private JPanel getCurvePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(this.controlStringLabel);
        p.add(this.controlStringTextField);
        p.add(this.connectCheckBox);
        panel.add((Component)p, "North");
        return panel;
    }

    private JPanel getBezierCurvePanel() {
        JPanel panel = this.getCurvePanel();
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(this.tminLabel);
        p1.add(this.tminTextField);
        p1.add(this.tmaxLabel);
        p1.add(this.tmaxTextField);
        JPanel p2 = new JPanel(new FlowLayout(0));
        p2.add(this.sampleLimitLabel);
        p2.add(this.sampleLimitTextField);
        JPanel p3 = new JPanel(new BorderLayout());
        p3.add((Component)p1, "North");
        p3.add((Component)p2, "Center");
        panel.add((Component)p3, "Center");
        return panel;
    }

    private JPanel getBSplinePanel(boolean nurbs) {
        JPanel panel = this.getCurvePanel();
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(this.tminLabel);
        p1.add(this.tminTextField);
        p1.add(this.tmaxLabel);
        p1.add(this.tmaxTextField);
        JPanel p2 = new JPanel(new FlowLayout(0));
        p2.add(this.sampleLimitLabel);
        p2.add(this.sampleLimitTextField);
        p2.add(this.degreeLabel);
        p2.add(this.degreeTextField);
        JPanel p3 = new JPanel(new FlowLayout(0));
        p3.add(this.knotVectorTypeLabel);
        p3.add(this.knotVectorTypeComboBox);
        JPanel p4 = new JPanel(new FlowLayout(0));
        p4.add(this.useDefaultIntervalCheckBox);
        if (nurbs) {
            p4.add(this.useWeightVectorCheckBox);
        }
        JPanel p5 = new JPanel(new BorderLayout());
        p5.add((Component)p3, "North");
        p5.add((Component)p4, "Center");
        JPanel p6 = new JPanel(new BorderLayout());
        p6.add((Component)p2, "North");
        p6.add((Component)p5, "Center");
        JPanel p7 = new JPanel(new BorderLayout());
        p7.add((Component)p1, "North");
        p7.add((Component)p6, "Center");
        JPanel p8 = new JPanel(new BorderLayout());
        p8.add((Component)p7, "North");
        JPanel vvp = null;
        if (nurbs) {
            vvp = new JPanel(new GridLayout(1, 2));
            vvp.add(this.knotVectorPanel);
            vvp.add(this.weightVectorPanel);
        } else {
            vvp = this.knotVectorPanel;
        }
        p8.add((Component)vvp, "Center");
        panel.add((Component)p8, "Center");
        return panel;
    }

    private JPanel getCardinalSplinePanel() {
        JPanel panel = this.getCurvePanel();
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(this.alphaLabel);
        p1.add(this.alphaTextField);
        panel.add((Component)p1, "Center");
        return panel;
    }

    private JPanel getCubicBSplinePanel() {
        JPanel panel = this.getCurvePanel();
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(this.interpolateEndpointsCheckBox);
        panel.add((Component)p1, "Center");
        return panel;
    }

    private JPanel getLagrangeCurvePanel() {
        JPanel panel = this.getCurvePanel();
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(this.baseIndexLabel);
        p1.add(this.baseIndexTextField);
        p1.add(this.baseLengthLabel);
        p1.add(this.baseLengthTextField);
        JPanel p2 = new JPanel(new FlowLayout(0));
        p2.add(this.interpolateFirstCheckBox);
        p2.add(this.interpolateLastCheckBox);
        JPanel p3 = new JPanel(new BorderLayout());
        p3.add((Component)p1, "North");
        p3.add((Component)p2, "Center");
        JPanel p4 = new JPanel(new BorderLayout());
        p4.add((Component)p3, "North");
        p4.add((Component)this.knotVectorPanel, "Center");
        panel.add((Component)p4, "Center");
        return panel;
    }

    private JPanel getNaturalCubicSplinePanel() {
        JPanel panel = this.getCurvePanel();
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(this.closedCheckBox);
        panel.add((Component)p1, "Center");
        return panel;
    }
}

