/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class CurveDemo
implements ActionListener {
    private EditCurvePanel editCurvePanel = new EditCurvePanel();
    private ControlPathPanel controlPathPanel = new ControlPathPanel();
    private JFrame frame = new JFrame("Curve Demo");
    private JDialog editDialog = new JDialog((Frame)this.frame, "Curve Options");
    private JMenuItem editCurveMenuItem = new JMenuItem("Edit Curves");
    private JMenuItem setFlatnessMenuItem = new JMenuItem("Set Flatness");
    private JCheckBoxMenuItem showControlPointsCheckBox = new JCheckBoxMenuItem("Show Control Points", this.controlPathPanel.getShowControlPoints());
    private JCheckBoxMenuItem showControlLineCheckBox = new JCheckBoxMenuItem("Show Control Line", this.controlPathPanel.getShowControlLine());
    private JCheckBoxMenuItem showPointNumbersCheckBox = new JCheckBoxMenuItem("Show Point Numbers", this.controlPathPanel.getShowPointNumbers());
    private JCheckBoxMenuItem showPointLocationsCheckBox = new JCheckBoxMenuItem("Show Point Locations", this.controlPathPanel.getShowPointLocations());
    private JCheckBoxMenuItem antialiasCurvesCheckBox = new JCheckBoxMenuItem("Anti-alias Curves", this.controlPathPanel.getAntialiasCurves());
    private JCheckBoxMenuItem showCurvesCheckBox = new JCheckBoxMenuItem("Show Curves", this.controlPathPanel.getShowCurves());

    public CurveDemo() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setSize(500, 500);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        this.frame.setContentPane(this.controlPathPanel);
        JMenuBar menuBar = new JMenuBar();
        this.frame.setJMenuBar(menuBar);
        JMenu controlPathMenu = new JMenu("Control-Path");
        controlPathMenu.add(this.showControlPointsCheckBox);
        controlPathMenu.add(this.showControlLineCheckBox);
        controlPathMenu.add(this.showPointNumbersCheckBox);
        controlPathMenu.add(this.showPointLocationsCheckBox);
        controlPathMenu.add(this.antialiasCurvesCheckBox);
        controlPathMenu.add(this.showCurvesCheckBox);
        controlPathMenu.add(this.setFlatnessMenuItem);
        controlPathMenu.add(this.editCurveMenuItem);
        menuBar.add(controlPathMenu);
        this.editDialog.setContentPane(this.editCurvePanel);
        this.editDialog.setSize(500, 300);
        this.editDialog.setLocation((d.width - this.editDialog.getWidth()) / 2, (d.height - this.editDialog.getHeight()) / 2);
        this.editCurveMenuItem.addActionListener(this);
        this.setFlatnessMenuItem.addActionListener(this);
        this.showControlPointsCheckBox.addActionListener(this);
        this.showControlLineCheckBox.addActionListener(this);
        this.showPointNumbersCheckBox.addActionListener(this);
        this.showPointLocationsCheckBox.addActionListener(this);
        this.antialiasCurvesCheckBox.addActionListener(this);
        this.showCurvesCheckBox.addActionListener(this);
        this.frame.show();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        double f;
        Object o;
        Object src = evt.getSource();
        if (src == this.editCurveMenuItem) {
            this.editCurvePanel.setControlPath(this.controlPathPanel.getControlPath());
            this.editCurvePanel.setRepaintPanel(this.controlPathPanel);
            this.editDialog.show();
        } else if (src == this.showControlPointsCheckBox) {
            this.controlPathPanel.setShowControlPoints(this.showControlPointsCheckBox.isSelected());
        } else if (src == this.showControlLineCheckBox) {
            this.controlPathPanel.setShowControlLine(this.showControlLineCheckBox.isSelected());
        } else if (src == this.showPointNumbersCheckBox) {
            this.controlPathPanel.setShowPointNumbers(this.showPointNumbersCheckBox.isSelected());
        } else if (src == this.showPointLocationsCheckBox) {
            this.controlPathPanel.setShowPointLocations(this.showPointLocationsCheckBox.isSelected());
        } else if (src == this.antialiasCurvesCheckBox) {
            this.controlPathPanel.setAntialiasCurves(this.antialiasCurvesCheckBox.isSelected());
        } else if (src == this.showCurvesCheckBox) {
            this.controlPathPanel.setShowCurves(this.showCurvesCheckBox.isSelected());
        } else if (src == this.setFlatnessMenuItem && (o = JOptionPane.showInputDialog(this.frame, "Enter flatness value:", "Flatness", 3, null, null, String.valueOf(f = this.controlPathPanel.getFlatness()))) != null) {
            try {
                f = Double.parseDouble(o.toString());
                this.controlPathPanel.setFlatness(f);
            }
            catch (Throwable err) {
                JOptionPane.showMessageDialog(this.frame, err, "ERROR", 0);
            }
        }
        this.controlPathPanel.repaint();
    }

    public static void main(String[] args) {
        new CurveDemo();
    }
}

