/*
 * Decompiled with CFR 0.152.
 */
import com.graphbuilder.curve.BSpline;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.Curve;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.Point;
import com.graphbuilder.curve.ShapeMultiPath;
import com.graphbuilder.geom.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class ControlPathPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private ControlPath cp = new ControlPath();
    private PointFactory pointFactory = new PointFactory();
    private int controlPointSize = 10;
    private Color controlPointColor = Color.red;
    private Color controlLineColor = Color.blue;
    private Color insertPointColor = Color.red;
    private Color closestPointColor = Color.black;
    private Color pointNumberColor = Color.black;
    private int grabDistanceThreshold = 10;
    private boolean grabbing = false;
    private int closestPointIndex1 = -1;
    private int closestPointIndex2 = -1;
    private int closestPointIndex = -1;
    private double mouseX = 0.0;
    private double mouseY = 0.0;
    private double deltaX = 0.0;
    private double deltaY = 0.0;
    private boolean showControlPoints = true;
    private boolean showControlLine = true;
    private boolean showPointNumbers = false;
    private boolean showPointLocations = false;
    private boolean antialiasCurves = false;
    private boolean showCurves = true;
    private ShapeMultiPath multiPath = new ShapeMultiPath();

    public ControlPathPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
        this.cp.addCurve(new BSpline(this.cp, new GroupIterator("0:n-1", 0)));
    }

    public void setShowControlLine(boolean b) {
        this.showControlLine = b;
    }

    public void setShowControlPoints(boolean b) {
        this.showControlPoints = b;
    }

    public boolean getShowControlLine() {
        return this.showControlLine;
    }

    public boolean getShowControlPoints() {
        return this.showControlPoints;
    }

    public boolean getAntialiasCurves() {
        return this.antialiasCurves;
    }

    public void setAntialiasCurves(boolean b) {
        this.antialiasCurves = b;
    }

    public boolean getShowPointNumbers() {
        return this.showPointNumbers;
    }

    public void setShowPointNumbers(boolean b) {
        this.showPointNumbers = b;
    }

    public ControlPath getControlPath() {
        return this.cp;
    }

    public void setControlPath(ControlPath cp) {
        this.cp = cp;
    }

    public double getFlatness() {
        return this.multiPath.getFlatness();
    }

    public void setFlatness(double f) {
        this.multiPath.setFlatness(f);
    }

    public void setShowPointLocations(boolean b) {
        this.showPointLocations = b;
    }

    public boolean getShowPointLocations() {
        return this.showPointLocations;
    }

    public void setShowCurves(boolean b) {
        this.showCurves = b;
    }

    public boolean getShowCurves() {
        return this.showCurves;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        double x = evt.getX();
        double y = evt.getY();
        if (evt.getClickCount() == 2) {
            int numPoints = this.cp.numPoints();
            if (this.closestPointIndex >= 0) {
                this.cp.removePoint(this.closestPointIndex);
                this.closestPointIndex = -1;
                this.closestPointIndex1 = -1;
                this.closestPointIndex2 = -1;
            } else {
                Point p = this.pointFactory.createPoint(x, y);
                if (this.cp.numPoints() == 0) {
                    this.closestPointIndex = this.cp.numPoints();
                    this.cp.addPoint(p);
                } else if (this.closestPointIndex2 < 0) {
                    if (this.closestPointIndex1 == 0) {
                        this.cp.insertPoint(p, 0);
                        this.closestPointIndex = 0;
                    } else if (this.closestPointIndex1 > 0) {
                        this.closestPointIndex = this.cp.numPoints();
                        this.cp.addPoint(p);
                    }
                } else {
                    this.cp.insertPoint(p, this.closestPointIndex1);
                    this.closestPointIndex = this.closestPointIndex1;
                }
            }
            if (this.cp.numPoints() != numPoints) {
                int i = 0;
                while (i < this.cp.numCurves()) {
                    Curve c = this.cp.getCurve(i);
                    GroupIterator gi = c.getGroupIterator();
                    c.setGroupIterator(new GroupIterator(gi.getControlString(), this.cp.numPoints()));
                    ++i;
                }
            }
        }
        if (this.closestPointIndex >= 0) {
            double[] loc = this.cp.getPoint(this.closestPointIndex).getLocation();
            this.deltaX = loc[0] - x;
            this.deltaY = loc[1] - y;
            this.grabbing = true;
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.grabbing = false;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.closestPointIndex1 = -1;
        this.closestPointIndex2 = -1;
        if (this.grabbing) {
            double x = evt.getX();
            double y = evt.getY();
            double[] loc = this.cp.getPoint(this.closestPointIndex).getLocation();
            loc[0] = x + this.deltaX;
            loc[1] = y + this.deltaY;
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.mouseX = evt.getX();
        this.mouseY = evt.getY();
        this.findClosestLineSegment(this.mouseX, this.mouseY);
        this.findClosestPoint(this.mouseX, this.mouseY);
        this.repaint();
    }

    private void findClosestPoint(double x, double y) {
        double dist = Double.MAX_VALUE;
        int i = 0;
        while (i < this.cp.numPoints()) {
            double dy;
            double[] loc = this.cp.getPoint(i).getLocation();
            double dx = x - loc[0];
            double d = dx * dx + (dy = y - loc[1]) * dy;
            if (d < dist) {
                dist = d;
                this.closestPointIndex = i;
            }
            ++i;
        }
        if (Math.sqrt(dist) > (double)(this.controlPointSize / 2 + this.grabDistanceThreshold)) {
            this.closestPointIndex = -1;
        }
    }

    private void findClosestLineSegment(double x, double y) {
        double b;
        double[] loc2;
        double[] loc1;
        if (this.cp.numPoints() == 0) {
            this.closestPointIndex1 = -1;
            this.closestPointIndex2 = -1;
            return;
        }
        if (this.cp.numPoints() == 1) {
            this.closestPointIndex1 = 0;
            this.closestPointIndex2 = -1;
            return;
        }
        int index = 0;
        double dist = Double.MAX_VALUE;
        double angle = Math.PI;
        int i = 1;
        while (i < this.cp.numPoints()) {
            double[] loc22;
            Point p1 = this.cp.getPoint(i - 1);
            Point p2 = this.cp.getPoint(i);
            double[] loc12 = p1.getLocation();
            double d = Geom.ptSegDistSq(loc12[0], loc12[1], (loc22 = p2.getLocation())[0], loc22[1], x, y, null);
            if (d < dist) {
                dist = d;
                index = i;
            } else if (d == dist && index + 1 == i) {
                double c;
                double dac;
                double b2;
                double[] loc3 = this.cp.getPoint(i - 2).getLocation();
                double ox = loc12[0];
                double oy = loc12[1];
                double a = Geom.getAngle(ox, oy, x, y);
                double dab = a - (b2 = Geom.getAngle(ox, oy, loc3[0], loc3[1]));
                if (dab < 0.0) {
                    dab = -dab;
                }
                if (dab > Math.PI) {
                    dab = Math.PI * 2 - dab;
                }
                if ((dac = a - (c = Geom.getAngle(ox, oy, loc22[0], loc22[1]))) < 0.0) {
                    dac = -dac;
                }
                if (dac > Math.PI) {
                    dac = Math.PI * 2 - dac;
                }
                if (dac < dab) {
                    index = i;
                }
            }
            ++i;
        }
        boolean done = false;
        if (index == 1) {
            loc1 = this.cp.getPoint(0).getLocation();
            loc2 = this.cp.getPoint(1).getLocation();
            double a = Geom.getAngle(loc1[0], loc1[1], x, y);
            double dab = a - (b = Geom.getAngle(loc1[0], loc1[1], loc2[0], loc2[1]));
            if (dab < 0.0) {
                dab = -dab;
            }
            if (dab > Math.PI) {
                dab = Math.PI * 2 - dab;
            }
            if (dab > 1.5707963267948966) {
                this.closestPointIndex1 = 0;
                this.closestPointIndex2 = -1;
                done = true;
            }
        }
        if (index == this.cp.numPoints() - 1) {
            loc1 = this.cp.getPoint(index).getLocation();
            loc2 = this.cp.getPoint(index - 1).getLocation();
            double a = Geom.getAngle(loc1[0], loc1[1], x, y);
            double dab = a - (b = Geom.getAngle(loc1[0], loc1[1], loc2[0], loc2[1]));
            if (dab < 0.0) {
                dab = -dab;
            }
            if (dab > Math.PI) {
                dab = Math.PI * 2 - dab;
            }
            if (dab > 1.5707963267948966) {
                this.closestPointIndex1 = index;
                this.closestPointIndex2 = -1;
                done = true;
            }
        }
        if (!done) {
            this.closestPointIndex1 = index;
            this.closestPointIndex2 = index - 1;
        }
    }

    @Override
    public void paint(Graphics _g) {
        super.paint(_g);
        if (this.cp.numPoints() == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)_g;
        if (this.showCurves) {
            this.multiPath.setNumPoints(0);
            int i = 0;
            while (i < this.cp.numCurves()) {
                this.cp.getCurve(i).appendTo(this.multiPath);
                ++i;
            }
            if (this.antialiasCurves) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.draw(this.multiPath);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.showControlLine) {
            Line2D.Double line = new Line2D.Double();
            g.setColor(this.controlLineColor);
            Point lastPoint = this.cp.getPoint(0);
            int i = 1;
            while (i < this.cp.numPoints()) {
                Point p = this.cp.getPoint(i);
                double[] loc = p.getLocation();
                double[] old = lastPoint.getLocation();
                line.setLine(old[0], old[1], loc[0], loc[1]);
                g.draw(line);
                lastPoint = p;
                ++i;
            }
            g.setColor(this.insertPointColor);
            if (this.closestPointIndex1 >= 0) {
                double[] loc = this.cp.getPoint(this.closestPointIndex1).getLocation();
                line.setLine(this.mouseX, this.mouseY, loc[0], loc[1]);
                g.draw(line);
            }
            if (this.closestPointIndex2 >= 0) {
                double[] loc = this.cp.getPoint(this.closestPointIndex2).getLocation();
                line.setLine(this.mouseX, this.mouseY, loc[0], loc[1]);
                g.draw(line);
            }
        }
        if (this.showControlPoints) {
            Rectangle2D.Double rect = new Rectangle2D.Double();
            g.setColor(this.controlPointColor);
            int i = 0;
            while (i < this.cp.numPoints()) {
                Point p = this.cp.getPoint(i);
                double[] loc = p.getLocation();
                rect.setRect(loc[0] - (double)(this.controlPointSize / 2), loc[1] - (double)(this.controlPointSize / 2), this.controlPointSize, this.controlPointSize);
                g.fill(rect);
                ++i;
            }
            if (this.closestPointIndex >= 0) {
                g.setColor(this.closestPointColor);
                double[] loc = this.cp.getPoint(this.closestPointIndex).getLocation();
                rect.setRect(loc[0] - (double)(this.controlPointSize / 2), loc[1] - (double)(this.controlPointSize / 2), this.controlPointSize, this.controlPointSize);
                g.fill(rect);
            }
            if (this.showPointNumbers || this.showPointLocations) {
                g.setColor(this.pointNumberColor);
                i = 0;
                while (i < this.cp.numPoints()) {
                    double[] loc = this.cp.getPoint(i).getLocation();
                    String s = "";
                    if (this.showPointNumbers) {
                        s = String.valueOf(String.valueOf(i)) + " ";
                    }
                    if (this.showPointLocations) {
                        s = String.valueOf(s) + "(" + (int)loc[0] + ", " + (int)loc[1] + ")";
                    }
                    g.drawString(s, (int)loc[0], (int)loc[1] - this.controlPointSize);
                    ++i;
                }
            }
        }
    }
}

