/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.QRDecompositionImpl;
import org.apache.commons.math.linear.RealMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathFunctions {
    private static void insertPoint2DInMatrix(RealMatrix realMatrix, Point2D.Double double_, int n) {
        realMatrix.setEntry(n, 0, double_.x);
        realMatrix.setEntry(n, 1, double_.y);
        realMatrix.setEntry(n, 2, 1.0);
    }

    public static AffineTransform generateAffineTransformFromPointPairs(Map<Point2D.Double, Point2D.Double> map) {
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(map.size(), 3);
        Array2DRowRealMatrix array2DRowRealMatrix2 = new Array2DRowRealMatrix(map.size(), 3);
        int n = 0;
        for (Map.Entry<Point2D.Double, Point2D.Double> object2 : map.entrySet()) {
            Point2D.Double double_ = object2.getKey();
            Point2D.Double double_2 = object2.getValue();
            MathFunctions.insertPoint2DInMatrix((RealMatrix)array2DRowRealMatrix, double_, n);
            MathFunctions.insertPoint2DInMatrix((RealMatrix)array2DRowRealMatrix2, double_2, n);
            ++n;
        }
        DecompositionSolver decompositionSolver = new QRDecompositionImpl((RealMatrix)array2DRowRealMatrix).getSolver();
        double[][] dArray = decompositionSolver.solve((RealMatrix)array2DRowRealMatrix2).transpose().getData();
        return new AffineTransform(dArray[0][0], dArray[1][0], dArray[0][1], dArray[1][1], dArray[0][2], dArray[1][2]);
    }

    public static AffineTransform generateAffineTransformFromPointPairs(Map<Point2D.Double, Point2D.Double> map, double d, double d2) throws Exception {
        AffineTransform affineTransform = MathFunctions.generateAffineTransformFromPointPairs(map);
        double d3 = 0.0;
        double d4 = 0.0;
        for (Map.Entry<Point2D.Double, Point2D.Double> entry : map.entrySet()) {
            try {
                Point2D.Double double_ = entry.getKey();
                Point2D.Double double_2 = entry.getValue();
                Point2D.Double double_3 = (Point2D.Double)affineTransform.inverseTransform(double_2, null);
                Point2D.Double double_4 = (Point2D.Double)affineTransform.transform(double_, null);
                d3 += double_.distanceSq(double_3);
                d4 += double_2.distanceSq(double_4);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Exception();
            }
        }
        int n = map.size();
        double d5 = Math.sqrt(d3 / (double)n);
        double d6 = Math.sqrt(d4 / (double)n);
        if (d5 > d || d6 > d2) {
            throw new Exception("Point mapping scatter exceeds tolerance.");
        }
        return affineTransform;
    }

    public static double getScalingFactor(AffineTransform affineTransform) {
        return Math.sqrt(Math.abs(affineTransform.getDeterminant()));
    }

    public static double clip(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), d3);
    }

    public static int clip(int n, int n2, int n3) {
        return Math.min(Math.max(n, n2), n3);
    }

    public static void runAffineTest() {
        HashMap<Point2D.Double, Point2D.Double> hashMap = new HashMap<Point2D.Double, Point2D.Double>();
        hashMap.put(new Point2D.Double(1.0, 1.0), new Point2D.Double(18.0, 2.0));
        hashMap.put(new Point2D.Double(1.0, 9.0), new Point2D.Double(2.0, 2.0));
        hashMap.put(new Point2D.Double(9.0, 9.0), new Point2D.Double(2.0, 18.0));
        hashMap.put(new Point2D.Double(9.0, 1.0), new Point2D.Double(18.0, 18.0));
        AffineTransform affineTransform = MathFunctions.generateAffineTransformFromPointPairs(hashMap);
        System.out.println(hashMap);
        System.out.println(affineTransform);
        int n = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            Point2D.Double double_ = (Point2D.Double)entry.getKey();
            Point2D.Double double_2 = (Point2D.Double)entry.getValue();
            Point2D.Double double_3 = new Point2D.Double();
            affineTransform.transform(double_, double_3);
            System.out.println(double_ + "->" + double_3 + " residual: " + double_2.distance(double_3));
            ++n;
        }
    }
}

