/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MMUUEncoder {
    protected int maxBytesPerLine = 45;

    public void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        outputStream.write("begin 664 raw.bin\n".getBytes());
        byte[] byArray = new byte[this.maxBytesPerLine * 4 / 3];
        int n = 0;
        while (true) {
            int n2;
            if (n == this.maxBytesPerLine * 4 / 3) {
                MMUUEncoder.writeWithLength(outputStream, byArray, n);
                n = 0;
            }
            if ((n2 = inputStream.read()) < 0) break;
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
            byArray[n++] = MMUUEncoder.encode(n5 >> 18 & 0x3F);
            byArray[n++] = MMUUEncoder.encode(n5 >> 12 & 0x3F);
            if (n3 < 0) break;
            byArray[n++] = MMUUEncoder.encode(n5 >> 6 & 0x3F);
            if (n4 < 0) break;
            byArray[n++] = MMUUEncoder.encode(n5 & 0x3F);
        }
        if (n > 0) {
            MMUUEncoder.writeWithLength(outputStream, byArray, n);
        }
        outputStream.write("`\nend\n".getBytes());
    }

    public static void writeWithLength(OutputStream outputStream, byte[] byArray, int n) throws IOException {
        outputStream.write(MMUUEncoder.encode(n * 3 / 4));
        outputStream.write(byArray, 0, n);
        outputStream.write(10);
    }

    public static byte encode(int n) {
        return (byte)(n == 0 ? 96 : 32 + n);
    }
}

