/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.PropertySetting;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class MDUtils {
    private static final SimpleDateFormat iso8601modified_ = new SimpleDateFormat("yyyy-MM-dd E HH:mm:ss Z");

    public static JSONObject copy(JSONObject jSONObject) {
        try {
            return new JSONObject(jSONObject.toString());
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static int getPositionIndex(JSONObject jSONObject) throws JSONException {
        return jSONObject.getInt("PositionIndex");
    }

    public static void setPositionIndex(JSONObject jSONObject, int n) throws JSONException {
        jSONObject.put("PositionIndex", n);
    }

    public static int getBitDepth(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("Summary")) {
            return jSONObject.getJSONObject("Summary").getInt("BitDepth");
        }
        return jSONObject.getInt("BitDepth");
    }

    public static int getWidth(JSONObject jSONObject) throws JSONException {
        return jSONObject.getInt("Width");
    }

    public static void setWidth(JSONObject jSONObject, int n) throws JSONException {
        jSONObject.put("Width", n);
    }

    public static int getHeight(JSONObject jSONObject) throws JSONException {
        return jSONObject.getInt("Height");
    }

    public static void setHeight(JSONObject jSONObject, int n) throws JSONException {
        jSONObject.put("Height", n);
    }

    public static int getBinning(JSONObject jSONObject) throws JSONException {
        return jSONObject.getInt("Binning");
    }

    public static void setBinning(JSONObject jSONObject, int n) throws JSONException {
        jSONObject.put("Binning", n);
    }

    public static int getSliceIndex(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("SliceIndex")) {
            return jSONObject.getInt("SliceIndex");
        }
        return jSONObject.getInt("Slice");
    }

    public static void setSliceIndex(JSONObject jSONObject, int n) throws JSONException {
        jSONObject.put("SliceIndex", n);
        jSONObject.put("Slice", n);
    }

    public static int getChannelIndex(JSONObject jSONObject) throws JSONException {
        return jSONObject.getInt("ChannelIndex");
    }

    public static void setChannelIndex(JSONObject jSONObject, int n) throws JSONException {
        jSONObject.put("ChannelIndex", n);
    }

    public static int getFrameIndex(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("Frame")) {
            return jSONObject.getInt("Frame");
        }
        return jSONObject.getInt("FrameIndex");
    }

    public static void setFrameIndex(JSONObject jSONObject, int n) throws JSONException {
        jSONObject.put("Frame", n);
        jSONObject.put("FrameIndex", n);
    }

    public static int getNumPositions(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("Positions")) {
            return jSONObject.getInt("Positions");
        }
        throw new JSONException("Positions tag not found in summary metadata");
    }

    public static String getPositionName(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("PositionName") && !jSONObject.isNull("PositionName")) {
            return jSONObject.getString("PositionName");
        }
        if (jSONObject.has("PositionIndex")) {
            return "Pos" + jSONObject.getString("PositionIndex");
        }
        return null;
    }

    public static void setPositionName(JSONObject jSONObject, String string) throws JSONException {
        jSONObject.put("PositionName", string);
    }

    public static String getChannelName(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("Channel") && !jSONObject.isNull("Channel")) {
            return jSONObject.getString("Channel");
        }
        return "";
    }

    public static int getChannelColor(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("ChColor") && !jSONObject.isNull("ChColor")) {
            return jSONObject.getInt("ChColor");
        }
        return -1;
    }

    public static String getFileName(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("FileName")) {
            return jSONObject.getString("FileName");
        }
        return null;
    }

    public static void setFileName(JSONObject jSONObject, String string) throws JSONException {
        jSONObject.put("FileName", string);
    }

    public static int getIJType(JSONObject jSONObject) throws JSONException, MMScriptException {
        try {
            return jSONObject.getInt("IJType");
        }
        catch (JSONException jSONException) {
            try {
                String string = jSONObject.getString("PixelType");
                if (string.contentEquals("GRAY8")) {
                    return 0;
                }
                if (string.contentEquals("GRAY16")) {
                    return 1;
                }
                if (string.contentEquals("GRAY32")) {
                    return 2;
                }
                if (string.contentEquals("RGB32")) {
                    return 4;
                }
                throw new MMScriptException("Can't figure out IJ type.");
            }
            catch (MMScriptException mMScriptException) {
                throw new MMScriptException("Can't figure out IJ type");
            }
        }
    }

    public static String getPixelType(JSONObject jSONObject) throws JSONException, MMScriptException {
        try {
            if (jSONObject != null) {
                return jSONObject.getString("PixelType");
            }
        }
        catch (JSONException jSONException) {
            try {
                int n = jSONObject.getInt("IJType");
                if (n == 0) {
                    return "GRAY8";
                }
                if (n == 1) {
                    return "GRAY16";
                }
                if (n == 2) {
                    return "GRAY32";
                }
                if (n == 4) {
                    return "RGB32";
                }
                throw new MMScriptException("Can't figure out pixel type");
            }
            catch (MMScriptException mMScriptException) {
                throw new MMScriptException("Can't figure out pixel type");
            }
        }
        return "";
    }

    public static void addRandomUUID(JSONObject jSONObject) throws JSONException {
        UUID uUID = UUID.randomUUID();
        jSONObject.put("UUID", uUID.toString());
    }

    public static UUID getUUID(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("UUID")) {
            return UUID.fromString(jSONObject.getString("UUID"));
        }
        return null;
    }

    public static void setPixelType(JSONObject jSONObject, int n) throws JSONException {
        switch (n) {
            case 0: {
                jSONObject.put("PixelType", "GRAY8");
                break;
            }
            case 1: {
                jSONObject.put("PixelType", "GRAY16");
                break;
            }
            case 4: {
                jSONObject.put("PixelType", "RGB32");
                break;
            }
            case 64: {
                jSONObject.put("PixelType", "RGB64");
            }
        }
    }

    public static void setPixelTypeFromByteDepth(JSONObject jSONObject, int n) throws JSONException {
        switch (n) {
            case 1: {
                jSONObject.put("PixelType", "GRAY8");
                break;
            }
            case 2: {
                jSONObject.put("PixelType", "GRAY16");
                break;
            }
            case 4: {
                jSONObject.put("PixelType", "RGB32");
                break;
            }
            case 8: {
                jSONObject.put("PixelType", "RGB64");
            }
        }
    }

    public static int getSingleChannelType(JSONObject jSONObject) throws JSONException, MMScriptException {
        String string = MDUtils.getPixelType(jSONObject);
        if (string.contentEquals("GRAY8")) {
            return 0;
        }
        if (string.contentEquals("GRAY16")) {
            return 1;
        }
        if (string.contentEquals("GRAY32")) {
            return 2;
        }
        if (string.contentEquals("RGB32")) {
            return 0;
        }
        if (string.contentEquals("RGB64")) {
            return 1;
        }
        throw new MMScriptException("Can't figure out channel type.");
    }

    public static int getNumberOfComponents(JSONObject jSONObject) throws MMScriptException, JSONException {
        String string = MDUtils.getPixelType(jSONObject);
        if (string.contentEquals("GRAY8")) {
            return 1;
        }
        if (string.contentEquals("GRAY16")) {
            return 1;
        }
        if (string.contentEquals("GRAY32")) {
            return 1;
        }
        if (string.contentEquals("RGB32")) {
            return 3;
        }
        if (string.contentEquals("RGB64")) {
            return 3;
        }
        throw new MMScriptException("Pixel type \"" + string + "\"not recognized!");
    }

    public static boolean isGRAY8(JSONObject jSONObject) throws JSONException, MMScriptException {
        return MDUtils.getPixelType(jSONObject).contentEquals("GRAY8");
    }

    public static boolean isGRAY16(JSONObject jSONObject) throws JSONException, MMScriptException {
        return MDUtils.getPixelType(jSONObject).contentEquals("GRAY16");
    }

    public static boolean isGRAY32(JSONObject jSONObject) throws JSONException, MMScriptException {
        return MDUtils.getPixelType(jSONObject).contentEquals("GRAY32");
    }

    public static boolean isRGB32(JSONObject jSONObject) throws JSONException, MMScriptException {
        return MDUtils.getPixelType(jSONObject).contentEquals("RGB32");
    }

    public static boolean isRGB64(JSONObject jSONObject) throws JSONException, MMScriptException {
        return MDUtils.getPixelType(jSONObject).contentEquals("RGB64");
    }

    public static boolean isGRAY8(TaggedImage taggedImage) throws JSONException, MMScriptException {
        return MDUtils.isGRAY8(taggedImage.tags);
    }

    public static boolean isGRAY16(TaggedImage taggedImage) throws JSONException, MMScriptException {
        return MDUtils.isGRAY16(taggedImage.tags);
    }

    public static boolean isRGB32(TaggedImage taggedImage) throws JSONException, MMScriptException {
        return MDUtils.isRGB32(taggedImage.tags);
    }

    public static boolean isRGB64(TaggedImage taggedImage) throws JSONException, MMScriptException {
        return MDUtils.isRGB64(taggedImage.tags);
    }

    public static boolean isGRAY(JSONObject jSONObject) throws JSONException, MMScriptException {
        return MDUtils.isGRAY8(jSONObject) || MDUtils.isGRAY16(jSONObject) || MDUtils.isGRAY32(jSONObject);
    }

    public static boolean isRGB(JSONObject jSONObject) throws JSONException, MMScriptException {
        return MDUtils.isRGB32(jSONObject) || MDUtils.isRGB64(jSONObject);
    }

    public static boolean isGRAY(TaggedImage taggedImage) throws JSONException, MMScriptException {
        return MDUtils.isGRAY(taggedImage.tags);
    }

    public static boolean isRGB(TaggedImage taggedImage) throws JSONException, MMScriptException {
        return MDUtils.isRGB(taggedImage.tags);
    }

    public static void addConfiguration(JSONObject jSONObject, Configuration configuration) {
        int n = 0;
        while ((long)n < configuration.size()) {
            try {
                PropertySetting propertySetting = configuration.getSetting(n);
                String string = propertySetting.getDeviceLabel() + "-" + propertySetting.getPropertyName();
                String string2 = propertySetting.getPropertyValue();
                jSONObject.put(string, string2);
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
            ++n;
        }
    }

    public static String getLabel(JSONObject jSONObject) {
        try {
            return MDUtils.generateLabel(MDUtils.getChannelIndex(jSONObject), MDUtils.getSliceIndex(jSONObject), MDUtils.getFrameIndex(jSONObject), MDUtils.getPositionIndex(jSONObject));
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
            return null;
        }
    }

    public static String generateLabel(int n, int n2, int n3, int n4) {
        return NumberUtils.intToCoreString(n) + "_" + NumberUtils.intToCoreString(n2) + "_" + NumberUtils.intToCoreString(n3) + "_" + NumberUtils.intToCoreString(n4);
    }

    public static int[] getIndices(String string) {
        try {
            int[] nArray = new int[4];
            String[] stringArray = string.split("_");
            int n = 0;
            for (String string2 : stringArray) {
                nArray[n] = NumberUtils.coreStringToInt(string2);
                ++n;
            }
            return nArray;
        }
        catch (ParseException parseException) {
            ReportingUtils.logError(parseException);
            return null;
        }
    }

    public static String[] getKeys(JSONObject jSONObject) {
        int n = jSONObject.length();
        String[] stringArray = new String[n];
        Iterator<String> iterator = jSONObject.keys();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = iterator.next();
        }
        return stringArray;
    }

    public static JSONArray getJSONArrayMember(JSONObject jSONObject, String string) throws JSONException {
        JSONArray jSONArray;
        try {
            jSONArray = jSONObject.getJSONArray(string);
        }
        catch (JSONException jSONException) {
            jSONArray = new JSONArray(jSONObject.getString(string));
        }
        return jSONArray;
    }

    public static String getTime(Date date) {
        return iso8601modified_.format(date);
    }

    public static String getCurrentTime() {
        return MDUtils.getTime(new Date());
    }

    public static String getROI(CMMCore cMMCore) {
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        try {
            cMMCore.getROI(nArray, nArray2, nArray3, nArray4);
            string = string + nArray[0] + "-" + nArray2[0] + "-" + nArray3[0] + "-" + nArray4[0];
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception, "Error in MDUtils::getROI");
        }
        return string;
    }

    public static int getDepth(JSONObject jSONObject) throws MMScriptException, JSONException {
        String string = MDUtils.getPixelType(jSONObject);
        if (string.contains("GRAY8")) {
            return 1;
        }
        if (string.contains("GRAY16")) {
            return 2;
        }
        if (string.contains("RGB32")) {
            return 4;
        }
        if (string.contains("RGB64")) {
            return 8;
        }
        return 0;
    }

    public static int getNumFrames(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2;
        if (jSONObject.has("Summary") && (jSONObject2 = jSONObject.getJSONObject("Summary")).has("Frames")) {
            return Math.max(1, jSONObject2.getInt("Frames"));
        }
        if (jSONObject.has("Frames")) {
            return Math.max(1, jSONObject.getInt("Frames"));
        }
        return 1;
    }

    public static int getNumSlices(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2;
        if (jSONObject.has("Summary") && (jSONObject2 = jSONObject.getJSONObject("Summary")).has("Slices")) {
            return Math.max(1, jSONObject2.getInt("Slices"));
        }
        if (jSONObject.has("Slices")) {
            return Math.max(1, jSONObject.getInt("Slices"));
        }
        return 1;
    }

    public static int getNumChannels(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2;
        if (jSONObject.has("Summary") && (jSONObject2 = jSONObject.getJSONObject("Summary")).has("Channels")) {
            return Math.max(1, jSONObject2.getInt("Channels"));
        }
        if (jSONObject.has("Channels")) {
            return Math.max(1, jSONObject.getInt("Channels"));
        }
        return 1;
    }
}

