/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class ColorRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = -2539377758420096159L;
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;

    public ColorRenderer(boolean bl) {
        this.isBordered = bl;
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color = (Color)object;
        if (jTable.isEnabled()) {
            this.setBackground(color);
        } else {
            Color color2 = this.mixColors(color, jTable.getBackground(), 0.5);
            this.setBackground(color2);
        }
        if (this.isBordered) {
            if (bl) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        this.setToolTipText("RGB value: " + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
        return this;
    }

    private Color mixColors(Color color, Color color2, double d) {
        return new Color((int)((double)color.getRed() * d + (double)color2.getRed() * (1.0 - d)), (int)((double)color.getGreen() * d + (double)color2.getGreen() * (1.0 - d)), (int)((double)color.getBlue() * d + (double)color2.getBlue() * (1.0 - d)));
    }
}

