/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import com.swtdesigner.SwingResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.BevelBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.micromanager.utils.AutofocusManager;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.MMException;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.SliderPanel;

public class AutofocusPropertyEditor
extends MMDialog {
    private SpringLayout springLayout;
    private static final long serialVersionUID = 1507097881635431043L;
    private JTable table_;
    private PropertyTableData data_;
    private PropertyCellEditor cellEditor_;
    private JCheckBox showReadonlyCheckBox_;
    private static final String PREF_SHOW_READONLY = "show_readonly";
    private JScrollPane scrollPane_;
    private AutofocusManager afMgr_;
    private JButton btnClose;
    private JComboBox methodCombo_;

    public AutofocusPropertyEditor(AutofocusManager autofocusManager) {
        Serializable serializable;
        this.afMgr_ = autofocusManager;
        this.setModal(false);
        this.data_ = new PropertyTableData();
        this.table_ = new JTable();
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setModel(this.data_);
        this.cellEditor_ = new PropertyCellEditor();
        PropertyCellRenderer propertyCellRenderer = new PropertyCellRenderer();
        for (int i = 0; i < this.data_.getColumnCount(); ++i) {
            serializable = new TableColumn(i, 200, propertyCellRenderer, this.cellEditor_);
            this.table_.addColumn((TableColumn)serializable);
        }
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.setPrefsNode(preferences.node(preferences.absolutePath() + "/AutofocusPropertyEditor"));
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        this.setSize(551, 514);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AutofocusPropertyEditor.this.cleanup();
            }

            public void windowOpened(WindowEvent windowEvent) {
                Preferences preferences = AutofocusPropertyEditor.this.getPrefsNode();
                AutofocusPropertyEditor.this.showReadonlyCheckBox_.setSelected(preferences.getBoolean(AutofocusPropertyEditor.PREF_SHOW_READONLY, true));
                AutofocusPropertyEditor.this.data_.updateStatus();
                AutofocusPropertyEditor.this.data_.fireTableStructureChanged();
            }
        });
        this.setTitle("Autofocus properties");
        this.loadPosition(100, 100, 400, 300);
        this.scrollPane_ = new JScrollPane();
        this.scrollPane_.setFont(new Font("Arial", 0, 10));
        this.scrollPane_.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.scrollPane_);
        this.springLayout.putConstraint("South", (Component)this.scrollPane_, -5, "South", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.scrollPane_, 70, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.scrollPane_, -5, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.scrollPane_, 5, "West", (Component)this.getContentPane());
        this.scrollPane_.setViewportView(this.table_);
        this.table_ = new JTable();
        this.table_.setAutoCreateColumnsFromModel(false);
        serializable = new JButton();
        this.springLayout.putConstraint("North", (Component)serializable, 10, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)serializable, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)serializable, 33, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)serializable, 110, "West", (Component)this.getContentPane());
        ((AbstractButton)serializable).setIcon(SwingResourceManager.getIcon(AutofocusPropertyEditor.class, "/org/micromanager/icons/arrow_refresh.png"));
        ((JComponent)serializable).setFont(new Font("Arial", 0, 10));
        this.getContentPane().add((Component)serializable);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutofocusPropertyEditor.this.refresh();
            }
        });
        ((AbstractButton)serializable).setText("Refresh! ");
        this.showReadonlyCheckBox_ = new JCheckBox();
        this.springLayout.putConstraint("North", (Component)this.showReadonlyCheckBox_, 41, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showReadonlyCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showReadonlyCheckBox_, 64, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.showReadonlyCheckBox_, 183, "West", (Component)this.getContentPane());
        this.showReadonlyCheckBox_.setFont(new Font("Arial", 0, 10));
        this.showReadonlyCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutofocusPropertyEditor.this.data_.setShowReadOnly(AutofocusPropertyEditor.this.showReadonlyCheckBox_.isSelected());
                AutofocusPropertyEditor.this.data_.updateStatus();
                AutofocusPropertyEditor.this.data_.fireTableStructureChanged();
            }
        });
        this.showReadonlyCheckBox_.setText("Show read-only properties");
        this.getContentPane().add(this.showReadonlyCheckBox_);
        Preferences preferences2 = this.getPrefsNode();
        this.showReadonlyCheckBox_.setSelected(preferences2.getBoolean(PREF_SHOW_READONLY, true));
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutofocusPropertyEditor.this.cleanup();
                AutofocusPropertyEditor.this.dispose();
            }
        });
        this.springLayout.putConstraint("South", (Component)this.btnClose, 0, "South", (Component)serializable);
        this.springLayout.putConstraint("East", (Component)this.btnClose, -10, "East", (Component)this.getContentPane());
        this.getContentPane().add(this.btnClose);
        if (this.afMgr_ != null) {
            String[] stringArray;
            this.methodCombo_ = new JComboBox();
            for (String string : stringArray = this.afMgr_.getAfDevices()) {
                this.methodCombo_.addItem(string);
            }
            if (this.afMgr_.getDevice() != null) {
                this.methodCombo_.setSelectedItem(this.afMgr_.getDevice().getDeviceName());
            }
            this.methodCombo_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AutofocusPropertyEditor.this.changeAFMethod((String)AutofocusPropertyEditor.this.methodCombo_.getSelectedItem());
                }
            });
            this.springLayout.putConstraint("West", (Component)this.methodCombo_, 80, "East", (Component)serializable);
            this.springLayout.putConstraint("South", (Component)this.methodCombo_, 0, "South", (Component)serializable);
            this.springLayout.putConstraint("East", (Component)this.methodCombo_, -6, "West", (Component)this.btnClose);
            this.getContentPane().add(this.methodCombo_);
        }
        this.data_.setShowReadOnly(this.showReadonlyCheckBox_.isSelected());
    }

    protected void changeAFMethod(String string) {
        try {
            this.cellEditor_.stopEditing();
            this.afMgr_.selectDevice(string);
        }
        catch (MMException mMException) {
            this.handleException(mMException);
        }
        this.updateStatus();
    }

    protected void refresh() {
        this.data_.refresh();
    }

    public void rebuild() {
        String string = this.afMgr_.getDevice().getDeviceName();
        ActionListener actionListener = this.methodCombo_.getActionListeners()[0];
        try {
            if (actionListener != null) {
                this.methodCombo_.removeActionListener(actionListener);
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
        this.methodCombo_.removeAllItems();
        if (this.afMgr_ != null) {
            String[] stringArray;
            for (String string2 : stringArray = this.afMgr_.getAfDevices()) {
                this.methodCombo_.addItem(string2);
            }
            this.methodCombo_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AutofocusPropertyEditor.this.changeAFMethod((String)AutofocusPropertyEditor.this.methodCombo_.getSelectedItem());
                }
            });
            if (string != null) {
                this.methodCombo_.setSelectedItem(string);
            } else if (this.afMgr_.getDevice() != null) {
                this.methodCombo_.setSelectedItem(this.afMgr_.getDevice().getDeviceName());
            }
        }
    }

    public void updateStatus() {
        if (this.data_ != null) {
            this.data_.updateStatus();
        }
    }

    private void handleException(Exception exception) {
        ReportingUtils.showError(exception);
    }

    public void cleanup() {
        this.savePosition();
        Preferences preferences = this.getPrefsNode();
        preferences.putBoolean(PREF_SHOW_READONLY, this.showReadonlyCheckBox_.isSelected());
        if (this.afMgr_ != null && this.afMgr_.getDevice() != null) {
            this.afMgr_.getDevice().saveSettings();
        }
    }

    public class PropertyCellRenderer
    implements TableCellRenderer {
        PropertyItem item_;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent;
            PropertyTableData propertyTableData = (PropertyTableData)jTable.getModel();
            this.item_ = propertyTableData.getPropertyItem(n);
            if (bl) {
                // empty if block
            }
            if (bl2) {
                // empty if block
            }
            if (n2 == 0) {
                JLabel jLabel = new JLabel();
                jLabel.setText((String)object);
                jLabel.setOpaque(true);
                jLabel.setHorizontalAlignment(2);
                jComponent = jLabel;
            } else if (n2 == 1) {
                if (this.item_.hasRange) {
                    SliderPanel sliderPanel = new SliderPanel();
                    sliderPanel.setLimits(this.item_.lowerLimit, this.item_.upperLimit);
                    sliderPanel.setText((String)object);
                    sliderPanel.setToolTipText((String)object);
                    jComponent = sliderPanel;
                } else {
                    JLabel jLabel = new JLabel();
                    jLabel.setOpaque(true);
                    jLabel.setText(this.item_.value.toString());
                    jLabel.setHorizontalAlignment(2);
                    jComponent = jLabel;
                }
            } else {
                jComponent = new JLabel("Undefinded");
            }
            if (this.item_.readOnly) {
                ((Component)jComponent).setBackground(Color.LIGHT_GRAY);
            } else {
                ((Component)jComponent).setBackground(Color.white);
            }
            return jComponent;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    public class PropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JTextField text_ = new JTextField();
        JComboBox combo_ = new JComboBox();
        JCheckBox check_ = new JCheckBox();
        SliderPanel slider_ = new SliderPanel();
        int editingCol_;
        PropertyItem item_;

        public PropertyCellEditor() {
            this.check_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
            this.slider_.addEditActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
            this.slider_.addSliderMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
        }

        public void stopEditing() {
            this.fireEditingStopped();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                // empty if block
            }
            this.editingCol_ = n2;
            PropertyTableData propertyTableData = (PropertyTableData)jTable.getModel();
            this.item_ = propertyTableData.getPropertyItem(n);
            if (n2 == 1) {
                int n3;
                if (this.item_.allowed.length == 0) {
                    if (this.item_.hasRange) {
                        if (this.item_.isInteger()) {
                            this.slider_.setLimits((int)this.item_.lowerLimit, (int)this.item_.upperLimit);
                        } else {
                            this.slider_.setLimits(this.item_.lowerLimit, this.item_.upperLimit);
                        }
                        this.slider_.setText((String)object);
                        return this.slider_;
                    }
                    this.text_.setText((String)object);
                    return this.text_;
                }
                ActionListener[] actionListenerArray = this.combo_.getActionListeners();
                for (n3 = 0; n3 < actionListenerArray.length; ++n3) {
                    this.combo_.removeActionListener(actionListenerArray[n3]);
                }
                this.combo_.removeAllItems();
                for (n3 = 0; n3 < this.item_.allowed.length; ++n3) {
                    this.combo_.addItem(this.item_.allowed[n3]);
                }
                this.combo_.setSelectedItem(this.item_.value);
                this.combo_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PropertyCellEditor.this.fireEditingStopped();
                    }
                });
                return this.combo_;
            }
            if (n2 == 2) {
                return this.check_;
            }
            return null;
        }

        public Object getCellEditorValue() {
            if (this.editingCol_ == 1) {
                if (this.item_.allowed.length == 0) {
                    if (this.item_.hasRange) {
                        return this.slider_.getText();
                    }
                    return this.text_.getText();
                }
                return this.combo_.getSelectedItem();
            }
            if (this.editingCol_ == 2) {
                return this.check_;
            }
            return null;
        }
    }

    class PropertyTableData
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] columnNames_ = new String[]{"Property", "Value"};
        ArrayList<PropertyItem> propList_ = new ArrayList();
        private boolean showReadOnly_ = true;

        public PropertyTableData() {
            this.updateStatus();
        }

        public void setShowReadOnly(boolean bl) {
            this.showReadOnly_ = bl;
        }

        public int getRowCount() {
            return this.propList_.size();
        }

        public int getColumnCount() {
            return this.columnNames_.length;
        }

        public PropertyItem getPropertyItem(int n) {
            return this.propList_.get(n);
        }

        public Object getValueAt(int n, int n2) {
            PropertyItem propertyItem = this.propList_.get(n);
            if (n2 == 0) {
                return propertyItem.device + "-" + propertyItem.name;
            }
            if (n2 == 1) {
                return propertyItem.value;
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            PropertyItem propertyItem = this.propList_.get(n);
            if (n2 == 1 && AutofocusPropertyEditor.this.afMgr_.getDevice() != null) {
                try {
                    if (propertyItem.isInteger()) {
                        AutofocusPropertyEditor.this.afMgr_.getDevice().setPropertyValue(propertyItem.name, NumberUtils.intStringDisplayToCore(object));
                    } else if (propertyItem.isFloat()) {
                        AutofocusPropertyEditor.this.afMgr_.getDevice().setPropertyValue(propertyItem.name, NumberUtils.doubleStringDisplayToCore(object));
                    } else {
                        AutofocusPropertyEditor.this.afMgr_.getDevice().setPropertyValue(propertyItem.name, object.toString());
                    }
                    this.refresh();
                    this.fireTableCellUpdated(n, n2);
                }
                catch (Exception exception) {
                    AutofocusPropertyEditor.this.handleException(exception);
                }
            }
        }

        public String getColumnName(int n) {
            return this.columnNames_[n];
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                return !this.propList_.get((int)n).readOnly;
            }
            return false;
        }

        public void refresh() {
            if (AutofocusPropertyEditor.this.afMgr_.getDevice() == null) {
                return;
            }
            try {
                for (int i = 0; i < this.propList_.size(); ++i) {
                    PropertyItem propertyItem = this.propList_.get(i);
                    propertyItem.value = AutofocusPropertyEditor.this.afMgr_.getDevice().getPropertyValue(propertyItem.name);
                }
                this.fireTableDataChanged();
            }
            catch (Exception exception) {
                AutofocusPropertyEditor.this.handleException(exception);
            }
        }

        public void updateStatus() {
            this.propList_.clear();
            PropertyItem[] propertyItemArray = new PropertyItem[]{};
            if (AutofocusPropertyEditor.this.afMgr_.getDevice() != null) {
                propertyItemArray = AutofocusPropertyEditor.this.afMgr_.getDevice().getProperties();
            }
            for (int i = 0; i < propertyItemArray.length; ++i) {
                if (propertyItemArray[i].preInit || (!this.showReadOnly_ || !propertyItemArray[i].readOnly) && propertyItemArray[i].readOnly) continue;
                this.propList_.add(propertyItemArray[i]);
            }
            this.fireTableStructureChanged();
        }

        public boolean isShowReadOnly() {
            return this.showReadOnly_;
        }
    }
}

