/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.script;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ScriptingEngine;
import org.micromanager.utils.ScriptingGUI;

public class BeanshellEngine
implements ScriptingEngine {
    Interpreter interp_;
    boolean running_ = false;
    boolean error_ = false;
    EvalThread evalThd_ = new EvalThread("");
    boolean stop_ = false;
    private ScriptingGUI gui_;
    private Interpreter interp_old_;

    public void setInterpreter(Interpreter interpreter) {
        this.interp_old_ = this.interp_;
        this.interp_ = interpreter;
    }

    public void resetInterpreter() {
        this.interp_ = this.interp_old_;
    }

    public BeanshellEngine(ScriptingGUI scriptingGUI) {
        this.gui_ = scriptingGUI;
    }

    public void evaluate(String string) throws MMScriptException {
        try {
            this.interp_.eval(string);
        }
        catch (EvalError evalError) {
            throw new MMScriptException(this.formatBeanshellError(evalError, evalError.getErrorLineNumber()));
        }
    }

    public void evaluateAsync(String string) throws MMScriptException {
        if (this.evalThd_.isAlive()) {
            throw new MMScriptException("Another script execution in progress!");
        }
        this.evalThd_ = new EvalThread(string);
        this.evalThd_.start();
    }

    public void insertGlobalObject(String string, Object object) throws MMScriptException {
        try {
            this.interp_.set(string, object);
        }
        catch (EvalError evalError) {
            throw new MMScriptException(evalError);
        }
    }

    public void stopRequest() {
        if (this.evalThd_.isAlive()) {
            this.evalThd_.stop();
        }
        this.stop_ = true;
    }

    public boolean stopRequestPending() {
        if (this.evalThd_.isAlive() && this.stop_) {
            return this.stop_;
        }
        this.stop_ = false;
        return this.stop_;
    }

    private String formatBeanshellError(EvalError evalError, int n) {
        if (evalError instanceof TargetError) {
            Throwable throwable = ((TargetError)((Object)evalError)).getTarget();
            return new String("Line " + n + ": run-time error : " + (throwable != null ? throwable.getMessage() : evalError.getErrorText()));
        }
        if (evalError instanceof ParseException) {
            return new String("Line " + n + ": syntax error : " + evalError.getErrorText());
        }
        Throwable throwable = evalError.getCause();
        return new String("Line " + n + ": general error : " + (throwable != null ? throwable.getMessage() : evalError.getErrorText()));
    }

    public void sleep(long l) throws MMScriptException {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            throw new MMScriptException("Execution interrupted by the user");
        }
    }

    public class EvalThread
    extends Thread {
        String script_;
        String errorText_;

        public EvalThread(String string) {
            this.script_ = string;
            this.errorText_ = new String();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: {
                BeanshellEngine.this.stop_ = false;
                BeanshellEngine.this.running_ = true;
                this.errorText_ = new String();
                try {
                    try {
                        BeanshellEngine.this.interp_.eval(this.script_);
                    }
                    catch (TargetError targetError) {
                        int n = targetError.getErrorLineNumber();
                        BeanshellEngine.this.gui_.displayError(BeanshellEngine.this.formatBeanshellError((EvalError)((Object)targetError), n), n);
                        Object var5_2 = null;
                        BeanshellEngine.this.running_ = false;
                        break block6;
                    }
                    catch (ParseException parseException) {
                        String string = parseException.getMessage();
                        String string2 = string.substring(20, string.indexOf(44));
                        BeanshellEngine.this.gui_.displayError("Parse error: " + string, Integer.parseInt(string2));
                        Object var5_3 = null;
                        BeanshellEngine.this.running_ = false;
                        break block6;
                    }
                    catch (EvalError evalError) {
                        int n = evalError.getErrorLineNumber();
                        BeanshellEngine.this.gui_.displayError(BeanshellEngine.this.formatBeanshellError(evalError, n), n);
                        Object var5_4 = null;
                        BeanshellEngine.this.running_ = false;
                    }
                    Object var5_1 = null;
                    BeanshellEngine.this.running_ = false;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    BeanshellEngine.this.running_ = false;
                    throw throwable;
                }
            }
        }

        public String getError() {
            return this.errorText_;
        }
    }
}

