/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.navigation;

import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import mmcorej.CMMCore;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.utils.ReportingUtils;

public class ZWheelListener
implements MouseWheelListener {
    private CMMCore core_;
    private MMStudioMainFrame gui_;
    private ImageCanvas canvas_;
    private static boolean isRunning_ = false;
    private static final double moveIncrement_ = 0.2;

    public ZWheelListener(CMMCore cMMCore, MMStudioMainFrame mMStudioMainFrame) {
        this.core_ = cMMCore;
        this.gui_ = mMStudioMainFrame;
    }

    public void start() {
        if (WindowManager.getCurrentWindow() != null) {
            this.start(WindowManager.getCurrentWindow());
        }
    }

    public void start(ImageWindow imageWindow) {
        if (isRunning_) {
            this.stop();
        }
        isRunning_ = true;
        if (imageWindow != null) {
            this.attach(imageWindow);
        }
    }

    public void stop() {
        if (this.canvas_ != null) {
            this.canvas_.removeMouseWheelListener((MouseWheelListener)this);
        }
        isRunning_ = false;
    }

    public boolean isRunning() {
        return isRunning_;
    }

    public void attach(ImageWindow imageWindow) {
        if (!isRunning_) {
            return;
        }
        this.canvas_ = imageWindow.getCanvas();
        this.canvas_.addMouseWheelListener((MouseWheelListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        ZWheelListener zWheelListener = this;
        synchronized (zWheelListener) {
            String string = this.core_.getFocusDevice();
            if (string == null) {
                return;
            }
            double d = 0.2;
            double d2 = this.core_.getPixelSizeUm();
            if (d2 > 0.0) {
                d = 2.0 * d2;
            }
            int n = mouseWheelEvent.getWheelRotation();
            try {
                this.core_.setRelativePosition(string, (double)n * d);
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
                return;
            }
            this.gui_.updateZPosRelative((double)n * d);
        }
    }
}

