/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import com.swtdesigner.SwingResourceManager;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.ImageCache;
import org.micromanager.graph.GraphData;
import org.micromanager.graph.HistogramPanel;
import org.micromanager.internalinterfaces.Histograms;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.HistogramUtils;
import org.micromanager.utils.NumberUtils;

public class SingleChannelHistogram
extends JPanel
implements Histograms,
HistogramPanel.CursorListener {
    private static final long serialVersionUID = 1L;
    private static final int SLOW_HIST_UPDATE_INTERVAL_MS = 1000;
    private long lastUpdateTime_;
    private JComboBox histRangeComboBox_;
    private HistogramPanel histogramPanel_;
    private JLabel maxLabel_;
    private JLabel minLabel_;
    private JLabel meanLabel_;
    private JLabel stdDevLabel_;
    private double gamma_ = 1.0;
    private int histMax_;
    private int maxIntensity_;
    private int bitDepth_;
    private double mean_;
    private double stdDev_;
    private int pixelMin_ = 0;
    private int pixelMax_ = 255;
    private double binSize_ = 1.0;
    private static final int HIST_BINS = 256;
    private int contrastMin_;
    private int contrastMax_;
    private double minAfterRejectingOutliers_;
    private double maxAfterRejectingOutliers_;
    private VirtualAcquisitionDisplay display_;
    private ImagePlus img_;
    private ImageCache cache_;

    public SingleChannelHistogram(VirtualAcquisitionDisplay virtualAcquisitionDisplay) {
        this.display_ = virtualAcquisitionDisplay;
        this.img_ = virtualAcquisitionDisplay.getImagePlus();
        this.cache_ = virtualAcquisitionDisplay.getImageCache();
        this.bitDepth_ = this.cache_.getBitDepth();
        this.histMax_ = this.maxIntensity_ = (int)(Math.pow(2.0, this.bitDepth_) - 1.0);
        this.binSize_ = (double)(this.histMax_ + 1) / 256.0;
        this.initGUI();
        this.loadDisplaySettings();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setFont(new Font("", 0, 10));
        this.histogramPanel_ = new HistogramPanel(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.setColor(Color.black);
                graphics.setFont(new Font("Lucida Grande", 0, 10));
                String string = "" + SingleChannelHistogram.this.histMax_;
                graphics.drawString(string, this.getSize().width - 7 * string.length(), this.getSize().height);
            }
        };
        this.histogramPanel_.setMargins(8.0f, 10.0f);
        this.histogramPanel_.setTraceStyle(true, Color.white);
        this.histogramPanel_.setTextVisible(false);
        this.histogramPanel_.setGridVisible(false);
        this.histogramPanel_.addCursorListener(this);
        this.add((Component)this.histogramPanel_, "Center");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "First");
        this.add((Component)jPanel2, "Before");
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleChannelHistogram.this.fullButtonAction();
            }
        });
        jButton.setFont(new Font("Arial", 0, 10));
        jButton.setToolTipText("Set display levels to full pixel range");
        jButton.setText("Full");
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleChannelHistogram.this.autoButtonAction();
            }
        });
        jButton2.setFont(new Font("Arial", 0, 10));
        jButton2.setToolTipText("Set display levels to maximum contrast");
        jButton2.setText("Auto");
        this.minLabel_ = new JLabel();
        this.minLabel_.setFont(new Font("", 0, 10));
        this.maxLabel_ = new JLabel();
        this.maxLabel_.setFont(new Font("", 0, 10));
        this.meanLabel_ = new JLabel();
        this.meanLabel_.setFont(new Font("", 0, 10));
        this.stdDevLabel_ = new JLabel();
        this.stdDevLabel_.setFont(new Font("", 0, 10));
        JButton jButton3 = new JButton();
        jButton3.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/zoom_in.png"));
        JButton jButton4 = new JButton();
        jButton4.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/zoom_out.png"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleChannelHistogram.this.zoomInAction();
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleChannelHistogram.this.zoomOutAction();
            }
        });
        jButton3.setPreferredSize(new Dimension(22, 22));
        jButton4.setPreferredSize(new Dimension(22, 22));
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel("Hist range:");
        jLabel.setFont(new Font("Arial", 0, 10));
        jPanel3.add(jLabel);
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        this.histRangeComboBox_ = new JComboBox();
        this.histRangeComboBox_.setFont(new Font("", 0, 10));
        this.histRangeComboBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleChannelHistogram.this.histRangeComboAction();
            }
        });
        this.histRangeComboBox_.setModel(new DefaultComboBoxModel<String>(new String[]{"Camera Depth", "4bit (0-15)", "5bit (0-31)", "6bit (0-63)", "7bit (0-127)", "8bit (0-255)", "9bit (0-511)", "10bit (0-1023)", "11bit (0-2047)", "12bit (0-4095)", "13bit (0-8191)", "14bit (0-16383)", "15bit (0-32767)", "16bit (0-65535)"}));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel4 = new JPanel(new GridLayout(5, 1));
        jPanel4.add(new JLabel(" "));
        jPanel4.add(this.minLabel_);
        jPanel4.add(this.maxLabel_);
        jPanel4.add(this.meanLabel_);
        jPanel4.add(this.stdDevLabel_);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jLabel);
        jPanel5.add(jButton4);
        jPanel5.add(jButton3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JLabel(" "), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        jButton.setPreferredSize(new Dimension(60, 15));
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        jButton2.setPreferredSize(new Dimension(60, 15));
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.histRangeComboBox_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
    }

    private void loadDisplaySettings() {
        this.contrastMax_ = this.cache_.getChannelMax(0);
        if (this.contrastMax_ < 0) {
            this.contrastMax_ = this.maxIntensity_;
        }
        this.contrastMin_ = this.cache_.getChannelMin(0);
        this.gamma_ = this.cache_.getChannelGamma(0);
        int n = this.cache_.getChannelHistogramMax(0);
        if (n != -1) {
            int n2 = (int)(Math.ceil(Math.log(n) / Math.log(2.0)) - 3.0);
            this.histRangeComboBox_.setSelectedIndex(n2);
        }
    }

    private void autoButtonAction() {
        this.autostretch();
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    private void fullButtonAction() {
        this.setFullScale();
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    private void histRangeComboAction() {
        this.setHistMaxAndBinSize();
        this.calcAndDisplayHistAndStats(true);
    }

    public void rejectOutliersChangeAction() {
        this.calcAndDisplayHistAndStats(true);
        this.autoButtonAction();
    }

    public void autoscaleAllChannels() {
        this.autoButtonAction();
    }

    public void applyLUTToImage() {
        if (this.img_ == null) {
            return;
        }
        ImageProcessor imageProcessor = this.img_.getProcessor();
        if (imageProcessor == null) {
            return;
        }
        double d = 255.0;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            double d2 = Math.pow((double)i / d, this.gamma_) * d;
            byArray[i] = (byte)d2;
            byArray2[i] = (byte)d2;
            byArray3[i] = (byte)d2;
        }
        imageProcessor.setColorModel((ColorModel)new LUT(8, 256, byArray, byArray2, byArray3));
        imageProcessor.setMinAndMax((double)this.contrastMin_, (double)this.contrastMax_);
        this.saveDisplaySettings();
        this.updateHistogram();
    }

    public void saveDisplaySettings() {
        int n;
        n = this.histRangeComboBox_.getSelectedIndex() == 0 ? (n = -1) : this.histMax_;
        this.cache_.storeChannelDisplaySettings(0, this.contrastMin_, this.contrastMax_, this.gamma_, n, 1);
    }

    public void setChannelHistogramDisplayMax(int n, int n2) {
        if (n != 0) {
            return;
        }
        int n3 = (int)(n2 == -1 ? 0.0 : Math.ceil(Math.log(n2) / Math.log(2.0)) - 3.0);
        this.histRangeComboBox_.setSelectedIndex(n3);
    }

    private void updateHistogram() {
        this.histogramPanel_.setCursors((double)this.contrastMin_ / this.binSize_, (double)(this.contrastMax_ + 1) / this.binSize_, this.gamma_);
        this.histogramPanel_.repaint();
    }

    private void zoomInAction() {
        int n = this.histRangeComboBox_.getSelectedIndex();
        if (n == 0) {
            n = this.bitDepth_ - 3;
        }
        if (n != 1) {
            --n;
        }
        this.histRangeComboBox_.setSelectedIndex(n);
    }

    private void zoomOutAction() {
        int n = this.histRangeComboBox_.getSelectedIndex();
        if (n == 0) {
            n = this.bitDepth_ - 3;
        }
        if (n < this.histRangeComboBox_.getModel().getSize() - 1) {
            ++n;
        }
        this.histRangeComboBox_.setSelectedIndex(n);
    }

    private void setHistMaxAndBinSize() {
        int n = this.histRangeComboBox_.getSelectedIndex() + 3;
        this.histMax_ = n == 3 ? this.maxIntensity_ : (int)(Math.pow(2.0, n) - 1.0);
        this.binSize_ = (double)(this.histMax_ + 1) / 256.0;
        this.updateHistogram();
        this.saveDisplaySettings();
    }

    public void autostretch() {
        this.contrastMin_ = this.pixelMin_;
        this.contrastMax_ = this.pixelMax_;
        if (this.pixelMin_ == this.pixelMax_) {
            if (this.pixelMax_ > 0) {
                --this.contrastMin_;
            } else {
                ++this.contrastMax_;
            }
        }
        if (this.display_.getHistogramControlsState().ignoreOutliers) {
            if ((double)this.contrastMin_ < this.minAfterRejectingOutliers_ && 0.0 < this.minAfterRejectingOutliers_) {
                this.contrastMin_ = (int)this.minAfterRejectingOutliers_;
            }
            if (this.maxAfterRejectingOutliers_ < (double)this.contrastMax_) {
                this.contrastMax_ = (int)this.maxAfterRejectingOutliers_;
            }
            if (this.contrastMax_ <= this.contrastMin_) {
                if (this.contrastMax_ > 0) {
                    this.contrastMin_ = this.contrastMax_ - 1;
                } else {
                    this.contrastMax_ = this.contrastMin_ + 1;
                }
            }
        }
    }

    private void setFullScale() {
        this.setHistMaxAndBinSize();
        this.display_.disableAutoStretchCheckBox();
        this.contrastMin_ = 0;
        this.contrastMax_ = this.histMax_;
    }

    public void imageChanged() {
        boolean bl = true;
        if ((this.display_.acquisitionIsRunning() || MMStudioMainFrame.getInstance().isLiveModeOn() && this.display_.isSimpleDisplay()) && this.display_.getHistogramControlsState().slowHist) {
            long l = System.currentTimeMillis();
            if (l - this.lastUpdateTime_ < 1000L) {
                bl = false;
            } else {
                this.lastUpdateTime_ = l;
            }
        }
        if (bl) {
            this.calcAndDisplayHistAndStats(this.display_.isActiveDisplay());
            if (this.display_.getHistogramControlsState().autostretch) {
                this.autostretch();
            }
            this.applyLUTToImage();
        }
    }

    public void calcAndDisplayHistAndStats(boolean bl) {
        int n;
        int n2;
        if (this.img_ == null || this.img_.getProcessor() == null) {
            return;
        }
        int[] nArray = this.img_.getProcessor().getHistogram();
        int n3 = this.img_.getWidth();
        int n4 = this.img_.getHeight();
        if (this.display_.getHistogramControlsState().ignoreOutliers) {
            this.maxAfterRejectingOutliers_ = nArray.length;
            int n5 = n4 * n3;
            HistogramUtils histogramUtils = new HistogramUtils(nArray, n5, 0.01 * this.display_.getHistogramControlsState().percentToIgnore);
            this.minAfterRejectingOutliers_ = histogramUtils.getMinAfterRejectingOutliers();
            this.maxAfterRejectingOutliers_ = histogramUtils.getMaxAfterRejectingOutliers();
        }
        GraphData graphData = new GraphData();
        this.pixelMin_ = -1;
        this.pixelMax_ = 0;
        this.mean_ = 0.0;
        int n6 = (int)Math.min((double)nArray.length / this.binSize_, 256.0);
        int[] nArray2 = new int[256];
        int n7 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            nArray2[n2] = 0;
            n = 0;
            while ((double)n < this.binSize_) {
                int n8 = (int)((double)n2 * this.binSize_ + (double)n);
                int n9 = nArray[n8];
                int n10 = n2;
                nArray2[n10] = nArray2[n10] + n9;
                if (n9 > 0) {
                    this.pixelMax_ = n8;
                    if (this.pixelMin_ == -1) {
                        this.pixelMin_ = n8;
                    }
                    this.mean_ += (double)(n8 * n9);
                }
                ++n;
            }
            n7 += nArray2[n2];
            if (!this.display_.getHistogramControlsState().logHist) continue;
            nArray2[n2] = nArray2[n2] > 0 ? (int)(1000.0 * Math.log(nArray2[n2])) : 0;
        }
        this.mean_ /= (double)(n3 * n4);
        if (n7 == 0) {
            if (this.img_.getProcessor().getMin() == 0.0) {
                nArray2[0] = n3 * n4;
            } else {
                nArray2[n6 - 1] = n3 * n4;
            }
        }
        if (this.histRangeComboBox_.getSelectedIndex() != -1) {
            this.mean_ = 0.0;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.mean_ += (double)(n2 * nArray[n2]);
            }
            this.mean_ /= (double)(n3 * n4);
        }
        if (bl) {
            this.stdDev_ = 0.0;
            if (this.histRangeComboBox_.getSelectedIndex() != -1) {
                this.pixelMin_ = nArray.length - 1;
            }
            for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                if (this.histRangeComboBox_.getSelectedIndex() != -1) {
                    if (nArray[n2] > 0 && n2 < this.pixelMin_) {
                        this.pixelMin_ = n2;
                    }
                    if (nArray[n2] > 0 && n2 > this.pixelMax_) {
                        this.pixelMax_ = n2;
                    }
                }
                for (n = 0; n < nArray[n2]; ++n) {
                    this.stdDev_ += ((double)n2 - this.mean_) * ((double)n2 - this.mean_);
                }
            }
            this.stdDev_ = Math.sqrt(this.stdDev_ / (double)(n3 * n4));
            graphData.setData(nArray2);
            this.histogramPanel_.setData(graphData);
            this.histogramPanel_.setAutoScale();
            this.histogramPanel_.setToolTipText("Click and drag curve to adjust gamma");
            this.maxLabel_.setText("Max: " + NumberUtils.intToDisplayString(this.pixelMax_));
            this.minLabel_.setText("Min: " + NumberUtils.intToDisplayString(this.pixelMin_));
            this.meanLabel_.setText("Mean: " + NumberUtils.intToDisplayString((int)this.mean_));
            this.stdDevLabel_.setText("Std Dev: " + NumberUtils.intToDisplayString((int)this.stdDev_));
            this.updateHistogram();
        }
    }

    public void setChannelContrast(int n, int n2, int n3, double d) {
        if (n != 0) {
            return;
        }
        this.contrastMax_ = n3;
        this.contrastMin_ = n2;
        this.gamma_ = d;
    }

    public void onLeftCursor(double d) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMin_ = (int)(Math.max(0.0, d) * this.binSize_);
        if (this.contrastMin_ >= this.maxIntensity_) {
            this.contrastMin_ = this.maxIntensity_ - 1;
        }
        if (this.contrastMax_ < this.contrastMin_) {
            this.contrastMax_ = this.contrastMin_ + 1;
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    public void onRightCursor(double d) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMax_ = (int)(Math.min(255.0, d) * this.binSize_);
        if (this.contrastMin_ > this.contrastMax_) {
            this.contrastMin_ = this.contrastMax_;
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    public void onGammaCurve(double d) {
        if (d != 0.0) {
            this.gamma_ = d > 0.9 & d < 1.1 ? 1.0 : d;
            this.applyLUTToImage();
            this.display_.drawWithoutUpdate();
        }
    }

    public void setupChannelControls(ImageCache imageCache) {
    }

    public ContrastSettings getChannelContrastSettings(int n) {
        if (n != 0) {
            return null;
        }
        return new ContrastSettings(this.contrastMin_, this.contrastMax_, this.gamma_);
    }

    public int getNumberOfChannels() {
        return 1;
    }
}

