/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.prefs.Preferences;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.Label;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PagePanel;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ReportingUtils;

public class LabelsPage
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private String[] labels_ = new String[0];
    private Hashtable<String, String[]> originalLabels_ = new Hashtable();
    ArrayList<Device> devices_ = new ArrayList();
    boolean originalLabelsStored_ = false;
    private JTable devTable_;
    private JTable labelTable_;

    public LabelsPage(Preferences preferences) {
        this.title_ = "Define position labels for state devices";
        this.helpText_ = "State devices with discrete positions, such as filter changers or objective turrets, etc. can have mnemonic labels assigned for each position.\n\nSelect the device in the left-hand list and edit corresponding position labels in the right-hand list.\n\nUse the 'Read' button to read label info from the hardware. This will override your changes!\n\n";
        this.setHelpFileName("conf_labels_page.html");
        this.prefs_ = preferences;
        this.setLayout(null);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(182, 30, 269, 482);
        this.add(jScrollPane);
        this.labelTable_ = new JTable();
        this.labelTable_.setModel(new LabelTableModel());
        this.labelTable_.setAutoCreateColumnsFromModel(false);
        this.labelTable_.setSelectionMode(0);
        InputMap inputMap = this.labelTable_.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "none");
        jScrollPane.setViewportView(this.labelTable_);
        GUIUtils.setClickCountToStartEditing(this.labelTable_, 1);
        GUIUtils.stopEditingOnLosingFocus(this.labelTable_);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setBounds(10, 30, 162, 482);
        this.add(jScrollPane2);
        this.devTable_ = new JTable();
        DevTableModel devTableModel = new DevTableModel();
        this.devTable_.setModel(devTableModel);
        this.devTable_.getSelectionModel().addListSelectionListener(new SelectionListener(this.devTable_));
        this.devTable_.setSelectionMode(0);
        jScrollPane2.setViewportView(this.devTable_);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LabelsPage.this.readFromHardware();
            }
        });
        jButton.setText("Read");
        jButton.setBounds(457, 30, 93, 23);
        this.add(jButton);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LabelsPage.this.resetLabels();
            }
        });
        jButton2.setText("Reset");
        jButton2.setBounds(457, 53, 93, 23);
        this.add(jButton2);
    }

    public void readFromHardware() {
        LabelTableModel labelTableModel = (LabelTableModel)this.labelTable_.getModel();
        Device device = labelTableModel.getCurrentDevice();
        if (device != null) {
            try {
                device.getSetupLabelsFromHardware(this.core_);
                labelTableModel.setData(this.model_, device.getName());
                labelTableModel.fireTableStructureChanged();
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
    }

    public void resetLabels() {
        LabelTableModel labelTableModel = (LabelTableModel)this.labelTable_.getModel();
        Device device = labelTableModel.getCurrentDevice();
        if (device != null) {
            for (int i = 0; i < this.devices_.size(); ++i) {
                String[] stringArray;
                if (device != this.devices_.get(i) || (stringArray = this.originalLabels_.get(this.devices_.get(i).getName())) == null) continue;
                for (int j = 0; j < this.labels_.length; ++j) {
                    device.setSetupLabel(j, stringArray[j]);
                    this.labels_[j] = stringArray[j];
                }
                labelTableModel.fireTableStructureChanged();
            }
        }
    }

    public void storeLabels() {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = this.devices_.get(i);
            if (this.originalLabels_.containsKey(device.getName())) continue;
            String[] stringArray = new String[device.getNumberOfStates()];
            for (int j = 0; j < device.getNumberOfStates(); ++j) {
                Label label = device.getSetupLabelByState(j);
                stringArray[j] = label != null ? label.label_ : "State-" + j;
            }
            this.originalLabels_.put(device.getName(), stringArray);
        }
    }

    public boolean enterPage(boolean bl) {
        DevTableModel devTableModel = (DevTableModel)this.devTable_.getModel();
        devTableModel.setData(this.model_);
        try {
            TableModel tableModel;
            try {
                this.model_.loadStateLabelsFromHardware(this.core_);
            }
            catch (Throwable throwable) {
                ReportingUtils.logError(throwable);
            }
            if (this.devTable_.getSelectedRowCount() < 1 && 0 < (tableModel = this.devTable_.getModel()).getRowCount()) {
                this.devTable_.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return false;
        }
        return true;
    }

    public boolean exitPage(boolean bl) {
        try {
            if (this.labelTable_.isEditing()) {
                this.labelTable_.getDefaultEditor(String.class).stopCellEditing();
            }
            this.model_.applySetupLabelsToHardware(this.core_);
            this.model_.loadDeviceDataFromHardware(this.core_);
        }
        catch (Exception exception) {
            this.handleError(exception.getMessage());
            return !bl;
        }
        return true;
    }

    public void refresh() {
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }

    static /* synthetic */ String[] access$102(LabelsPage labelsPage, String[] stringArray) {
        labelsPage.labels_ = stringArray;
        return stringArray;
    }

    class DevTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"State devices"};

        DevTableModel() {
        }

        public void setData(MicroscopeModel microscopeModel) {
            Device[] deviceArray = microscopeModel.getDevices();
            LabelsPage.this.devices_.clear();
            for (int i = 0; i < deviceArray.length; ++i) {
                if (!deviceArray[i].isStateDevice()) continue;
                LabelsPage.this.devices_.add(deviceArray[i]);
            }
            LabelsPage.this.storeLabels();
        }

        public int getRowCount() {
            return LabelsPage.this.devices_.size();
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            return LabelsPage.this.devices_.get(n).getName();
        }
    }

    class LabelTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"State", "Label"};
        private Device curDevice_;

        LabelTableModel() {
        }

        public Device getCurrentDevice() {
            return this.curDevice_;
        }

        public void setData(MicroscopeModel microscopeModel, String string) {
            this.curDevice_ = microscopeModel.findDevice(string);
            String[] stringArray = new String[]{};
            if (this.curDevice_ == null) {
                LabelsPage.access$102(LabelsPage.this, stringArray);
                return;
            }
            stringArray = new String[this.curDevice_.getNumberOfStates()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = "State-" + i;
            }
            Label[] labelArray = this.curDevice_.getAllSetupLabels();
            for (int i = 0; i < labelArray.length; ++i) {
                stringArray[labelArray[i].state_] = labelArray[i].label_;
                if (LabelsPage.this.labels_.length <= labelArray[i].state_) continue;
                LabelsPage.this.model_.updateLabelsInPreset(this.curDevice_.getName(), LabelsPage.this.labels_[labelArray[i].state_], stringArray[labelArray[i].state_]);
            }
            LabelsPage.access$102(LabelsPage.this, stringArray);
        }

        public int getRowCount() {
            return LabelsPage.this.labels_.length;
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return Integer.toString(n);
            }
            return LabelsPage.this.labels_[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                try {
                    String string = LabelsPage.this.labels_[n];
                    ((LabelsPage)LabelsPage.this).labels_[n] = (String)object;
                    this.curDevice_.setSetupLabel(n, (String)object);
                    this.fireTableCellUpdated(n, n2);
                    LabelsPage.this.model_.updateLabelsInPreset(this.curDevice_.getName(), string, LabelsPage.this.labels_[n]);
                }
                catch (Exception exception) {
                    ReportingUtils.showError(exception);
                }
            }
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            LabelTableModel labelTableModel = (LabelTableModel)LabelsPage.this.labelTable_.getModel();
            if (listSelectionModel.isSelectionEmpty()) {
                labelTableModel.setData(LabelsPage.this.model_, null);
            } else {
                if (labelTableModel.getColumnCount() > 0 && LabelsPage.this.labelTable_.isEditing()) {
                    LabelsPage.this.labelTable_.getDefaultEditor(String.class).stopCellEditing();
                }
                String string = (String)this.table.getValueAt(listSelectionModel.getMinSelectionIndex(), 0);
                labelTableModel.setData(LabelsPage.this.model_, string);
            }
            labelTableModel.fireTableStructureChanged();
            LabelsPage.this.labelTable_.getColumnModel().getColumn(0).setWidth(40);
        }
    }
}

