/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.PagePanel;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.ReportingUtils;

public class IntroPage
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JTextField filePathField_;
    private boolean initialized_ = false;
    private JRadioButton modifyRadioButton_;
    private JRadioButton createNewRadioButton_;
    private JButton browseButton_;
    private static final String HELP_FILE_NAME = "conf_intro_page.html";

    public IntroPage(Preferences preferences) {
        this.title_ = "Select the configuration file";
        this.helpText_ = "Welcome to the Micro-Manager Configurator.\nThe Configurator will guide you through the process of configuring the software to work with your hardware setup.\nIn this step you choose if you are creating a new hardware configuration or editing an existing one.";
        this.setLayout(null);
        this.prefs_ = preferences;
        this.setHelpFileName(HELP_FILE_NAME);
        this.createNewRadioButton_ = new JRadioButton();
        this.createNewRadioButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPage.this.model_.reset();
                IntroPage.this.initialized_ = false;
                IntroPage.this.filePathField_.setEnabled(false);
                IntroPage.this.browseButton_.setEnabled(false);
            }
        });
        this.buttonGroup.add(this.createNewRadioButton_);
        this.createNewRadioButton_.setText("Create new configuration");
        this.createNewRadioButton_.setBounds(10, 31, 424, 23);
        this.add(this.createNewRadioButton_);
        this.modifyRadioButton_ = new JRadioButton();
        this.buttonGroup.add(this.modifyRadioButton_);
        this.modifyRadioButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPage.this.filePathField_.setEnabled(true);
                IntroPage.this.browseButton_.setEnabled(true);
            }
        });
        this.modifyRadioButton_.setText("Modify or explore existing configuration");
        this.modifyRadioButton_.setBounds(10, 55, 424, 23);
        this.add(this.modifyRadioButton_);
        this.filePathField_ = new JTextField();
        this.filePathField_.setBounds(10, 110, 509, 19);
        this.add(this.filePathField_);
        this.browseButton_ = new JButton();
        this.browseButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPage.this.loadConfiguration();
            }
        });
        this.browseButton_.setText("Browse...");
        this.browseButton_.setBounds(10, 85, 100, 23);
        this.add(this.browseButton_);
        this.createNewRadioButton_.setSelected(true);
        this.filePathField_.setEnabled(false);
        this.browseButton_.setEnabled(false);
    }

    public void loadSettings() {
        if (this.model_ != null) {
            this.filePathField_.setText(this.model_.getFileName());
        }
        if (this.filePathField_.getText().length() > 0) {
            this.modifyRadioButton_.setSelected(true);
            this.filePathField_.setEnabled(true);
            this.browseButton_.setEnabled(true);
        }
    }

    public void saveSettings() {
    }

    public boolean enterPage(boolean bl) {
        if (bl) {
            this.model_.reset();
            try {
                this.core_.unloadAllDevices();
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
            this.filePathField_.setText(this.model_.getFileName());
            this.initialized_ = false;
        }
        return true;
    }

    public boolean exitPage(boolean bl) {
        if (this.modifyRadioButton_.isSelected() && (!this.initialized_ || this.filePathField_.getText().compareTo(this.model_.getFileName()) != 0)) {
            try {
                this.model_.loadFromFile(this.filePathField_.getText());
            }
            catch (MMConfigFileException mMConfigFileException) {
                ReportingUtils.showError(mMConfigFileException);
                this.model_.reset();
                return false;
            }
            this.initialized_ = true;
        }
        return true;
    }

    public void refresh() {
    }

    private void loadConfiguration() {
        File file = FileDialogs.openFile(this.parent_, "Choose a config file", MMStudioMainFrame.MM_CONFIG_FILE);
        if (file == null) {
            return;
        }
        this.filePathField_.setText(file.getAbsolutePath());
    }
}

