/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.LongVector;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.conf2.Label;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Device {
    private String name_;
    private String adapterName_;
    private String library_;
    private PropertyItem[] properties_;
    private ArrayList<PropertyItem> setupProperties_;
    private String description_;
    private DeviceType type_;
    private Hashtable<Integer, Label> setupLabels_;
    private double delayMs_;
    private boolean usesDelay_;
    private int numPos_ = 0;
    private String parentHub_;
    private String[] childDevices_;
    private boolean initialized_;

    public Device(String string, String string2, String string3, String string4, boolean bl, String string5, Vector<String> vector) {
        this.name_ = string;
        this.library_ = string2;
        this.adapterName_ = string3;
        this.description_ = string4;
        this.type_ = DeviceType.AnyType;
        this.setupLabels_ = new Hashtable();
        this.properties_ = new PropertyItem[0];
        this.setupProperties_ = new ArrayList();
        this.usesDelay_ = false;
        this.delayMs_ = 0.0;
        this.parentHub_ = new String();
        this.childDevices_ = new String[0];
        this.initialized_ = false;
    }

    public Device(String string, String string2, String string3, String string4) {
        this.name_ = string;
        this.library_ = string2;
        this.adapterName_ = string3;
        this.description_ = string4;
        this.type_ = DeviceType.AnyType;
        this.setupLabels_ = new Hashtable();
        this.properties_ = new PropertyItem[0];
        this.setupProperties_ = new ArrayList();
        this.usesDelay_ = false;
        this.delayMs_ = 0.0;
        this.parentHub_ = new String();
        this.childDevices_ = new String[0];
    }

    public Device(String string, String string2, String string3) {
        this(string, string2, string3, "");
    }

    public void setTypeByInt(int n) {
        this.type_ = DeviceType.swigToEnum(n);
    }

    public int getTypeAsInt() {
        return this.type_.swigValue();
    }

    public String getTypeAsString() {
        String string = new String("Unknown");
        if (this.type_ == DeviceType.CameraDevice) {
            string = "Camera";
        } else if (this.type_ == DeviceType.SerialDevice) {
            string = "Serial Port";
        } else if (this.type_ == DeviceType.ShutterDevice) {
            string = "Shutter";
        } else if (this.type_ == DeviceType.CoreDevice) {
            string = "Micro-manager Core";
        } else if (this.type_ == DeviceType.AutoFocusDevice) {
            string = "Autofocus";
        } else if (this.type_ == DeviceType.CommandDispatchDevice) {
            string = "Command Dispatcher";
        } else if (this.type_ == DeviceType.HubDevice) {
            string = "Motorized scope or Hub";
        } else if (this.type_ == DeviceType.GenericDevice) {
            string = "Generic Device";
        } else if (this.type_ == DeviceType.AnyType) {
            string = "Misc.";
        } else if (this.type_ == DeviceType.ImageProcessorDevice) {
            string = "Image Processor";
        } else if (this.type_ == DeviceType.ImageStreamerDevice) {
            string = "Image Streamer";
        } else if (this.type_ == DeviceType.ProgrammableIODevice) {
            string = "Programmable I/O Device";
        } else if (this.type_ == DeviceType.SignalIODevice) {
            string = "Signal I/O Device";
        } else if (this.type_ == DeviceType.SLMDevice) {
            string = "SLM";
        } else if (this.type_ == DeviceType.StageDevice) {
            string = "Single Axis Stage";
        } else if (this.type_ == DeviceType.XYStageDevice) {
            string = "XY Stage";
        } else if (this.type_ == DeviceType.StateDevice) {
            string = "Discrete State Device";
        } else if (this.type_ == DeviceType.MagnifierDevice) {
            string = "Magnifier";
        } else {
            ReportingUtils.logError("Unercongized device type: " + this.adapterName_);
        }
        return string;
    }

    public void loadDataFromHardware(CMMCore cMMCore) throws Exception {
        StrVector strVector = cMMCore.getDevicePropertyNames(this.name_);
        this.properties_ = new PropertyItem[(int)strVector.size()];
        this.type_ = cMMCore.getDeviceType(this.name_);
        this.usesDelay_ = cMMCore.usesDeviceDelay(this.name_);
        int n = 0;
        while ((long)n < strVector.size()) {
            this.properties_[n] = new PropertyItem();
            this.properties_[n].name = strVector.get(n);
            this.properties_[n].value = cMMCore.getProperty(this.name_, strVector.get(n));
            this.properties_[n].readOnly = cMMCore.isPropertyReadOnly(this.name_, strVector.get(n));
            this.properties_[n].preInit = cMMCore.isPropertyPreInit(this.name_, strVector.get(n));
            this.properties_[n].type = cMMCore.getPropertyType(this.name_, strVector.get(n));
            StrVector strVector2 = cMMCore.getAllowedPropertyValues(this.name_, strVector.get(n));
            this.properties_[n].allowed = new String[(int)strVector2.size()];
            int n2 = 0;
            while ((long)n2 < strVector2.size()) {
                this.properties_[n].allowed[n2] = strVector2.get(n2);
                ++n2;
            }
            this.properties_[n].sort();
            ++n;
        }
        this.numPos_ = this.type_ == DeviceType.StateDevice ? cMMCore.getNumberOfStates(this.name_) : 0;
    }

    public static Device[] getLibraryContents(String string, CMMCore cMMCore) throws Exception {
        StrVector strVector = cMMCore.getAvailableDevices(string);
        StrVector strVector2 = cMMCore.getAvailableDeviceDescriptions(string);
        LongVector longVector = cMMCore.getAvailableDeviceTypes(string);
        Device[] deviceArray = new Device[(int)strVector.size()];
        int n = 0;
        while ((long)n < strVector.size()) {
            deviceArray[n] = new Device("Undefined", string, strVector.get(n), strVector2.get(n));
            deviceArray[n].setTypeByInt(longVector.get(n));
            ++n;
        }
        return deviceArray;
    }

    public void discoverPeripherals(CMMCore cMMCore) {
        if (this.isHub() && !this.getName().equals("Core") && this.childDevices_.length == 0) {
            StrVector strVector = cMMCore.getInstalledDevices(this.getName());
            this.childDevices_ = strVector.toArray();
        }
    }

    public String[] getPreInitProperties() {
        Vector<String> vector = new Vector<String>();
        for (PropertyItem propertyItem : this.properties_) {
            if (!propertyItem.preInit) continue;
            vector.add(propertyItem.name);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] getPeripherals() {
        return this.childDevices_;
    }

    public String getName() {
        return this.name_;
    }

    public String getAdapterName() {
        return this.adapterName_;
    }

    public String getDescription() {
        return this.description_;
    }

    public void addSetupProperty(PropertyItem propertyItem) {
        this.setupProperties_.add(propertyItem);
    }

    public void addSetupLabel(Label label) {
        this.setupLabels_.put(new Integer(label.state_), label);
    }

    public void getSetupLabelsFromHardware(CMMCore cMMCore) throws Exception {
        if (this.type_ == DeviceType.StateDevice) {
            StrVector strVector = cMMCore.getStateLabels(this.name_);
            this.numPos_ = (int)strVector.size();
            this.setupLabels_.clear();
            for (int i = 0; i < this.numPos_; ++i) {
                this.setSetupLabel(i, strVector.get(i));
            }
        }
    }

    public String getLibrary() {
        return this.library_;
    }

    public int getNumberOfProperties() {
        return this.properties_.length;
    }

    public PropertyItem getProperty(int n) {
        return this.properties_[n];
    }

    public String getPropertyValue(String string) throws MMConfigFileException {
        PropertyItem propertyItem = this.findProperty(string);
        if (propertyItem == null) {
            throw new MMConfigFileException("Property " + string + " is not defined");
        }
        return propertyItem.value;
    }

    public void setPropertyValue(String string, String string2) throws MMConfigFileException {
        PropertyItem propertyItem = this.findProperty(string);
        if (propertyItem == null) {
            throw new MMConfigFileException("Property " + string + " is not defined");
        }
        propertyItem.value = string2;
    }

    public int getNumberOfSetupProperties() {
        return this.setupProperties_.size();
    }

    public PropertyItem getSetupProperty(int n) {
        return this.setupProperties_.get(n);
    }

    public String getSetupPropertyValue(String string) throws MMConfigFileException {
        PropertyItem propertyItem = this.findSetupProperty(string);
        if (propertyItem == null) {
            throw new MMConfigFileException("Property " + string + " is not defined");
        }
        return propertyItem.value;
    }

    public void setSetupPropertyValue(String string, String string2) throws MMConfigFileException {
        PropertyItem propertyItem = this.findSetupProperty(string);
        if (propertyItem == null) {
            throw new MMConfigFileException("Property " + string + " is not defined");
        }
        propertyItem.value = string2;
    }

    public boolean isStateDevice() {
        return this.type_ == DeviceType.StateDevice;
    }

    public boolean isSerialPort() {
        return this.type_ == DeviceType.SerialDevice;
    }

    public boolean isCamera() {
        return this.type_ == DeviceType.CameraDevice;
    }

    public boolean isHub() {
        return this.type_ == DeviceType.HubDevice;
    }

    public int getNumberOfSetupLabels() {
        return this.setupLabels_.size();
    }

    public Label getSetupLabelByState(int n) {
        return this.setupLabels_.get(new Integer(n));
    }

    public void setSetupLabel(int n, String string) {
        Label label = this.setupLabels_.get(new Integer(n));
        if (label == null) {
            this.setupLabels_.put(new Integer(n), new Label(string, n));
        } else {
            label.label_ = string;
        }
    }

    public boolean isCore() {
        return this.name_.contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()));
    }

    public void setName(String string) {
        this.name_ = string;
    }

    public PropertyItem findProperty(String string) {
        for (int i = 0; i < this.properties_.length; ++i) {
            PropertyItem propertyItem = this.properties_[i];
            if (!propertyItem.name.contentEquals(new StringBuffer().append(string))) continue;
            return propertyItem;
        }
        return null;
    }

    public PropertyItem findSetupProperty(String string) {
        for (int i = 0; i < this.setupProperties_.size(); ++i) {
            PropertyItem propertyItem = this.setupProperties_.get(i);
            if (!propertyItem.name.contentEquals(new StringBuffer().append(string))) continue;
            return propertyItem;
        }
        return null;
    }

    public double getDelay() {
        return this.delayMs_;
    }

    public void setDelay(double d) {
        this.delayMs_ = d;
    }

    public boolean usesDelay() {
        return this.usesDelay_;
    }

    public int getNumberOfStates() {
        return this.numPos_;
    }

    public void setParentHub(String string) {
        this.parentHub_ = string;
    }

    public String getParentHub() {
        return this.parentHub_;
    }

    public boolean isInitialized() {
        return this.initialized_;
    }

    public void setInitialized(boolean bl) {
        this.initialized_ = bl;
    }

    public void updateSetupProperties() {
        this.setupProperties_.clear();
        for (int i = 0; i < this.properties_.length; ++i) {
            this.setupProperties_.add(new PropertyItem(this.properties_[i].name, this.properties_[i].value, this.properties_[i].preInit));
        }
    }

    public String getPort() {
        for (int i = 0; i < this.getNumberOfProperties(); ++i) {
            PropertyItem propertyItem = this.getProperty(i);
            if (propertyItem == null || propertyItem.name.compareTo(MMCoreJ.getG_Keyword_Port()) != 0) continue;
            return propertyItem.value;
        }
        return new String("");
    }

    public Label[] getAllSetupLabels() {
        Label[] labelArray = new Label[this.setupLabels_.size()];
        return this.setupLabels_.values().toArray(labelArray);
    }
}

