/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import ij.plugin.BrowserLauncher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import mmcorej.CMMCore;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.DeviceSetupDlg;
import org.micromanager.conf2.DeviceTreeNode;
import org.micromanager.conf2.DevicesPage;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PeripheralSetupDlg;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.ReportingUtils;

public class AddDeviceDlg
extends MMDialog
implements MouseListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private MicroscopeModel model_;
    private DevicesPage devicesPage_;
    private TreeWContextMenu theTree_;
    final String documentationURLroot_;
    String libraryDocumentationName_;
    private JCheckBox cbShowAll_;
    private JScrollPane availableScrollPane_;
    private CMMCore core_;
    private boolean listByLib_;

    public AddDeviceDlg(MicroscopeModel microscopeModel, CMMCore cMMCore, DevicesPage devicesPage) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AddDeviceDlg.this.savePosition();
            }
        });
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.setTitle("Add Device");
        this.setBounds(400, 100, 624, 529);
        this.loadPosition(400, 100);
        this.devicesPage_ = devicesPage;
        this.core_ = cMMCore;
        this.listByLib_ = true;
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AddDeviceDlg.this.addDevice()) {
                    AddDeviceDlg.this.rebuildTable();
                }
            }
        });
        jButton.setText("Add");
        jButton.setBounds(490, 10, 93, 23);
        this.getContentPane().add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDeviceDlg.this.savePosition();
                AddDeviceDlg.this.dispose();
            }
        });
        jButton2.setText("Done");
        jButton2.setBounds(490, 39, 93, 23);
        this.getContentPane().add(jButton2);
        this.getRootPane().setDefaultButton(jButton2);
        this.model_ = microscopeModel;
        this.documentationURLroot_ = "https://valelab.ucsf.edu/~MM/MMwiki/index.php/";
        JButton jButton3 = new JButton();
        jButton3.setText("Help");
        jButton3.setBounds(490, 68, 93, 23);
        this.getContentPane().add(jButton3);
        this.cbShowAll_ = new JCheckBox("Show all");
        this.cbShowAll_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDeviceDlg.this.buildTree();
            }
        });
        this.cbShowAll_.setBounds(476, 462, 137, 23);
        this.cbShowAll_.setSelected(false);
        this.getContentPane().add(this.cbShowAll_);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDeviceDlg.this.displayDocumentation();
            }
        });
        if (this.listByLib_) {
            this.buildTreeByLib(microscopeModel);
        } else {
            this.buildTreeByType(microscopeModel);
        }
        JCheckBox jCheckBox = new JCheckBox("List by library");
        jCheckBox.setSelected(this.listByLib_);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDeviceDlg.this.listByLib_ = ((JCheckBox)actionEvent.getSource()).isSelected();
                AddDeviceDlg.this.buildTree();
            }
        });
        jCheckBox.setBounds(476, 436, 137, 23);
        this.getContentPane().add(jCheckBox);
        this.availableScrollPane_ = new JScrollPane(this.theTree_);
        this.availableScrollPane_.setBounds(10, 10, 461, 480);
        this.availableScrollPane_.setViewportView(this.theTree_);
        this.getContentPane().add(this.availableScrollPane_);
    }

    private void buildTreeByType(MicroscopeModel microscopeModel) {
        Object[] objectArray;
        Cloneable cloneable;
        Device[] deviceArray = null;
        deviceArray = this.cbShowAll_.isSelected() ? microscopeModel.getAvailableDeviceList() : microscopeModel.getAvailableDevicesCompact();
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < deviceArray.length; ++i) {
            if (hashtable.containsKey(deviceArray[i].getTypeAsString())) {
                ((Vector)hashtable.get(deviceArray[i].getTypeAsString())).add(deviceArray[i]);
                continue;
            }
            cloneable = new Vector<Device>();
            ((Vector)cloneable).add(deviceArray[i]);
            hashtable.put(deviceArray[i].getTypeAsString(), cloneable);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Devices supported by \u00b5Manager");
        cloneable = null;
        for (Object object : objectArray = hashtable.keySet().toArray()) {
            cloneable = new DeviceTreeNode((String)object, false);
            defaultMutableTreeNode.add((MutableTreeNode)((Object)cloneable));
            Vector vector = (Vector)hashtable.get(object);
            for (int i = 0; i < vector.size(); ++i) {
                Object[] objectArray2 = new Object[]{((Device)vector.get(i)).getLibrary(), ((Device)vector.get(i)).getAdapterName(), ((Device)vector.get(i)).getDescription(), ((Device)vector.get(i)).isHub()};
                DeviceTreeNode deviceTreeNode = new DeviceTreeNode("", false);
                deviceTreeNode.setUserObject(objectArray2);
                ((DefaultMutableTreeNode)cloneable).add(deviceTreeNode);
            }
        }
        this.theTree_ = new TreeWContextMenu(defaultMutableTreeNode, this);
        this.theTree_.addTreeSelectionListener(this);
        TreeMouseListener treeMouseListener = new TreeMouseListener();
        this.theTree_.addMouseListener(treeMouseListener);
        this.theTree_.setRootVisible(false);
        this.theTree_.setShowsRootHandles(true);
    }

    private void buildTreeByLib(MicroscopeModel microscopeModel) {
        Device[] deviceArray = null;
        deviceArray = this.cbShowAll_.isSelected() ? microscopeModel.getAvailableDeviceList() : microscopeModel.getAvailableDevicesCompact();
        String string = "";
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Devices supported by \u00b5Manager");
        DeviceTreeNode deviceTreeNode = null;
        for (int i = 0; i < deviceArray.length; ++i) {
            if (0 != string.compareTo(deviceArray[i].getLibrary())) {
                deviceTreeNode = new DeviceTreeNode(deviceArray[i].getLibrary(), true);
                defaultMutableTreeNode.add(deviceTreeNode);
                string = deviceArray[i].getLibrary();
            }
            Object[] objectArray = new Object[]{deviceArray[i].getLibrary(), deviceArray[i].getAdapterName(), deviceArray[i].getDescription(), deviceArray[i].isHub()};
            DeviceTreeNode deviceTreeNode2 = new DeviceTreeNode("", true);
            deviceTreeNode2.setUserObject(objectArray);
            deviceTreeNode.add(deviceTreeNode2);
        }
        this.theTree_ = new TreeWContextMenu(defaultMutableTreeNode, this);
        this.theTree_.addTreeSelectionListener(this);
        TreeMouseListener treeMouseListener = new TreeMouseListener();
        this.theTree_.addMouseListener(treeMouseListener);
        this.theTree_.setRootVisible(false);
        this.theTree_.setShowsRootHandles(true);
    }

    private void displayDocumentation() {
        try {
            BrowserLauncher.openURL((String)(this.documentationURLroot_ + this.libraryDocumentationName_));
        }
        catch (IOException iOException) {
            ReportingUtils.showError(iOException);
        }
    }

    private void rebuildTable() {
        this.devicesPage_.rebuildDevicesTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDevice() {
        int[] nArray = this.theTree_.getSelectionRows();
        if (nArray == null) {
            return false;
        }
        if (0 < nArray.length && 0 < nArray[0]) {
            Device device;
            DeviceTreeNode deviceTreeNode = (DeviceTreeNode)this.theTree_.getLastSelectedPathComponent();
            Object[] objectArray = deviceTreeNode.getUserDataArray();
            if (null == objectArray && 1 == deviceTreeNode.getLeafCount() && null == (objectArray = (deviceTreeNode = (DeviceTreeNode)deviceTreeNode.getChildAt(0)).getUserDataArray())) {
                return false;
            }
            String string = objectArray[1].toString();
            String string2 = objectArray[0].toString();
            String string3 = objectArray[2].toString();
            String string4 = new String(string);
            Device device2 = this.model_.findDevice(string4);
            int n = 0;
            while (device2 != null) {
                string4 = new String(string + "-" + ++n);
                device2 = this.model_.findDevice(string4);
            }
            try {
                this.core_.loadDevice(string4, string2, string);
                device = new Device(string4, string2, string, string3);
                device.loadDataFromHardware(this.core_);
                this.model_.addDevice(device);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage());
                return false;
            }
            DeviceSetupDlg deviceSetupDlg = new DeviceSetupDlg(this.model_, this.core_, device);
            deviceSetupDlg.setVisible(true);
            if (!device.isInitialized()) {
                this.model_.removeDevice(device.getName());
                try {
                    this.core_.unloadDevice(device.getName());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage());
                }
                return false;
            }
            if (device.isHub() && !device.getName().equals("Core")) {
                Object object;
                String[] stringArray = device.getPeripherals();
                Vector<Device> vector = new Vector<Device>();
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        if (this.model_.hasAdapterName(device.getLibrary(), device.getName(), stringArray[i])) continue;
                        object = this.model_.getDeviceDescription(device.getLibrary(), stringArray[i]);
                        Device device3 = new Device(stringArray[i], device.getLibrary(), stringArray[i], (String)object);
                        vector.add(device3);
                        continue;
                    }
                    catch (Exception exception) {
                        ReportingUtils.logError(exception.getMessage());
                    }
                }
                if (vector.size() > 0) {
                    PeripheralSetupDlg peripheralSetupDlg = new PeripheralSetupDlg(this.model_, this.core_, device.getName(), vector);
                    peripheralSetupDlg.setVisible(true);
                    object = peripheralSetupDlg.getSelectedPeripherals();
                    for (int i = 0; i < ((Device[])object).length; ++i) {
                        try {
                            this.core_.loadDevice(object[i].getName(), object[i].getLibrary(), object[i].getAdapterName());
                            object[i].setParentHub(device.getName());
                            this.core_.setParentLabel(object[i].getName(), device.getName());
                            this.model_.addDevice(object[i]);
                            object[i].loadDataFromHardware(this.core_);
                            String[] stringArray2 = object[i].getPreInitProperties();
                            if (stringArray2.length > 0) {
                                DeviceSetupDlg deviceSetupDlg2 = new DeviceSetupDlg(this.model_, this.core_, object[i]);
                                deviceSetupDlg2.setVisible(true);
                                if (object[i].isInitialized()) continue;
                                this.core_.unloadDevice(object[i].getName());
                                this.model_.removeDevice(object[i].getName());
                                continue;
                            }
                            this.core_.initializeDevice(object[i].getName());
                            object[i].setInitialized(true);
                        }
                        catch (MMConfigFileException mMConfigFileException) {
                            JOptionPane.showMessageDialog(this, mMConfigFileException.getMessage());
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this, exception.getMessage());
                        }
                        continue;
                    }
                }
            }
        }
        return true;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DeviceTreeNode deviceTreeNode;
        Object object;
        int[] nArray = this.theTree_.getSelectionRows();
        if (null != nArray && 0 < nArray.length && 0 < nArray[0] && (object = (deviceTreeNode = (DeviceTreeNode)this.theTree_.getLastSelectedPathComponent()).getUserObject()) != null) {
            this.libraryDocumentationName_ = object.getClass().isArray() ? ((Object[])object)[0].toString() : object.toString();
        }
    }

    private void buildTree() {
        if (this.listByLib_) {
            this.buildTreeByLib(this.model_);
        } else {
            this.buildTreeByType(this.model_);
        }
        this.availableScrollPane_.setViewportView(this.theTree_);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    class TreeMouseListener
    extends MouseAdapter {
        TreeMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (2 == mouseEvent.getClickCount() && AddDeviceDlg.this.addDevice()) {
                AddDeviceDlg.this.rebuildTable();
            }
        }
    }

    class TreeWContextMenu
    extends JTree
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        JPopupMenu popupMenu_;
        AddDeviceDlg d_;

        public TreeWContextMenu(DefaultMutableTreeNode defaultMutableTreeNode, AddDeviceDlg addDeviceDlg2) {
            super(defaultMutableTreeNode);
            this.d_ = addDeviceDlg2;
            this.popupMenu_ = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Add");
            jMenuItem.setActionCommand("add");
            jMenuItem.addActionListener(this);
            this.popupMenu_.add(jMenuItem);
            jMenuItem = new JMenuItem("Help");
            jMenuItem.setActionCommand("help");
            jMenuItem.addActionListener(this);
            this.popupMenu_.add(jMenuItem);
            this.popupMenu_.setOpaque(true);
            this.popupMenu_.setLightWeightPopupEnabled(true);
            this.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        TreeWContextMenu.this.popupMenu_.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("help")) {
                this.d_.displayDocumentation();
            } else if (actionEvent.getActionCommand().equals("add") && this.d_.addDevice()) {
                this.d_.rebuildTable();
            }
        }
    }
}

