/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.api;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataProcessor<E>
extends Thread {
    private BlockingQueue<E> input_;
    private BlockingQueue<E> output_;
    private boolean stopRequested_ = false;
    private boolean started_ = false;

    protected abstract void process();

    @Override
    public void run() {
        this.setStarted(true);
        while (!this.stopRequested_) {
            this.process();
        }
    }

    public synchronized void requestStop() {
        this.stopRequested_ = true;
    }

    private synchronized void setStarted(boolean bl) {
        this.started_ = bl;
    }

    public synchronized boolean isStarted() {
        return this.started_;
    }

    public void setInput(BlockingQueue<E> blockingQueue) {
        this.input_ = blockingQueue;
    }

    public void setOutput(BlockingQueue<E> blockingQueue) {
        this.output_ = blockingQueue;
    }

    protected E poll() {
        while (!this.stopRequested()) {
            try {
                E e = this.input_.poll(100L, TimeUnit.MILLISECONDS);
                if (e == null) continue;
                return e;
            }
            catch (InterruptedException interruptedException) {
                ReportingUtils.logError(interruptedException);
            }
        }
        return null;
    }

    protected void drainTo(Collection<E> collection) {
        this.input_.drainTo(collection);
    }

    protected void produce(E e) {
        try {
            this.output_.put(e);
        }
        catch (InterruptedException interruptedException) {
            ReportingUtils.logError(interruptedException);
        }
    }

    protected synchronized boolean stopRequested() {
        return this.stopRequested_;
    }
}

