/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.MultipageTiffReader;
import org.micromanager.acquisition.MultipageTiffWriter;
import org.micromanager.acquisition.OMEMetadata;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.ImageLabelComparator;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaggedImageStorageMultipageTiff
implements TaggedImageStorage {
    public static final String OME_DATE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private JSONObject summaryMetadata_;
    private JSONObject displayAndComments_;
    private boolean newDataSet_;
    private int lastFrameOpenedDataSet_ = -1;
    private String directory_;
    private Thread shutdownHook_;
    private int numPositions_;
    private CachedImages cached_;
    public final boolean omeTiff_;
    private final boolean seperateMetadataFile_;
    private boolean splitByXYPosition_ = true;
    private boolean finished_ = false;
    private boolean expectedImageOrder_ = true;
    private int numChannels_;
    private int numSlices_;
    private String omeXML_ = null;
    private OMEMetadata omeMetadata_;
    private int lastFrame_ = 0;
    private int totalNumImagePlanes_ = 0;
    private HashMap<Integer, FileSet> fileSets_;
    private TreeMap<String, MultipageTiffReader> tiffReadersByLabel_;

    public TaggedImageStorageMultipageTiff(String string, Boolean bl, JSONObject jSONObject) throws IOException {
        this(string, bl, jSONObject, MMStudioMainFrame.getInstance().getMetadataFileWithMultipageTiff(), MMStudioMainFrame.getInstance().getSeperateFilesForPositionsMPTiff());
    }

    public TaggedImageStorageMultipageTiff(String string, boolean bl, JSONObject jSONObject, boolean bl2, boolean bl3) throws IOException {
        this.omeTiff_ = true;
        this.seperateMetadataFile_ = bl2;
        this.splitByXYPosition_ = bl3;
        this.newDataSet_ = bl;
        this.directory_ = string;
        this.tiffReadersByLabel_ = new TreeMap(new ImageLabelComparator());
        this.cached_ = new CachedImages();
        this.setSummaryMetadata(jSONObject);
        if (!this.newDataSet_) {
            this.openExistingDataSet();
        }
        this.shutdownHook_ = new Thread(){

            public void run() {
                TaggedImageStorageMultipageTiff.this.finished();
                TaggedImageStorageMultipageTiff.this.writeDisplaySettings();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook_);
    }

    private void processSummaryMD() {
        this.displayAndComments_ = VirtualAcquisitionDisplay.getDisplaySettingsFromSummary(this.summaryMetadata_);
        try {
            this.numPositions_ = MDUtils.getNumPositions(this.summaryMetadata_);
            if (this.numPositions_ <= 0) {
                this.numPositions_ = 1;
            }
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
            this.numPositions_ = 1;
        }
        try {
            this.numChannels_ = MDUtils.getNumChannels(this.summaryMetadata_);
            this.numSlices_ = MDUtils.getNumSlices(this.summaryMetadata_);
            this.totalNumImagePlanes_ = this.numChannels_ * MDUtils.getNumFrames(this.summaryMetadata_) * this.numPositions_ * this.numSlices_;
        }
        catch (Exception exception) {
            ReportingUtils.logError("Error estimating total number of image planes");
            this.totalNumImagePlanes_ = 1;
        }
    }

    boolean slicesFirst() {
        return ((ImageLabelComparator)this.tiffReadersByLabel_.comparator()).getSlicesFirst();
    }

    boolean timeFirst() {
        return ((ImageLabelComparator)this.tiffReadersByLabel_.comparator()).getTimeFirst();
    }

    private void openExistingDataSet() throws IOException {
        MultipageTiffReader multipageTiffReader = null;
        File file = new File(this.directory_);
        for (File file2 : file.listFiles()) {
            if (!file2.getName().endsWith(".tif") && !file2.getName().endsWith(".TIF")) continue;
            multipageTiffReader = new MultipageTiffReader(file2);
            Set<String> set = multipageTiffReader.getIndexKeys();
            for (String string : set) {
                this.tiffReadersByLabel_.put(string, multipageTiffReader);
                int n = Integer.parseInt(string.split("_")[2]);
                this.lastFrameOpenedDataSet_ = Math.max(n, this.lastFrameOpenedDataSet_);
            }
        }
        try {
            this.setSummaryMetadata(multipageTiffReader.getSummaryMetadata());
            this.numPositions_ = MDUtils.getNumPositions(this.summaryMetadata_);
            this.displayAndComments_ = multipageTiffReader.getDisplayAndComments();
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
        }
    }

    @Override
    public TaggedImage getImage(int n, int n2, int n3, int n4) {
        String string = MDUtils.generateLabel(n, n2, n3, n4);
        TaggedImage taggedImage = this.cached_.get(string);
        if (taggedImage != null) {
            return taggedImage;
        }
        if (!this.tiffReadersByLabel_.containsKey(string)) {
            return null;
        }
        return this.tiffReadersByLabel_.get(string).readImage(string);
    }

    @Override
    public JSONObject getImageTags(int n, int n2, int n3, int n4) {
        String string = MDUtils.generateLabel(n, n2, n3, n4);
        TaggedImage taggedImage = this.cached_.get(string);
        if (taggedImage != null) {
            return taggedImage.tags;
        }
        if (!this.tiffReadersByLabel_.containsKey(string)) {
            return null;
        }
        return this.tiffReadersByLabel_.get((Object)string).readImage((String)string).tags;
    }

    @Override
    public void putImage(TaggedImage taggedImage) throws MMException {
        int n;
        if (!this.newDataSet_) {
            throw new MMException("This ImageFileManager is read-only.");
        }
        int n2 = 0;
        if (this.splitByXYPosition_) {
            try {
                n2 = MDUtils.getPositionIndex(taggedImage.tags);
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError(jSONException);
            }
        }
        String string = MDUtils.getLabel(taggedImage.tags);
        if (this.fileSets_ == null) {
            try {
                this.fileSets_ = new HashMap();
                JavaUtils.createDirectory(this.directory_);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        if (this.omeTiff_ && this.omeMetadata_ == null) {
            this.omeMetadata_ = new OMEMetadata(this);
        }
        if (this.fileSets_.get(n2) == null) {
            this.fileSets_.put(n2, new FileSet(taggedImage.tags, this));
        }
        FileSet fileSet = this.fileSets_.get(n2);
        try {
            fileSet.writeImage(taggedImage);
        }
        catch (IOException iOException) {
            ReportingUtils.showError("problem writing image to file");
        }
        this.tiffReadersByLabel_.put(string, fileSet.getCurrentReader());
        try {
            n = MDUtils.getFrameIndex(taggedImage.tags);
        }
        catch (JSONException jSONException) {
            n = 0;
        }
        this.lastFrameOpenedDataSet_ = Math.max(n, this.lastFrameOpenedDataSet_);
        this.cached_.add(taggedImage, string);
    }

    @Override
    public Set<String> imageKeys() {
        return this.tiffReadersByLabel_.keySet();
    }

    @Override
    public synchronized void finished() {
        if (this.finished_) {
            return;
        }
        this.newDataSet_ = false;
        try {
            if (this.fileSets_ != null) {
                for (FileSet fileSet : this.fileSets_.values()) {
                    fileSet.finishAbortedAcqIfNeeded();
                }
                for (FileSet fileSet : this.fileSets_.values()) {
                    fileSet.finished();
                }
            }
        }
        catch (IOException iOException) {
            ReportingUtils.logError(iOException);
        }
        this.finished_ = true;
    }

    @Override
    public boolean isFinished() {
        return !this.newDataSet_;
    }

    @Override
    public void setSummaryMetadata(JSONObject jSONObject) {
        this.summaryMetadata_ = jSONObject;
        if (this.summaryMetadata_ != null) {
            try {
                boolean bl = this.summaryMetadata_.getBoolean("SlicesFirst");
                boolean bl2 = this.summaryMetadata_.getBoolean("TimeFirst");
                TreeMap<String, MultipageTiffReader> treeMap = this.tiffReadersByLabel_;
                this.tiffReadersByLabel_ = new TreeMap(new ImageLabelComparator(bl, bl2));
                this.tiffReadersByLabel_.putAll(treeMap);
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Couldn't find SlicesFirst or TimeFirst in summary metadata");
            }
            if (this.summaryMetadata_ != null && this.summaryMetadata_.length() > 0) {
                this.processSummaryMD();
            }
        }
    }

    @Override
    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    @Override
    public JSONObject getDisplayAndComments() {
        return this.displayAndComments_;
    }

    @Override
    public void setDisplayAndComments(JSONObject jSONObject) {
        this.displayAndComments_ = jSONObject;
    }

    @Override
    public void writeDisplaySettings() {
        for (MultipageTiffReader multipageTiffReader : new HashSet<MultipageTiffReader>(this.tiffReadersByLabel_.values())) {
            try {
                multipageTiffReader.rewriteDisplaySettings(this.displayAndComments_.getJSONArray("Channels"));
                multipageTiffReader.rewriteComments(this.displayAndComments_.getJSONObject("Comments"));
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Error writing display settings");
            }
            catch (IOException iOException) {
                ReportingUtils.logError(iOException);
            }
        }
    }

    @Override
    public void close() {
        this.shutdownHook_.run();
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook_);
        for (MultipageTiffReader multipageTiffReader : new HashSet<MultipageTiffReader>(this.tiffReadersByLabel_.values())) {
            try {
                multipageTiffReader.close();
            }
            catch (IOException iOException) {
                ReportingUtils.logError(iOException);
            }
        }
    }

    @Override
    public String getDiskLocation() {
        return this.directory_;
    }

    @Override
    public int lastAcquiredFrame() {
        if (this.newDataSet_) {
            return this.lastFrame_;
        }
        return this.lastFrameOpenedDataSet_;
    }

    @Override
    public long getDataSetSize() {
        File file = new File(this.directory_);
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                for (File file3 : file2.listFiles()) {
                    linkedList.add(file2);
                }
                continue;
            }
            linkedList.add(file2);
        }
        long l = 0L;
        for (File file2 : linkedList) {
            l += file2.length();
        }
        return l;
    }

    public boolean hasExpectedImageOrder() {
        return this.expectedImageOrder_;
    }

    private class CachedImages {
        private static final int NUM_TO_CACHE = 10;
        private LinkedList<TaggedImage> images = new LinkedList();
        private LinkedList<String> labels = new LinkedList();

        public void add(TaggedImage taggedImage, String string) {
            this.images.addFirst(taggedImage);
            this.labels.addFirst(string);
            while (this.images.size() > 10) {
                this.images.removeLast();
                this.labels.removeLast();
            }
        }

        public TaggedImage get(String string) {
            int n = this.labels.indexOf(string);
            return n == -1 ? null : this.images.get(n);
        }
    }

    private class FileSet {
        private LinkedList<MultipageTiffWriter> tiffWriters_ = new LinkedList();
        private FileWriter mdWriter_;
        private String baseFilename_;
        private String currentTiffFilename_;
        private String metadataFileFullPath_;
        private boolean finished_ = false;
        private int ifdCount_ = 0;
        private TaggedImageStorageMultipageTiff mpTiff_;
        int nextExpectedChannel_ = 0;
        int nextExpectedSlice_ = 0;
        int nextExpectedFrame_ = 0;

        public FileSet(JSONObject jSONObject, TaggedImageStorageMultipageTiff taggedImageStorageMultipageTiff2) {
            this.mpTiff_ = taggedImageStorageMultipageTiff2;
            this.baseFilename_ = this.createBaseFilename(jSONObject);
            this.currentTiffFilename_ = this.baseFilename_ + (TaggedImageStorageMultipageTiff.this.omeTiff_ ? ".ome.tif" : ".tif");
            this.tiffWriters_.add(new MultipageTiffWriter(TaggedImageStorageMultipageTiff.this.directory_, this.currentTiffFilename_, TaggedImageStorageMultipageTiff.this.summaryMetadata_, taggedImageStorageMultipageTiff2));
            try {
                if (TaggedImageStorageMultipageTiff.this.seperateMetadataFile_) {
                    this.startMetadataFile();
                }
            }
            catch (JSONException jSONException) {
                ReportingUtils.showError("Problem with summary metadata");
            }
        }

        public void finished() throws IOException {
            if (this.finished_) {
                return;
            }
            try {
                if (TaggedImageStorageMultipageTiff.this.seperateMetadataFile_) {
                    this.finishMetadataFile();
                }
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Problem finishing metadata.txt");
            }
            if (TaggedImageStorageMultipageTiff.this.omeXML_ == null) {
                TaggedImageStorageMultipageTiff.this.omeXML_ = TaggedImageStorageMultipageTiff.this.omeMetadata_.toString();
            }
            for (MultipageTiffWriter multipageTiffWriter : this.tiffWriters_) {
                multipageTiffWriter.close(TaggedImageStorageMultipageTiff.this.omeXML_);
            }
            this.finished_ = true;
        }

        public MultipageTiffReader getCurrentReader() {
            return this.tiffWriters_.getLast().getReader();
        }

        public void writeImage(TaggedImage taggedImage) throws IOException {
            if (!this.tiffWriters_.getLast().hasSpaceToWrite(taggedImage, TaggedImageStorageMultipageTiff.this.omeTiff_ ? this.estimateOMEMDSize() : 0)) {
                this.currentTiffFilename_ = this.baseFilename_ + "_" + this.tiffWriters_.size() + (TaggedImageStorageMultipageTiff.this.omeTiff_ ? ".ome.tif" : ".tif");
                this.ifdCount_ = 0;
                this.tiffWriters_.add(new MultipageTiffWriter(TaggedImageStorageMultipageTiff.this.directory_, this.currentTiffFilename_, TaggedImageStorageMultipageTiff.this.summaryMetadata_, this.mpTiff_));
            }
            try {
                taggedImage.tags.put("FileName", this.currentTiffFilename_);
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Error adding filename to metadata");
            }
            this.tiffWriters_.getLast().writeImage(taggedImage);
            if (TaggedImageStorageMultipageTiff.this.expectedImageOrder_) {
                if (TaggedImageStorageMultipageTiff.this.splitByXYPosition_) {
                    this.checkForExpectedImageOrder(taggedImage.tags);
                } else {
                    TaggedImageStorageMultipageTiff.this.expectedImageOrder_ = false;
                }
            }
            if (TaggedImageStorageMultipageTiff.this.omeTiff_) {
                try {
                    TaggedImageStorageMultipageTiff.this.omeMetadata_.addImageTagsToOME(taggedImage.tags, this.ifdCount_, this.baseFilename_, this.currentTiffFilename_);
                }
                catch (Exception exception) {
                    ReportingUtils.logError("Problem writing OME metadata");
                }
            }
            try {
                int n = MDUtils.getFrameIndex(taggedImage.tags);
                TaggedImageStorageMultipageTiff.this.lastFrame_ = Math.max(n, TaggedImageStorageMultipageTiff.this.lastFrame_);
            }
            catch (JSONException jSONException) {
                ReportingUtils.showError("Couldn't find frame index in image tags");
            }
            try {
                if (TaggedImageStorageMultipageTiff.this.seperateMetadataFile_) {
                    this.writeToMetadataFile(taggedImage.tags);
                }
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Problem with image metadata");
            }
            ++this.ifdCount_;
        }

        private int estimateOMEMDSize() {
            return TaggedImageStorageMultipageTiff.this.totalNumImagePlanes_ * TaggedImageStorageMultipageTiff.this.omeMetadata_.getOMEMetadataImageLength() + TaggedImageStorageMultipageTiff.this.numPositions_ * TaggedImageStorageMultipageTiff.this.omeMetadata_.getOMEMetadataBaseLenght();
        }

        private void writeToMetadataFile(JSONObject jSONObject) throws JSONException {
            try {
                this.mdWriter_.write(",\r\n\"FrameKey-" + MDUtils.getFrameIndex(jSONObject) + "-" + MDUtils.getChannelIndex(jSONObject) + "-" + MDUtils.getSliceIndex(jSONObject) + "\": ");
                this.mdWriter_.write(jSONObject.toString(2));
            }
            catch (IOException iOException) {
                ReportingUtils.logError("Problem writing to metadata.txt file");
            }
        }

        private void startMetadataFile() throws JSONException {
            this.metadataFileFullPath_ = TaggedImageStorageMultipageTiff.this.directory_ + "/" + this.baseFilename_ + "_metadata.txt";
            try {
                this.mdWriter_ = new FileWriter(this.metadataFileFullPath_);
                this.mdWriter_.write("{\r\n");
                this.mdWriter_.write("\"Summary\": ");
                this.mdWriter_.write(TaggedImageStorageMultipageTiff.this.summaryMetadata_.toString(2));
            }
            catch (IOException iOException) {
                ReportingUtils.logError("Problem creating metadata.txt file");
            }
        }

        private void finishMetadataFile() throws JSONException {
            try {
                this.mdWriter_.write("\r\n}\r\n");
                this.mdWriter_.close();
            }
            catch (IOException iOException) {
                ReportingUtils.logError("Problem creating metadata.txt file");
            }
        }

        private String createBaseFilename(JSONObject jSONObject) {
            String string;
            String string2 = "";
            try {
                string = TaggedImageStorageMultipageTiff.this.summaryMetadata_.getString("Prefix");
                string2 = string.length() == 0 ? "MMImages" : string + "_MMImages";
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Can't find Prefix in summary metadata");
                string2 = "MMImages";
            }
            if (TaggedImageStorageMultipageTiff.this.numPositions_ > 1 && TaggedImageStorageMultipageTiff.this.splitByXYPosition_) {
                try {
                    string = MDUtils.getPositionName(jSONObject);
                }
                catch (JSONException jSONException) {
                    ReportingUtils.logError("Couldn't find position name in image metadata");
                    try {
                        string = "pos" + MDUtils.getPositionIndex(jSONObject);
                    }
                    catch (JSONException jSONException2) {
                        string = "pos0";
                        ReportingUtils.showError("Couldnt find position index in image metadata");
                    }
                }
                string2 = string2 + "_" + string;
            }
            return string2;
        }

        private void finishAbortedAcqIfNeeded() {
            if (TaggedImageStorageMultipageTiff.this.expectedImageOrder_ && TaggedImageStorageMultipageTiff.this.splitByXYPosition_ && !TaggedImageStorageMultipageTiff.this.timeFirst()) {
                try {
                    this.completeFrameWithBlankImages(TaggedImageStorageMultipageTiff.this.lastAcquiredFrame());
                }
                catch (Exception exception) {
                    ReportingUtils.logError("Problem finishing aborted acq with blank images");
                }
            }
        }

        private void completeFrameWithBlankImages(int n) throws JSONException, MMScriptException {
            int n2 = MDUtils.getNumFrames(TaggedImageStorageMultipageTiff.this.summaryMetadata_);
            int n3 = MDUtils.getNumSlices(TaggedImageStorageMultipageTiff.this.summaryMetadata_);
            int n4 = MDUtils.getNumChannels(TaggedImageStorageMultipageTiff.this.summaryMetadata_);
            if (n2 > n + 1) {
                TreeSet<String> treeSet = new TreeSet<String>();
                for (MultipageTiffWriter object2 : this.tiffWriters_) {
                    treeSet.addAll(object2.getIndexMap().keySet());
                    object2.setAbortedNumFrames(n + 1);
                }
                int n5 = MDUtils.getIndices((String)treeSet.first())[3];
                if (TaggedImageStorageMultipageTiff.this.omeTiff_) {
                    TaggedImageStorageMultipageTiff.this.omeMetadata_.setNumFrames(n5, n + 1);
                }
                TreeSet<String> treeSet2 = new TreeSet<String>();
                for (int iterator = 0; iterator < n4; ++iterator) {
                    for (int i = 0; i < n3; ++i) {
                        treeSet2.add(MDUtils.generateLabel(iterator, i, n, n5));
                    }
                }
                treeSet2.removeAll(treeSet);
                try {
                    for (String string : treeSet2) {
                        this.tiffWriters_.getLast().writeBlankImage(string);
                        if (!TaggedImageStorageMultipageTiff.this.omeTiff_) continue;
                        JSONObject jSONObject = new JSONObject();
                        int n6 = Integer.parseInt(string.split("_")[0]);
                        int n7 = Integer.parseInt(string.split("_")[1]);
                        MDUtils.setChannelIndex(jSONObject, n6);
                        MDUtils.setFrameIndex(jSONObject, n);
                        MDUtils.setSliceIndex(jSONObject, n7);
                        TaggedImageStorageMultipageTiff.this.omeMetadata_.addImageTagsToOME(jSONObject, this.ifdCount_, this.baseFilename_, this.currentTiffFilename_);
                    }
                }
                catch (IOException iOException) {
                    ReportingUtils.logError("problem writing dummy image");
                }
            }
        }

        void checkForExpectedImageOrder(JSONObject jSONObject) {
            try {
                int n = MDUtils.getChannelIndex(jSONObject);
                int n2 = MDUtils.getFrameIndex(jSONObject);
                int n3 = MDUtils.getSliceIndex(jSONObject);
                if (n3 != this.nextExpectedSlice_ || n != this.nextExpectedChannel_ || n2 != this.nextExpectedFrame_) {
                    TaggedImageStorageMultipageTiff.this.expectedImageOrder_ = false;
                }
                if (TaggedImageStorageMultipageTiff.this.slicesFirst()) {
                    this.nextExpectedSlice_ = n3 + 1;
                    if (this.nextExpectedSlice_ == TaggedImageStorageMultipageTiff.this.numSlices_) {
                        this.nextExpectedSlice_ = 0;
                        this.nextExpectedChannel_ = n + 1;
                        if (this.nextExpectedChannel_ == TaggedImageStorageMultipageTiff.this.numChannels_) {
                            this.nextExpectedChannel_ = 0;
                            this.nextExpectedFrame_ = n2 + 1;
                        }
                    }
                } else {
                    this.nextExpectedChannel_ = n + 1;
                    if (this.nextExpectedChannel_ == TaggedImageStorageMultipageTiff.this.numChannels_) {
                        this.nextExpectedChannel_ = 0;
                        this.nextExpectedSlice_ = n3 + 1;
                        if (this.nextExpectedSlice_ == TaggedImageStorageMultipageTiff.this.numSlices_) {
                            this.nextExpectedSlice_ = 0;
                            this.nextExpectedFrame_ = n2 + 1;
                        }
                    }
                }
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Couldnt find channel, slice, or frame index in Image tags");
                TaggedImageStorageMultipageTiff.this.expectedImageOrder_ = false;
            }
        }
    }
}

