/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import com.swtdesigner.SwingResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.json.JSONObject;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.internalinterfaces.DisplayControls;
import org.micromanager.utils.ReportingUtils;

public class SimpleWindowControls
extends DisplayControls {
    private VirtualAcquisitionDisplay virtAcq_;
    private JButton showFolderButton_;
    private JButton snapButton_;
    private JButton liveButton_;
    private JLabel statusLabel_;

    public SimpleWindowControls(VirtualAcquisitionDisplay virtualAcquisitionDisplay) {
        this.virtAcq_ = virtualAcquisitionDisplay;
        this.initComponents();
        this.showFolderButton_.setEnabled(false);
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(512, 45));
        this.showFolderButton_ = new JButton();
        this.showFolderButton_.setBackground(new Color(255, 255, 255));
        this.showFolderButton_.setIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/folder.png")));
        this.showFolderButton_.setToolTipText("Show containing folder");
        this.showFolderButton_.setFocusable(false);
        this.showFolderButton_.setHorizontalTextPosition(0);
        this.showFolderButton_.setMaximumSize(new Dimension(30, 28));
        this.showFolderButton_.setMinimumSize(new Dimension(30, 28));
        this.showFolderButton_.setPreferredSize(new Dimension(30, 28));
        this.showFolderButton_.setVerticalTextPosition(3);
        this.showFolderButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleWindowControls.this.showFolderButtonActionPerformed();
            }
        });
        JButton jButton = new JButton();
        jButton.setBackground(new Color(255, 255, 255));
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/disk.png")));
        jButton.setToolTipText("Save as...");
        jButton.setFocusable(false);
        jButton.setHorizontalTextPosition(0);
        jButton.setMaximumSize(new Dimension(30, 28));
        jButton.setMinimumSize(new Dimension(30, 28));
        jButton.setPreferredSize(new Dimension(30, 28));
        jButton.setVerticalTextPosition(3);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleWindowControls.this.saveButtonActionPerformed();
            }
        });
        this.snapButton_ = new JButton();
        this.snapButton_.setFocusable(false);
        this.snapButton_.setIconTextGap(6);
        this.snapButton_.setText("Snap");
        this.snapButton_.setMinimumSize(new Dimension(99, 28));
        this.snapButton_.setPreferredSize(new Dimension(99, 28));
        this.snapButton_.setMaximumSize(new Dimension(99, 28));
        this.snapButton_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/camera.png"));
        this.snapButton_.setFont(new Font("Arial", 0, 10));
        this.snapButton_.setToolTipText("Snap single image");
        this.snapButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.getInstance().doSnap();
            }
        });
        this.liveButton_ = new JButton();
        this.liveButton_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/camera_go.png"));
        this.liveButton_.setIconTextGap(6);
        this.liveButton_.setText("Live");
        this.liveButton_.setMinimumSize(new Dimension(99, 28));
        this.liveButton_.setPreferredSize(new Dimension(99, 28));
        this.liveButton_.setMaximumSize(new Dimension(99, 28));
        this.liveButton_.setFocusable(false);
        this.liveButton_.setToolTipText("Continuous live view");
        this.liveButton_.setFont(new Font("Arial", 0, 10));
        this.liveButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleWindowControls.this.liveButtonAction();
            }
        });
        JButton jButton2 = new JButton("Album");
        jButton2.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/arrow_right.png"));
        jButton2.setIconTextGap(6);
        jButton2.setToolTipText("Add current image to album");
        jButton2.setFocusable(false);
        jButton2.setMaximumSize(new Dimension(90, 28));
        jButton2.setMinimumSize(new Dimension(90, 28));
        jButton2.setPreferredSize(new Dimension(90, 28));
        jButton2.setFont(new Font("Arial", 0, 10));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleWindowControls.this.addToSeriesButtonActionPerformed();
            }
        });
        this.statusLabel_ = new JLabel("                                            ");
        this.statusLabel_.setFocusable(false);
        this.statusLabel_.setFont(new Font("Lucida Grande", 0, 10));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        jPanel.add(this.showFolderButton_);
        jPanel.add(new JLabel(" "));
        jPanel.add(jButton);
        jPanel.add(new JLabel(" "));
        jPanel.add(this.snapButton_);
        jPanel.add(new JLabel(" "));
        jPanel.add(this.liveButton_);
        jPanel.add(new JLabel(" "));
        jPanel.add(jButton2);
        jPanel.add(new JLabel(" "));
        jPanel2.add(new JLabel(" "));
        jPanel2.add((Component)this.statusLabel_, "Center");
    }

    private void showFolderButtonActionPerformed() {
        this.virtAcq_.showFolder();
    }

    private void addToSeriesButtonActionPerformed() {
        try {
            MMStudioMainFrame mMStudioMainFrame = MMStudioMainFrame.getInstance();
            mMStudioMainFrame.copyFromLiveModeToAlbum(this.virtAcq_);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    private void liveButtonAction() {
        MMStudioMainFrame.getInstance().enableLiveMode(!MMStudioMainFrame.getInstance().isLiveModeOn());
    }

    private void saveButtonActionPerformed() {
        new Thread(){

            public void run() {
                SimpleWindowControls.this.virtAcq_.saveAs(false);
            }
        }.start();
    }

    public void newImageUpdate(JSONObject jSONObject) {
    }

    public void imagesOnDiskUpdate(boolean bl) {
    }

    public void acquiringImagesUpdate(boolean bl) {
        this.snapButton_.setEnabled(!bl);
        this.liveButton_.setIcon(bl ? SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/cancel.png") : SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/camera_go.png"));
        this.liveButton_.setText(bl ? "Stop Live" : "Live");
        if (!bl) {
            this.statusLabel_.setText("");
        }
    }

    public void setStatusLabel(String string) {
        this.statusLabel_.setText(string);
    }
}

