/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.ImagePlus;
import ij.gui.ImageWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import mmcorej.TaggedImage;
import org.jdesktop.layout.GroupLayout;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.AcquisitionVirtualStack;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.ImageCache;
import org.micromanager.graph.ContrastPanel;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ImageFocusListener;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.ReportingUtils;

public class MetadataPanel
extends JPanel
implements ImageFocusListener {
    private JSplitPane CommentsSplitPane;
    private JLabel imageCommentsLabel;
    private JPanel imageCommentsPanel;
    private JScrollPane imageCommentsScrollPane;
    private JTextArea imageCommentsTextArea;
    private JPanel imageMetadataScrollPane;
    private JTable imageMetadataTable;
    private JScrollPane imageMetadataTableScrollPane;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSplitPane metadataSplitPane;
    private JCheckBox showUnchangingPropertiesCheckbox;
    private JLabel summaryCommentsLabel;
    private JPanel summaryCommentsPane;
    private JScrollPane summaryCommentsScrollPane;
    private JTextArea summaryCommentsTextArea;
    private JPanel summaryMetadataPanel;
    private JScrollPane summaryMetadataScrollPane;
    private JTable summaryMetadataTable;
    private JTabbedPane tabbedPane;
    private ContrastPanel contrastPanel_;
    private final MetadataTableModel imageMetadataModel_;
    private final MetadataTableModel summaryMetadataModel_;
    private final String[] columnNames_ = new String[]{"Property", "Value"};
    private boolean showUnchangingKeys_;
    private ImageWindow lastWindow_;
    private VirtualAcquisitionDisplay currentDisplay_;

    public MetadataPanel() {
        this.imageMetadataModel_ = new MetadataTableModel();
        this.summaryMetadataModel_ = new MetadataTableModel();
        this.makeContrastPanel();
        this.initialize();
        GUIUtils.registerImageFocusListener(this);
        this.imageMetadataTable.setModel(this.imageMetadataModel_);
        this.summaryMetadataTable.setModel(this.summaryMetadataModel_);
        this.addTextChangeListeners();
        this.addFocusListeners();
    }

    private void makeContrastPanel() {
        this.contrastPanel_ = new ContrastPanel(this);
        this.contrastPanel_.setFont(new Font("", 0, 10));
    }

    private void initialize() {
        this.tabbedPane = new JTabbedPane();
        this.metadataSplitPane = new JSplitPane();
        this.imageMetadataScrollPane = new JPanel();
        this.imageMetadataTableScrollPane = new JScrollPane();
        this.imageMetadataTable = new JTable();
        this.showUnchangingPropertiesCheckbox = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.summaryMetadataPanel = new JPanel();
        this.summaryMetadataScrollPane = new JScrollPane();
        this.summaryMetadataTable = new JTable();
        this.jLabel3 = new JLabel();
        this.CommentsSplitPane = new JSplitPane();
        this.summaryCommentsPane = new JPanel();
        this.summaryCommentsLabel = new JLabel();
        this.summaryCommentsScrollPane = new JScrollPane();
        this.summaryCommentsTextArea = new JTextArea();
        this.imageCommentsPanel = new JPanel();
        this.imageCommentsLabel = new JLabel();
        this.imageCommentsScrollPane = new JScrollPane();
        this.imageCommentsTextArea = new JTextArea();
        this.tabbedPane.setFocusable(false);
        this.tabbedPane.setPreferredSize(new Dimension(400, 640));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MetadataPanel.this.tabbedPaneStateChanged(changeEvent);
            }
        });
        this.tabbedPane.addTab("Contrast", this.contrastPanel_);
        this.metadataSplitPane.setBorder(null);
        this.metadataSplitPane.setOrientation(0);
        this.imageMetadataTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Property", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.imageMetadataTable.setToolTipText("Metadata tags for each individual image");
        this.imageMetadataTable.setDebugGraphicsOptions(-1);
        this.imageMetadataTable.setDoubleBuffered(true);
        this.imageMetadataTableScrollPane.setViewportView(this.imageMetadataTable);
        this.showUnchangingPropertiesCheckbox.setText("Show unchanging properties");
        this.showUnchangingPropertiesCheckbox.setToolTipText("Show/hide properties that are the same for all images in the acquisition");
        this.showUnchangingPropertiesCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetadataPanel.this.showUnchangingPropertiesCheckboxActionPerformed(actionEvent);
            }
        });
        this.jLabel2.setText("Per-image properties");
        GroupLayout groupLayout = new GroupLayout((Container)this.imageMetadataScrollPane);
        this.imageMetadataScrollPane.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.imageMetadataTableScrollPane, -1, 620, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0, 308, Short.MAX_VALUE).add((Component)this.showUnchangingPropertiesCheckbox)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.showUnchangingPropertiesCheckbox).add((Component)this.jLabel2)).addPreferredGap(0).add((Component)this.imageMetadataTableScrollPane, -1, 517, Short.MAX_VALUE)));
        this.metadataSplitPane.setRightComponent(this.imageMetadataScrollPane);
        this.summaryMetadataPanel.setMinimumSize(new Dimension(0, 100));
        this.summaryMetadataPanel.setPreferredSize(new Dimension(539, 100));
        this.summaryMetadataScrollPane.setMinimumSize(new Dimension(0, 0));
        this.summaryMetadataScrollPane.setPreferredSize(new Dimension(454, 80));
        this.summaryMetadataTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Property", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.summaryMetadataTable.setToolTipText("Metadata tags for the whole acquisition");
        this.summaryMetadataScrollPane.setViewportView(this.summaryMetadataTable);
        this.jLabel3.setText("Acquisition properties");
        GroupLayout groupLayout2 = new GroupLayout((Container)this.summaryMetadataPanel);
        this.summaryMetadataPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (Component)this.summaryMetadataScrollPane, -1, 620, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabel3).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabel3).add(4, 4, 4).add((Component)this.summaryMetadataScrollPane, -1, -1, Short.MAX_VALUE)));
        this.metadataSplitPane.setLeftComponent(this.summaryMetadataPanel);
        this.tabbedPane.addTab("Metadata", this.metadataSplitPane);
        this.CommentsSplitPane.setBorder(null);
        this.CommentsSplitPane.setDividerLocation(200);
        this.CommentsSplitPane.setOrientation(0);
        this.summaryCommentsLabel.setText("Acquisition comments:");
        this.summaryCommentsTextArea.setColumns(20);
        this.summaryCommentsTextArea.setLineWrap(true);
        this.summaryCommentsTextArea.setRows(1);
        this.summaryCommentsTextArea.setTabSize(3);
        this.summaryCommentsTextArea.setToolTipText("Enter your comments for the whole acquisition here");
        this.summaryCommentsTextArea.setWrapStyleWord(true);
        this.summaryCommentsScrollPane.setViewportView(this.summaryCommentsTextArea);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.summaryCommentsPane);
        this.summaryCommentsPane.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.summaryCommentsLabel).addContainerGap(491, Short.MAX_VALUE)).add((Component)this.summaryCommentsScrollPane, -1, 620, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.summaryCommentsLabel).addPreferredGap(0).add((Component)this.summaryCommentsScrollPane, -1, 177, Short.MAX_VALUE)));
        this.CommentsSplitPane.setLeftComponent(this.summaryCommentsPane);
        this.imageCommentsPanel.setPreferredSize(new Dimension(500, 300));
        this.imageCommentsLabel.setText("Per-image comments:");
        this.imageCommentsTextArea.setColumns(20);
        this.imageCommentsTextArea.setLineWrap(true);
        this.imageCommentsTextArea.setRows(1);
        this.imageCommentsTextArea.setTabSize(3);
        this.imageCommentsTextArea.setToolTipText("Comments for each image may be entered here.");
        this.imageCommentsTextArea.setWrapStyleWord(true);
        this.imageCommentsScrollPane.setViewportView(this.imageCommentsTextArea);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.imageCommentsPanel);
        this.imageCommentsPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.imageCommentsLabel).add(400, 400, 400)).add((Component)this.imageCommentsScrollPane, -1, 620, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.imageCommentsLabel).add(0, 0, 0).add((Component)this.imageCommentsScrollPane, -1, 429, Short.MAX_VALUE)));
        this.CommentsSplitPane.setRightComponent(this.imageCommentsPanel);
        this.tabbedPane.addTab("Comments", this.CommentsSplitPane);
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((Component)this.tabbedPane, -1, 625, Short.MAX_VALUE).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((Component)this.tabbedPane, -1, 680, Short.MAX_VALUE).addContainerGap()));
    }

    private void showUnchangingPropertiesCheckboxActionPerformed(ActionEvent actionEvent) {
        this.showUnchangingKeys_ = this.showUnchangingPropertiesCheckbox.isSelected();
        this.imageChangedUpdate(this.currentDisplay_);
    }

    private void tabbedPaneStateChanged(ChangeEvent changeEvent) {
        this.imageChangedUpdate(this.currentDisplay_);
    }

    private void addFocusListeners() {
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                if (MetadataPanel.this.currentDisplay_ != null) {
                    ((MetadataPanel)MetadataPanel.this).currentDisplay_.imageCache_.writeDisplaySettings();
                }
            }
        };
        this.summaryCommentsTextArea.addFocusListener(focusListener);
        this.imageCommentsTextArea.addFocusListener(focusListener);
    }

    private void addTextChangeListeners() {
        this.summaryCommentsTextArea.getDocument().addDocumentListener(new DocumentListener(){

            private void handleChange() {
                if (MetadataPanel.this.currentDisplay_ != null) {
                    MetadataPanel.this.writeSummaryComments();
                }
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.handleChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.handleChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.handleChange();
            }
        });
        this.imageCommentsTextArea.getDocument().addDocumentListener(new DocumentListener(){

            private void handleChange() {
                if (MetadataPanel.this.currentDisplay_ != null) {
                    MetadataPanel.this.writeImageComments();
                }
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.handleChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.handleChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.handleChange();
            }
        });
    }

    private JSONObject selectChangingTags(ImagePlus imagePlus, JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        ImageCache imageCache = this.getCache(imagePlus);
        if (imageCache != null) {
            for (String string : imageCache.getChangingKeys()) {
                if (!jSONObject.has(string)) continue;
                try {
                    jSONObject2.put(string, jSONObject.get(string));
                }
                catch (JSONException jSONException) {
                    try {
                        jSONObject2.put(string, "");
                    }
                    catch (JSONException jSONException2) {
                        ReportingUtils.logError(jSONException2);
                    }
                }
            }
        }
        return jSONObject2;
    }

    private void writeSummaryComments() {
        if (this.currentDisplay_ == null) {
            return;
        }
        this.currentDisplay_.setSummaryComment(this.summaryCommentsTextArea.getText());
    }

    private void writeImageComments() {
        if (this.currentDisplay_ == null) {
            return;
        }
        this.currentDisplay_.setImageComment(this.imageCommentsTextArea.getText());
    }

    private ImageCache getCache(ImagePlus imagePlus) {
        if (VirtualAcquisitionDisplay.getDisplay(imagePlus) != null) {
            return VirtualAcquisitionDisplay.getDisplay((ImagePlus)imagePlus).imageCache_;
        }
        return null;
    }

    public ImageWindow getCurrentWindow() {
        return this.lastWindow_;
    }

    public synchronized void displayChanged(ImageWindow imageWindow) {
        if (imageWindow == this.lastWindow_) {
            return;
        }
        this.lastWindow_ = imageWindow;
        if (imageWindow == null || !(imageWindow instanceof VirtualAcquisitionDisplay.DisplayWindow)) {
            this.currentDisplay_ = null;
            this.contrastPanel_.displayChanged(null);
            this.imageChangedUpdate(this.currentDisplay_);
            return;
        }
        this.currentDisplay_ = this.getVirtualAcquisitionDisplay(imageWindow.getImagePlus());
        this.summaryCommentsTextArea.setText(this.currentDisplay_.getSummaryComment());
        this.imageCommentsTextArea.setText(this.currentDisplay_.getImageComment());
        this.contrastPanel_.displayChanged(this.currentDisplay_);
        this.imageChangedUpdate(this.currentDisplay_);
    }

    public void focusReceived(ImageWindow imageWindow) {
        this.displayChanged(imageWindow);
    }

    private VirtualAcquisitionDisplay getVirtualAcquisitionDisplay(ImagePlus imagePlus) {
        if (imagePlus == null) {
            return null;
        }
        return VirtualAcquisitionDisplay.getDisplay(imagePlus);
    }

    public void imageChangedUpdate(VirtualAcquisitionDisplay virtualAcquisitionDisplay) {
        int n = this.tabbedPane.getSelectedIndex();
        if (virtualAcquisitionDisplay == null || !virtualAcquisitionDisplay.isActiveDisplay()) {
            this.imageMetadataModel_.setMetadata(null);
            this.summaryMetadataModel_.setMetadata(null);
            this.summaryCommentsTextArea.setText("");
            this.imageCommentsTextArea.setText("");
            this.contrastPanel_.imageChanged();
        } else {
            AcquisitionVirtualStack acquisitionVirtualStack;
            this.imageCommentsTextArea.setText(virtualAcquisitionDisplay.getImageComment());
            if (n == 0) {
                this.contrastPanel_.imageChanged();
            }
            if ((acquisitionVirtualStack = virtualAcquisitionDisplay.virtualStack_) != null) {
                int n2 = virtualAcquisitionDisplay.getHyperImage().getCurrentSlice();
                TaggedImage taggedImage = acquisitionVirtualStack.getTaggedImage(n2);
                if (taggedImage == null) {
                    this.imageMetadataModel_.setMetadata(null);
                } else {
                    JSONObject jSONObject = acquisitionVirtualStack.getTaggedImage((int)n2).tags;
                    if (!this.showUnchangingKeys_) {
                        jSONObject = this.selectChangingTags(virtualAcquisitionDisplay.getHyperImage(), jSONObject);
                    }
                    this.imageMetadataModel_.setMetadata(jSONObject);
                }
                this.summaryMetadataModel_.setMetadata(virtualAcquisitionDisplay.getSummaryMetadata());
            } else {
                this.imageMetadataModel_.setMetadata(null);
            }
        }
        if (n == 1 || n == 0 || n == 2) {
            // empty if block
        }
    }

    public ContrastPanel getContrastPanel() {
        return this.contrastPanel_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MetadataTableModel
    extends AbstractTableModel {
        Vector<Vector<String>> data_ = new Vector();

        MetadataTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.data_.size();
        }

        public void addRow(Vector<String> vector) {
            this.data_.add(vector);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public synchronized Object getValueAt(int n, int n2) {
            if (this.data_.size() > n) {
                Vector<String> vector = this.data_.get(n);
                if (vector.size() > n2) {
                    return this.data_.get(n).get(n2);
                }
                return "";
            }
            return "";
        }

        public void clear() {
            this.data_.clear();
        }

        @Override
        public String getColumnName(int n) {
            return MetadataPanel.this.columnNames_[n];
        }

        public synchronized void setMetadata(JSONObject jSONObject) {
            this.clear();
            if (jSONObject != null) {
                Object[] objectArray = MDUtils.getKeys(jSONObject);
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    Vector<String> vector = new Vector<String>();
                    vector.add((String)object);
                    try {
                        vector.add(jSONObject.getString((String)object));
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    this.addRow(vector);
                }
            }
            this.fireTableDataChanged();
        }
    }
}

