/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.awt.Color;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.UUID;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mmcorej.CMMCore;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.AcqControlDlg;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.AcquisitionData;
import org.micromanager.acquisition.MMImageCache;
import org.micromanager.acquisition.MultipageTiffReader;
import org.micromanager.acquisition.TaggedImageStorageDiskDefault;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.acquisition.TaggedImageStorageRam;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.AcquisitionEngine;
import org.micromanager.api.ImageCache;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class MMAcquisition {
    public static final Color[] DEFAULT_COLORS = new Color[]{Color.red, Color.green, Color.blue, Color.pink, Color.orange, Color.yellow};
    private int numFrames_ = 0;
    private int numChannels_ = 0;
    private int numSlices_ = 0;
    private int numPositions_ = 0;
    protected String name_;
    protected int width_ = 0;
    protected int height_ = 0;
    protected int byteDepth_ = 1;
    protected int bitDepth_ = 8;
    protected int multiCamNumCh_ = 1;
    private boolean initialized_ = false;
    private long startTimeMs_;
    private String comment_ = "";
    private String rootDirectory_;
    private VirtualAcquisitionDisplay virtAcq_;
    private final boolean existing_;
    private final boolean virtual_;
    private final boolean show_;
    private JSONArray channelColors_ = new JSONArray();
    private JSONArray channelNames_ = new JSONArray();
    private JSONObject summary_ = new JSONObject();
    private final String NOTINITIALIZED = "Acquisition was not initialized";

    public MMAcquisition(String string, String string2) throws MMScriptException {
        this(string, string2, false, false, false);
    }

    public MMAcquisition(String string, String string2, boolean bl) throws MMScriptException {
        this(string, string2, bl, false, false);
    }

    public MMAcquisition(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws MMScriptException {
        this.name_ = string;
        this.rootDirectory_ = string2;
        this.show_ = bl;
        this.existing_ = bl3;
        this.virtual_ = bl2;
    }

    public MMAcquisition(String string, JSONObject jSONObject, boolean bl, AcquisitionEngine acquisitionEngine) {
        this.name_ = string;
        this.virtual_ = bl;
        this.existing_ = false;
        this.show_ = true;
        try {
            MMImageCache mMImageCache;
            if (jSONObject.has("Directory") && jSONObject.get("Directory").toString().length() > 0) {
                try {
                    String string2 = this.createAcqPath(jSONObject.getString("Directory"), jSONObject.getString("Prefix"));
                    TaggedImageStorage taggedImageStorage = ImageUtils.newImageStorageInstance(string2, true, null);
                    mMImageCache = new MMImageCache(taggedImageStorage);
                    if (!this.virtual_) {
                        mMImageCache.saveAs(new TaggedImageStorageRam(null), true);
                    }
                }
                catch (Exception exception) {
                    ReportingUtils.showError(exception, "Unable to create directory for saving images.");
                    acquisitionEngine.stop(true);
                    Object var5_9 = null;
                    mMImageCache = null;
                }
            } else {
                TaggedImageStorageRam taggedImageStorageRam = new TaggedImageStorageRam(null);
                mMImageCache = new MMImageCache(taggedImageStorageRam);
            }
            mMImageCache.setSummaryMetadata(jSONObject);
            this.virtAcq_ = new VirtualAcquisitionDisplay((ImageCache)mMImageCache, acquisitionEngine);
            mMImageCache.addImageCacheListener(this.virtAcq_);
            this.summary_ = jSONObject;
        }
        catch (JSONException jSONException) {
            ReportingUtils.showError(jSONException);
        }
    }

    private String createAcqPath(String string, String string2) throws Exception {
        File file = JavaUtils.createDirectory(string);
        int n = this.getCurrentMaxDirIndex(file, string2 + "_");
        File file2 = new File(string + "/" + string2 + "_" + (1 + n));
        return file2.getAbsolutePath();
    }

    private int getCurrentMaxDirIndex(File file, String string) throws NumberFormatException {
        int n = 0;
        for (File file2 : file.listFiles()) {
            String string2 = file2.getName();
            if (!string2.startsWith(string)) continue;
            try {
                int n2;
                Pattern pattern = Pattern.compile("\\Q" + string + "\\E" + "(\\d+).*+");
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches() || (n2 = Integer.parseInt(matcher.group(1))) < n) continue;
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public void setImagePhysicalDimensions(int n, int n2, int n3, int n4, int n5) throws MMScriptException {
        if (this.initialized_) {
            throw new MMScriptException("Can't image change dimensions - the acquisition is already initialized");
        }
        this.width_ = n;
        this.height_ = n2;
        this.byteDepth_ = n3;
        this.bitDepth_ = n4;
        this.multiCamNumCh_ = n5;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getByteDepth() {
        return this.byteDepth_;
    }

    public int getBitDepth() {
        return this.bitDepth_;
    }

    public int getMultiCameraNumChannels() {
        return this.multiCamNumCh_;
    }

    public int getFrames() {
        return this.numFrames_;
    }

    public int getChannels() {
        return this.numChannels_;
    }

    public int getSlices() {
        return this.numSlices_;
    }

    public int getPositions() {
        return this.numPositions_;
    }

    public void setDimensions(int n, int n2, int n3) throws MMScriptException {
        this.setDimensions(n, n2, n3, 0);
    }

    public void setDimensions(int n, int n2, int n3, int n4) throws MMScriptException {
        if (this.initialized_) {
            throw new MMScriptException("Can't change dimensions - the acquisition is already initialized");
        }
        this.numFrames_ = n;
        this.numChannels_ = n2;
        this.numSlices_ = n3;
        this.numPositions_ = n4;
    }

    public void setRootDirectory(String string) throws MMScriptException {
        if (this.initialized_) {
            throw new MMScriptException("Can't change root directory - the acquisition is already initialized");
        }
        this.rootDirectory_ = string;
    }

    public void initializeSimpleAcq() throws MMScriptException {
        if (this.initialized_) {
            throw new MMScriptException("Acquisition is already initialized");
        }
        TaggedImageStorageRam taggedImageStorageRam = new TaggedImageStorageRam(null);
        MMImageCache mMImageCache = new MMImageCache(taggedImageStorageRam);
        if (!this.existing_) {
            this.createDefaultAcqSettings(this.name_, mMImageCache);
        }
        MMStudioMainFrame.createSimpleDisplay(this.name_, mMImageCache);
        this.virtAcq_ = MMStudioMainFrame.getSimpleDisplay();
        if (this.show_) {
            this.virtAcq_.show();
        }
        this.initialized_ = true;
    }

    public void initialize() throws MMScriptException {
        int n;
        TaggedImageStorage taggedImageStorage;
        Object object;
        if (this.initialized_) {
            throw new MMScriptException("Acquisition is already initialized");
        }
        String string = this.name_;
        MMImageCache mMImageCache = null;
        if (this.virtual_ && this.existing_) {
            object = this.rootDirectory_ + File.separator + string;
            boolean bl = false;
            try {
                bl = MultipageTiffReader.isMMMultipageTiff((String)object);
                taggedImageStorage = bl ? new TaggedImageStorageMultipageTiff((String)object, false, null) : new TaggedImageStorageDiskDefault((String)object, false, null);
            }
            catch (Exception exception) {
                throw new MMScriptException(exception);
            }
            mMImageCache = new MMImageCache(taggedImageStorage);
        }
        if (this.virtual_ && !this.existing_) {
            object = this.rootDirectory_ + File.separator + string;
            if (new File((String)object).exists()) {
                try {
                    object = this.createAcqPath(this.rootDirectory_, this.name_);
                }
                catch (Exception exception) {
                    throw new MMScriptException("Failed to figure out acq saving path.");
                }
            }
            taggedImageStorage = ImageUtils.newImageStorageInstance((String)object, true, this.summary_);
            mMImageCache = new MMImageCache(taggedImageStorage);
        }
        if (!this.virtual_ && !this.existing_) {
            taggedImageStorage = new TaggedImageStorageRam(null);
            mMImageCache = new MMImageCache(taggedImageStorage);
        }
        if (!this.virtual_ && this.existing_) {
            TaggedImageStorage taggedImageStorage2;
            object = this.rootDirectory_ + File.separator + string;
            try {
                n = MultipageTiffReader.isMMMultipageTiff((String)object) ? 1 : 0;
                taggedImageStorage2 = n != 0 ? new TaggedImageStorageMultipageTiff((String)object, false, null) : new TaggedImageStorageDiskDefault((String)object, false, null);
            }
            catch (Exception exception) {
                throw new MMScriptException(exception);
            }
            System.gc();
            mMImageCache = new MMImageCache(taggedImageStorage2);
            if ((double)taggedImageStorage2.getDataSetSize() > 0.9 * (double)JavaUtils.getAvailableUnusedMemory()) {
                throw new MMScriptException("Not enough room in memory for this data set.\nTry opening as a virtual data set instead.");
            }
            taggedImageStorage = new TaggedImageStorageRam(null);
            mMImageCache.saveAs(taggedImageStorage);
        }
        object = MMStudioMainFrame.getInstance().getCore();
        if (!this.existing_) {
            int n2 = (int)((CMMCore)object).getNumberOfCameraChannels();
            if (n2 > 1) {
                for (n = 0; n < n2; ++n) {
                    if (this.channelNames_.length() >= 1 + n) continue;
                    this.setChannelName(n, ((CMMCore)object).getCameraChannelName(n));
                }
            } else {
                for (n = 0; n < this.numChannels_; ++n) {
                    if (this.channelNames_.length() >= 1 + n) continue;
                    this.setChannelName(n, "Default");
                }
            }
            this.createDefaultAcqSettings(string, mMImageCache);
        }
        if (mMImageCache.getSummaryMetadata() != null) {
            this.virtAcq_ = new VirtualAcquisitionDisplay(mMImageCache, null, string);
            if (this.show_) {
                this.virtAcq_.show();
            }
            this.initialized_ = true;
        }
    }

    private void createDefaultAcqSettings(String string, ImageCache imageCache) {
        String[] stringArray = new String[this.summary_.length()];
        Iterator<String> iterator = this.summary_.keys();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[0] = iterator.next();
            ++n;
        }
        try {
            JSONObject jSONObject = new JSONObject(this.summary_, stringArray);
            CMMCore cMMCore = MMStudioMainFrame.getInstance().getCore();
            jSONObject.put("BitDepth", cMMCore.getImageBitDepth());
            jSONObject.put("Channels", this.numChannels_);
            this.setDefaultChannelTags(jSONObject);
            jSONObject.put("Comment", this.comment_);
            String string2 = null;
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                ReportingUtils.showError(unknownHostException);
            }
            if (string2 != null) {
                jSONObject.put("ComputerName", string2);
            }
            jSONObject.put("Date", new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime()));
            jSONObject.put("Depth", cMMCore.getBytesPerPixel());
            jSONObject.put("Frames", this.numFrames_);
            jSONObject.put("GridColumn", 0);
            jSONObject.put("GridRow", 0);
            jSONObject.put("Height", this.height_);
            int n2 = -1;
            if (this.byteDepth_ == 1) {
                n2 = 0;
            } else if (this.byteDepth_ == 2) {
                n2 = 1;
            } else if (this.byteDepth_ == 8) {
                n2 = 64;
            } else if (this.byteDepth_ == 4 && cMMCore.getNumberOfComponents() == 1L) {
                n2 = 2;
            } else if (this.byteDepth_ == 4 && cMMCore.getNumberOfComponents() == 4L) {
                n2 = 4;
            }
            jSONObject.put("IJType", n2);
            jSONObject.put("MetadataVersion", 10);
            jSONObject.put("MicroManagerVersion", MMStudioMainFrame.getInstance().getVersion());
            jSONObject.put("NumComponents", 1);
            jSONObject.put("Positions", this.numPositions_);
            jSONObject.put("Source", "Micro-Manager");
            jSONObject.put("PixelAspect", 1.0);
            jSONObject.put("PixelSize_um", cMMCore.getPixelSizeUm());
            jSONObject.put("PixelType", (cMMCore.getNumberOfComponents() == 1L ? "GRAY" : "RGB") + 8 * this.byteDepth_);
            jSONObject.put("Slices", this.numSlices_);
            jSONObject.put("SlicesFirst", false);
            jSONObject.put("StartTime", MDUtils.getCurrentTime());
            jSONObject.put("Time", Calendar.getInstance().getTime());
            jSONObject.put("TimeFirst", true);
            jSONObject.put("UserName", System.getProperty("user.name"));
            jSONObject.put("UUID", UUID.randomUUID());
            jSONObject.put("Width", this.width_);
            this.startTimeMs_ = System.currentTimeMillis();
            imageCache.setSummaryMetadata(jSONObject);
        }
        catch (JSONException jSONException) {
            ReportingUtils.showError(jSONException);
        }
    }

    public static int getMultiCamDefaultChannelColor(int n, String string) {
        Preferences preferences = Preferences.userNodeForPackage(AcqControlDlg.class);
        Preferences preferences2 = preferences.node(preferences.absolutePath() + "/" + "ColorSettings");
        int n2 = DEFAULT_COLORS[n % DEFAULT_COLORS.length].getRGB();
        String string2 = MMStudioMainFrame.getInstance().getCore().getChannelGroup();
        if (string2 == null) {
            string2 = "";
        }
        n2 = preferences2.getInt("Color_Camera_" + string, preferences2.getInt("Color_" + string2 + "_" + string, n2));
        return n2;
    }

    private void setDefaultChannelTags(JSONObject jSONObject) {
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        this.channelColors_ = new JSONArray();
        if (this.numChannels_ == 1) {
            try {
                this.channelColors_.put(0, Color.white.getRGB());
                this.channelNames_.put(0, "Default");
                jSONArray2.put(0);
                jSONArray.put(Math.pow(2.0, jSONObject.getInt("BitDepth")) - 1.0);
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError(jSONException);
            }
        } else {
            Integer n = 0;
            while (n < this.numChannels_) {
                try {
                    this.channelColors_.put(MMAcquisition.getMultiCamDefaultChannelColor(n, this.channelNames_.getString(n)));
                }
                catch (JSONException jSONException) {
                    ReportingUtils.logError(jSONException);
                }
                try {
                    this.channelNames_.get(n);
                }
                catch (JSONException jSONException) {
                    try {
                        this.channelNames_.put((int)n, String.valueOf(n));
                    }
                    catch (JSONException jSONException2) {
                        // empty catch block
                    }
                }
                try {
                    jSONArray.put(Math.pow(2.0, jSONObject.getInt("BitDepth")) - 1.0);
                    jSONArray2.put(0);
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n + 1);
            }
        }
        try {
            jSONObject.put("ChColors", this.channelColors_);
            jSONObject.put("ChNames", this.channelNames_);
            jSONObject.put("ChContrastMax", jSONArray);
            jSONObject.put("ChContrastMin", jSONArray2);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    public void insertImage(Object object, int n, int n2, int n3) throws MMScriptException {
        this.insertImage(object, n, n2, n3, 0);
    }

    public void insertImage(Object object, int n, int n2, int n3, int n4) throws MMScriptException {
        if (!this.initialized_) {
            throw new MMScriptException("Acquisition data must be initialized before inserting images");
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("Channel", this.getChannelName(n2));
            jSONObject.put("ChannelIndex", n2);
            jSONObject.put("Frame", n);
            jSONObject.put("Height", this.height_);
            jSONObject.put("PositionIndex", n4);
            if (this.numPositions_ > 1) {
                jSONObject.put("PositionName", "Pos" + n4);
            }
            jSONObject.put("Slice", n3);
            jSONObject.put("SliceIndex", n3);
            jSONObject.put("Width", this.width_);
            MDUtils.setPixelTypeFromByteDepth(jSONObject, this.byteDepth_);
            TaggedImage taggedImage = new TaggedImage(object, jSONObject);
            this.insertImage(taggedImage);
        }
        catch (JSONException jSONException) {
            throw new MMScriptException(jSONException);
        }
    }

    public void insertTaggedImage(TaggedImage taggedImage, int n, int n2, int n3) throws MMScriptException {
        if (!this.initialized_) {
            throw new MMScriptException("Acquisition data must be initialized before inserting images");
        }
        try {
            JSONObject jSONObject = taggedImage.tags;
            jSONObject.put("FrameIndex", n);
            jSONObject.put("Frame", n);
            jSONObject.put("ChannelIndex", n2);
            jSONObject.put("SliceIndex", n3);
            MDUtils.setPixelTypeFromByteDepth(jSONObject, this.byteDepth_);
            jSONObject.put("PositionIndex", 0);
            this.insertImage(taggedImage);
        }
        catch (JSONException jSONException) {
            throw new MMScriptException(jSONException);
        }
    }

    public void insertImage(TaggedImage taggedImage, int n, int n2, int n3, int n4) throws MMScriptException, JSONException {
        taggedImage.tags.put("FrameIndex", n);
        taggedImage.tags.put("ChannelIndex", n2);
        taggedImage.tags.put("SliceIndex", n3);
        taggedImage.tags.put("PositionIndex", n4);
        this.insertImage(taggedImage, this.show_);
    }

    public void insertImage(TaggedImage taggedImage, int n, int n2, int n3, int n4, boolean bl) throws MMScriptException, JSONException {
        taggedImage.tags.put("FrameIndex", n);
        taggedImage.tags.put("ChannelIndex", n2);
        taggedImage.tags.put("SliceIndex", n3);
        taggedImage.tags.put("PositionIndex", n4);
        this.insertImage(taggedImage, bl, true);
    }

    public void insertImage(TaggedImage taggedImage, int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws MMScriptException, JSONException {
        taggedImage.tags.put("FrameIndex", n);
        taggedImage.tags.put("ChannelIndex", n2);
        taggedImage.tags.put("SliceIndex", n3);
        taggedImage.tags.put("PositionIndex", n4);
        this.insertImage(taggedImage, bl, bl2);
    }

    public void insertImage(TaggedImage taggedImage) throws MMScriptException {
        this.insertImage(taggedImage, this.show_);
    }

    public void insertImage(TaggedImage taggedImage, boolean bl) throws MMScriptException {
        this.insertImage(taggedImage, bl && this.show_, true);
    }

    public void insertImage(TaggedImage taggedImage, boolean bl, boolean bl2) throws MMScriptException {
        if (!this.initialized_) {
            throw new MMScriptException("Acquisition data must be initialized before inserting images");
        }
        try {
            JSONObject jSONObject = taggedImage.tags;
            if (MDUtils.getWidth(jSONObject) != this.width_ || MDUtils.getHeight(jSONObject) != this.height_) {
                ReportingUtils.logError("Metadata width and height: " + MDUtils.getWidth(jSONObject) + "  " + MDUtils.getHeight(jSONObject) + "   Acquisition Width and height: " + this.width_ + " " + this.height_);
                throw new MMScriptException("Image dimensions do not match MMAcquisition.");
            }
            if (!MDUtils.getPixelType(jSONObject).contentEquals(MMAcquisition.getPixelType(this.byteDepth_))) {
                throw new MMScriptException("Pixel type does not match MMAcquisition.");
            }
            int n = jSONObject.getInt("ChannelIndex");
            int n2 = MDUtils.getFrameIndex(jSONObject);
            if (!MDUtils.getPixelType(jSONObject).startsWith("RGB")) {
                jSONObject.put("Channel", this.getChannelName(n));
            }
            long l = System.currentTimeMillis() - this.startTimeMs_;
            jSONObject.put("ElapsedTime-ms", l);
            jSONObject.put("Time", MDUtils.getCurrentTime());
        }
        catch (JSONException jSONException) {
            throw new MMScriptException(jSONException);
        }
        try {
            this.virtAcq_.imageCache_.putImage(taggedImage);
            this.virtAcq_.albumChanged();
        }
        catch (Exception exception) {
            throw new MMScriptException(exception);
        }
        if (bl) {
            try {
                if (this.virtAcq_ != null) {
                    this.virtAcq_.showImage(taggedImage.tags, bl2);
                }
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
                throw new MMScriptException("Unable to show image");
            }
        }
    }

    public void close() {
        if (this.virtAcq_ != null && this.virtAcq_.acquisitionIsRunning()) {
            this.virtAcq_.abort();
        }
    }

    public boolean isInitialized() {
        return this.initialized_;
    }

    public void closeImageWindow() {
        this.close();
        if (this.virtAcq_ != null) {
            this.virtAcq_.close();
        }
    }

    public void toFront() {
        this.virtAcq_.getHyperImage().getWindow().toFront();
    }

    public void setComment(String string) throws MMScriptException {
        if (this.isInitialized()) {
            try {
                this.virtAcq_.imageCache_.getSummaryMetadata().put("COMMENT", string);
            }
            catch (JSONException jSONException) {
                throw new MMScriptException("Failed to set Comment");
            }
        } else {
            this.comment_ = string;
        }
    }

    public AcquisitionData getAcqData() {
        return null;
    }

    public ImageCache getImageCache() {
        if (this.virtAcq_ == null) {
            return null;
        }
        return this.virtAcq_.getImageCache();
    }

    public JSONObject getSummaryMetadata() {
        if (this.isInitialized()) {
            return this.virtAcq_.imageCache_.getSummaryMetadata();
        }
        return null;
    }

    public String getChannelName(int n) {
        if (this.isInitialized()) {
            String string = "";
            try {
                JSONArray jSONArray = this.getSummaryMetadata().getJSONArray("ChNames");
                if (jSONArray == null || n >= jSONArray.length()) {
                    return "";
                }
                string = jSONArray.getString(n);
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError(jSONException);
                return "";
            }
            return string;
        }
        try {
            return this.channelNames_.getString(n);
        }
        catch (JSONException jSONException) {
            return "";
        }
    }

    public void setChannelName(int n, String string) throws MMScriptException {
        if (this.isInitialized()) {
            try {
                this.virtAcq_.imageCache_.getDisplayAndComments().getJSONArray("Channels").getJSONObject(n).put("Name", string);
                this.virtAcq_.imageCache_.getSummaryMetadata().getJSONArray("ChNames").put(n, string);
                this.virtAcq_.updateChannelNamesAndColors();
            }
            catch (JSONException jSONException) {
                throw new MMScriptException("Problem setting Channel name");
            }
        }
        try {
            this.channelNames_.put(n, string);
        }
        catch (JSONException jSONException) {
            throw new MMScriptException(jSONException);
        }
    }

    public void setChannelColor(int n, int n2) throws MMScriptException {
        if (this.isInitialized()) {
            try {
                this.virtAcq_.imageCache_.setChannelColor(n, n2);
                this.virtAcq_.imageCache_.getSummaryMetadata().getJSONArray("ChColors").put(n, n2);
                this.virtAcq_.updateChannelNamesAndColors();
                this.virtAcq_.updateAndDraw();
            }
            catch (JSONException jSONException) {
                throw new MMScriptException(jSONException);
            }
        }
        try {
            this.channelColors_.put(n, n2);
        }
        catch (JSONException jSONException) {
            throw new MMScriptException(jSONException);
        }
    }

    public void promptToSave(boolean bl) {
        VirtualAcquisitionDisplay.getDisplay(this.virtAcq_.getHyperImage()).promptToSave(bl);
    }

    public void setChannelContrast(int n, int n2, int n3) throws MMScriptException {
        if (!this.isInitialized()) {
            throw new MMScriptException("Acquisition was not initialized");
        }
        this.virtAcq_.setChannelContrast(n, n2, n3, 1.0);
    }

    public void setContrastBasedOnFrame(int n, int n2) throws MMScriptException {
        if (!this.isInitialized()) {
            throw new MMScriptException("Acquisition was not initialized");
        }
        int n3 = this.virtAcq_.getHyperImage().getFrame();
        int n4 = this.virtAcq_.getHyperImage().getSlice();
        int n5 = this.virtAcq_.getHyperImage().getChannel();
        this.virtAcq_.getHyperImage().setPosition(n5, n2, n);
        this.virtAcq_.getHistograms().autoscaleAllChannels();
        this.virtAcq_.getHyperImage().setPosition(n5, n4, n3);
    }

    public void setProperty(String string, String string2) throws MMScriptException {
        if (this.isInitialized()) {
            try {
                this.virtAcq_.imageCache_.getSummaryMetadata().put(string, string2);
            }
            catch (JSONException jSONException) {
                throw new MMScriptException("Failed to set property: " + string);
            }
        }
        try {
            this.summary_.put(string, string2);
        }
        catch (JSONException jSONException) {
            throw new MMScriptException("Failed to set property: " + string);
        }
    }

    public String getProperty(String string) throws MMScriptException {
        if (this.isInitialized()) {
            try {
                return this.virtAcq_.imageCache_.getSummaryMetadata().getString(string);
            }
            catch (JSONException jSONException) {
                throw new MMScriptException("Failed to get property: " + string);
            }
        }
        try {
            return this.summary_.getString(string);
        }
        catch (JSONException jSONException) {
            throw new MMScriptException("Failed to get property: " + string);
        }
    }

    public void setProperty(int n, int n2, int n3, String string, String string2) throws MMScriptException {
        if (this.isInitialized()) {
            try {
                JSONObject jSONObject = this.virtAcq_.imageCache_.getImage((int)n2, (int)n3, (int)n, (int)0).tags;
                jSONObject.put(string, string2);
            }
            catch (JSONException jSONException) {
                throw new MMScriptException(jSONException);
            }
        } else {
            throw new MMScriptException("Can not set property before acquisition is initialized");
        }
    }

    public void setSystemState(int n, int n2, int n3, JSONObject jSONObject) throws MMScriptException {
        if (this.isInitialized()) {
            try {
                JSONObject jSONObject2 = this.virtAcq_.imageCache_.getImage((int)n2, (int)n3, (int)n, (int)0).tags;
                Iterator<String> iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    jSONObject2.put(string, jSONObject.get(string));
                }
            }
            catch (JSONException jSONException) {
                throw new MMScriptException(jSONException);
            }
        } else {
            throw new MMScriptException("Can not set system state before acquisition is initialized");
        }
    }

    public String getProperty(int n, int n2, int n3, String string) throws MMScriptException {
        if (this.isInitialized()) {
            try {
                JSONObject jSONObject = this.virtAcq_.imageCache_.getImage((int)n2, (int)n3, (int)n, (int)0).tags;
                return jSONObject.getString(string);
            }
            catch (JSONException jSONException) {
                throw new MMScriptException(jSONException);
            }
        }
        return "";
    }

    public boolean hasActiveImage5D() {
        return this.virtAcq_.windowClosed();
    }

    public void setSummaryProperties(JSONObject jSONObject) throws MMScriptException {
        if (this.isInitialized()) {
            try {
                JSONObject jSONObject2 = this.virtAcq_.imageCache_.getSummaryMetadata();
                Iterator<String> iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    jSONObject2.put(string, jSONObject.get(string));
                }
            }
            catch (Exception exception) {
                throw new MMScriptException(exception);
            }
        }
        try {
            Iterator<String> iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = iterator.next();
                this.summary_.put(string, jSONObject.get(string));
            }
        }
        catch (Exception exception) {
            throw new MMScriptException(exception);
        }
    }

    public boolean windowClosed() {
        if (!this.initialized_) {
            return false;
        }
        return this.virtAcq_ == null || this.virtAcq_.windowClosed();
    }

    public boolean getShow() {
        return this.show_;
    }

    private static String getPixelType(int n) {
        switch (n) {
            case 1: {
                return "GRAY8";
            }
            case 2: {
                return "GRAY16";
            }
            case 4: {
                return "RGB32";
            }
            case 8: {
                return "RGB64";
            }
        }
        return null;
    }

    public int getLastAcquiredFrame() {
        return this.virtAcq_.imageCache_.lastAcquiredFrame();
    }

    public VirtualAcquisitionDisplay getAcquisitionWindow() {
        return this.virtAcq_;
    }
}

