/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import mmcorej.TaggedImage;
import org.micromanager.acquisition.TaggedImageQueue;
import org.micromanager.api.ImageCache;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class LiveAcq {
    private static int untitledID_ = 0;
    private final BlockingQueue<TaggedImage> imageProducingQueue_;
    private ImageCache imageCache_ = null;

    public LiveAcq(BlockingQueue blockingQueue, ImageCache imageCache) throws MMScriptException {
        this.imageProducingQueue_ = blockingQueue;
        this.imageCache_ = imageCache;
    }

    public void start() {
        Thread thread = new Thread("LiveAcq saving thread."){

            public void run() {
                long l = System.currentTimeMillis();
                int n = 0;
                try {
                    while (true) {
                        TaggedImage taggedImage;
                        if ((taggedImage = (TaggedImage)LiveAcq.this.imageProducingQueue_.poll(1L, TimeUnit.SECONDS)) == null) {
                            continue;
                        }
                        if (!TaggedImageQueue.isPoison(taggedImage)) {
                            ++n;
                            LiveAcq.this.imageCache_.putImage(taggedImage);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
                long l2 = System.currentTimeMillis();
                ReportingUtils.logMessage(n + " images saved in " + (l2 - l) + " ms.");
                LiveAcq.this.imageCache_.finished();
            }
        };
        thread.start();
    }

    public ImageCache getImageCache() {
        return this.imageCache_;
    }
}

