/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ComponentTitledBorder
implements Border,
MouseListener,
SwingConstants {
    int offset = 5;
    Component comp;
    JComponent container;
    Rectangle rect;
    Border border;

    public ComponentTitledBorder(Component component, JComponent jComponent, Border border) {
        this.comp = component;
        this.container = jComponent;
        this.border = border;
        jComponent.addMouseListener(this);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Insets insets = this.border.getBorderInsets(component);
        Insets insets2 = this.getBorderInsets(component);
        int n5 = (insets2.top - insets.top) / 2;
        this.border.paintBorder(component, graphics, n, n2 + n5, n3, n4 - n5);
        Dimension dimension = this.comp.getPreferredSize();
        this.rect = new Rectangle(this.offset, 0, dimension.width, dimension.height);
        SwingUtilities.paintComponent(graphics, this.comp, (Container)component, this.rect);
    }

    public Insets getBorderInsets(Component component) {
        Dimension dimension = this.comp.getPreferredSize();
        Insets insets = this.border.getBorderInsets(component);
        insets.top = Math.max(insets.top, dimension.height);
        return insets;
    }

    private void dispatchEvent(MouseEvent mouseEvent) {
        if (this.rect != null && this.rect.contains(mouseEvent.getX(), mouseEvent.getY())) {
            Point point = mouseEvent.getPoint();
            point.translate(-this.offset, 0);
            this.comp.setBounds(this.rect);
            this.comp.dispatchEvent(new MouseEvent(this.comp, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            if (!this.comp.isValid()) {
                this.container.repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void setBorder(Border border) {
        this.border = border;
    }
}

