/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.MMOptions;
import org.micromanager.PositionListDlg;
import org.micromanager.navigation.MultiStagePosition;
import org.micromanager.navigation.StagePosition;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class TileCreatorDlg
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private CMMCore core_;
    private MultiStagePosition[] endPosition_;
    private boolean[] endPositionSet_;
    private PositionListDlg positionListDlg_;
    private JTextField overlapField_;
    private JTextField pixelSizeField_;
    private final JLabel labelLeft_ = new JLabel();
    private final JLabel labelTop_ = new JLabel();
    private final JLabel labelRight_ = new JLabel();
    private final JLabel labelBottom_ = new JLabel();
    private int prefix_ = 0;
    private static final DecimalFormat FMT_POS = new DecimalFormat("000");

    public TileCreatorDlg(CMMCore cMMCore, MMOptions mMOptions, PositionListDlg positionListDlg) {
        this.setResizable(false);
        this.setName("tileDialog");
        this.getContentPane().setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TileCreatorDlg.this.savePosition();
            }
        });
        this.core_ = cMMCore;
        this.positionListDlg_ = positionListDlg;
        this.endPosition_ = new MultiStagePosition[4];
        this.endPositionSet_ = new boolean[4];
        this.setTitle("Tile Creator");
        this.setBounds(300, 300, 344, 280);
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.setPrefsNode(preferences.node(preferences.absolutePath() + "/TileCreatorDlg"));
        Rectangle rectangle = this.getBounds();
        this.loadPosition(rectangle.x, rectangle.y);
        JButton jButton = new JButton();
        jButton.setFont(new Font("", 0, 10));
        jButton.setText("Go To");
        jButton.setBounds(20, 89, 93, 23);
        this.getContentPane().add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TileCreatorDlg.this.endPositionSet_[3]) {
                    TileCreatorDlg.this.goToPosition(TileCreatorDlg.this.endPosition_[3]);
                }
            }
        });
        this.labelLeft_.setFont(new Font("", 0, 8));
        this.labelLeft_.setHorizontalAlignment(0);
        this.labelLeft_.setText("");
        this.labelLeft_.setBounds(0, 112, 130, 14);
        this.getContentPane().add(this.labelLeft_);
        JButton jButton2 = new JButton();
        jButton2.setBounds(20, 66, 93, 23);
        jButton2.setFont(new Font("", 0, 10));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TileCreatorDlg.this.markPosition(3);
                TileCreatorDlg.this.labelLeft_.setText(TileCreatorDlg.this.thisPosition());
            }
        });
        jButton2.setText("Set");
        this.getContentPane().add(jButton2);
        this.labelTop_.setFont(new Font("", 0, 8));
        this.labelTop_.setHorizontalAlignment(0);
        this.labelTop_.setText("");
        this.labelTop_.setBounds(115, 51, 130, 14);
        this.getContentPane().add(this.labelTop_);
        JButton jButton3 = new JButton();
        jButton3.setFont(new Font("", 0, 10));
        jButton3.setText("Go To");
        jButton3.setBounds(133, 28, 93, 23);
        this.getContentPane().add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TileCreatorDlg.this.endPositionSet_[0]) {
                    TileCreatorDlg.this.goToPosition(TileCreatorDlg.this.endPosition_[0]);
                }
            }
        });
        JButton jButton4 = new JButton();
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TileCreatorDlg.this.markPosition(0);
                TileCreatorDlg.this.labelTop_.setText(TileCreatorDlg.this.thisPosition());
            }
        });
        jButton4.setBounds(133, 5, 93, 23);
        jButton4.setFont(new Font("", 0, 10));
        jButton4.setText("Set");
        this.getContentPane().add(jButton4);
        this.labelRight_.setFont(new Font("", 0, 8));
        this.labelRight_.setHorizontalAlignment(0);
        this.labelRight_.setText("");
        this.labelRight_.setBounds(214, 112, 130, 14);
        this.getContentPane().add(this.labelRight_);
        JButton jButton5 = new JButton();
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TileCreatorDlg.this.markPosition(1);
                TileCreatorDlg.this.labelRight_.setText(TileCreatorDlg.this.thisPosition());
            }
        });
        jButton5.setBounds(234, 66, 93, 23);
        jButton5.setFont(new Font("", 0, 10));
        jButton5.setText("Set");
        this.getContentPane().add(jButton5);
        this.labelBottom_.setFont(new Font("", 0, 8));
        this.labelBottom_.setHorizontalAlignment(0);
        this.labelBottom_.setText("");
        this.labelBottom_.setBounds(115, 172, 130, 14);
        this.getContentPane().add(this.labelBottom_);
        JButton jButton6 = new JButton();
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TileCreatorDlg.this.markPosition(2);
                TileCreatorDlg.this.labelBottom_.setText(TileCreatorDlg.this.thisPosition());
            }
        });
        jButton6.setFont(new Font("", 0, 10));
        jButton6.setText("Set");
        jButton6.setBounds(133, 126, 93, 23);
        this.getContentPane().add(jButton6);
        JButton jButton7 = new JButton();
        jButton7.setFont(new Font("", 0, 10));
        jButton7.setText("Go To");
        jButton7.setBounds(234, 89, 93, 23);
        this.getContentPane().add(jButton7);
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TileCreatorDlg.this.endPositionSet_[1]) {
                    TileCreatorDlg.this.goToPosition(TileCreatorDlg.this.endPosition_[1]);
                }
            }
        });
        JButton jButton8 = new JButton();
        jButton8.setFont(new Font("", 0, 10));
        jButton8.setText("Go To");
        jButton8.setBounds(133, 149, 93, 23);
        this.getContentPane().add(jButton8);
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TileCreatorDlg.this.endPositionSet_[2]) {
                    TileCreatorDlg.this.goToPosition(TileCreatorDlg.this.endPosition_[2]);
                }
            }
        });
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("", 0, 10));
        jLabel.setText("Overlap [um]");
        jLabel.setBounds(20, 189, 80, 14);
        this.getContentPane().add(jLabel);
        this.overlapField_ = new JTextField();
        this.overlapField_.setBounds(95, 186, 50, 20);
        this.overlapField_.setFont(new Font("", 0, 10));
        this.overlapField_.setText("0");
        this.getContentPane().add(this.overlapField_);
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font("", 0, 10));
        jLabel2.setText("Pixel Size [um]");
        jLabel2.setBounds(175, 189, 80, 14);
        this.getContentPane().add(jLabel2);
        this.pixelSizeField_ = new JTextField();
        this.pixelSizeField_.setFont(new Font("", 0, 10));
        this.pixelSizeField_.setBounds(259, 186, 50, 20);
        this.pixelSizeField_.setText(NumberUtils.doubleToDisplayString(this.core_.getPixelSizeUm()));
        this.getContentPane().add(this.pixelSizeField_);
        JButton jButton9 = new JButton();
        jButton9.setFont(new Font("", 0, 10));
        jButton9.setText("OK");
        jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TileCreatorDlg.this.savePosition();
                TileCreatorDlg.this.addToPositionList();
            }
        });
        jButton9.setBounds(20, 216, 93, 23);
        this.getContentPane().add(jButton9);
        JButton jButton10 = new JButton();
        jButton10.setBounds(133, 216, 93, 23);
        jButton10.setFont(new Font("", 0, 10));
        jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TileCreatorDlg.this.savePosition();
                TileCreatorDlg.this.dispose();
            }
        });
        jButton10.setText("Cancel");
        this.getContentPane().add(jButton10);
        JButton jButton11 = new JButton();
        jButton11.setBounds(234, 216, 93, 23);
        jButton11.setFont(new Font("", 0, 10));
        jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TileCreatorDlg.this.reset();
            }
        });
        jButton11.setText("Reset");
        this.getContentPane().add(jButton11);
    }

    private void markPosition(int n) {
        MultiStagePosition multiStagePosition = new MultiStagePosition();
        multiStagePosition.setDefaultXYStage(this.core_.getXYStageDevice());
        multiStagePosition.setDefaultZStage(this.core_.getFocusDevice());
        try {
            StrVector strVector = this.core_.getLoadedDevicesOfType(DeviceType.StageDevice);
            int n2 = 0;
            while ((long)n2 < strVector.size()) {
                StagePosition stagePosition = new StagePosition();
                stagePosition.stageName = strVector.get(n2);
                stagePosition.numAxes = 1;
                stagePosition.x = this.core_.getPosition(strVector.get(n2));
                multiStagePosition.add(stagePosition);
                ++n2;
            }
            StrVector strVector2 = this.core_.getLoadedDevicesOfType(DeviceType.XYStageDevice);
            int n3 = 0;
            while ((long)n3 < strVector2.size()) {
                StagePosition stagePosition = new StagePosition();
                stagePosition.stageName = strVector2.get(n3);
                stagePosition.numAxes = 2;
                stagePosition.x = this.core_.getXPosition(strVector2.get(n3));
                stagePosition.y = this.core_.getYPosition(strVector2.get(n3));
                multiStagePosition.add(stagePosition);
                ++n3;
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
        this.endPosition_[n] = multiStagePosition;
        this.endPositionSet_[n] = true;
    }

    private String thisPosition() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            StrVector strVector = this.core_.getLoadedDevicesOfType(DeviceType.StageDevice);
            int n = 0;
            while ((long)n < strVector.size()) {
                StagePosition stagePosition = new StagePosition();
                stagePosition.stageName = strVector.get(n);
                stagePosition.numAxes = 1;
                stagePosition.x = this.core_.getPosition(strVector.get(n));
                stringBuffer.append(stagePosition.getVerbose() + "\n");
                ++n;
            }
            StrVector strVector2 = this.core_.getLoadedDevicesOfType(DeviceType.XYStageDevice);
            int n2 = 0;
            while ((long)n2 < strVector2.size()) {
                StagePosition stagePosition = new StagePosition();
                stagePosition.stageName = strVector2.get(n2);
                stagePosition.numAxes = 2;
                stagePosition.x = this.core_.getXPosition(strVector2.get(n2));
                stagePosition.y = this.core_.getYPosition(strVector2.get(n2));
                stringBuffer.append(stagePosition.getVerbose() + "\n");
                ++n2;
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
        return stringBuffer.toString();
    }

    private void addToPositionList() {
        int n;
        boolean bl;
        boolean bl2;
        double d = 0.0;
        try {
            d = NumberUtils.displayStringToDouble(this.pixelSizeField_.getText());
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        if (d <= 0.0) {
            JOptionPane.showMessageDialog(this, "Pixel Size should be a value > 0 (usually 0.1 -1 um).  It should be experimentally determined. ");
            return;
        }
        double d2 = 0.0;
        try {
            d2 = NumberUtils.displayStringToDouble(this.overlapField_.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = this.core_.getCameraDevice();
        if (string == null) {
            JOptionPane.showMessageDialog(null, "This function does not work without a camera");
            return;
        }
        try {
            String string2 = this.core_.getProperty(string, "TransposeCorrection");
            bl2 = !string2.equals("0");
            string2 = this.core_.getProperty(string, MMCoreJ.getG_Keyword_Transpose_MirrorX());
            boolean bl3 = !string2.equals("0");
            string2 = this.core_.getProperty(string, MMCoreJ.getG_Keyword_Transpose_MirrorY());
            boolean bl4 = !string2.equals("0");
            string2 = this.core_.getProperty(string, MMCoreJ.getG_Keyword_Transpose_SwapXY());
            bl = !string2.equals("0");
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
        double d3 = d * (double)this.core_.getImageWidth() - d2;
        double d4 = d * (double)this.core_.getImageHeight() - d2;
        double d5 = d3;
        double d6 = d4;
        if (!bl2 && bl) {
            d5 = d4;
            d6 = d3;
        }
        int n2 = (int)Math.floor(d2 / d);
        int n3 = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.endPositionSet_[i]) continue;
            ++n3;
        }
        if (n3 < 2) {
            JOptionPane.showMessageDialog(this, "At least two corners should be set");
            return;
        }
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        boolean bl5 = false;
        StagePosition stagePosition = new StagePosition();
        for (n = 0; n < 4; ++n) {
            if (!this.endPositionSet_[n]) continue;
            if (!bl5) {
                stagePosition = this.endPosition_[n].get(this.endPosition_[n].getDefaultXYStage());
                d7 = d9 = stagePosition.x;
                d8 = d10 = stagePosition.y;
                stagePosition = this.endPosition_[n].get(this.endPosition_[n].getDefaultZStage());
                d11 = stagePosition.x;
                bl5 = true;
                continue;
            }
            stagePosition = this.endPosition_[n].get(this.endPosition_[n].getDefaultXYStage());
            if (stagePosition.x < d7) {
                d7 = stagePosition.x;
            }
            if (stagePosition.x > d9) {
                d9 = stagePosition.x;
            }
            if (stagePosition.y < d8) {
                d8 = stagePosition.y;
            }
            if (stagePosition.y > d10) {
                d10 = stagePosition.y;
            }
            stagePosition = this.endPosition_[n].get(this.endPosition_[n].getDefaultZStage());
            d11 += stagePosition.x;
        }
        d11 /= (double)n3;
        n = (int)Math.floor((d9 - d7) / d5) + 2;
        int n4 = (int)Math.floor((d10 - d8) / d6) + 2;
        ++this.prefix_;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = j;
                if ((i & 1) == 1) {
                    n5 = n - j - 1;
                }
                MultiStagePosition multiStagePosition = new MultiStagePosition();
                StagePosition stagePosition2 = new StagePosition();
                stagePosition2.stageName = this.core_.getFocusDevice();
                stagePosition2.numAxes = 1;
                stagePosition2.x = d11;
                if (this.positionListDlg_.useDrive(stagePosition2.stageName)) {
                    multiStagePosition.add(stagePosition2);
                }
                multiStagePosition.setDefaultXYStage(this.core_.getXYStageDevice());
                multiStagePosition.setDefaultZStage(this.core_.getFocusDevice());
                StagePosition stagePosition3 = new StagePosition();
                stagePosition3.stageName = this.core_.getXYStageDevice();
                stagePosition3.numAxes = 2;
                stagePosition3.x = d7 + (double)n5 * d5;
                stagePosition3.y = d8 + (double)i * d6;
                multiStagePosition.add(stagePosition3);
                multiStagePosition.setGridCoordinates(i, n5);
                multiStagePosition.setProperty("OverlapUm", NumberUtils.doubleToCoreString(d2));
                multiStagePosition.setProperty("OverlapPixels", NumberUtils.intToCoreString(n2));
                this.positionListDlg_.addPosition(multiStagePosition, TileCreatorDlg.generatePosLabel(this.prefix_ + "-Pos", n5, i));
            }
        }
        this.dispose();
    }

    private void reset() {
        for (int i = 0; i < 4; ++i) {
            this.endPositionSet_[i] = false;
        }
        this.labelTop_.setText("");
        this.labelRight_.setText("");
        this.labelBottom_.setText("");
        this.labelLeft_.setText("");
        double d = this.core_.getPixelSizeUm();
        this.pixelSizeField_.setText(NumberUtils.doubleToDisplayString(d));
        this.overlapField_.setText("0");
    }

    private void goToPosition(MultiStagePosition multiStagePosition) {
        try {
            MultiStagePosition.goToPosition(multiStagePosition, this.core_);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    private void handleError(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public static String generatePosLabel(String string, int n, int n2) {
        String string2 = string + "_" + FMT_POS.format(n) + "_" + FMT_POS.format(n2);
        return string2;
    }
}

